﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using HtmlAgilityPack;

namespace 漫画网爬虫
{
    public partial class Form1 : Form
    {
        public string[] hrefList;
        public int hrefNum;

        public Form1()
        {
            InitializeComponent();
        }

        private void go()
        {
            int j, total = 0,l=0;
            string bookName="";
            string[,] imgSrc = new string[5000,2];
            toolStripProgressBar1.Value = 0;
            if(listBox2.Items.Count==0)
            {
                MessageBox.Show("右边列表不能为空哦.");
                result.Text = "";
                return;
            }
            for (j = 0; j < listBox2.Items.Count; j++)
            {
                var url = listBox2.Items[j].ToString();
                var web = new HtmlWeb();
                var htmlDoc = web.Load(url);
                int i = 1;
                
                bookName = htmlDoc.DocumentNode.SelectSingleNode("//title").InnerText;//获取书名
                System.IO.Directory.CreateDirectory(bookName);//新建文件夹
                url = url.Replace(".shtml", "");//替换后缀，用来进行下一页
                while (true)//循环遍历文章的下一页，直到规则匹配不到  404页面
                {
                    HtmlNodeCollection imgs = htmlDoc.DocumentNode.SelectNodes("//div[@class='Mid2L_con']//img");//获取文章中的图片
                    if (imgs != null)
                    {
                        foreach (HtmlNode img in imgs)
                        {
                            HtmlAttribute att = img.Attributes["src"];//获取图片链接
                            imgSrc[l,0] = bookName;
                            imgSrc[l,1] =att.Value;//放入总图片数组中
                            total++;
                            l++;
                        }
                    }
                    else break;//没有了就跳出
                    i++;
                    htmlDoc = web.Load(url + "_" + (i.ToString()) + ".shtml");  //下一页
                }
                //文章的图片遍历完毕
                TaskDownload(imgSrc);//开始放入task下载
                l = 0;
                toolStripProgressBar1.Maximum = total;//重新赋值进度条
            }

            result.Text += "共有"+total.ToString()+"张图片 \r\n";
            result.Text += "下载开始了...\r\n";
        }

        void TaskDownload(string[,] imgSrc)
        {
            Task task = new Task(() =>
            {
                //*****以下是异步执行的代码*****
                int k; 
                for (k = 0; k < 5000; k++)
                {
                    if (imgSrc[k,0]==null) break; //数组后续为空就直接退出了

                    HttpDownload(imgSrc[k,1], k.ToString(), imgSrc[k,0]);
                    MethodInvoker mi = new MethodInvoker(() =>
                    {
                        if(toolStripProgressBar1.Maximum > toolStripProgressBar1.Value)
                          toolStripProgressBar1.Value = toolStripProgressBar1.Value + 1;
                    });
                    this.BeginInvoke(mi);
                }
                MethodInvoker status = new MethodInvoker(() =>
                {
                    result.Text += imgSrc[0,0]+"---分配完毕... \r\n"; 
                });
                this.BeginInvoke(status);
                //*****以上是异步执行的代码*****
            });
            task.Start();
        }

        private void getList(string url)
        {
            hrefList = new string[100];
            listBox1.Items.Clear();//清空列表
            hrefNum = 0;
            var web = new HtmlWeb();
            var htmlDoc = web.Load(url);
            HtmlNodeCollection imgs = htmlDoc.DocumentNode.SelectNodes(textBox2.Text);
            if (imgs != null)
            {
                foreach (HtmlNode img in imgs)
                {
                    HtmlAttribute att = img.Attributes["href"];//获取链接
                    if (att.Value.IndexOf("http://") > -1)
                    {
                        hrefList[hrefNum] = att.Value;
                        att = img.Attributes["title"];
                        listBox1.Items.Add(att.Value);
                    }
                    else
                    {
                        hrefList[hrefNum] = "http://www.gamersky.com" + att.Value;
                        att = img.Attributes["title"];
                        listBox1.Items.Add(att.Value);//补全链接，有时候是绝对链接
                    }
                    hrefNum++; //这样就是从0开始的
                }
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            try {
                listBox2.Items.Add(hrefList[listBox1.SelectedIndex]);//双击左边，右边就会添加这个链接
            }
            catch { }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            result.Text = "任务分析中... \r\n";
            go();
        }
        private void button5_Click(object sender, EventArgs e)
        {
            getList("http://www.gamersky.com/ent/qw/");
        }

        private void button6_Click(object sender, EventArgs e)
        {
            getList("http://www.gamersky.com/ent/xz/");
        }

        private void button4_Click(object sender, EventArgs e)
        {
            getList("http://www.gamersky.com/wenku/movie/");
        }

        private void button7_Click(object sender, EventArgs e)
        {
            getList("http://www.gamersky.com/ent/discovery/");
        }

        public bool HttpDownload(string url, string name, string path)
        {
            //  string tempPath = System.IO.Path.GetDirectoryName(path) + @"\temp";
            //  System.IO.Directory.CreateDirectory(tempPath);  //创建临时文件目录
            //  string tempFile = tempPath + @"\" + System.IO.Path.GetFileName(path) + ".temp"; //临时文件
            string tempFile = path + @"\" + name + url.Substring(url.Length - 4, 4); //写入文件
            try
            {
                if (System.IO.File.Exists(tempFile))
                    System.IO.File.Delete(tempFile);    //存在则删除
                FileStream fs = new FileStream(tempFile, FileMode.Append, FileAccess.Write, FileShare.ReadWrite);
                // 设置参数
                HttpWebRequest request = WebRequest.Create(url) as HttpWebRequest;
                //发送请求并获取相应回应数据
                HttpWebResponse response = request.GetResponse() as HttpWebResponse;
                //直到request.GetResponse()程序才开始向目标网页发送Post请求
                Stream responseStream = response.GetResponseStream();
                //创建本地文件写入流
                //Stream stream = new FileStream(tempFile, FileMode.Create);
                byte[] bArr = new byte[1024];
                int size = responseStream.Read(bArr, 0, (int)bArr.Length);
                while (size > 0)
                {
                    //stream.Write(bArr, 0, size);
                    fs.Write(bArr, 0, size);
                    size = responseStream.Read(bArr, 0, (int)bArr.Length);
                }
                //stream.Close();
                fs.Close();
                responseStream.Close();
                // System.IO.File.Move(tempFile, path);
                return true;
            }
            catch (Exception ex)
            {
                return false;
            }
        }

        private void button8_Click(object sender, EventArgs e)
        {
            listBox2.Items.Clear();
        }
    }
}
