﻿cr.define('options', function() {
  var OptionsPage = options.OptionsPage;

  function LabOptions() {
      OptionsPage.call(this, 'lab', templateData.labPageTabTitle, 'labPage');
  }

  cr.addSingletonGetter(LabOptions);

  LabOptions.prototype = {
    __proto__: options.OptionsPage.prototype,

    initializePage: function() {
      OptionsPage.prototype.initializePage.call(this);

      Preferences.getInstance().addEventListener('browser.kantu.enable_kandatu', function(e) {
        document.querySelector('[pref="browser.kantu.hide_kandatu_label"]').disabled = !e.value.value;
        $("manage-kandatu-list").disabled = !e.value.value;
      });

      $("manage-kandatu-list").onclick = function(event) {
        OptionsPage.navigateToPage("manageKandatuList");
      };

      Preferences.getInstance().addEventListener('browser.prerender_url_under_mouse.enable', function(e) {
        document.querySelector('[pref="browser.prerender_url_under_mouse.text_limit"]').disabled = !e.value.value;
      });

      document.querySelector('[pref="browser.prerender_url_under_mouse.text_limit"]').addEventListener('change', function() {
        if (this.value < 5) {
          this.value = 5;
        }
        if (this.value > 1000) {
          this.value = 1000;
        }
      }, false);
    },
  };

  return {
    LabOptions: LabOptions
  };
});
