// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

var AddLanguageOverlay = options.AddLanguageOverlay;
var AdvancedOptions = options.AdvancedOptions;
var AlertOverlay = options.AlertOverlay;
var AutofillEditAddressOverlay = options.AutofillEditAddressOverlay;
var AutofillEditCreditCardOverlay = options.AutofillEditCreditCardOverlay;
var AutofillOptions = options.AutofillOptions;
var BrowserOptions = options.BrowserOptions;
var ContentSettings = options.ContentSettings;
var ContentSettingsExceptionsArea = options.contentSettings.ContentSettingsExceptionsArea;
var CookiesView = options.CookiesView;
var ExtensionSettings = options.ExtensionSettings;
var FontSettings = options.FontSettings;
var HandlerOptions = options.HandlerOptions;
var ImportDataOverlay = options.ImportDataOverlay;
var ImportExportBookmarkOverlay = options.ImportExportBookmarkOverlay;
var ManageKandatuListOverlay = options.ManageKandatuListOverlay;
var IntentsView = options.IntentsView;
var InstantConfirmOverlay = options.InstantConfirmOverlay;
var LanguageOptions = options.LanguageOptions;
var Proxy360Options = options.Proxy360Options;
var OptionsPage = options.OptionsPage;
var PackExtensionOverlay = options.PackExtensionOverlay;
var PasswordManager = options.PasswordManager;
var PersonalOptions = options.PersonalOptions;
var Preferences = options.Preferences;
var ManageProfileOverlay = options.ManageProfileOverlay;
var ProxyOptions = options.ProxyOptions;
var SearchEngineManager = options.SearchEngineManager;
var SearchPage = options.SearchPage;
var SyncSetupOverlay = options.SyncSetupOverlay;
var Sync360SettingOverlay = options.Sync360SettingOverlay;
var VirtualKeyboardManager = options.VirtualKeyboardManager;

/** 360 chrome add **/
var TabOptionsPage = options.TabOptionsPage;
var LabOptions = options.LabOptions;
var TpMoreOptions = options.TpMoreOptions;
var TpMoreMouseGestureOptions = options.TpMoreMouseGestureOptions;
var adFilterOptions = options.ADFilterOptions;
var adFilterExceptionOptions = options.ADFilterExceptionOptions;
var uiStyleOptions = options.UIStyleOptions;
var downloadSettingOptions = options.DownloadSettingOptions;
var TrustedOrBlockedSiteArea = options.TrustedOrBlockedSiteArea;
var AppStore = options.AppStore;
var AppstoreNotifyOverlay = options.AppstoreNotifyOverlay;
var SwitcherManageOptions = options.SwitcherManageOptions;
var ShortCut = options.ShortCut;
/** 360chrome add end **/

/**
 * DOMContentLoaded handler, sets up the page.
 */
function load() {

  procressLoadTimeData();

  // Decorate the existing elements in the document.
  cr.ui.decorate('input[pref][type=checkbox]',
    options.PrefCheckbox);
  cr.ui.decorate('input[pref][type=number]',
    options.PrefNumber);
  cr.ui.decorate('input[pref][type=radio]',
    options.PrefRadio);
  cr.ui.decorate('input[pref][type=range]',
    options.PrefRange);
  cr.ui.decorate('select[pref]',
    options.PrefSelect);
  cr.ui.decorate('input[pref][type=text]',
    options.PrefTextField);
  cr.ui.decorate('input[pref][type=url]',
    options.PrefTextField);
  cr.ui.decorate('button[pref]',
    options.PrefButton);
  cr.ui.decorate('#content-settings-page input[type=radio]:not(.handler-radio)',
    options.ContentSettingsRadio);
  cr.ui.decorate('#content-settings-page input[type=radio].handler-radio',
    options.HandlersEnabledRadio);
  cr.ui.decorate('span.controlled-setting-indicator',
    options.ControlledSettingIndicator);

  var menuOffPattern = /(^\?|&)menu=off($|&)/;
  var menuDisabled = menuOffPattern.test(window.location.search);
  // document.documentElement.setAttribute('hide-menu', menuDisabled);
  // We can't use an attribute on the html element because of webkit bug
  // 12519. Instead, we add a class.
  if (menuDisabled)
    document.documentElement.classList.add('hide-menu');

  localStrings = new LocalStrings();

  OptionsPage.register(SearchPage.getInstance());
  OptionsPage.register(BrowserOptions.getInstance());
  OptionsPage.register(uiStyleOptions.getInstance());
  OptionsPage.registerSubPage(
    SearchEngineManager.getInstance(),
    BrowserOptions.getInstance(), [$('defaultSearchManageEnginesButton')]);

  /** 360chrome add **/
  OptionsPage.register(TabOptionsPage.getInstance());
  // OptionsPage.register(adFilterOptions.getInstance());
  OptionsPage.register(downloadSettingOptions.getInstance());
  OptionsPage.register(TpMoreMouseGestureOptions.getInstance());
  OptionsPage.register(ShortCut.getInstance());
  /** 360chrome add **/

  OptionsPage.register(PersonalOptions.getInstance());
  OptionsPage.registerSubPage(
    AutofillOptions.getInstance(),
    PersonalOptions.getInstance(), [$('autofill-settings')]);
  OptionsPage.registerSubPage(PasswordManager.getInstance(),
    PersonalOptions.getInstance(), [$('manage-passwords')]);
  OptionsPage.register(AdvancedOptions.getInstance());
  OptionsPage.register(LabOptions.getInstance());
  OptionsPage.registerSubPage(ContentSettings.getInstance(),
    AdvancedOptions.getInstance(), [$('privacyContentSettingsButton')]);
  OptionsPage.registerSubPage(ContentSettingsExceptionsArea.getInstance(),
    ContentSettings.getInstance());
  OptionsPage.registerSubPage(CookiesView.getInstance(),
    ContentSettings.getInstance(), [$('privacyContentSettingsButton'),
      $('show-cookies-button')
    ]);

  OptionsPage.registerSubPage(TrustedOrBlockedSiteArea.getInstance(),
    AdvancedOptions.getInstance(), [$('siteTrustOrBlockButton')]);

  // If HandlerOptions is null it means it got compiled out.
  if (HandlerOptions) {
    OptionsPage.registerSubPage(HandlerOptions.getInstance(),
      ContentSettings.getInstance(), [$('manage-handlers-button')]);
  }
  if (IntentsView && $('manage-intents-button')) {
    OptionsPage.registerSubPage(IntentsView.getInstance(),
      ContentSettings.getInstance(), [$('manage-intents-button')]);
  }
  OptionsPage.registerSubPage(FontSettings.getInstance(),
    AdvancedOptions.getInstance(), [$('fontSettingsCustomizeFontsButton')]);

  if (!cr.isChromeOS) {
    OptionsPage.registerSubPage(LanguageOptions.getInstance(),
      AdvancedOptions.getInstance(), [$('language-button')]);
    OptionsPage.registerSubPage(Proxy360Options.getInstance(),
      AdvancedOptions.getInstance(), [$('proxy360Button')]);
  }

  OptionsPage.registerOverlay(AddLanguageOverlay.getInstance(),
    LanguageOptions.getInstance());
  OptionsPage.registerOverlay(AlertOverlay.getInstance());
  OptionsPage.registerOverlay(AutofillEditAddressOverlay.getInstance(),
    AutofillOptions.getInstance());
  OptionsPage.registerOverlay(AutofillEditCreditCardOverlay.getInstance(),
    AutofillOptions.getInstance());
  OptionsPage.registerOverlay(ImportDataOverlay.getInstance(),
    PersonalOptions.getInstance());
  OptionsPage.registerOverlay(InstantConfirmOverlay.getInstance(),
    BrowserOptions.getInstance());
  OptionsPage.registerOverlay(SyncSetupOverlay.getInstance(),
    PersonalOptions.getInstance());
  OptionsPage.registerOverlay(Sync360SettingOverlay.getInstance(),
    PersonalOptions.getInstance());
  OptionsPage.registerOverlay(ManageProfileOverlay.getInstance(),
    PersonalOptions.getInstance());
  OptionsPage.registerOverlay(ImportExportBookmarkOverlay.getInstance(),
    PersonalOptions.getInstance());
  OptionsPage.registerOverlay(ManageKandatuListOverlay.getInstance(),
    LabOptions.getInstance());

  OptionsPage.register(AppStore.getInstance());
  OptionsPage.registerOverlay(AppstoreNotifyOverlay.getInstance(), AppStore.getInstance());
  OptionsPage.registerSubPage(SwitcherManageOptions.getInstance(),
    AdvancedOptions.getInstance());
  OptionsPage.registerSubPage(
    adFilterExceptionOptions.getInstance(),
    AdvancedOptions.getInstance());

  Preferences.getInstance().initialize();
  OptionsPage.initialize();

  var path = document.location.pathname;

  if (path.length > 1) {
    // Skip starting slash and remove trailing slash (if any).
    var pageName = path.slice(1).replace(/\/$/, '');
    // Proxy page is now per network and only reachable from internet details.
    if (pageName != 'proxy') {
      // Show page, but don't update history (there's already an entry for it).
      if (pageName == 'search') {
        OptionsPage.showDefaultPage();
      } else {
        OptionsPage.showPageByName(pageName, false);
      }
    }
  } else {
    OptionsPage.showDefaultPage();
  }

  var subpagesNavTabs = document.querySelectorAll('.subpages-nav-tabs');
  for (var i = 0; i < subpagesNavTabs.length; i++) {
    subpagesNavTabs[i].onclick = function(event) {
      OptionsPage.showTab(event.srcElement);
    }
  }

  if (navigator.plugins['Shockwave Flash'])
    document.documentElement.setAttribute('hasFlashPlugin', '');

  // Clicking on the Settings title brings up the 'Basics' page.
  $('navbar-content-title').onclick = function() {
    OptionsPage.navigateToPage(BrowserOptions.getInstance().name);
  };
  // Clicking on the Settings title brings up the 'Basics' page.
  $('restore-default-settings').onclick = function() {
    if (confirm($('restore-default-settings-confirm').innerText)) {
      chrome.send('restoreDefaultContentSettings');
      chrome.send('restoreDefaultSettings');
    }
  };

  /** 360chrome add **/
  tpGetInitOptionsData();
  if (location == 'chrome://settings/extensions') {
    location = 'chrome://myextensions/extensions';
  }
  /** 360chrome add end **/
}

document.addEventListener('DOMContentLoaded', load);

window.onpopstate = function(e) {
  options.OptionsPage.setState(e.state);
};

window.onbeforeunload = function() {
  options.OptionsPage.willClose();
};

function updateTips() {
  $("updateTips").style.opacity = "1";
  setTimeout(function() {
    $("updateTips").style.opacity = "0";
  }, 1500);
}

function restartTips() {
  $("restartTips").style.opacity = "1";
  setTimeout(function() {
    $("restartTips").style.opacity = "0";
  }, 1500);
}

document.addEventListener("change", function(e) {
  var targetNode = e.target;
  var exceptionList = ["gaia-email", "gaia-passwd", "search-field", "sync360-bookmarks", "sync360-preference", "sync360-extension", "sync360-theme", "sync360-switcher", "sync360-autofill"];
  if (targetNode.id == "gpu-mode-checkbox" || targetNode.id == "metricsReportingEnabled" || targetNode.id == "CHECKBOX_IDS_MORE_SETTING_DIRECTWRITE_SUPPORT" || targetNode.id == "CHECKBOX_IDS_MORE_SETTING_TAB_AUDIO_MUTE_ENABLE" || targetNode.id == "RADIO_IDS_MORE_SETTING_USE_SYSTEM_FONT_SIZE" || targetNode.id == "RADIO_IDS_MORE_SETTING_USE_CUSTOM_FONT_SIZE" || targetNode.id == "SELECT_IDS_MORE_SETTING_USE_CUSTOM_FONT_SIZE")
    restartTips();
  else if (!options.arrayContains(exceptionList, targetNode.id) && targetNode.type != 'search')
    updateTips();
});

document.addEventListener("click", function(e) {
  var targetNode = e.target;
  if (targetNode.nodeName.toLowerCase() == "button" && targetNode.classList.contains('close-subpage'))
    return;
  if (targetNode.id == "startupUseCurrentButton" || targetNode.id == "defaultBrowserUseAsDefaultButton" || targetNode.classList.contains("raw-button"))
    updateTips();
});

function restoreDefaultSettingsDone() {
  $("restoreTips").style.opacity = "1";
  setTimeout(function() {
    $("restoreTips").style.opacity = "0";
    setTimeout(function() {
      location.reload();
    }, 2000);
  }, 1500);
}

function procressLoadTimeData() {
  if (window.templateData) {
    for (var key in templateData) {
      if (typeof templateData[key] == 'string') {
        templateData[key] = templateData[key].replace('设置 -', '选项 -');
      }
    }
  }
}