/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.AppContextAdapter;
import com.opera.AppContextCreator;
import com.opera.AppletContextManager;
import com.opera.AppletPanel;
import com.opera.CertificateHandler;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.PropertyPermission;

public class AppletClassLoader
extends URLClassLoader {
    private static RuntimePermission usePolicyPermission = new RuntimePermission("usePolicy");
    private static PropertyPermission browserReadPerm = new PropertyPermission("browser", "read");
    private static PropertyPermission browserVerReadPerm = new PropertyPermission("browser.version", "read");
    private URL codeBase;
    private CodeSource codeSource;
    private String key;
    private AppContextAdapter appContext = null;
    private ThreadGroup threadGroup = null;
    private int usageCount = 0;
    private Object usageCountSync = new Object();

    URL getCodeBase() {
        return this.codeBase;
    }

    String getKey() {
        return this.key;
    }

    public AppletClassLoader(URL uRL, String string) {
        super(new URL[0]);
        this.codeBase = uRL;
        this.codeSource = new CodeSource(uRL, (Certificate[])null);
        this.key = string;
    }

    public void addJar(URL uRL) {
        this.addURL(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThreadGroup getThreadGroup() {
        block7: {
            try {
                if (this.threadGroup != null && !this.threadGroup.isDestroyed()) break block7;
                this.threadGroup = new ThreadGroup(this.codeBase + "-threadGroup");
                this.threadGroup.setMaxPriority(4);
                AppContextCreator appContextCreator = new AppContextCreator(this.threadGroup);
                appContextCreator.setContextClassLoader(this);
                Object object = appContextCreator.syncObject;
                synchronized (object) {
                    appContextCreator.start();
                    try {
                        appContextCreator.syncObject.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.appContext = appContextCreator.appContext;
                }
                appContextCreator = null;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        return this.threadGroup;
    }

    protected int getUsageCount() {
        return this.usageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void grab() {
        Object object = this.usageCountSync;
        synchronized (object) {
            ++this.usageCount;
            this.getThreadGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release() {
        Object object = this.usageCountSync;
        synchronized (object) {
            if (this.usageCount > 1) {
                --this.usageCount;
            } else {
                if (this.appContext != null) {
                    try {
                        this.appContext.dispose();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        illegalThreadStateException.printStackTrace(System.err);
                    }
                }
                this.usageCount = 0;
                this.appContext = null;
                this.threadGroup = null;
                AppletPanel.cacheClassLoader(this);
            }
        }
    }

    public AppContextAdapter getAppContext() {
        return this.appContext;
    }

    private String replaceEscapes(String string) throws NumberFormatException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '%') {
                c = (char)Integer.parseInt(string.substring(n + 1, n + 3), 16);
                n += 3;
            } else {
                ++n;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        URL uRL = codeSource.getLocation();
        if (uRL == null) {
            Permissions permissions = new Permissions();
            ((PermissionCollection)permissions).add(new AllPermission());
            return permissions;
        }
        final PermissionCollection permissionCollection = super.getPermissions(codeSource);
        if (uRL.getProtocol().equals("file")) {
            int n;
            String string = uRL.getFile().replace('/', File.separatorChar);
            if (!string.endsWith(File.separator) && (n = string.lastIndexOf(File.separatorChar)) != -1) {
                string = string.substring(0, n + 1) + "-";
                string = this.replaceEscapes(string);
                permissionCollection.add(new FilePermission(string, "read"));
            }
            permissionCollection.add(new SocketPermission("localhost", "connect,accept"));
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        String string = InetAddress.getLocalHost().getHostName();
                        permissionCollection.add(new SocketPermission(string, "connect,accept"));
                    }
                    catch (UnknownHostException unknownHostException) {}
                    return null;
                }
            });
            if (this.codeBase.getProtocol().equals("file")) {
                String string2 = this.codeBase.getFile().replace('/', File.separatorChar);
                if (string2.endsWith(File.separator)) {
                    string2 = string2 + "-";
                }
                string2 = this.replaceEscapes(string2);
                permissionCollection.add(new FilePermission(string2, "read"));
            }
        }
        permissionCollection.add(browserReadPerm);
        permissionCollection.add(browserVerReadPerm);
        if (codeSource.getCertificates() != null && !permissionCollection.implies(usePolicyPermission) && this.allPermissionsGranted(codeSource)) {
            permissionCollection.add(new AllPermission());
        }
        return permissionCollection;
    }

    private boolean allPermissionsGranted(CodeSource codeSource) {
        if (System.getProperty("browser.opera.useCertificateHandler").equals("true")) {
            return CertificateHandler.checkCertificates(codeSource, AppletContextManager.getDocumentPtrFromClassLoader(this));
        }
        return false;
    }

    public URL findResource(String string) {
        URL uRL;
        block3: {
            uRL = super.findResource(string);
            if (uRL != null) break block3;
            try {
                uRL = new URL(this.codeBase, string);
                if (!this.resourceExists(uRL)) {
                    uRL = null;
                }
            }
            catch (Exception exception) {
                uRL = null;
            }
        }
        return uRL;
    }

    private boolean resourceExists(URL uRL) {
        boolean bl;
        block5: {
            bl = true;
            try {
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    int n = httpURLConnection.getResponseCode();
                    if (n == 200) {
                        return true;
                    }
                    if (n >= 400) {
                        return false;
                    }
                    break block5;
                }
                InputStream inputStream = uRLConnection.getInputStream();
                inputStream.close();
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public Enumeration findResources(String string) throws IOException {
        if (string != null && string.indexOf("META-INF/services/javax.sound") != -1) {
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }
        URL uRL = new URL(this.codeBase, string);
        if (!this.resourceExists(uRL)) {
            uRL = null;
        }
        final Enumeration<URL> enumeration = super.findResources(string);
        final URL uRL2 = uRL;
        return new Enumeration(){
            private boolean done;

            public Object nextElement() {
                if (!this.done) {
                    if (enumeration.hasMoreElements()) {
                        return enumeration.nextElement();
                    }
                    this.done = true;
                    if (uRL2 != null) {
                        return uRL2;
                    }
                }
                throw new NoSuchElementException();
            }

            public boolean hasMoreElements() {
                return !this.done && (enumeration.hasMoreElements() || uRL2 != null);
            }
        };
    }

    public Class findClass(String string) throws ClassNotFoundException {
        if (string.equals("com.opera.LCInvoke")) {
            URL uRL = this.getResource(string.replace('.', '/').concat(".class"));
            if (uRL != null) {
                try {
                    URLConnection uRLConnection = uRL.openConnection();
                    if (uRLConnection != null) {
                        int n = uRLConnection.getContentLength();
                        byte[] byArray = new byte[n];
                        uRLConnection.getInputStream().read(byArray, 0, n);
                        return this.defineClass(string, byArray, 0, n, new CodeSource(null, (Certificate[])null));
                    }
                }
                catch (IOException iOException) {
                    throw new ClassNotFoundException(string, iOException);
                }
            }
            throw new ClassNotFoundException(string);
        }
        try {
            return super.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                final String string2 = string.replace('.', '/').concat(".class");
                byte[] byArray = (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return AppletClassLoader.this.readClassFile(new URL(AppletClassLoader.this.codeBase, string2));
                    }
                });
                if (byArray == null) {
                    throw new ClassNotFoundException(string);
                }
                return this.defineClass(string, byArray, 0, byArray.length, this.codeSource);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new ClassNotFoundException(string, privilegedActionException.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readClassFile(URL uRL) throws IOException {
        byte[] byArray;
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection && ((HttpURLConnection)uRLConnection).getResponseCode() >= 400) {
            throw new IOException("HTTP Connection failed.");
        }
        int n = uRLConnection.getContentLength();
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            if (n != -1) {
                byArray = new byte[n];
                while (n > 0) {
                    int n2 = inputStream.read(byArray, byArray.length - n, n);
                    if (n2 == -1) {
                        throw new IOException("Unexpected EOF");
                    }
                    n -= n2;
                }
            } else {
                byte[] byArray2;
                byArray = new byte[1024];
                int n3 = 0;
                while ((n = inputStream.read(byArray, n3, byArray.length - n3)) != -1) {
                    if ((n3 += n) < byArray.length) continue;
                    byArray2 = new byte[n3 * 2];
                    System.arraycopy(byArray, 0, byArray2, 0, n3);
                    byArray = byArray2;
                }
                if (n3 != byArray.length) {
                    byArray2 = new byte[n3];
                    System.arraycopy(byArray, 0, byArray2, 0, n3);
                    byArray = byArray2;
                }
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return byArray;
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        int n;
        String string2 = string.replace('/', '.');
        if (string2.startsWith("[") && (n = string2.lastIndexOf(91)) != -1 && n + 2 < string2.length()) {
            string2 = string2.substring(n + 2);
        }
        if ((n = string2.lastIndexOf(46)) != -1) {
            System.getSecurityManager().checkPackageAccess(string2.substring(0, n));
        }
        if (string.equals("com.opera.LCInvoke")) {
            return this.findClass(string);
        }
        return super.loadClass(string, bl);
    }

    public URL[] getURLs() {
        URL[] uRLArray = super.getURLs();
        URL[] uRLArray2 = new URL[uRLArray.length + 1];
        System.arraycopy(uRLArray, 0, uRLArray2, 0, uRLArray.length);
        uRLArray2[uRLArray2.length - 1] = this.codeBase;
        return uRLArray2;
    }
}

