/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.AppletContext;
import com.opera.AppletContextManager;
import com.opera.AppletEvent;
import com.opera.AppletPanel;
import com.opera.JavaConsole;
import com.opera.StreamHandlerFactory;
import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AllPermission;

class AppletManager {
    private static AppletManager instance;
    private String audioClipClassName;
    private String embedFrameClassName;
    private JavaConsole console;
    private Thread mainThread;
    private Thread profilerServerThread;

    private AppletManager() {
    }

    private void stopSoundDispatcher() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        Thread[] threadArray = new Thread[threadGroup.activeCount()];
        int n = threadGroup.enumerate(threadArray);
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            if (thread.getName().equals("Java Sound event dispatcher")) {
                thread.interrupt();
                break;
            }
            ++n2;
        }
    }

    private void destroy() {
        this.stopSoundDispatcher();
        if (this.console != null) {
            this.console.dispose();
            this.console = null;
        }
        if (this.profilerServerThread != null) {
            this.profilerServerThread.interrupt();
            this.profilerServerThread = null;
        }
    }

    static AppletManager getInstance() {
        if (instance == null) {
            instance = new AppletManager();
        }
        return instance;
    }

    static void destroyInstance() {
        instance.destroy();
        instance = null;
    }

    protected String getAudioClipClassName() {
        return this.audioClipClassName;
    }

    protected String getEmbeddedFrameClassName() {
        return this.embedFrameClassName;
    }

    void showConsole(boolean bl) {
        if (this.console != null) {
            this.console.setVisible(bl);
        }
    }

    boolean isInMainThread() {
        return Thread.currentThread() == this.mainThread;
    }

    void initialiseAppletEnv(String[] stringArray) throws SecurityException {
        Object object;
        Object object2;
        Class<?> clazz;
        this.mainThread = Thread.currentThread();
        this.console = new JavaConsole();
        String string = System.getProperty("browser.opera.runprofiler");
        if (string != null && string.equals("true")) {
            try {
                clazz = Class.forName("com.opera.ProfilerServer");
                object2 = clazz.getConstructor(null);
                object = (Runnable)((Constructor)object2).newInstance(null);
                this.profilerServerThread = new Thread((Runnable)object);
                this.profilerServerThread.start();
            }
            catch (Throwable throwable) {
                System.err.println("Couldn't start profiler server due to following exception:");
                throwable.printStackTrace(System.err);
            }
        }
        try {
            clazz = Class.forName("sun.plugin.security.JDK11ClassFileTransformer");
            object2 = clazz.getMethod("init", null);
            ((Method)object2).invoke(null, (Object[])null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int n = 0;
        while (n < stringArray.length / 2) {
            System.setProperty(stringArray[n * 2], stringArray[n * 2 + 1]);
            ++n;
        }
        object2 = new SecurityManager();
        System.setSecurityManager((SecurityManager)object2);
        object = System.getSecurityManager();
        if (object != null) {
            ((SecurityManager)object).checkPermission(new AllPermission());
        }
        if (System.getProperty("browser.opera.useStreamHandler").equals("true")) {
            URL.setURLStreamHandlerFactory(new StreamHandlerFactory());
        }
        boolean bl = Boolean.valueOf(System.getProperty("browser.opera.useImageCache", "true"));
        boolean bl2 = Boolean.valueOf(System.getProperty("browser.opera.useAudioCache", "true"));
        AppletContext.setCachePolicy(bl, bl2);
        try {
            AppletPanel.setClassLoaderCacheSize(Integer.parseInt(System.getProperty("browser.opera.classLoaderCacheSize", "10")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.audioClipClassName = System.getProperty("browser.opera.audioClipClassName");
        this.embedFrameClassName = System.getProperty("browser.opera.frameClassName");
        if (this.embedFrameClassName != null) {
            this.embedFrameClassName = this.embedFrameClassName.replace('.', '/');
        }
    }

    AppletPanel newApplet(int n, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String string, int n2, int n3, boolean bl) {
        Frame frame = this.createNewFrame(this.embedFrameClassName, n);
        if (frame == null) {
            return null;
        }
        AppletPanel appletPanel = new AppletPanel(stringArray, stringArray2, stringArray3, stringArray4, string, n2, n3, bl);
        frame.add(appletPanel);
        frame.setVisible(true);
        appletPanel.setFrame(frame);
        appletPanel.setVisible(true);
        appletPanel.startHandler();
        appletPanel.sendEvent(new AppletEvent(1));
        appletPanel.sendEvent(new AppletEvent(2));
        appletPanel.sendEvent(new AppletEvent(3));
        return appletPanel;
    }

    void resizeApplet(AppletPanel appletPanel, int n, int n2) {
        Dimension dimension = appletPanel.getSize();
        if (dimension.getWidth() != (double)n || dimension.getHeight() != (double)n2) {
            appletPanel.sendEvent(new AppletEvent(6, new Dimension(n, n2)));
        }
    }

    void destroyApplet(AppletPanel appletPanel) {
        try {
            appletPanel.destroy();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    void deleteDocument(int n) {
        AppletContextManager.deleteDocument(n);
    }

    private native Frame createNewFrame(String var1, int var2);
}

