#-------------------------------------------------------------------------------
#
# Spirit 
# powermedia@qq.com
#
#-------------------------------------------------------------------------------

require 'sketchup.rb'
require 'extensions.rb'

#-------------------------------------------------------------------------------

module PM
    module Plugins
        module Spirit
            ### CONSTANTS ### ------------------------------------------------------------

            # Resource paths
            file = __FILE__.dup
            file.force_encoding("UTF-8") if file.respond_to?(:force_encoding)
            PLUGINS_FOLDER_NAME = File.basename(file, '.*').freeze
            PATH_ROOT           = File.dirname(file).freeze
            PATH                = File.join(PATH_ROOT, PLUGINS_FOLDER_NAME).freeze
            # Plugin information
            PLUGIN          = self
            PLUGIN_ID       = 'PM_Spirit'.freeze
            PLUGIN_NAME     = 'Spirit'.freeze
            PLUGIN_VERSION  =  Sketchup.read_default(PLUGIN_ID, "Version", "2.2.8")


            ### EXTENSION ### ------------------------------------------------------------

            unless file_loaded?(file)
                loader = File.join(PATH, 'startup')
                ex = SketchupExtension.new(PLUGIN_NAME, loader)
                ex.description = 'Spirit • An App Store For Sketchup'
                ex.version     = PLUGIN_VERSION
                ex.copyright   = 'POWERMEDIA © 2016'
                ex.creator     = 'powermedia'
                @extension     = ex
                Sketchup.register_extension(@extension, true)
            end
            
            #-------------------------------------------------------------------------------

            file_loaded(file)

            #-------------------------------------------------------------------------------

        end # module Spirit
    end # module Plugins
end # module PM

