module PM::Plugins::Spirit
    class Translator
        def initialize(filename, options = nil)
            path  = nil  
            unless options.nil?
                unless options.is_a?(Hash)
                    raise ArgumentError, 'Second argument must be Nil or a Hash.'
                end
                path  = options[:custom_path] unless options[:custom_path].nil?
            end
            @strings = parse(filename, path)
        end

        def string_file_path
            @full_file_path
        end

        def parse(filename, custom_path = nil)
            if custom_path
                path = File.expand_path(custom_path)
                @full_file_path = File.join(path, Sketchup.get_locale, filename)
            else
                @full_file_path = Sketchup.get_resource_path(filename)
            end
            strings = Hash.new { |hash, key| key }

            if @full_file_path.nil? || !File.exist?(@full_file_path)
                puts "Warning! Could not load dictionary: #{@full_file_path}"
                return strings
            end
            if Sketchup.version.split('.')[0].to_i < 14
                read_flags = 'r'
            else
                read_flags = 'r:BOM|UTF-8'
            end
            langFile = File.open(@full_file_path, read_flags)
            entryString = ""
            inComment = false
            langFile.each do |line|
                if !line.include?("//")
                    if line.include?("/*")
                        inComment = true
                    end
                    if inComment==true
                        if line.include?("*/")
                            inComment=false
                        end
                    else
                        entryString += line
                    end
                end
                if entryString.include?(";")
                    entryString.strip!
                    keyvalue = entryString.split("\"=\"")
                    key = keyvalue[0][(keyvalue[0].index("\"")+1)..(keyvalue[0].length+1)]
                    keyvalue[1].gsub!(";", "")
                    value = keyvalue[1].gsub("\"", "") 
                    strings[key]=value
                    entryString = ""
                end
            end
            langFile.close
            return strings
        end
        def get(key)
            retval = @strings[key]
            if retval!= nil
                retval=retval.chomp
            else
                retval = key
            end
            return retval
        end
        alias :GetString :get
        def get_strings
            return @strings
        end
    end
end