﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=18632#18632
// AutohideTab.js    ver.2.8    2012-07-19
// Hide tabbar if one tab.
//    Opens files in the current tab if the Alt key holded or the left mouse button pressed.
//    Can open files in the current tab by default, by pressing Alt or LMB in a new tab.
// Usage: Call ("Scripts::Main", 1, "AutohideTab.js"[, "s [p]"])
//    Second call closes the script.
//    s - settings flags, integer 0...15, default 1:
//       b0001 (1) - open files in current tab by default, in new tab if holded Alt.
//       b0010 (2) - don`t restore tabbar on exit.
//       b0100 (4) - if no tabbar on start, then show it at the bottom.
//       b1000 (8) - force tabbar on exit.
//    p - delay time of file opening in milliseconds, default 100:
//       Scripts checks on hold the left mouse button. To give you time to press it after Drag`n`Drop, pause is needed.
//       Example: Call ("Scripts::Main", 1, "AutohideTab.js", "3 120")
// Autorun (in AkelPad.ini or Registry):
//    Add following to "CmdLineBegin": /Call ("Scripts::Main", 1, "AutohideTab.js"[, "s[ p]"])

var hMainWnd = AkelPad.GetMainWnd();
var oSys=AkelPad.SystemFunction();
var pClassName="AkelPad::Scripts::" + WScript.ScriptName + "::" + oSys.Call("kernel32::GetCurrentProcessId");
var hInstanceDLL = AkelPad.GetInstanceDll();
var hWnd;
var options = 1;
var pauseOpen = 100;
var tabState;
var tabBottom = false;
var keyAlt;
var mouseLB;
var framesMany;
var framesManyPrev = 2;

if (hMainWnd && AkelPad.IsMDI())
{
   if (AkelPad.WindowRegisterClass(pClassName))
   {
      hWnd = oSys.Call("user32::CreateWindowEx" + _TCHAR, 0, pClassName, 0, 0x80000000/*WS_POPUP*/, 0,0,0,0, hMainWnd, 0, hInstanceDLL, WindowCallback);
      if (hWnd)
      {
         if (AkelPad.WindowSubClass(hMainWnd, AkelPadCallBack,/*AKDN_*/ 1036 /*EDIT_ONFINISH*/, 1035 /*EDIT_ONSTART*/, 1077 /*OPENDOCUMENT_START*/))
         {
             AkelPad.ScriptNoMutex();
             AkelPad.WindowGetMessage();
             AkelPad.WindowUnsubClass(hMainWnd);
         }
         else
            AkelPad.SendMessage(hWnd, 16 /*WM_CLOSE*/, 0, 0);
      }
      AkelPad.WindowUnregisterClass(pClassName);
   }
   else if (hWnd = oSys.Call("user32::FindWindowEx" + _TCHAR, 0, 0, pClassName, 0))
      AkelPad.SendMessage(hWnd, 16 /*WM_CLOSE*/, 0, 0);
}

function AkelPadCallBack(hwnd,umsg,wparam,lparam)
{
   if (umsg == 1077 /*AKDN_OPENDOCUMENT_START*/)
   {
      keyAlt = oSys.Call("user32::GetAsyncKeyState", 18 /*VK_MENU*/);
      WScript.Sleep(pauseOpen);
      mouseLB = oSys.Call("user32::GetAsyncKeyState", 1 /*VK_LBUTTON*/);
      if ( (((keyAlt < 0) || (mouseLB < 0)) && (!(options & 1))) || (((keyAlt >= 0) && (mouseLB >= 0)) && (options & 1)) )
          AkelPad.Command(4324 /*IDM_WINDOW_FILECLOSE*/);
   }
   else if (umsg == 1035 /*AKDN_EDIT_ONSTART*/)
      OneTabHide(1);
   else if (umsg == 1036 /*AKDN_EDIT_ONFINISH*/)
      OneTabHide(0);
   return 0;
}

function WindowCallback(hwnd, umsg, wparam,lparam)
{
   if (umsg == 1 /*WM_CREATE*/)
   {
      options = GetArg(0, options, 0, 15);
      pauseOpen = GetArg(1, pauseOpen, 0);
      tabState = AkelPad.SendMessage(hMainWnd, 1222 /*AKD_GETMAININFO*/, 157 /*MI_TABoptionsMDI*/, 0);
      if ( (tabState & 4) || ((options & 4)&&(tabState & 1)) )
         tabBottom = true;
      OneTabHide(0);
   }
   else if (umsg == 16 /*WM_CLOSE*/)
   {
      if (((options&8) && (tabBottom)) || ((!(options&2)) && (tabState&4)))
         AkelPad.Command(4302 /*IDM_WINDOW_TABVIEW_BOTTOM*/);
      else if ((!(options&2)) && (tabState&1) && (!(options&8)))
         AkelPad.Command(4303 /*IDM_WINDOW_TABVIEW_NONE*/);
      else if ((!(options&2)) || (options&8))
         AkelPad.Command(4301 /*IDM_WINDOW_TABVIEW_TOP*/);
      oSys.Call("user32::DestroyWindow", hwnd);
   }
   else if (umsg == 2 /*WM_DESTROY*/)
      oSys.Call("user32::PostQuitMessage", 0);
   return 0;
}

function OneTabHide(shift)
{
   framesMany = ((AkelPad.SendMessage(hMainWnd, 1291 /*AKD_FRAMESTATS*/, 0 /*FWS_COUNTALL*/, 0) + shift) > 1)?true:false;
   if (framesMany != framesManyPrev)
   {
      framesManyPrev = framesMany;
      if (framesMany)
      {
         if (tabBottom)    AkelPad.Command(4302 /*IDM_WINDOW_TABVIEW_BOTTOM*/);
         else        AkelPad.Command(4301 /*IDM_WINDOW_TABVIEW_TOP*/);
      }
      else      AkelPad.Command(4303 /*IDM_WINDOW_TABVIEW_NONE*/);
   }
}

function GetArg(aNum, aDef, aFrom, aTo)
{
   if (WScript.Arguments.length > aNum)
   {
      var aValue = +WScript.Arguments(aNum);
      if ((Math.floor(aValue) == aValue) && (aValue >= aFrom) && ((aTo === undefined) || (aValue <= aTo)))
         return aValue;
   }
   return aDef;
}