﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=15158#15158
// Description(1033): Show area/window code navigation
// Description(1049): Отображение области/окна навигации по коду
// Version: 1.4 (2015.01.14)
// Author: VladSh
// 
// Usage:
// 	-"Область навигации слева" Call("Scripts::Main", 1, "CodeFoldSwitcher.js") Icon("%a\AkelFiles\Plugs\Coder.dll", 1)		-	при отключении отключает и окошко, т.к. окошко без области слева вывести невозможно (
// 	-"Окно навигации..." Call("Scripts::Main", 1, "CodeFoldSwitcher.js", `-ShowDock=1`) Icon("%a\AkelFiles\Plugs\Coder.dll", 3)		-	отображает область с окошком, скрывает только окошко
// 	-"Область навигации с окном" Call("Scripts::Main", 1, "CodeFoldSwitcher.js", `-ShowDock=1 -hideAll=1`) Icon("%a\AkelFiles\Plugs\Coder.dll", 3)		-	отображает область с окошком и скрывает их все

var pParameterName = "ShowDock";

var nShowArg = AkelPad.GetArgValue(pParameterName, 0);		//наличие окошка: командуем при вызове
var nHideAll = AkelPad.GetArgValue("hideAll", 0);

var pPluginFileName = "Coder";
var oSet = AkelPad.ScriptSettings();
var nType = 1 /*PO_DWORD*/;

var nShowDock;		//наличие окошка: что имеется в настройках

if (oSet.Begin(pPluginFileName, 0x21 /* POB_PLUGS + POB_READ */)) {
	nShowDock = oSet.Read(pParameterName, nType) || 0;
	oSet.End();
}

var cf = pPluginFileName + "::CodeFold";
if (AkelPad.IsPluginRunning(cf)) {
	if (nShowArg) {
		AkelPad.Call(cf, 1);
		if (nHideAll && nShowDock)		//на строчке выше ShowDock изменился, но если он раньше был включен, значит надо погасить
			AkelPad.Call(cf);	//выключаем плаг
	}
	else {
		if (nShowDock)
			AkelPad.Call(cf, 1);	//выключаем окошко
		AkelPad.Call(cf);	//выключаем плаг
	}
}
else {
	if (!nShowArg && nShowDock) {
		//для случая, когда окно включать ненужно, но в ini указано ShowDock=1 (мог остаться там при нажатии стандартных кнопок либо закрывалась прога с открытым окном)
		if (oSet.Begin(pPluginFileName, 0x22 /* POB_PLUGS + POB_SAVE */)) {
			nShowDock = oSet.Write(pParameterName, nType, 0);
			oSet.End();
		}
	}
	
	AkelPad.Call(cf);	//загружаем плаг - включается область навигации слева и то, что указано в ShowDock в ini
	
	if (nShowArg && !nShowDock)		//для случая, когда окно нужно включить, а в ini ShowDock=0, ещё одним запуском с "1" выводим и окошко
		AkelPad.Call(cf, 1);
}