// Columnar Select All

var hMainWnd     = AkelPad.GetMainWnd();

if (hMainWnd)
{
  var DT_DWORD              = 3;
  var AEM_SETSEL            = 3126;
  var AEM_INDEXUPDATE       = 3132;

  var hEditWnd     = AkelPad.GetEditWnd();
  var oSys         = AkelPad.SystemFunction();

  var lpCaret  = AkelPad.MemAlloc(12 /*sizeof(AECHARINDEX)*/);
  var lpSelect = AkelPad.MemAlloc(28 /*sizeof(AESELECTION)*/);

  var lpBegSel  = lpSelect;
  var lpEndSel  = lpSelect + 12;
  var lpSelFlag = lpSelect + 24;
  var lpBegL    = lpBegSel;
  var lpBegC    = lpBegSel + 8;
  var lpEndL    = lpEndSel;
  var lpEndC    = lpEndSel + 8;
  var lpCarL    = lpCaret;
  var lpCarC    = lpCaret + 8;

  ColSelAll();

  AkelPad.MemFree(lpCaret);
  AkelPad.MemFree(lpSelect);
}

function ColSelAll()
{
  var nBegL;
  var nBegC;
  var nEndL;
  var nEndC;
  var i;

  var bColSel = 1;

  aLines    =AkelPad.GetTextRange(0, -1, 1 /*"\r"*/).split("\r");

  // Support DoubleByteCharacter, Such as Chinese, Janpanese, Korean...
  String.prototype.getBytesLength = function()
  {
    return this.replace(/[^\u0000-\u00ff]/gi, "--").length;
  }

  var MaxLineBytesLength = 0;

  for (i = 0; i < aLines.length; ++i)
  {
    if (aLines[i].getBytesLength() > MaxLineBytesLength)
    {
      MaxLineBytesLength = aLines[i].getBytesLength();
    }
  }

  nBegL = 0;
  nBegC = 0;
  nEndL = aLines.length-1;
  nEndC = MaxLineBytesLength - aLines[nEndL].getBytesLength() + aLines[nEndL].length;

  if (nBegC < nEndC)
    CopyCoordinatesToIndex(nBegL, nBegC, nEndL, nEndC, nEndL, nEndC);
  else
    CopyCoordinatesToIndex(nBegL, nEndC, nEndL, nBegC, nEndL, nBegC);

  AkelPad.SendMessage(hEditWnd, AEM_INDEXUPDATE, 0, lpBegSel);
  AkelPad.SendMessage(hEditWnd, AEM_INDEXUPDATE, 0, lpEndSel);
  AkelPad.SendMessage(hEditWnd, AEM_INDEXUPDATE, 0, lpCaret);

  AkelPad.MemCopy(lpSelFlag, bColSel, DT_DWORD);
  AkelPad.SendMessage(hEditWnd, AEM_SETSEL, lpCaret, lpSelect);

  oSys.Call("user32::InvalidateRect", hEditWnd, 0, true);
}

function CopyCoordinatesToIndex(n1, n2, n3, n4, n5, n6)
{
  AkelPad.MemCopy(lpBegL, n1, DT_DWORD);
  AkelPad.MemCopy(lpBegC, n2, DT_DWORD);
  AkelPad.MemCopy(lpEndL, n3, DT_DWORD);
  AkelPad.MemCopy(lpEndC, n4, DT_DWORD);
  AkelPad.MemCopy(lpCarL, n5, DT_DWORD);
  AkelPad.MemCopy(lpCarC, n6, DT_DWORD);
}
