﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=1988#1988
// Description(1033): Delete file
// Description(1049): Удаляет файл (текущий открытый на экране либо из списка свежих либо др.)
///	если в это время открыта панель Explorer-плагина, то дополнительно производится обновление списка файлов
// Version: 2.6 (2015.10.17)
// Author: VladSh
// 
// Arguments:
// 	-file - deleted file
// 	-warn ([false]/true) - show warning to confirm deletion
// 	-updRecent ([false]/true) - update recent list
// 
// Usage:
// 	-"Delete file" Call("Scripts::Main", 1, "DeleteFile.js", `-file="%f" -warn=true -updRecent=true`) Icon("%a\AkelFiles\Plugs\ToolBar.dll", 25)		- delete file from recent list with warning
// 	-"Delete file" Call("Scripts::Main", 1, "DeleteFile.js") Icon("%a\AkelFiles\Plugs\ToolBar.dll", 25)		- delete current file without warning

var hWndMain = AkelPad.GetMainWnd()

var pFileCurrent = AkelPad.GetEditFile(0);
var pFileFullName = AkelPad.GetArgValue("file", pFileCurrent);

var fso = new ActiveXObject("Scripting.FileSystemObject");
var bFileExist = fso.FileExists(pFileFullName)

if (bFileExist && AkelPad.GetArgValue("warn", false)) {
	if (AkelPad.MessageBox(hWndMain, 'Delete this file ' + pFileFullName + '?', WScript.ScriptName, 4 /*MB_YESNO*/ + 48 /*MB_ICONEXCLAMATION*/) == 7 /*IDNO*/)
		WScript.Quit();
}

if (pFileFullName == pFileCurrent) {
	AkelPad.SendMessage(hWndMain, 1229 /*AKD_SETMODIFY*/, 0, false);
	
	AkelPad.Command(4324 /*IDM_WINDOW_FILECLOSE*/);
	AkelPad.Command(4318 /*IDM_WINDOW_FRAMECLOSE*/);
}

if (pFileFullName) {
	if (bFileExist) {
		fso.DeleteFile(pFileFullName, true);
		var pExplorer = "Explorer::Main";
		if (AkelPad.IsPluginRunning(pExplorer)) {
			AkelPad.Call(pExplorer, 2);
		}
	}
	if (AkelPad.GetArgValue("updRecent", false)) {
		deleteRecentRecord(pFileFullName);
	}
}

/* Instructor's code (from DeleteRecentFile.js) */
function deleteRecentRecord(pFile) {
	var nIndex;
	if ((nIndex = AkelPad.SendMessage(hWndMain, 1238 /*AKD_RECENTFILES*/, 7 /*RF_FINDINDEX*/, AkelPad.MemStrPtr(pFile))) >= 0) {
		if (AkelPad.SendMessage(hWndMain, 1238 /*AKD_RECENTFILES*/, 8 /*RF_DELETEINDEX*/, nIndex))
			AkelPad.SendMessage(hWndMain, 1238 /*AKD_RECENTFILES*/, 4 /*RF_SAVE*/, 0);
	}
}