﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=1653#1653
// Description(1033): Needed to determine the type of commentary for the current file. Script implemented as the library for using in other scripts.
// Description(1049): Необходима для работы скриптов простановки комментариев. 
// Version: 3.13 (2014.12.19)
// Author: VladSh

var cBlockOpen;
var cBlockClose;
var cSimple;

var commentsSets = {
	// (c) Infocatcher
	//= extension: [
	//=     [blockCmmStart0, blockCmmStart1],
	//=     [blockCmmEnd0, blockCmmEnd1],
	//=     [lineCmm]
	//= ]
	// Or
	//= otherExtension: "extension"
	//= "extension" must be already defined!
	// Use 'null' (without commas) for unavailable comments type.
	// First string will be used for comments adding (blockCmmStart0 and blockCmmEnd0 in example).
	c: ["/*", "*/", "//"],
	cpp: "c",
	h: "c",
	js: "c",
	jsm: "c",
	java: "c",
	php: "c",
	dpr: ["{", "}", "//"],
	pas: "dpr",
	html: ["<!--", "-->", "//"],		//добавил возможность коментить js-код внутри html
	xhtml: "html",
	shtml: "html",
	htm: "html",
	xml: "html",
	xsl: "html",
	xul: "html",
	xbl: "html",
	rdf: "html",
	dtd: "html",
	css: ["/*", "*/", null],
	sql: ["/*", "*/", "--"],
	tpl: ["{*", "*}", "//"],
	ini: [null, null, ";"],
	asm: "ini",
	ahk: "ini",
	mnu: "ini",		//AkelPad menu file
	highlight: "ini",
	coder: "ini",
	spck: "ini",
	au3: ["#cs", "#ce", ";"],
	bat: [null, null, "rem "],
	vbs: [null, null, "'"],
	lss: ["%REM", "%END REM", "'"],
	manifest: [null, null, "#"],
	properties: "manifest",
	htaccess: "manifest",
	py: [null, null, "#"],
	pyw: "py"
};

function setComments(ext) {
	if (ext == "")
		ext = "c";		//by default
	
	var cmmSet = commentsSets[ext];
	if (typeof(cmmSet) == "string")
		cmmSet = commentsSets[cmmSet];
	
	if (cmmSet == undefined) {
		AkelPad.MessageBox(AkelPad.GetEditWnd(), 'Для расширения "' + ext + '" комментарии не заданы!', WScript.ScriptName, 48 /*MB_EXCLAMATION*/);
		WScript.Quit();
	}
	
	cBlockOpen = cmmSet[0];
	cBlockClose = cmmSet[1];
	cSimple = cmmSet[2];
}