// COMCTL32.DLL constants;
// Common control window classes
	HOTKEY_CLASS		='msctls_hotkey32';
	PROGRESS_CLASS		='msctls_progress32';
	STATUS_CLASS		='msctls_statusbar32';
	TRACKBAR_CLASS		='msctls_trackbar32';
	UPDOWN_CLASS		='msctls_updown32';
	TOOLTIPS_CLASS		='tooltips_class32';
	ANIMATE_CLASS		='SysAnimate32';
	HEADER_CLASS		='SysHeader32';
	LISTVIEW_CLASS		='SysListView32';
	TREEVIEW_CLASS		='SysTreeView32';
	TABCONTROL_CLASS	='SysTabControl32';
	MONTHCAL_CLASS		='SysMonthCal32';
	DATETIMEPICK_CLASS	='SysDateTimePick32';
	TOOLBAR_CLASS		='ToolbarWindow32';
	REBAR_CLASS			='ReBarWindow32';
// Ranges for control message IDs
	LVM_FIRST	= 0x1000;
	TV_FIRST	= 0x1100;
	HDM_FIRST	= 0x1200;
	TCM_FIRST	= 0x1300;
	MCM_FIRST	= 0x1000;
	DTM_FIRST	= 0x1000;
	CCM_FIRST	= 0x2000;
// Ranges for control notification IDs
	NM_FIRST	= 0;
	LVN_FIRST	= -100;
	PSN_FIRST	= -200;
	HDN_FIRST	= -300;
	TVN_FIRST	= -400;
	TTN_FIRST	= -520;
	TCN_FIRST	= -550;
	CDN_FIRST	= -601;
	TBN_FIRST	= -700;
	UDN_FIRST	= -721;
	MCN_FIRST	= -750;
	DTN_FIRST	= -760;
	CBEN_FIRST	= -800;
	RBN_FIRST	= -831;
// Generic notifications
	NM_OUTOFMEMORY		= NM_FIRST - 1;
	NM_CLICK			= NM_FIRST - 2;
	NM_DBLCLK			= NM_FIRST - 3;
	NM_RETURN			= NM_FIRST - 4;
	NM_RCLICK			= NM_FIRST - 5;
	NM_RDBLCLK			= NM_FIRST - 6;
	NM_SETFOCUS			= NM_FIRST - 7;
	NM_KILLFOCUS		= NM_FIRST - 8;
	NM_CUSTOMDRAW		= NM_FIRST - 12;
// Common control styles
	CCS_TOP				= 0x01;
	CCS_NOMOVEY			= 0x02;
	CCS_BOTTOM			= 0x03;
	CCS_NORESIZE		= 0x04;
	CCS_NOPARENTALIGN	= 0x08;
	CCS_ADJUSTABLE		= 0x20;
	CCS_NODIVIDER		= 0x40;
	CCS_VERT			= 0x80;
	CCS_LEFT			= CCS_VERT + CCS_TOP;
	CCS_RIGHT			= CCS_VERT + CCS_BOTTOM;
	CCS_NOMOVEX			= CCS_VERT + CCS_NOMOVEY;
// Owner-drawn control types
	ODT_HEADER		= 100;
	ODT_TAB			= 101;
	ODT_LISTVIEW	= 102;
// InitCommonControlsEx classes
	ICC_ANIMATE_CLASS			= 0x0080;
	ICC_BAR_CLASSES				= 0x0004;
	ICC_COOL_CLASSES			= 0x0400;
	ICC_DATE_CLASSES			= 0x0100;
	ICC_HOTKEY_CLASS			= 0x0040;
	ICC_INTERNET_CLASSES		= 0x0800;
	ICC_LISTVIEW_CLASSES		= 0x0001;
	ICC_PAGESCROLLER_CLASS		= 0x1000;
	ICC_PROGRESS_CLASS			= 0x0020;
	ICC_TAB_CLASSES				= 0x0008;
	ICC_TREEVIEW_CLASSES		= 0x0002;
	ICC_UPDOWN_CLASS			= 0x0010;
	ICC_USEREX_CLASSES			= 0x0200;
	ICC_WIN95_CLASSES			= 0x00FF;
// Shared messages
	CCM_SETCOLORSCHEME		= CCM_FIRST + 2;
	CCM_GETCOLORSCHEME		= CCM_FIRST + 3;
	CCM_GETDROPTARGET		= CCM_FIRST + 4;
	CCM_SETUNICODEFORMAT	= CCM_FIRST + 5;
	CCM_GETUNICODEFORMAT	= CCM_FIRST + 6;
// Property sheet page flags
	PSP_DEFAULT			= 0x0000;
	PSP_DLGINDIRECT		= 0x0001;
	PSP_USEHICON		= 0x0002;
	PSP_USEICONID		= 0x0004;
	PSP_USETITLE		= 0x0008;
	PSP_HASHELP			= 0x0020;
	PSP_USEREFPARENT	= 0x0040;
	PSP_USECALLBACK	= 0x0080;
// Property sheet page actions
	PSPCB_RELEASE	= 1;
	PSPCB_CREATE	= 2;
// Property sheet header flags
	PSH_DEFAULT			= 0x0000;
	PSH_PROPTITLE		= 0x0001;
	PSH_USEHICON		= 0x0002;
	PSH_USEICONID		= 0x0004;
	PSH_PROPSHEETPAGE	= 0x0008;
	PSH_MULTILINETABS	= 0x0010;
	PSH_WIZARD			= 0x0020;
	PSH_USEPSTARTPAGE	= 0x0040;
	PSH_NOAPPLYNOW		= 0x0080;
	PSH_USECALLBACK		= 0x0100;
	PSH_HASHELP			= 0x0200;
	PSH_MODELESS		= 0x0400;
// Property sheet actions
	PSCB_INITIALIZED	= 1;
// Property sheet notifications
	PSN_SETACTIVE		= PSN_FIRST - 0;
	PSN_KILLACTIVE		= PSN_FIRST - 1;
	PSN_APPLY			= PSN_FIRST - 2;
	PSN_RESET			= PSN_FIRST - 3;
	PSN_HELP			= PSN_FIRST - 5;
	PSN_WIZBACK			= PSN_FIRST - 6;
	PSN_WIZNEXT			= PSN_FIRST - 7;
	PSN_WIZFINISH		= PSN_FIRST - 8;
	PSN_QUERYCANCEL		= PSN_FIRST - 9;
// Property sheet return values
	PSNRET_NOERROR					= 0;
	PSNRET_INVALID					= 1;
	PSNRET_INVALID_NOCHANGEPAGE	= 2;
// Property sheet messages
	PSM_SETCURSEL				= 0x0400 + 101;
	PSM_REMOVEPAGE				= 0x0400 + 102;
	PSM_ADDPAGE					= 0x0400 + 103;
	PSM_CHANGED					= 0x0400 + 104;
	PSM_RESTARTWINDOWS			= 0x0400 + 105;
	PSM_REBOOTSYSTEM			= 0x0400 + 106;
	PSM_CANCELTOCLOSE			= 0x0400 + 107;
	PSM_QUERYSIBLINGS			= 0x0400 + 108;
	PSM_UNCHANGED				= 0x0400 + 109;
	PSM_APPLY					= 0x0400 + 110;
	PSM_SETTITLEA				= 0x0400 + 111;
	PSM_SETTITLEW				= 0x0400 + 120;
	PSM_SETTITLE				= AkelPad.IsOldWindows()?PSM_SETTITLEA:PSM_SETTITLEW;
	PSM_SETWIZBUTTONS			= 0x0400 + 112;
	PSM_PRESSBUTTON				= 0x0400 + 113;
	PSM_SETCURSELID				= 0x0400 + 114;
	PSM_SETFINISHTEXTA			= 0x0400 + 115;
	PSM_SETFINISHTEXTW			= 0x0400 + 121;
	PSM_SETFINISHTEXT			= AkelPad.IsOldWindows()?PSM_SETFINISHTEXTA:PSM_SETFINISHTEXTW;
	PSM_GETTABCONTROL			= 0x0400 + 116;
	PSM_ISDIALOGMESSAGE			= 0x0400 + 117;
// Property sheet buttons
	PSBTN_BACK				= 0;
	PSBTN_NEXT				= 1;
	PSBTN_FINISH			= 2;
	PSBTN_OK				= 3;
	PSBTN_APPLYNOW			= 4;
	PSBTN_CANCEL			= 5;
	PSBTN_HELP				= 6;
	PSWIZB_BACK				= 1;
	PSWIZB_NEXT				= 2;
	PSWIZB_FINISH			= 4;
	PSWIZB_DISABLEDFINISH	= 8;
	ID_PSRESTARTWINDOWS		= 2;
	ID_PSREBOOTSYSTEM		= ID_PSRESTARTWINDOWS + 1;
// Property sheet sizes
	PROP_SM_CXDLG			= 212;
	PROP_SM_CYDLG			= 188;
	PROP_MED_CXDLG			= 227;
	PROP_MED_CYDLG			= 215;
	PROP_LG_CXDLG			= 252;
	PROP_LG_CYDLG			= 218;
	WIZ_CXDLG				= 276;
	WIZ_CYDLG				= 140;
	WIZ_CXBMP				= 80;
	WIZ_BODYX				= 92;
	WIZ_BODYCX				= 184;
// Image list types
	ILC_MASK			= 0x001;
	ILC_COLOR			= 0x0FE;
	ILC_COLORDDB		= 0x0FE;
	ILC_COLOR4			= 0x004;
	ILC_COLOR8			= 0x008;
	ILC_COLOR16			= 0x010;
	ILC_COLOR24			= 0x018;
	ILC_COLOR32			= 0x020;
	ILC_PALETTE			= 0x800;
// Image list color values
	CLR_NONE			= 0x0FFFFFFFF;
	CLR_DEFAULT			= 0x0FF000000;
	CLR_HILIGHT			= CLR_DEFAULT;
// Image list drawing styles
	ILD_NORMAL		= 0x0000;
	ILD_TRANSPARENT	= 0x0001;
	ILD_MASK		= 0x0010;
	ILD_IMAGE		= 0x0020;
	ILD_BLEND25		= 0x0002;
	ILD_BLEND50		= 0x0004;
	ILD_OVERLAYMASK	= 0x0F00;
	ILD_SELECTED	= ILD_BLEND50;
	ILD_FOCUS		= ILD_BLEND25;
	ILD_BLEND		= ILD_BLEND50;
// Header control styles
	HDS_HORZ		= 0x00;
	HDS_BUTTONS		= 0x02;
	HDS_HOTTRACK	= 0x04;
	HDS_HIDDEN		= 0x08;
	HDS_DRAGDROP	= 0x40;
	HDS_FULLDRAG	= 0x80;
// Header control structure flags
	HDI_WIDTH	= 0x01;
	HDI_HEIGHT	= HDI_WIDTH;
	HDI_TEXT	= 0x02;
	HDI_FORMAT	= 0x04;
	HDI_LPARAM	= 0x08;
	HDI_BITMAP	= 0x10;
// Header control flags
	HDF_LEFT		= 0x0000;
	HDF_RIGHT		= 0x0001;
	HDF_CENTER		= 0x0002;
	HDF_JUSTIFYMASK	= 0x0003;
	HDF_RTLREADING	= 0x0004;
	HDF_BITMAP		= 0x2000;
	HDF_STRING		= 0x4000;
	HDF_OWNERDRAW	= 0x8000;
// Header control messages
	HDM_GETITEMCOUNT	= HDM_FIRST + 0;
	HDM_INSERTITEMA		= HDM_FIRST + 1;
	HDM_DELETEITEM		= HDM_FIRST + 2;
	HDM_GETITEMA		= HDM_FIRST + 3;
	HDM_SETITEMA		= HDM_FIRST + 4;
	HDM_LAYOUT			= HDM_FIRST + 5;
	HDM_HITTEST			= HDM_FIRST + 6;
	HDM_INSERTITEMW		= HDM_FIRST + 10;
	HDM_GETITEMW		= HDM_FIRST + 11;
	HDM_SETITEMW		= HDM_FIRST + 12;
	HDM_INSERTITEM		= AkelPad.IsOldWindows()?HDM_INSERTITEMA:HDM_INSERTITEMW;
	HDM_GETITEM			= AkelPad.IsOldWindows()?HDM_GETITEMA:HDM_GETITEMW;
	HDM_SETITEM			= AkelPad.IsOldWindows()?HDM_SETITEMA:HDM_SETITEMW;
// Hit test result flags
	HHT_NOWHERE		= 0x001;
	HHT_ONHEADER	= 0x002;
	HHT_ONDIVIDER	= 0x004;
	HHT_ONDIVOPEN	= 0x008;
	HHT_ABOVE		= 0x100;
	HHT_BELOW		= 0x200;
	HHT_TORIGHT		= 0x400;
	HHT_TOLEFT		= 0x800;
// Header control notifications
	HDN_ITEMCHANGINGA			= HDN_FIRST - 0;
	HDN_ITEMCHANGEDA			= HDN_FIRST - 1;
	HDN_ITEMCLICKA				= HDN_FIRST - 2;
	HDN_ITEMDBLCLICKA			= HDN_FIRST - 3;
	HDN_DIVIDERDBLCLICKA		= HDN_FIRST - 5;
	HDN_BEGINTRACKA				= HDN_FIRST - 6;
	HDN_ENDTRACKA				= HDN_FIRST - 7;
	HDN_TRACKA					= HDN_FIRST - 8;
	HDN_ITEMCHANGINGW			= HDN_FIRST - 20;
	HDN_ITEMCHANGEDW			= HDN_FIRST - 21;
	HDN_ITEMCLICKW				= HDN_FIRST - 22;
	HDN_ITEMDBLCLICKW			= HDN_FIRST - 23;
	HDN_DIVIDERDBLCLICKW		= HDN_FIRST - 25;
	HDN_BEGINTRACKW				= HDN_FIRST - 26;
	HDN_ENDTRACKW				= HDN_FIRST - 27;
	HDN_TRACKW					= HDN_FIRST - 28;
	HDN_ITEMCHANGING			= AkelPad.IsOldWindows()?HDN_ITEMCHANGINGA:HDN_ITEMCHANGINGW;
	HDN_ITEMCHANGED				= AkelPad.IsOldWindows()?HDN_ITEMCHANGEDA:HDN_ITEMCHANGEDW;
	HDN_ITEMCLICK				= AkelPad.IsOldWindows()?HDN_ITEMCLICKA:HDN_ITEMCLICKW;
	HDN_ITEMDBLCLICK			= AkelPad.IsOldWindows()?HDN_ITEMDBLCLICKA:HDN_ITEMDBLCLICKW;
	HDN_DIVIDERDBLCLICK			= AkelPad.IsOldWindows()?HDN_DIVIDERDBLCLICKA:HDN_DIVIDERDBLCLICKW;
	HDN_BEGINTRACK				= AkelPad.IsOldWindows()?HDN_BEGINTRACKA:HDN_BEGINTRACKW;
	HDN_ENDTRACK				= AkelPad.IsOldWindows()?HDN_ENDTRACKA:HDN_ENDTRACKW;
	HDN_TRACK					= AkelPad.IsOldWindows()?HDN_TRACKA:HDN_TRACKW;
// Toolbar bitmap flags
	CMB_MASKED	= 2;
// Toolbar button states
	TBSTATE_CHECKED			= 0x01;
	TBSTATE_PRESSED			= 0x02;
	TBSTATE_ENABLED			= 0x04;
	TBSTATE_HIDDEN			= 0x08;
	TBSTATE_INDETERMINATE	= 0x10;
	TBSTATE_WRAP			= 0x20;
	TBSTATE_ELLIPSES		= 0x40;
// Toolbar button styles
	TBSTYLE_BUTTON			= 0x0000;
	TBSTYLE_SEP				= 0x0001;
	TBSTYLE_CHECK			= 0x0002;
	TBSTYLE_GROUP			= 0x0004;
	TBSTYLE_CHECKGROUP		= TBSTYLE_GROUP + TBSTYLE_CHECK;
	TBSTYLE_DROPDOWN		= 0x0008;
	TBSTYLE_TOOLTIPS		= 0x0100;
	TBSTYLE_WRAPABLE		= 0x0200;
	TBSTYLE_ALTDRAG			= 0x0400;
	TBSTYLE_FLAT			= 0x0800;
	TBSTYLE_LIST			= 0x1000;
	TBSTYLE_CUSTOMERASE		= 0x2000;
	TBSTYLE_TRANSPARENT		= 0x8000;
// Toolbar button extended styles
	TBSTYLE_EX_DRAWDDARROWS	= 0x0001;
// Toolbar messages
	TB_ENABLEBUTTON			= 0x0400 + 1;
	TB_CHECKBUTTON			= 0x0400 + 2;
	TB_PRESSBUTTON			= 0x0400 + 3;
	TB_HIDEBUTTON			= 0x0400 + 4;
	TB_INDETERMINATE		= 0x0400 + 5;
	TB_ISBUTTONENABLED		= 0x0400 + 9;
	TB_ISBUTTONCHECKED		= 0x0400 + 10;
	TB_ISBUTTONPRESSED		= 0x0400 + 11;
	TB_ISBUTTONHIDDEN		= 0x0400 + 12;
	TB_ISBUTTONINDETERMINATE	= 0x0400 + 13;
	TB_SETSTATE				= 0x0400 + 17;
	TB_GETSTATE				= 0x0400 + 18;
	TB_ADDBITMAP			= 0x0400 + 19;
	TB_ADDBUTTONS			= 0x0400 + 20;
	TB_INSERTBUTTON			= 0x0400 + 21;
	TB_DELETEBUTTON			= 0x0400 + 22;
	TB_GETBUTTON			= 0x0400 + 23;
	TB_BUTTONCOUNT			= 0x0400 + 24;
	TB_COMMANDTOINDEX		= 0x0400 + 25;
	TB_SAVERESTOREA			= 0x0400 + 26;
	TB_ADDSTRINGA			= 0x0400 + 28;
	TB_CUSTOMIZE			= 0x0400 + 27;
	TB_GETITEMRECT			= 0x0400 + 29;
	TB_BUTTONSTRUCTSIZE		= 0x0400 + 30;
	TB_SETBUTTONSIZE		= 0x0400 + 31;
	TB_SETBITMAPSIZE		= 0x0400 + 32;
	TB_AUTOSIZE				= 0x0400 + 33;
	TB_GETTOOLTIPS			= 0x0400 + 35;
	TB_SETTOOLTIPS			= 0x0400 + 36;
	TB_SETPARENT			= 0x0400 + 37;
	TB_SETROWS				= 0x0400 + 39;
	TB_GETROWS				= 0x0400 + 40;
	TB_GETBITMAPFLAGS		= 0x0400 + 41;
	TB_SETCMDID				= 0x0400 + 42;
	TB_CHANGEBITMAP			= 0x0400 + 43;
	TB_GETBITMAP			= 0x0400 + 44;
	TB_GETBUTTONTEXTA		= 0x0400 + 45;
	TB_REPLACEBITMAP		= 0x0400 + 46;
	TB_SETINDENT			= 0x0400 + 47;
	TB_SETIMAGELIST			= 0x0400 + 48;
	TB_GETIMAGELIST			= 0x0400 + 49;
	TB_LOADIMAGES			= 0x0400 + 50;
	TB_GETRECT				= 0x0400 + 51;
	TB_SETHOTIMAGELIST		= 0x0400 + 52;
	TB_GETHOTIMAGELIST		= 0x0400 + 53;
	TB_SETDISABLEDIMAGELIST	= 0x0400 + 54;
	TB_GETDISABLEDIMAGELIST	= 0x0400 + 55;
	TB_SETSTYLE				= 0x0400 + 56;
	TB_GETSTYLE				= 0x0400 + 57;
	TB_GETBUTTONSIZE		= 0x0400 + 58;
	TB_SETBUTTONWIDTH		= 0x0400 + 59;
	TB_SETMAXTEXTROWS		= 0x0400 + 60;
	TB_GETTEXTROWS			= 0x0400 + 61;
	TB_GETBUTTONTEXTW		= 0x0400 + 75;
	TB_SAVERESTOREW			= 0x0400 + 76;
	TB_ADDSTRINGW			= 0x0400 + 77;
	TB_SETEXTENDEDSTYLE		= 0x0400 + 84;
	TB_GETEXTENDEDSTYLE		= 0x0400 + 85;
	TB_GETBUTTONTEXT		= AkelPad.IsOldWindows()?TB_GETBUTTONTEXTA:TB_GETBUTTONTEXTW;
	TB_SAVERESTORE			= AkelPad.IsOldWindows()?TB_SAVERESTOREA:TB_SAVERESTOREW;
	TB_ADDSTRING			= AkelPad.IsOldWindows()?TB_ADDSTRINGA:TB_ADDSTRINGW;
// System-defined button bitmaps
	HINST_COMMCTRL			= -1;
	IDB_STD_SMALL_COLOR		= 0;
	IDB_STD_LARGE_COLOR		= 1;
	IDB_VIEW_SMALL_COLOR	= 4;
	IDB_VIEW_LARGE_COLOR	= 5;
	IDB_HIST_SMALL_COLOR	= 8;
	IDB_HIST_LARGE_COLOR	= 9;
// Icon indexes for standard bitmap
	STD_CUT				= 0;
	STD_COPY			= 1;
	STD_PASTE			= 2;
	STD_UNDO			= 3;
	STD_REDOW			= 4;
	STD_DELETE			= 5;
	STD_FILENEW			= 6;
	STD_FILEOPEN		= 7;
	STD_FILESAVE		= 8;
	STD_PRINTPRE		= 9;
	STD_PROPERTIES		= 10;
	STD_HELP			= 11;
	STD_FIND			= 12;
	STD_REPLACE			= 13;
	STD_PRINT			= 14;
// Icon indexes for standard view bitmap
	VIEW_LARGEICONS			= 0;
	VIEW_SMALLICONS			= 1;
	VIEW_LIST				= 2;
	VIEW_DETAILS			= 3;
	VIEW_SORTNAME			= 4;
	VIEW_SORTSIZE			= 5;
	VIEW_SORTDATE			= 6;
	VIEW_SORTTYPE			= 7;
	VIEW_PARENTFOLDER		= 8;
	VIEW_NETCONNECT			= 9;
	VIEW_NETDISCONNECT		= 10;
	VIEW_NEWFOLDER			= 11;
// Icon indexes for history bitmap
	HIST_BACK					= 0;
	HIST_FORWARD				= 1;
	HIST_FAVORITES				= 2;
	HIST_ADDTOFAVORITES			= 3;
	HIST_VIEWTREE				= 4;
// Toolbar bitmap flags
	TBBF_LARGE	= 1;
// Toolbar notifications
	TBN_GETBUTTONINFOA		= TBN_FIRST - 0;
	TBN_BEGINDRAG			= TBN_FIRST - 1;
	TBN_ENDDRAG				= TBN_FIRST - 2;
	TBN_BEGINADJUST			= TBN_FIRST - 3;
	TBN_ENDADJUST			= TBN_FIRST - 4;
	TBN_RESET				= TBN_FIRST - 5;
	TBN_QUERYINSERT			= TBN_FIRST - 6;
	TBN_QUERYDELETE			= TBN_FIRST - 7;
	TBN_TOOLBARCHANGE		= TBN_FIRST - 8;
	TBN_CUSTHELP			= TBN_FIRST - 9;
	TBN_DROPDOWN			= TBN_FIRST - 10;
	TBN_CLOSEUP				= TBN_FIRST - 11;
	TBN_GETBUTTONINFOW		= TBN_FIRST - 20;
	TBN_GETBUTTONINFO		= AkelPad.IsOldWindows()?TBN_GETBUTTONINFOA:TBN_GETBUTTONINFOW;
// ReBar styles
	RBS_TOOLTIPS				= 0x100;
	RBS_VARHEIGHT				= 0x200;
	RBS_BANDBORDERS				= 0x400;
	RBS_FIXEDORDER				= 0x800;
	RBS_REGISTERDROP			= 0x1000;
	RBS_AUTOSIZE				= 0x2000;
	RBS_VERTICALGRIPPER			= 0x4000;
	RBS_DBLCLKTOGGLE			= 0x8000;
// ReBar band info structure flags
	RBBIM_STYLE			= 0x001;
	RBBIM_COLORS		= 0x002;
	RBBIM_TEXT			= 0x004;
	RBBIM_IMAGE			= 0x008;
	RBBIM_CHILD			= 0x010;
	RBBIM_CHILDSIZE		= 0x020;
	RBBIM_SIZE			= 0x040;
	RBBIM_BACKGROUND	= 0x080;
	RBBIM_ID			= 0x100;
	RBBIM_IDEALSIZE		= 0x200;
	RBBIM_LPARAM		= 0x400;
	RBBIM_HEADERSIZE	= 0x800;
// ReBar band styles
	RBBS_BREAK				= 0x001;
	RBBS_FIXEDSIZE			= 0x002;
	RBBS_CHILDEDGE			= 0x004;
	RBBS_HIDDEN				= 0x008;
	RBBS_NOVERT				= 0x010;
	RBBS_FIXEDBMP			= 0x020;
	RBBS_VARIABLEHEIGHT		= 0x040;
	RBBS_GRIPPERALWAYS		= 0x080;
	RBBS_NOGRIPPER			= 0x100;
// ReBar messages
	RB_INSERTBANDA				= 0x0400 + 1;
	RB_DELETEBAND				= 0x0400 + 2;
	RB_GETBARINFO				= 0x0400 + 3;
	RB_SETBARINFO				= 0x0400 + 4;
	RB_GETBANDINFO				= 0x0400 + 5;
	RB_SETBANDINFOA				= 0x0400 + 6;
	RB_SETPARENT				= 0x0400 + 7;
	RB_INSERTBANDW				= 0x0400 + 10;
	RB_SETBANDINFOW				= 0x0400 + 11;
	RB_GETBANDCOUNT				= 0x0400 + 12;
	RB_GETROWCOUNT				= 0x0400 + 13;
	RB_GETROWHEIGHT				= 0x0400 + 14;
	RB_IDTOINDEX				= 0x0400 + 16;
	RB_GETTOOLTIPS				= 0x0400 + 17;
	RB_SETTOOLTIPS				= 0x0400 + 18;
	RB_SETBKCOLOR				= 0x0400 + 19;
	RB_GETBKCOLOR				= 0x0400 + 20;
	RB_SETTEXTCOLOR				= 0x0400 + 21;
	RB_GETTEXTCOLOR				= 0x0400 + 22;
	RB_SIZETORECT				= 0x0400 + 23;
	RB_BEGINDRAG				= 0x0400 + 24;
	RB_ENDDRAG					= 0x0400 + 25;
	RB_DRAGMOVE					= 0x0400 + 26;
	RB_GETBARHEIGHT				= 0x0400 + 27;
	RB_GETBANDINFOW				= 0x0400 + 28;
	RB_GETBANDINFOA				= 0x0400 + 29;
	RB_MINIMIZEBAND				= 0x0400 + 30;
	RB_MAXIMIZEBAND				= 0x0400 + 31;
	RB_GETDROPTARGET			= CCM_GETDROPTARGET;
	RB_GETBANDBORDERS			= 0x0400 + 34;
	RB_SHOWBAND					= 0x0400 + 35;
	RB_SETPALETTE				= 0x0400 + 37;
	RB_GETPALETTE				= 0x0400 + 38;
	RB_MOVEBAND					= 0x0400 + 39;
	RB_SETUNICODEFORMAT			= CCM_SETUNICODEFORMAT;
	RB_GETUNICODEFORMAT			= CCM_GETUNICODEFORMAT;
	RB_INSERTBAND				= AkelPad.IsOldWindows()?RB_INSERTBANDA:RB_INSERTBANDW;
	RB_SETBANDINFO				= AkelPad.IsOldWindows()?RB_SETBANDINFOA:RB_SETBANDINFOW;
// ReBar notifications
	RBN_HEIGHTCHANGE	= RBN_FIRST - 0;
	RBN_GETOBJECT		= RBN_FIRST - 1;
	RBN_LAYOUTCHANGED	= RBN_FIRST - 2;
	RBN_AUTOSIZE		= RBN_FIRST - 3;
	RBN_BEGINDRAG		= RBN_FIRST - 4;
	RBN_ENDDRAG			= RBN_FIRST - 5;
	RBN_DELETINGBAND	= RBN_FIRST - 6;
	RBN_DELETEDBAND		= RBN_FIRST - 7;
	RBN_CHILDSIZE		= RBN_FIRST - 8;
// Tooltip styles
	TTS_ALWAYSTIP	= 1;
	TTS_NOPREFIX	= 2;
// Tooltip flags
	TTF_IDISHWND		= 0x01;
	TTF_CENTERTIP		= 0x02;
	TTF_RTLREADING		= 0x04;
	TTF_SUBCLASS		= 0x10;
	TTF_TRACK			= 0x0020;
	TTF_ABSOLUTE		= 0x0080;
	TTF_TRANSPARENT		= 0x0100;
	TTF_PARSELINKS		= 0x1000;
	TTF_DI_SETITEM		= 0x8000;
// Tooltip durations
	TTDT_AUTOMATIC		= 0;
	TTDT_RESHOW			= 1;
	TTDT_AUTOPOP		= 2;
	TTDT_INITIAL		= 3;
// Tooltip messages
	TTM_ACTIVATE				= WM_USER + 1;
	TTM_SETDELAYTIME			= WM_USER + 3;
	TTM_ADDTOOLA				= WM_USER + 4;
	TTM_DELTOOLA				= WM_USER + 5;
	TTM_NEWTOOLRECTA			= WM_USER + 6;
	TTM_RELAYEVENT				= WM_USER + 7;
	TTM_GETTOOLINFOA			= WM_USER + 8;
	TTM_SETTOOLINFOA			= WM_USER + 9;
	TTM_HITTESTA				= WM_USER + 10;
	TTM_GETTEXTA				= WM_USER + 11;
	TTM_UPDATETIPTEXTA			= WM_USER + 12;
	TTM_GETTOOLCOUNT			= WM_USER + 13;
	TTM_ENUMTOOLSA				= WM_USER + 14;
	TTM_GETCURRENTTOOLA			= WM_USER + 15;
	TTM_WINDOWFROMPOINT			= WM_USER + 16;

	TTM_TRACKACTIVATE			= WM_USER + 17;  // wParam = TRUE/FALSE start end  lparam = LPTOOLINFO
	TTM_TRACKPOSITION			= WM_USER + 18;  // lParam = dwPos
	TTM_SETTIPBKCOLOR			= WM_USER + 19;
	TTM_SETTIPTEXTCOLOR			= WM_USER + 20;
	TTM_GETDELAYTIME			= WM_USER + 21;
	TTM_GETTIPBKCOLOR			= WM_USER + 22;
	TTM_GETTIPTEXTCOLOR			= WM_USER + 23;
	TTM_SETMAXTIPWIDTH			= WM_USER + 24;
	TTM_GETMAXTIPWIDTH			= WM_USER + 25;
	TTM_SETMARGIN				= WM_USER + 26;  // lParam = lprc
	TTM_GETMARGIN				= WM_USER + 27;  // lParam = lprc
	TTM_POP						= WM_USER + 28;

	TTM_UPDATE					= WM_USER + 29;
	TTM_GETBUBBLESIZE			= WM_USER + 30;
	TTM_ADJUSTRECT				= WM_USER + 31;
	TTM_SETTITLEA				= WM_USER + 32;  // wParam = TTI_*, lParam = char* szTitle
	TTM_SETTITLEW				= WM_USER + 33;  // wParam = TTI_*, lParam = wchar* szTitle
	TTM_POPUP					= WM_USER + 34;
	TTM_GETTITLE				= WM_USER + 35; // wParam = 0, lParam = TTGETTITLE*


	TTM_ADDTOOLW				= WM_USER + 50;
	TTM_DELTOOLW				= WM_USER + 51;
	TTM_NEWTOOLRECTW			= WM_USER + 52;
	TTM_GETTOOLINFOW			= WM_USER + 53;
	TTM_SETTOOLINFOW			= WM_USER + 54;
	TTM_HITTESTW				= WM_USER + 55;
	TTM_GETTEXTW				= WM_USER + 56;
	TTM_UPDATETIPTEXTW			= WM_USER + 57;
	TTM_ENUMTOOLSW				= WM_USER + 58;
	TTM_GETCURRENTTOOLW			= WM_USER + 59;


	TTM_ADDTOOL				= AkelPad.IsOldWindows()?TTM_ADDTOOLA:TTM_ADDTOOLW;
	TTM_DELTOOL				= AkelPad.IsOldWindows()?TTM_DELTOOLA:TTM_DELTOOLW;
	TTM_NEWTOOLRECT			= AkelPad.IsOldWindows()?TTM_NEWTOOLRECTA:TTM_NEWTOOLRECTW;
	TTM_GETTOOLINFO			= AkelPad.IsOldWindows()?TTM_GETTOOLINFOA:TTM_GETTOOLINFOW;
	TTM_SETTOOLINFO			= AkelPad.IsOldWindows()?TTM_SETTOOLINFOA:TTM_SETTOOLINFOW;
	TTM_HITTEST				= AkelPad.IsOldWindows()?TTM_HITTESTA:TTM_HITTESTW;
	TTM_GETTEXT				= AkelPad.IsOldWindows()?TTM_GETTEXTA:TTM_GETTEXTW;
	TTM_UPDATETIPTEXT		= AkelPad.IsOldWindows()?TTM_UPDATETIPTEXTA:TTM_UPDATETIPTEXTW;
	TTM_ENUMTOOLS			= AkelPad.IsOldWindows()?TTM_ENUMTOOLSA:TTM_ENUMTOOLSW;
	TTM_GETCURRENTTOOL		= AkelPad.IsOldWindows()?TTM_GETCURRENTTOOLA:TTM_GETCURRENTTOOLW;
	TTM_SETTITLE			= AkelPad.IsOldWindows()?TTM_SETTITLEA:TTM_SETTITLEW;
// Tooltip notifications
	TTN_NEEDTEXTA		= TTN_FIRST - 0;
	TTN_SHOW			= TTN_FIRST - 1;
	TTN_POP				= TTN_FIRST - 2;
	TTN_NEEDTEXTW		= TTN_FIRST - 10;
	TTN_NEEDTEXT		= AkelPad.IsOldWindows()?TTN_NEEDTEXTA:TTN_NEEDTEXTW;
// Status bar styles
	SBARS_SIZEGRIP		= 0x100;
// Status bar messages
	SB_SETTEXTA			= 0x0400 + 1;
	SB_GETTEXTA			= 0x0400 + 2;
	SB_GETTEXTLENGTHA	= 0x0400 + 3;
	SB_SETPARTS			= 0x0400 + 4;
	SB_GETPARTS			= 0x0400 + 6;
	SB_GETBORDERS		= 0x0400 + 7;
	SB_SETMINHEIGHT		= 0x0400 + 8;
	SB_SIMPLE			= 0x0400 + 9;
	SB_GETRECT			= 0x0400 + 10;
	SB_SETTEXTW			= 0x0400 + 11;
	SB_GETTEXTW			= 0x0400 + 13;
	SB_GETTEXTLENGTHW	= 0x0400 + 12;
	SB_SETTEXT			= AkelPad.IsOldWindows()?SB_SETTEXTA:SB_SETTEXTW;
	SB_GETTEXT			= AkelPad.IsOldWindows()?SB_GETTEXTA:SB_GETTEXTW;
	SB_GETTEXTLENGTH	= AkelPad.IsOldWindows()?SB_GETTEXTLENGTHA:SB_GETTEXTLENGTHW;
// Status bar drawing types
	SBT_OWNERDRAW	= 0x1000;
	SBT_NOBORDERS	= 0x0100;
	SBT_POPOUT		= 0x0200;
	SBT_RTLREADING	= 0x0400;
// Trackbar styles
	TBS_AUTOTICKS		= 0x01;
	TBS_VERT			= 0x02;
	TBS_HORZ			= 0x00;
	TBS_TOP				= 0x04;
	TBS_BOTTOM			= 0x00;
	TBS_LEFT			= 0x04;
	TBS_RIGHT			= 0x00;
	TBS_BOTH			= 0x08;
	TBS_NOTICKS			= 0x10;
	TBS_ENABLESELRANGE	= 0x20;
	TBS_FIXEDLENGTH		= 0x40;
	TBS_NOTHUMB			= 0x80;
// Trackbar messages
	TBM_GETPOS			= 0x0400 + 0;
	TBM_GETRANGEMIN		= 0x0400 + 1;
	TBM_GETRANGEMAX		= 0x0400 + 2;
	TBM_GETTIC			= 0x0400 + 3;
	TBM_SETTIC			= 0x0400 + 4;
	TBM_SETPOS			= 0x0400 + 5;
	TBM_SETRANGE			= 0x0400 + 6;
	TBM_SETRANGEMIN			= 0x0400 + 7;
	TBM_SETRANGEMAX			= 0x0400 + 8;
	TBM_CLEARTICS			= 0x0400 + 9;
	TBM_SETSEL				= 0x0400 + 10;
	TBM_SETSELSTART			= 0x0400 + 11;
	TBM_SETSELEND			= 0x0400 + 12;
	TBM_GETPTICS			= 0x0400 + 14;
	TBM_GETTICPOS			= 0x0400 + 15;
	TBM_GETNUMTICS			= 0x0400 + 16;
	TBM_GETSELSTART			= 0x0400 + 17;
	TBM_GETSELEND			= 0x0400 + 18;
	TBM_CLEARSEL			= 0x0400 + 19;
	TBM_SETTICFREQ			= 0x0400 + 20;
	TBM_SETPAGESIZE			= 0x0400 + 21;
	TBM_GETPAGESIZE			= 0x0400 + 22;
	TBM_SETLINESIZE			= 0x0400 + 23;
	TBM_GETLINESIZE			= 0x0400 + 24;
	TBM_GETTHUMBRECT		= 0x0400 + 25;
	TBM_GETCHANNELRECT	= 0x0400 + 26;
	TBM_SETTHUMBLENGTH	= 0x0400 + 27;
	TBM_GETTHUMBLENGTH	= 0x0400 + 28;
// Trackbar notifications
	TB_LINEUP		= 0;
	TB_LINEDOWN		= 1;
	TB_PAGEUP		= 2;
	TB_PAGEDOWN		= 3;
	TB_THUMBPOSITION	= 4;
	TB_THUMBTRACK		= 5;
	TB_TOP			= 6;
	TB_BOTTOM		= 7;
	TB_ENDTRACK		= 8;
// Up-down control styles
	UDS_WRAP		= 0x01;
	UDS_SETBUDDYINT	= 0x02;
	UDS_ALIGNRIGHT		= 0x04;
	UDS_ALIGNLEFT		= 0x08;
	UDS_AUTOBUDDY		= 0x10;
	UDS_ARROWKEYS		= 0x20;
	UDS_HORZ		= 0x40;
	UDS_NOTHOUSANDS	= 0x80;
// Up-down control messages
	UDM_SETRANGE	= 0x0400 + 101;
	UDM_GETRANGE	= 0x0400 + 102;
	UDM_SETPOS		= 0x0400 + 103;
	UDM_GETPOS		= 0x0400 + 104;
	UDM_SETBUDDY	= 0x0400 + 105;
	UDM_GETBUDDY	= 0x0400 + 106;
	UDM_SETACCEL	= 0x0400 + 107;
	UDM_GETACCEL	= 0x0400 + 108;
	UDM_SETBASE		= 0x0400 + 109;
	UDM_GETBASE		= 0x0400 + 110;
// Up-down control notifications
	UDN_DELTAPOS	= UDN_FIRST - 1;
// Progress bar messages
	PBM_SETRANGE		= 0x0400 + 1;
	PBM_SETPOS			= 0x0400 + 2;
	PBM_DELTAPOS		= 0x0400 + 3;
	PBM_SETSTEP			= 0x0400 + 4;
	PBM_STEPIT			= 0x0400 + 5;
	PBM_SETRANGE32		= 0x0400 + 6;
	PBM_GETRANGE		= 0x0400 + 7;
	PBM_GETPOS			= 0x0400 + 8;
// Hot-key control messages
	HKM_SETHOTKEY	= 0x0400 + 1;
	HKM_GETHOTKEY	= 0x0400 + 2;
	HKM_SETRULES	= 0x0400 + 3;
// Hot key flags
	HOTKEYF_SHIFT	= 1;
	HOTKEYF_CONTROL	= 2;
	HOTKEYF_ALT		= 4;
	HOTKEYF_EXT		= 8;
// Key combination flags
	HKCOMB_NONE	= 0x01;
	HKCOMB_S			= 0x02;
	HKCOMB_C			= 0x04;
	HKCOMB_A			= 0x08;
	HKCOMB_SC		= 0x10;
	HKCOMB_SA		= 0x20;
	HKCOMB_CA		= 0x40;
	HKCOMB_SCA		= 0x80;
// List view styles
	LVS_ICON					= 0x0000;
	LVS_REPORT					= 0x0001;
	LVS_SMALLICON				= 0x0002;
	LVS_LIST					= 0x0003;
	LVS_TYPEMASK				= 0x0003;
	LVS_SINGLESEL				= 0x0004;
	LVS_SHOWSELALWAYS			= 0x0008;
	LVS_SORTASCENDING			= 0x0010;
	LVS_SORTDESCENDING			= 0x0020;
	LVS_SHAREIMAGELISTS			= 0x0040;
	LVS_NOLABELWRAP				= 0x0080;
	LVS_AUTOARRANGE				= 0x0100;
	LVS_EDITLABELS				= 0x0200;
	LVS_OWNERDATA				= 0x1000;
	LVS_NOSCROLL				= 0x2000;
	LVS_ALIGNTOP				= 0x0000;
	LVS_ALIGNLEFT				= 0x0800;
	LVS_OWNERDRAWFIXED			= 0x0400;
	LVS_NOCOLUMNHEADER			= 0x4000;
	LVS_NOSORTHEADER			= 0x8000;
// List view extended styles
	LVS_EX_GRIDLINES			= 0x0001;
	LVS_EX_SUBITEMIMAGES		= 0x0002;
	LVS_EX_CHECKBOXES			= 0x0004;
	LVS_EX_TRACKSELECT			= 0x0008;
	LVS_EX_HEADERDRAGDROP		= 0x0010;
	LVS_EX_FULLROWSELECT		= 0x0020;
	LVS_EX_ONECLICKACTIVATE	= 0x0040;
	LVS_EX_TWOCLICKACTIVATE	= 0x0080;
	LVS_EX_FLATSB			= 0x0100;
	LVS_EX_REGIONAL			= 0x0200;
	LVS_EX_INFOTIP			= 0x0400;
	LVS_EX_UNDERLINEHOT		= 0x0800;
	LVS_EX_UNDERLINECOLD	= 0x1000;
	LVS_EX_MULTIWORKAREAS	= 0x2000;
	LVS_EX_LABELTIP			= 0x4000;
// List view messages
	LVM_GETBKCOLOR					= LVM_FIRST + 0;
	LVM_SETBKCOLOR					= LVM_FIRST + 1;
	LVM_GETIMAGELIST				= LVM_FIRST + 2;
	LVM_SETIMAGELIST				= LVM_FIRST + 3;
	LVM_GETITEMCOUNT				= LVM_FIRST + 4;
	LVM_GETITEMA					= LVM_FIRST + 5;
	LVM_SETITEMA					= LVM_FIRST + 6;
	LVM_INSERTITEMA					= LVM_FIRST + 7;
	LVM_DELETEITEM					= LVM_FIRST + 8;
	LVM_DELETEALLITEMS				= LVM_FIRST + 9;
	LVM_GETCALLBACKMASK				= LVM_FIRST + 10;
	LVM_SETCALLBACKMASK				= LVM_FIRST + 11;
	LVM_GETNEXTITEM					= LVM_FIRST + 12;
	LVM_FINDITEMA					= LVM_FIRST + 13;
	LVM_GETITEMRECT					= LVM_FIRST + 14;
	LVM_SETITEMPOSITION				= LVM_FIRST + 15;
	LVM_GETITEMPOSITION				= LVM_FIRST + 16;
	LVM_GETSTRINGWIDTHA				= LVM_FIRST + 17;
	LVM_HITTEST						= LVM_FIRST + 18;
	LVM_ENSUREVISIBLE				= LVM_FIRST + 19;
	LVM_SCROLL						= LVM_FIRST + 20;
	LVM_REDRAWITEMS					= LVM_FIRST + 21;
	LVM_ARRANGE						= LVM_FIRST + 22;
	LVM_EDITLABELA					= LVM_FIRST + 23;
	LVM_GETEDITCONTROL				= LVM_FIRST + 24;
	LVM_GETCOLUMNA					= LVM_FIRST + 25;
	LVM_SETCOLUMNA					= LVM_FIRST + 26;
	LVM_INSERTCOLUMNA				= LVM_FIRST + 27;
	LVM_DELETECOLUMN				= LVM_FIRST + 28;
	LVM_GETCOLUMNWIDTH				= LVM_FIRST + 29;
	LVM_SETCOLUMNWIDTH				= LVM_FIRST + 30;
	LVM_CREATEDRAGIMAGE				= LVM_FIRST + 33;
	LVM_GETVIEWRECT					= LVM_FIRST + 34;
	LVM_GETTEXTCOLOR				= LVM_FIRST + 35;
	LVM_SETTEXTCOLOR				= LVM_FIRST + 36;
	LVM_GETTEXTBKCOLOR				= LVM_FIRST + 37;
	LVM_SETTEXTBKCOLOR				= LVM_FIRST + 38;
	LVM_GETTOPINDEX					= LVM_FIRST + 39;
	LVM_GETCOUNTPERPAGE				= LVM_FIRST + 40;
	LVM_GETORIGIN					= LVM_FIRST + 41;
	LVM_UPDATE						= LVM_FIRST + 42;
	LVM_SETITEMSTATE				= LVM_FIRST + 43;
	LVM_GETITEMSTATE				= LVM_FIRST + 44;
	LVM_GETITEMTEXTA				= LVM_FIRST + 45;
	LVM_SETITEMTEXTA				= LVM_FIRST + 46;
	LVM_SETITEMCOUNT				= LVM_FIRST + 47;
	LVM_SORTITEMS					= LVM_FIRST + 48;
	LVM_SETITEMPOSITION32			= LVM_FIRST + 49;
	LVM_GETSELECTEDCOUNT			= LVM_FIRST + 50;
	LVM_GETITEMSPACING				= LVM_FIRST + 51;
	LVM_GETISEARCHSTRINGA			= LVM_FIRST + 52;
	LVM_SETICONSPACING				= LVM_FIRST + 53;
	LVM_SETEXTENDEDLISTVIEWSTYLE	= LVM_FIRST + 54;
	LVM_GETEXTENDEDLISTVIEWSTYLE	= LVM_FIRST + 55;
	LVM_GETSUBITEMRECT				= LVM_FIRST + 56;
	LVM_SUBITEMHITTEST				= LVM_FIRST + 57;
	LVM_SETCOLUMNORDERARRAY			= LVM_FIRST + 58;
	LVM_GETCOLUMNORDERARRAY			= LVM_FIRST + 59;
	LVM_SETHOTITEM					= LVM_FIRST + 60;
	LVM_GETHOTITEM					= LVM_FIRST + 61;
	LVM_SETHOTCURSOR				= LVM_FIRST + 62;
	LVM_GETHOTCURSOR				= LVM_FIRST + 63;
	LVM_APPROXIMATEVIEWRECT			= LVM_FIRST + 64;
	LVM_SETWORKAREA					= LVM_FIRST + 65;
	LVM_GETITEMW					= LVM_FIRST + 75;
	LVM_SETITEMW					= LVM_FIRST + 76;
	LVM_INSERTITEMW					= LVM_FIRST + 77;
	LVM_FINDITEMW					= LVM_FIRST + 83;
	LVM_GETSTRINGWIDTHW				= LVM_FIRST + 87;
	LVM_GETCOLUMNW					= LVM_FIRST + 95;
	LVM_SETCOLUMNW					= LVM_FIRST + 96;
	LVM_INSERTCOLUMNW				= LVM_FIRST + 97;
	LVM_GETITEMTEXTW				= LVM_FIRST + 115;
	LVM_SETITEMTEXTW				= LVM_FIRST + 116;
	LVM_GETISEARCHSTRINGW			= LVM_FIRST + 117;
	LVM_EDITLABELW					= LVM_FIRST + 118;
	LVM_GETITEM						= AkelPad.IsOldWindows()?LVM_GETITEMA:LVM_GETITEMW;
	LVM_SETITEM						= AkelPad.IsOldWindows()?LVM_SETITEMA:LVM_SETITEMW;
	LVM_INSERTITEM					= AkelPad.IsOldWindows()?LVM_INSERTITEMA:LVM_INSERTITEMW;
	LVM_FINDITEM					= AkelPad.IsOldWindows()?LVM_FINDITEMA:LVM_FINDITEMW;
	LVM_GETSTRINGWIDTH				= AkelPad.IsOldWindows()?LVM_GETSTRINGWIDTHA:LVM_GETSTRINGWIDTHW;
	LVM_GETCOLUMN					= AkelPad.IsOldWindows()?LVM_GETCOLUMNA:LVM_GETCOLUMNW;
	LVM_SETCOLUMN					= AkelPad.IsOldWindows()?LVM_SETCOLUMNA:LVM_SETCOLUMNW;
	LVM_INSERTCOLUMN				= AkelPad.IsOldWindows()?LVM_INSERTCOLUMNA:LVM_INSERTCOLUMNW;
	LVM_GETITEMTEXT					= AkelPad.IsOldWindows()?LVM_GETITEMTEXTA:LVM_GETITEMTEXTW;
	LVM_SETITEMTEXT					= AkelPad.IsOldWindows()?LVM_SETITEMTEXTA:LVM_SETITEMTEXTW;
	LVM_GETISEARCHSTRING			= AkelPad.IsOldWindows()?LVM_GETISEARCHSTRINGA:LVM_GETISEARCHSTRINGW;
	LVM_EDITLABEL					= AkelPad.IsOldWindows()?LVM_EDITLABELA:LVM_EDITLABELW;
// List view image list types
	LVSIL_NORMAL	= 0;
	LVSIL_SMALL		= 1;
	LVSIL_STATE		= 2;
// LVM_SETITEMCOUNT flags
	LVSICF_NOINVALIDATEALL	= 1;
	LVSICF_NOSCROLL			= 2;
// List view item structure flags
	LVIF_TEXT		= 0x0001;
	LVIF_IMAGE		= 0x0002;
	LVIF_PARAM		= 0x0004;
	LVIF_STATE		= 0x0008;
	LVIF_INDENT		= 0x0010;
	LVIF_NORECOMPUTE	= 0x0800;
	LVIF_DI_SETITEM	= 0x1000;
// List view item states
	LVIS_FOCUSED				= 0x00001;
	LVIS_SELECTED				= 0x00002;
	LVIS_CUT					= 0x00004;
	LVIS_DROPHILITED			= 0x00008;
	LVIS_ACTIVATING				= 0x0020;
	LVIS_OVERLAYMASK			= 0x00F00;
	LVIS_STATEIMAGEMASK			= 0x0F000;
// List view callback item values
	LPSTR_TEXTCALLBACK		= -1;
	I_IMAGECALLBACK			= -1;
	I_CHILDRENCALLBACK		= -1;
// List view next item relations
	LVNI_ALL			= 0x000;
	LVNI_FOCUSED		= 0x001;
	LVNI_SELECTED		= 0x002;
	LVNI_CUT			= 0x004;
	LVNI_DROPHILITED	= 0x008;
	LVNI_ABOVE			= 0x100;
	LVNI_BELOW			= 0x200;
	LVNI_TOLEFT			= 0x400;
	LVNI_TORIGHT		= 0x800;
// List view sear0xc types
	LVFI_PARAM			= 0x01;
	LVFI_STRING			= 0x02;
	LVFI_PARTIAL		= 0x08;
	LVFI_WRAP			= 0x20;
	LVFI_NEARESTXY		= 0x40;
// List view item rectangle types
	LVIR_BOUNDS			= 0;
	LVIR_ICON			= 1;
	LVIR_LABEL			= 2;
	LVIR_SELECTBOUNDS	= 3;
// List view hit test flags
	LVHT_NOWHERE				= 0x01;
	LVHT_ONITEMICON				= 0x02;
	LVHT_ONITEMLABEL			= 0x04;
	LVHT_ONITEMSTATEICON	= 0x08;
	LVHT_ONITEM				= LVHT_ONITEMICON + LVHT_ONITEMLABEL + LVHT_ONITEMSTATEICON;
	LVHT_ABOVE				= 0x08;
	LVHT_BELOW				= 0x10;
	LVHT_TORIGHT			= 0x20;
	LVHT_TOLEFT				= 0x40;
// List view alignment values
	LVA_DEFAULT				= 0x000;
	LVA_ALIGNLEFT			= 0x001;
	LVA_ALIGNTOP			= 0x002;
	LVA_ALIGNRIGHT			= 0x003;
	LVA_ALIGNBOTTOM			= 0x004;
	LVA_SNAPTOGRID			= 0x005;
	LVA_SORTASCENDING		= 0x100;
	LVA_SORTDESCENDING		= 0x200;
// List view column structure flags
	LVCF_FMT			= 1;
	LVCF_WIDTH			= 2;
	LVCF_TEXT			= 4;
	LVCF_SUBITEM		= 8;
// List view column alignment values
	LVCFMT_LEFT				= 0;
	LVCFMT_RIGHT			= 1;
	LVCFMT_CENTER			= 2;
	LVCFMT_JUSTIFYMASK		= 3;
// List view column width values
	LVSCW_AUTOSIZE				= -1;
	LVSCW_AUTOSIZE_USEHEADER	= -2;
// List view notifications
	LVN_ITEMCHANGING			= LVN_FIRST - 0;
	LVN_ITEMCHANGED				= LVN_FIRST - 1;
	LVN_INSERTITEM				= LVN_FIRST - 2;
	LVN_DELETEITEM				= LVN_FIRST - 3;
	LVN_DELETEALLITEMS			= LVN_FIRST - 4;
	LVN_BEGINLABELEDITA			= LVN_FIRST - 5;
	LVN_ENDLABELEDITA			= LVN_FIRST - 6;
	LVN_COLUMNCLICK				= LVN_FIRST - 8;
	LVN_BEGINDRAG				= LVN_FIRST - 9;
	LVN_BEGINRDRAG				= LVN_FIRST - 11;
	LVN_ODCACHEHINT				= LVN_FIRST - 13;
	LVN_GETDISPINFOA			= LVN_FIRST - 50;
	LVN_SETDISPINFOA			= LVN_FIRST - 51;
	LVN_ODFINDITEMA				= LVN_FIRST - 52;
	LVN_KEYDOWN					= LVN_FIRST - 55;
	LVN_BEGINLABELEDITW			= LVN_FIRST - 75;
	LVN_ENDLABELEDITW			= LVN_FIRST - 76;
	LVN_GETDISPINFOW			= LVN_FIRST - 77;
	LVN_SETDISPINFOW			= LVN_FIRST - 78;
	LVN_ODFINDITEMW				= LVN_FIRST - 79;
	LVN_BEGINLABELEDIT			= AkelPad.IsOldWindows()?LVN_BEGINLABELEDITA:LVN_BEGINLABELEDITW;
	LVN_ENDLABELEDIT			= AkelPad.IsOldWindows()?LVN_ENDLABELEDITA:LVN_ENDLABELEDITW;
	LVN_GETDISPINFO				= AkelPad.IsOldWindows()?LVN_GETDISPINFOA:LVN_GETDISPINFOW;
	LVN_SETDISPINFO				= AkelPad.IsOldWindows()?LVN_SETDISPINFOA:LVN_SETDISPINFOW;
	LVN_ODFINDITEM				= AkelPad.IsOldWindows()?LVN_ODFINDITEMA:LVN_ODFINDITEMW;
// Tree view styles
	TVS_HASBUTTONS				= 0x0001;
	TVS_HASLINES				= 0x0002;
	TVS_LINESATROOT				= 0x0004;
	TVS_EDITLABELS				= 0x0008;
	TVS_DISABLEDRAGDROP			= 0x0010;
	TVS_SHOWSELALWAYS			= 0x0020;
	TVS_RTLREADING				= 0x0040;
	TVS_NOTOOLTIPS				= 0x0080;
	TVS_CHECKBOXES				= 0x0100;
	TVS_TRACKSELECT				= 0x0200;
	TVS_SINGLEEXPAND			= 0x0400;
	TVS_INFOTIP					= 0x0800;
	TVS_FULLROWSELECT			= 0x1000;
	TVS_NOSCROLL				= 0x2000;
	TVS_NONEVENHEIGHT			= 0x4000;
// Tree view item structure flags
	TVIF_TEXT			= 0x0001;
	TVIF_IMAGE			= 0x0002;
	TVIF_PARAM			= 0x0004;
	TVIF_STATE			= 0x0008;
	TVIF_HANDLE			= 0x0010;
	TVIF_SELECTEDIMAGE	= 0x0020;
	TVIF_CHILDREN		= 0x0040;
	TVIF_DI_SETITEM		= 0x1000;
// Tree view item states
	TVIS_FOCUSED				= 0x00001;
	TVIS_SELECTED				= 0x00002;
	TVIS_CUT					= 0x00004;
	TVIS_DROPHILITED			= 0x00008;
	TVIS_BOLD					= 0x00010;
	TVIS_EXPANDED				= 0x00020;
	TVIS_EXPANDEDONCE			= 0x00040;
	TVIS_EXPANDPARTIAL			= 0x00080;
	TVIS_OVERLAYMASK			= 0x00F00;
	TVIS_STATEIMAGEMASK			= 0x0F000;
	TVIS_USERMASK				= 0x0F000;
// Tree view predefined item values
	TVI_ROOT	= 0x0FFFF0000;
	TVI_FIRST	= 0x0FFFF0001;
	TVI_LAST	= 0x0FFFF0002;
	TVI_SORT	= 0x0FFFF0003;
// Tree view messages
	TVM_INSERTITEMA				= TV_FIRST + 0;
	TVM_DELETEITEM				= TV_FIRST + 1;
	TVM_EXPAND					= TV_FIRST + 2;
	TVM_GETITEMRECT				= TV_FIRST + 4;
	TVM_GETCOUNT				= TV_FIRST + 5;
	TVM_GETINDENT				= TV_FIRST + 6;
	TVM_SETINDENT				= TV_FIRST + 7;
	TVM_GETIMAGELIST			= TV_FIRST + 8;
	TVM_SETIMAGELIST			= TV_FIRST + 9;
	TVM_GETNEXTITEM				= TV_FIRST + 10;
	TVM_SELECTITEM				= TV_FIRST + 11;
	TVM_GETITEMA				= TV_FIRST + 12;
	TVM_SETITEMA				= TV_FIRST + 13;
	TVM_EDITLABELA				= TV_FIRST + 14;
	TVM_GETEDITCONTROL			= TV_FIRST + 15;
	TVM_GETVISIBLECOUNT			= TV_FIRST + 16;
	TVM_HITTEST					= TV_FIRST + 17;
	TVM_CREATEDRAGIMAGE			= TV_FIRST + 18;
	TVM_SORTCHILDREN			= TV_FIRST + 19;
	TVM_ENSUREVISIBLE			= TV_FIRST + 20;
	TVM_SORTCHILDRENCB			= TV_FIRST + 21;
	TVM_ENDEDITLABELNOW			= TV_FIRST + 22;
	TVM_GETISEARCHSTRINGA		= TV_FIRST + 23;
	TVM_INSERTITEMW				= TV_FIRST + 50;
	TVM_GETITEMW				= TV_FIRST + 62;
	TVM_SETITEMW				= TV_FIRST + 63;
	TVM_GETISEARCHSTRINGW		= TV_FIRST + 64;
	TVM_EDITLABELW				= TV_FIRST + 65;
	TVM_INSERTITEM				= AkelPad.IsOldWindows()?TVM_INSERTITEMA:TVM_INSERTITEMW;
	TVM_GETITEM					= AkelPad.IsOldWindows()?TVM_GETITEMA:TVM_GETITEMW;
	TVM_SETITEM					= AkelPad.IsOldWindows()?TVM_SETITEMA:TVM_SETITEMW;
	TVM_GETISEARCHSTRING		= AkelPad.IsOldWindows()?TVM_GETISEARCHSTRINGA:TVM_GETISEARCHSTRINGW;
	TVM_EDITLABEL				= AkelPad.IsOldWindows()?TVM_EDITLABELA:TVM_EDITLABELW;
// Tree view action flags
	TVE_COLLAPSE		= 0x0001;
	TVE_EXPAND			= 0x0002;
	TVE_TOGGLE			= 0x0003;
	TVE_EXPANDPARTIAL	= 0x4000;
	TVE_COLLAPSERESET	= 0x8000;
// Tree view image list types
	TVSIL_NORMAL	= 0;
	TVSIL_STATE		= 2;
// Tree view next item types
	TVGN_ROOT					= 0;
	TVGN_NEXT					= 1;
	TVGN_PREVIOUS				= 2;
	TVGN_PARENT					= 3;
	TVGN_CHILD					= 4;
	TVGN_FIRSTVISIBLE			= 5;
	TVGN_NEXTVISIBLE			= 6;
	TVGN_PREVIOUSVISIBLE		= 7;
	TVGN_DROPHILITE				= 8;
	TVGN_CARET					= 9;
// Tree view hit test flags
	TVHT_NOWHERE			= 0x001;
	TVHT_ONITEMICON			= 0x002;
	TVHT_ONITEMLABEL		= 0x004;
	TVHT_ONITEMINDENT		= 0x008;
	TVHT_ONITEMBUTTON		= 0x010;
	TVHT_ONITEMRIGHT		= 0x020;
	TVHT_ONITEMSTATEICON	= 0x040;
	TVHT_ONITEM				= TVHT_ONITEMICON + TVHT_ONITEMLABEL + TVHT_ONITEMSTATEICON;
	TVHT_ABOVE				= 0x100;
	TVHT_BELOW				= 0x200;
	TVHT_TORIGHT			= 0x400;
	TVHT_TOLEFT				= 0x800;
// Tree view notifications
	TVN_SELCHANGINGA			= TVN_FIRST - 1;
	TVN_SELCHANGEDA				= TVN_FIRST - 2;
	TVN_GETDISPINFOA			= TVN_FIRST - 3;
	TVN_SETDISPINFOA			= TVN_FIRST - 4;
	TVN_ITEMEXPANDINGA			= TVN_FIRST - 5;
	TVN_ITEMEXPANDEDA			= TVN_FIRST - 6;
	TVN_BEGINDRAGA				= TVN_FIRST - 7;
	TVN_BEGINRDRAGA				= TVN_FIRST - 8;
	TVN_DELETEITEMA				= TVN_FIRST - 9;
	TVN_BEGINLABELEDITA			= TVN_FIRST - 10;
	TVN_ENDLABELEDITA			= TVN_FIRST - 11;
	TVN_KEYDOWN					= TVN_FIRST - 12;
	TVN_SELCHANGINGW			= TVN_FIRST - 50;
	TVN_SELCHANGEDW				= TVN_FIRST - 51;
	TVN_GETDISPINFOW			= TVN_FIRST - 52;
	TVN_SETDISPINFOW			= TVN_FIRST - 53;
	TVN_ITEMEXPANDINGW			= TVN_FIRST - 54;
	TVN_ITEMEXPANDEDW			= TVN_FIRST - 55;
	TVN_BEGINDRAGW				= TVN_FIRST - 56;
	TVN_BEGINRDRAGW				= TVN_FIRST - 57;
	TVN_DELETEITEMW				= TVN_FIRST - 58;
	TVN_BEGINLABELEDITW			= TVN_FIRST - 59;
	TVN_ENDLABELEDITW			= TVN_FIRST - 60;
	TVN_SELCHANGING				= AkelPad.IsOldWindows()?TVN_SELCHANGINGA:TVN_SELCHANGINGW;
	TVN_SELCHANGED				= AkelPad.IsOldWindows()?TVN_SELCHANGEDA:TVN_SELCHANGEDW;
	TVN_GETDISPINFO				= AkelPad.IsOldWindows()?TVN_GETDISPINFOA:TVN_GETDISPINFOW;
	TVN_SETDISPINFO				= AkelPad.IsOldWindows()?TVN_SETDISPINFOA:TVN_SETDISPINFOW;
	TVN_ITEMEXPANDING			= AkelPad.IsOldWindows()?TVN_ITEMEXPANDINGA:TVN_ITEMEXPANDINGW;
	TVN_ITEMEXPANDED			= AkelPad.IsOldWindows()?TVN_ITEMEXPANDEDA:TVN_ITEMEXPANDEDW;
	TVN_BEGINDRAG				= AkelPad.IsOldWindows()?TVN_BEGINDRAGA:TVN_BEGINDRAGW;
	TVN_BEGINRDRAG				= AkelPad.IsOldWindows()?TVN_BEGINRDRAGA:TVN_BEGINRDRAGW;
	TVN_DELETEITEM				= AkelPad.IsOldWindows()?TVN_DELETEITEMA:TVN_DELETEITEMW;
	TVN_BEGINLABELEDIT			= AkelPad.IsOldWindows()?TVN_BEGINLABELEDITA:TVN_BEGINLABELEDITW;
	TVN_ENDLABELEDIT			= AkelPad.IsOldWindows()?TVN_ENDLABELEDITA:TVN_ENDLABELEDITW;
// Tree view action flags
	TVC_UNKNOWN			= 0;
	TVC_BYMOUSE			= 1;
	TVC_BYKEYBOARD		= 2;
// Tab control styles
	TCS_SCROLLOPPOSITE			= 0x0001;
	TCS_BOTTOM					= 0x0002;
	TCS_RIGHT					= 0x0002;
	TCS_FORCEICONLEFT			= 0x0010;
	TCS_FORCELABELLEFT			= 0x0020;
	TCS_HOTTRACK				= 0x0040;
	TCS_VERTICAL				= 0x0080;
	TCS_TABS					= 0x0000;
	TCS_BUTTONS					= 0x0100;
	TCS_SINGLELINE				= 0x0000;
	TCS_MULTILINE				= 0x0200;
	TCS_RIGHTJUSTIFY			= 0x0000;
	TCS_FIXEDWIDTH				= 0x0400;
	TCS_RAGGEDRIGHT				= 0x0800;
	TCS_FOCUSONBUTTONDOWN		= 0x1000;
	TCS_OWNERDRAWFIXED			= 0x2000;
	TCS_TOOLTIPS				= 0x4000;
	TCS_FOCUSNEVER				= 0x8000;
// Tab control messages
	TCM_GETIMAGELIST		= TCM_FIRST + 2;
	TCM_SETIMAGELIST		= TCM_FIRST + 3;
	TCM_GETITEMCOUNT		= TCM_FIRST + 4;
	TCM_GETITEMA			= TCM_FIRST + 5;
	TCM_SETITEMA			= TCM_FIRST + 6;
	TCM_INSERTITEMA			= TCM_FIRST + 7;
	TCM_DELETEITEM			= TCM_FIRST + 8;
	TCM_DELETEALLITEMS		= TCM_FIRST + 9;
	TCM_GETITEMRECT			= TCM_FIRST + 10;
	TCM_GETCURSEL			= TCM_FIRST + 11;
	TCM_SETCURSEL			= TCM_FIRST + 12;
	TCM_HITTEST				= TCM_FIRST + 13;
	TCM_SETITEMEXTRA		= TCM_FIRST + 14;
	TCM_ADJUSTRECT			= TCM_FIRST + 40;
	TCM_SETITEMSIZE			= TCM_FIRST + 41;
	TCM_REMOVEIMAGE			= TCM_FIRST + 42;
	TCM_SETPADDING			= TCM_FIRST + 43;
	TCM_GETROWCOUNT			= TCM_FIRST + 44;
	TCM_GETTOOLTIPS			= TCM_FIRST + 45;
	TCM_SETTOOLTIPS			= TCM_FIRST + 46;
	TCM_GETCURFOCUS			= TCM_FIRST + 47;
	TCM_SETCURFOCUS			= TCM_FIRST + 48;
	TCM_GETITEMW			= TCM_FIRST + 60;
	TCM_SETITEMW			= TCM_FIRST + 61;
	TCM_INSERTITEMW			= TCM_FIRST + 62;
	TCM_GETITEM				= AkelPad.IsOldWindows()?TCM_GETITEMA:TCM_GETITEMW;
	TCM_SETITEM				= AkelPad.IsOldWindows()?TCM_SETITEMA:TCM_SETITEMW;
	TCM_INSERTITEM			= AkelPad.IsOldWindows()?TCM_INSERTITEMA:TCM_INSERTITEMW;
// Tab control item structure flags
	TCIF_TEXT		= 1;
	TCIF_IMAGE		= 2;
	TCIF_RTLREADING	= 4;
	TCIF_PARAM		= 8;
// Tab control hit test flags
	TCHT_NOWHERE		= 1;
	TCHT_ONITEMICON		= 2;
	TCHT_ONITEMLABEL	= 4;
	TCHT_ONITEM			= TCHT_ONITEMICON + TCHT_ONITEMLABEL;
// Tab control notifications
	TCN_KEYDOWN			= TCN_FIRST - 0;
	TCN_SELCHANGE		= TCN_FIRST - 1;
	TCN_SELCHANGING		= TCN_FIRST - 2;
// Animation control styles
	ACS_CENTER		= 1;
	ACS_TRANSPARENT	= 2;
	ACS_AUTOPLAY	= 4;
	ACS_TIMER		= 8;
// Animation control messages
	ACM_OPENA	= 0x0400 + 100;
	ACM_PLAY	= 0x0400 + 101;
	ACM_STOP	= 0x0400 + 102;
	ACM_OPENW	= 0x0400 + 103;
	ACM_OPEN	= AkelPad.IsOldWindows()?ACM_OPENA:ACM_OPENW;
// Animation control notifications
	ACN_START	= 1;
	ACN_STOP	= 2;
// Month calendar styles
	MCS_DAYSTATE			= 1;
	MCS_MULTISELECT			= 2;
	MCS_WEEKNUMBERS			= 4;
	MCS_NOTODAY_PRE_IE4		= 8;
	MCS_NOTODAYCIRCLE		= 8;
	MCS_NOTODAY				= 16;
// Month calendar messages
	MCM_GETCURSEL				= MCM_FIRST + 1;
	MCM_SETCURSEL				= MCM_FIRST + 2;
	MCM_GETMAXSELCOUNT			= MCM_FIRST + 3;
	MCM_SETMAXSELCOUNT			= MCM_FIRST + 4;
	MCM_GETSELRANGE				= MCM_FIRST + 5;
	MCM_SETSELRANGE				= MCM_FIRST + 6;
	MCM_GETMONTHRANGE			= MCM_FIRST + 7;
	MCM_SETDAYSTATE				= MCM_FIRST + 8;
	MCM_GETMINREQRECT			= MCM_FIRST + 9;
	MCM_SETCOLOR				= MCM_FIRST + 10;
	MCM_GETCOLOR				= MCM_FIRST + 11;
	MCM_SETTODAY				= MCM_FIRST + 12;
	MCM_GETTODAY				= MCM_FIRST + 13;
	MCM_HITTEST					= MCM_FIRST + 14;
	MCM_SETFIRSTDAYOFWEEK		= MCM_FIRST + 15;
	MCM_GETFIRSTDAYOFWEEK		= MCM_FIRST + 16;
	MCM_GETRANGE				= MCM_FIRST + 17;
	MCM_SETRANGE				= MCM_FIRST + 18;
	MCM_GETMONTHDELTA			= MCM_FIRST + 19;
	MCM_SETMONTHDELTA			= MCM_FIRST + 20;
// Month calendar hit test flags
	MCHT_TITLE				= 0x0010000;
	MCHT_CALENDAR			= 0x0020000;
	MCHT_TODAYLINK			= 0x0030000;
	MCHT_NEXT				= 0x1000000;
	MCHT_PREV				= 0x2000000;
	MCHT_NOWHERE			= 0x0000000;
	MCHT_TITLEBK			= MCHT_TITLE;
	MCHT_TITLEMONTH			= MCHT_TITLE + 1;
	MCHT_TITLEYEAR			= MCHT_TITLE + 2;
	MCHT_TITLEBTNNEXT		= MCHT_TITLE + MCHT_NEXT + 3;
	MCHT_TITLEBTNPREV		= MCHT_TITLE + MCHT_PREV + 3;
	MCHT_CALENDARBK			= MCHT_CALENDAR;
	MCHT_CALENDARDATE		= MCHT_CALENDAR + 1;
	MCHT_CALENDARDATENEXT	= MCHT_CALENDARDATE + MCHT_NEXT;
	MCHT_CALENDARDATEPREV	= MCHT_CALENDARDATE + MCHT_PREV;
	MCHT_CALENDARDAY		= MCHT_CALENDAR + 2;
	MCHT_CALENDARWEEKNUM	= MCHT_CALENDAR + 3;
// Month calendar color codes
	MCSC_BACKGROUND		= 0;
	MCSC_TEXT			= 1;
	MCSC_TITLEBK		= 2;
	MCSC_TITLETEXT		= 3;
	MCSC_MONTHBK		= 4;
	MCSC_TRAILINGTEXT	= 5;
// Month calendar notifications
	MCN_SELCHANGE		= MCN_FIRST + 1;
	MCN_GETDAYSTATE		= MCN_FIRST + 3;
	MCN_SELECT			= MCN_FIRST + 4;
// Date-time pick control messages
	DTM_GETSYSTEMTIME	= DTM_FIRST + 1;
	DTM_SETSYSTEMTIME	= DTM_FIRST + 2;
	DTM_GETRANGE		= DTM_FIRST + 3;
	DTM_SETRANGE		= DTM_FIRST + 4;
	DTM_SETFORMATA		= DTM_FIRST + 5;
	DTM_SETMCCOLOR		= DTM_FIRST + 6;
	DTM_GETMCCOLOR		= DTM_FIRST + 7;
	DTM_GETMONTHCAL		= DTM_FIRST + 8;
	DTM_SETMCFONT		= DTM_FIRST + 9;
	DTM_GETMCFONT		= DTM_FIRST + 10;
	DTM_SETFORMATW		= DTM_FIRST + 50;
	DTM_SETFORMAT		= AkelPad.IsOldWindows()?DTM_SETFORMATA:DTM_SETFORMATW;
// Date-time pick control styles
	DTS_UPDOWN				= 0x01;
	DTS_SHOWNONE			= 0x02;
	DTS_SHORTDATEFORMAT		= 0x00;
	DTS_LONGDATEFORMAT		= 0x04;
	DTS_TIMEFORMAT			= 0x09;
	DTS_APPCANPARSE			= 0x10;
	DTS_RIGHTALIGN			= 0x20;
// Date-time pick control notifications
	DTN_DATETIMECHANGE		= DTN_FIRST + 1;
	DTN_USERSTRINGA			= DTN_FIRST + 2;
	DTN_WMKEYDOWNA			= DTN_FIRST + 3;
	DTN_FORMATA				= DTN_FIRST + 4;
	DTN_FORMATQUERYA		= DTN_FIRST + 5;
	DTN_DROPDOWN			= DTN_FIRST + 6;
	DTN_CLOSEUP				= DTN_FIRST + 7;
	DTN_USERSTRINGW			= DTN_FIRST + 15;
	DTN_WMKEYDOWNW			= DTN_FIRST + 16;
	DTN_FORMATW				= DTN_FIRST + 17;
	DTN_FORMATQUERYW		= DTN_FIRST + 18;
	DTN_USERSTRING			= AkelPad.IsOldWindows()?DTN_USERSTRINGA:DTN_USERSTRINGW;
	DTN_WMKEYDOWN			= AkelPad.IsOldWindows()?DTN_WMKEYDOWNA:DTN_WMKEYDOWNW;
	DTN_FORMAT				= AkelPad.IsOldWindows()?DTN_FORMATA:DTN_FORMATW;
	DTN_FORMATQUERY			= AkelPad.IsOldWindows()?DTN_FORMATQUERYA:DTN_FORMATQUERYW;
// ImageList_LoadImage types
	IMAGE_BITMAP		= 0;
	IMAGE_ICON			= 1;
	IMAGE_CURSOR		= 2;
	IMAGE_ENHMETAFILE	= 3;
// ImageList_LoadImage flags
	LR_DEFAULTCOLOR			= 0x0000;
	LR_MONOCHROME			= 0x0001;
	LR_COLOR				= 0x0002;
	LR_COPYRETURNORG		= 0x0004;
	LR_COPYDELETEORG		= 0x0008;
	LR_LOADFROMFILE			= 0x0010;
	LR_LOADTRANSPARENT		= 0x0020;
	LR_DEFAULTSIZE			= 0x0040;
	LR_VGACOLOR				= 0x0080;
	LR_LOADMAP3DCOLORS		= 0x1000;
	LR_CREATEDIBSECTION		= 0x2000;
	LR_COPYFROMRESOURCE		= 0x4000;
	LR_SHARED				= 0x8000;
// IP control messages
	IPM_CLEARADDRESS	= 0x0400 + 100;
	IPM_SETADDRESS		= 0x0400 + 101;
	IPM_GETADDRESS		= 0x0400 + 102;
	IPM_SETRANGE		= 0x0400 + 103;
	IPM_SETFOCUS		= 0x0400 + 104;
	IPM_ISBLANK			= 0x0400 + 105;
// Custom Draw flags
	CDRF_DODEFAULT				= 0;
	CDRF_NEWFONT				= 2;
	CDRF_SKIPDEFAULT			= 4;
	CDRF_NOTIFYPOSTPAINT		= 0x10;
	CDRF_NOTIFYITEMDRAW			= 0x20;
	CDRF_NOTIFYSUBITEMDRAW		= 0x20;
	CDRF_NOTIFYPOSTERASE		= 0x40;
	CDDS_PREPAINT				= 1;
	CDDS_POSTPAINT				= 2;
	CDDS_PREERASE				= 3;
	CDDS_POSTERASE				= 4;
	CDDS_ITEM					= 0x10000;
	CDDS_ITEMPREPAINT			= CDDS_ITEM + CDDS_PREPAINT;
	CDDS_ITEMPOSTPAINT			= CDDS_ITEM + CDDS_POSTPAINT;
	CDDS_ITEMPREERASE			= CDDS_ITEM + CDDS_PREERASE;
	CDDS_ITEMPOSTERASE			= CDDS_ITEM + CDDS_POSTERASE;
	CDDS_SUBITEM				= 0x20000;
	CDIS_SELECTED				= 1;
	CDIS_GRAYED					= 2;
	CDIS_DISABLED				= 4;
	CDIS_CHECKED				= 8;
	CDIS_FOCUS					= 0x10;
	CDIS_DEFAULT				= 0x20;
	CDIS_HOT					= 0x40;
	CDIS_MARKED					= 0x80;
	CDIS_INDETERMINATE			= 0x100;
