// USER32.DLL constants
// MessageBox type flags
	MB_OK					= 0x000000;
	MB_OKCANCEL				= 0x000001;
	MB_ABORTRETRYIGNORE		= 0x000002;
	MB_YESNOCANCEL			= 0x000003;
	MB_YESNO				= 0x000004;
	MB_RETRYCANCEL			= 0x000005;
	MB_ICONHAND				= 0x000010;
	MB_ICONQUESTION			= 0x000020;
	MB_ICONEXCLAMATION		= 0x000030;
	MB_ICONASTERISK			= 0x000040;
	MB_USERICON				= 0x000080;
	MB_ICONWARNING			= MB_ICONEXCLAMATION;
	MB_ICONERROR			= MB_ICONHAND;
	MB_ICONINFORMATION		= MB_ICONASTERISK;
	MB_ICONSTOP				= MB_ICONHAND;
	MB_DEFBUTTON1			= 0x000000;
	MB_DEFBUTTON2			= 0x000100;
	MB_DEFBUTTON3			= 0x000200;
	MB_DEFBUTTON4			= 0x000300;
	MB_APPLMODAL			= 0x000000;
	MB_SYSTEMMODAL			= 0x001000;
	MB_TASKMODAL			= 0x002000;
	MB_HELP					= 0x004000;
	MB_NOFOCUS				= 0x008000;
	MB_SETFOREGROUND		= 0x010000;
	MB_DEFAULT_DESKTOP_ONLY	= 0x020000;
	MB_TOPMOST				= 0x040000;
	MB_RIGHT				= 0x080000;
	MB_RTLREADING			= 0x100000;
	MB_SERVICE_NOTIFICATION	= 0x200000;
// Conventional dialog box and message box command IDs
	IDOK		= 1;
	IDCANCEL	= 2;
	IDABORT		= 3;
	IDRETRY		= 4;
	IDIGNORE	= 5;
	IDYES		= 6;
	IDNO		= 7;
	IDCLOSE		= 8;
	IDHELP		= 9;
// Class styles
	CS_VREDRAW			= 0x00001;
	CS_HREDRAW			= 0x00002;
	CS_KEYCVTWINDOW		= 0x00004;
	CS_DBLCLKS			= 0x00008;
	CS_OWNDC			= 0x00020;
	CS_CLASSDC			= 0x00040;
	CS_PARENTDC			= 0x00080;
	CS_NOKEYCVT			= 0x00100;
	CS_SAVEBITS			= 0x00800;
	CS_NOCLOSE			= 0x00200;
	CS_BYTEALIGNCLIENT	= 0x01000;
	CS_BYTEALIGNWINDOW	= 0x02000;
	CS_PUBLICCLASS		= 0x04000;
	CS_GLOBALCLASS		= CS_PUBLICCLASS;
	CS_IME				= 0x10000;
// Windows styles
	WS_OVERLAPPED	= 0x000000000;
	WS_ICONICPOPUP	= 0x0C0000000;
	WS_POPUP		= 0x080000000;
	WS_CHILD		= 0x040000000;
	WS_MINIMIZE		= 0x020000000;
	WS_VISIBLE		= 0x010000000;
	WS_DISABLED		= 0x008000000;
	WS_CLIPSIBLINGS	= 0x004000000;
	WS_CLIPCHILDREN	= 0x002000000;
	WS_MAXIMIZE		= 0x001000000;
	WS_CAPTION		= 0x000C00000;
	WS_BORDER		= 0x000800000;
	WS_DLGFRAME		= 0x000400000;
	WS_VSCROLL		= 0x000200000;
	WS_HSCROLL		= 0x000100000;
	WS_SYSMENU		= 0x000080000;
	WS_THICKFRAME	= 0x000040000;
	WS_HREDRAW		= 0x000020000;
	WS_VREDRAW		= 0x000010000;
	WS_GROUP		= 0x000020000;
	WS_TABSTOP		= 0x000010000;
	WS_MINIMIZEBOX	= 0x000020000;
	WS_MAXIMIZEBOX	= 0x000010000;
// Common Window Styles
	WS_OVERLAPPEDWINDOW		= 0x00cf0000;
	WS_POPUPWINDOW			= 0x80880000;
	WS_CHILDWINDOW			= WS_CHILD;
	WS_TILEDWINDOW			= WS_OVERLAPPEDWINDOW;
	WS_TILED				= WS_OVERLAPPED;
	WS_ICONIC				= WS_MINIMIZE;
	WS_SIZEBOX				= WS_THICKFRAME;
// Extended Window Styles
	WS_EX_DLGMODALFRAME			= 0x00001;
	WS_EX_DRAGOBJECT			= 0x00002;
	WS_EX_NOPARENTNOTIFY		= 0x00004;
	WS_EX_TOPMOST				= 0x00008;
	WS_EX_ACCEPTFILES			= 0x00010;
	WS_EX_TRANSPARENT			= 0x00020;
	WS_EX_MDICHILD				= 0x00040;
	WS_EX_TOOLWINDOW			= 0x00080;
	WS_EX_WINDOWEDGE			= 0x00100;
	WS_EX_CLIENTEDGE			= 0x00200;
	WS_EX_CONTEXTHELP			= 0x00400;
	WS_EX_RIGHT					= 0x01000;
	WS_EX_LEFT					= 0x00000;
	WS_EX_RTLREADING			= 0x02000;
	WS_EX_LTRREADING			= 0x00000;
	WS_EX_LEFTSCROLLBAR			= 0x04000;
	WS_EX_RIGHTSCROLLBAR		= 0x00000;
	WS_EX_CONTROLPARENT			= 0x10000;
	WS_EX_STATICEDGE			= 0x20000;
	WS_EX_APPWINDOW				= 0x40000;
	WS_EX_LAYERED				= 0x80000;
	WS_EX_OVERLAPPEDWINDOW		= 0x00000300;
	WS_EX_PALETTEWINDOW			= 0x00000188;
// MDI client style bits
	MDIS_ALLCHILDSTYLES	= 1;
// Special CreateWindow position value
	CW_USEDEFAULT				= 0x80000000;
// Predefined window handle
	HWND_DESKTOP		= 0;
// ShowWindow commands
	SW_HIDE				= 0;
	SW_SHOWNORMAL		= 1;
	SW_NORMAL			= 1;
	SW_SHOWMINIMIZED	= 2;
	SW_SHOWMAXIMIZED	= 3;
	SW_MAXIMIZE			= 3;
	SW_SHOWNOACTIVATE	= 4;
	SW_SHOW				= 5;
	SW_MINIMIZE			= 6;
	SW_SHOWMINNOACTIVE	= 7;
	SW_SHOWNA			= 8;
	SW_RESTORE			= 9;
	SW_SHOWDEFAULT		= 10;
// SetWindowPos flags
	SWP_NOSIZE				= 0x0001;
	SWP_NOMOVE				= 0x0002;
	SWP_NOZORDER			= 0x0004;
	SWP_NOREDRAW			= 0x0008;
	SWP_NOACTIVATE			= 0x0010;
	SWP_DRAWFRAME			= 0x0020;
	SWP_SHOWWINDOW			= 0x0040;
	SWP_HIDEWINDOW			= 0x0080;
	SWP_NOCOPYBITS			= 0x0100;
	SWP_NOREPOSITION		= 0x0200;
	SWP_DEFERERASE			= 0x2000;
	SWP_ASYNCWINDOWPOS		= 0x4000;
// SetWindowPos special handle values
	HWND_TOP			= 0;
	HWND_BOTTOM			= 1;
	HWND_TOPMOST		= -1;
	HWND_NOTOPMOST		= -2;
// GetWindow flags
	GW_HWNDFIRST		= 0;
	GW_HWNDLAST			= 1;
	GW_HWNDNEXT			= 2;
	GW_HWNDPREV			= 3;
	GW_OWNER			= 4;
	GW_CHILD			= 5;
// RedrawWindow flags
	RDW_INVALIDATE				= 0x0001;
	RDW_INTERNALPAINT			= 0x0002;
	RDW_ERASE					= 0x0004;
	RDW_VALIDATE				= 0x0008;
	RDW_NOINTERNALPAINT			= 0x0010;
	RDW_NOERASE					= 0x0020;
	RDW_NOCHILDREN				= 0x0040;
	RDW_ALLCHILDREN				= 0x0080;
	RDW_UPDATENOW				= 0x0100;
	RDW_ERASENOW				= 0x0200;
	RDW_FRAME					= 0x0400;
	RDW_NOFRAME					= 0x0800;
// PeekMessage Options
	PM_NOREMOVE		= 0x0000;
	PM_REMOVE		= 0x0001;
	PM_NOYIELD		= 0x0002;
// Window state messages
	WM_STATE			= 0x0000;
	WM_NULL				= 0x0000;
	WM_CREATE			= 0x0001;
	WM_DESTROY			= 0x0002;
	WM_MOVE				= 0x0003;
	WM_SIZE				= 0x0005;
	WM_ACTIVATE			= 0x0006;
	WM_SETFOCUS			= 0x0007;
	WM_KILLFOCUS		= 0x0008;
	WM_ENABLE			= 0x000A;
	WM_SETREDRAW		= 0x000B;
	WM_SETTEXT			= 0x000C;
	WM_GETTEXT			= 0x000D;
	WM_GETTEXTLENGTH	= 0x000E;
	WM_PAINT			= 0x000F;
	WM_CLOSE			= 0x0010;
	WM_QUERYENDSESSION	= 0x0011;
	WM_QUIT				= 0x0012;
	WM_QUERYOPEN		= 0x0013;
	WM_ERASEBKGND		= 0x0014;
	WM_SYSCOLORCHANGE	= 0x0015;
	WM_ENDSESSION		= 0x0016;
	WM_SYSTEMERROR		= 0x0017;
	WM_SHOWWINDOW		= 0x0018;
	WM_CTLCOLOR			= 0x0019;
	WM_WININICHANGE			= 0x001A;
	WM_DEVMODECHANGE		= 0x001B;
	WM_ACTIVATEAPP			= 0x001C;
	WM_FONTCHANGE			= 0x001D;
	WM_TIMECHANGE			= 0x001E;
	WM_CANCELMODE			= 0x001F;
	WM_SETCURSOR			= 0x0020;
	WM_MOUSEACTIVATE		= 0x0021;
	WM_CHILDACTIVATE		= 0x0022;
	WM_QUEUESYNC			= 0x0023;
	WM_GETMINMAXINFO		= 0x0024;
	WM_PAINTICON			= 0x0026;
	WM_ICONERASEBKGND		= 0x0027;
	WM_NEXTDLGCTL			= 0x0028;
	WM_SPOOLERSTATUS		= 0x002A;
	WM_DRAWITEM				= 0x002B;
	WM_MEASUREITEM			= 0x002C;
	WM_DELETEITEM			= 0x002D;
	WM_VKEYTOITEM			= 0x002E;
	WM_CHARTOITEM			= 0x002F;
	WM_SETFONT				= 0x0030;
	WM_GETFONT				= 0x0031;
	WM_SETHOTKEY			= 0x0032;
	WM_QUERYDRAGICON		= 0x0037;
	WM_COMPAREITEM			= 0x0039;
	WM_COMPACTING			= 0x0041;
	WM_COMMNOTIFY			= 0x0044;
	WM_WINDOWPOSCHANGING	= 0x0046;
	WM_WINDOWPOSCHANGED		= 0x0047;
	WM_POWER				= 0x0048;
	WM_COPYDATA				= 0x004A;
	WM_CANCELJOURNAL		= 0x004B;
	WM_NOTIFY				= 0x004E;
	WM_INPUTLANGCHANGEREQUEST	= 0x0050;
	WM_INPUTLANGCHANGE		= 0x0051;
	WM_TCARD				= 0x0052;
	WM_HELP					= 0x0053;
	WM_USERCHANGED			= 0x0054;
	WM_NOTIFYFORMAT			= 0x0055;
	WM_CONTEXTMENU			= 0x007B;
	WM_STYLECHANGING		= 0x007C;
	WM_STYLECHANGED			= 0x007D;
	WM_DISPLAYCHANGE		= 0x007E;
	WM_GETICON				= 0x007F;
	WM_SETICON				= 0x0080;
	WM_NCCREATE				= 0x0081;
	WM_NCDESTROY			= 0x0082;
	WM_NCCALCSIZE			= 0x0083;
	WM_NCHITTEST			= 0x0084;
	WM_NCPAINT				= 0x0085;
	WM_NCACTIVATE			= 0x0086;
	WM_GETDLGCODE			= 0x0087;
	WM_NCMOUSEMOVE			= 0x00A0;
	WM_NCLBUTTONDOWN		= 0x00A1;
	WM_NCLBUTTONUP			= 0x00A2;
	WM_NCLBUTTONDBLCLK		= 0x00A3;
	WM_NCRBUTTONDOWN		= 0x00A4;
	WM_NCRBUTTONUP			= 0x00A5;
	WM_NCRBUTTONDBLCLK		= 0x00A6;
	WM_NCMBUTTONDOWN		= 0x00A7;
	WM_NCMBUTTONUP			= 0x00A8;
	WM_NCMBUTTONDBLCLK		= 0x00A9;
	WM_KEYFIRST			= 0x0100;
	WM_KEYDOWN			= 0x0100;
	WM_KEYUP			= 0x0101;
	WM_CHAR				= 0x0102;
	WM_DEADCHAR			= 0x0103;
	WM_SYSKEYDOWN		= 0x0104;
	WM_SYSKEYUP			= 0x0105;
	WM_SYSCHAR			= 0x0106;
	WM_SYSDEADCHAR		= 0x0107;
	WM_KEYLAST			= 0x0108;
	WM_INITDIALOG		= 0x0110;
	WM_COMMAND			= 0x0111;
	WM_SYSCOMMAND		= 0x0112;
	WM_TIMER			= 0x0113;
	WM_HSCROLL			= 0x0114;
	WM_VSCROLL			= 0x0115;
	WM_INITMENU			= 0x0116;
	WM_INITMENUPOPUP	= 0x0117;
	WM_MENUSELECT		= 0x011F;
	WM_MENUCHAR			= 0x0120;
	WM_ENTERIDLE		= 0x0121;
	WM_MENURBUTTONUP	= 0x0122;
	WM_MENUDRAG			= 0x0123;
	WM_MENUGETOBJECT		= 0x0124;
	WM_UNINITMENUPOPUP		= 0x0125;
	WM_MENUCOMMAND			= 0x0126;
	WM_CTLCOLORMSGBOX		= 0x0132;
	WM_CTLCOLOREDIT			= 0x0133;
	WM_CTLCOLORLISTBOX		= 0x0134;
	WM_CTLCOLORBTN			= 0x0135;
	WM_CTLCOLORDLG			= 0x0136;
	WM_CTLCOLORSCROLLBAR	= 0x0137;
	WM_CTLCOLORSTATIC		= 0x0138;
	WM_MOUSEFIRST			= 0x0200;
	WM_MOUSEMOVE			= 0x0200;
	WM_LBUTTONDOWN			= 0x0201;
	WM_LBUTTONUP			= 0x0202;
	WM_LBUTTONDBLCLK		= 0x0203;
	WM_RBUTTONDOWN			= 0x0204;
	WM_RBUTTONUP			= 0x0205;
	WM_RBUTTONDBLCLK		= 0x0206;
	WM_MBUTTONDOWN			= 0x0207;
	WM_MBUTTONUP			= 0x0208;
	WM_MBUTTONDBLCLK		= 0x0209;
	WM_MOUSEWHEEL			= 0x020A;
	WM_MOUSELAST			= 0x020A;
	WM_PARENTNOTIFY			= 0x0210;
	WM_ENTERMENULOOP		= 0x0211;
	WM_EXITMENULOOP			= 0x0212;
	WM_NEXTMENU				= 0x0213;
	WM_SIZING				= 0x0214;
	WM_CAPTURECHANGED		= 0x0215;
	WM_MOVING				= 0x0216;
	WM_POWERBROADCAST		= 0x0218;
	WM_DEVICECHANGE			= 0x0219;
	WM_MDICREATE			= 0x0220;
	WM_MDIDESTROY			= 0x0221;
	WM_MDIACTIVATE			= 0x0222;
	WM_MDIRESTORE			= 0x0223;
	WM_MDINEXT				= 0x0224;
	WM_MDIMAXIMIZE			= 0x0225;
	WM_MDITILE				= 0x0226;
	WM_MDICASCADE			= 0x0227;
	WM_MDIICONARRANGE		= 0x0228;
	WM_MDIGETACTIVE			= 0x0229;
	WM_MDISETMENU			= 0x0230;
	WM_ENTERSIZEMOVE		= 0x0231;
	WM_EXITSIZEMOVE			= 0x0232;
	WM_DROPFILES			= 0x0233;
	WM_MDIREFRESHMENU		= 0x0234;
	WM_IME_SETCONTEXT		= 0x0281;
	WM_IME_NOTIFY			= 0x0282;
	WM_IME_CONTROL			= 0x0283;
	WM_IME_COMPOSITIONFULL	= 0x0284;
	WM_IME_SELECT			= 0x0285;
	WM_IME_CHAR				= 0x0286;
	WM_IME_KEYDOWN			= 0x0290;
	WM_IME_KEYUP			= 0x0291;
	WM_MOUSEHOVER			= 0x02A1;
	WM_MOUSELEAVE			= 0x02A3;
	WM_CUT					= 0x0300;
	WM_COPY					= 0x0301;
	WM_PASTE				= 0x0302;
	WM_CLEAR				= 0x0303;
	WM_UNDO					= 0x0304;
	WM_RENDERFORMAT			= 0x0305;
	WM_RENDERALLFORMATS		= 0x0306;
	WM_DESTROYCLIPBOARD		= 0x0307;
	WM_DRAWCLIPBOARD		= 0x0308;
	WM_PAINTCLIPBOARD		= 0x0309;
	WM_VSCROLLCLIPBOARD		= 0x030A;
	WM_SIZECLIPBOARD		= 0x030B;
	WM_ASKCBFORMATNAME		= 0x030C;
	WM_CHANGECBCHAIN		= 0x030D;
	WM_HSCROLLCLIPBOARD		= 0x030E;
	WM_QUERYNEWPALETTE		= 0x030F;
	WM_PALETTEISCHANGING	= 0x0310;
	WM_PALETTECHANGED		= 0x0311;
	WM_HOTKEY				= 0x0312;
	WM_PRINT				= 0x0317;
	WM_PRINTCLIENT			= 0x0318;
	WM_HANDHELDFIRST		= 0x0358;
	WM_HANDHELDLAST			= 0x035F;
	WM_AFXFIRST				= 0x0360;
	WM_AFXLAST				= 0x037F;
	WM_PENWINFIRST			= 0x0380;
	WM_PENWINLAST			= 0x038F;
	WM_COALESCE_FIRST		= 0x0390;
	WM_COALESCE_LAST		= 0x039F;
	WM_USER					= 0x0400;
// WM_SIZE commands
	SIZE_RESTORED		= 0;
	SIZE_MINIMIZED		= 1;
	SIZE_MAXIMIZED		= 2;
	SIZE_MAXSHOW		= 3;
	SIZE_MAXHIDE		= 4;
// WM_ACTIVATE states
	WA_INACTIVE			= 0;
	WA_ACTIVE			= 1;
	WA_CLICKACTIVE		= 2;
// WM_SHOWWINDOW identifiers
	SW_PARENTCLOSING	= 1;
	SW_OTHERZOOM		= 2;
	SW_PARENTOPENING	= 3;
	SW_OTHERUNZOOM		= 4;
// WM_MOUSEACTIVATE return codes
	MA_ACTIVATE				= 1;
	MA_ACTIVATEANDEAT		= 2;
	MA_NOACTIVATE			= 3;
	MA_NOACTIVATEANDEAT	= 4;
// WM_MDITILE flags
	MDITILE_VERTICAL		= 0;
	MDITILE_HORIZONTAL		= 1;
	MDITILE_SKIPDISABLED	= 2;
// WM_NOTIFY codes
	NM_OUTOFMEMORY		= -1;
	NM_CLICK			= -2;
	NM_DBLCLICK			= -3;
	NM_RETURN			= -4;
	NM_RCLICK			= -5;
	NM_RDBLCLK			= -6;
	NM_SETFOCUS			= -7;
	NM_KILLFOCUS		= -8;
// WM_SETICON types
	ICON_SMALL			= 0;
	ICON_BIG			= 1;
// WM_HOTKEY commands
	HOTKEYF_SHIFT		= 0x01;
	HOTKEYF_CONTROL		= 0x02;
	HOTKEYF_ALT			= 0x04;
	HOTKEYF_EXT			= 0x08;
// Keystroke flags
	KF_EXTENDED	= 0x0100;
	KF_DLGMODE	= 0x0800;
	KF_MENUMODE	= 0x1000;
	KF_ALTDOWN	= 0x2000;
	KF_REPEAT	= 0x4000;
	KF_UP		= 0x8000;
// Key state masks for mouse messages
	MK_LBUTTON	= 0x01;
	MK_RBUTTON	= 0x02;
	MK_SHIFT	= 0x04;
	MK_CONTROL	= 0x08;
	MK_MBUTTON	= 0x10;
// WM_SIZING codes
	WMSZ_LEFT			= 1;
	WMSZ_RIGHT			= 2;
	WMSZ_TOP			= 3;
	WMSZ_TOPLEFT		= 4;
	WMSZ_TOPRIGHT		= 5;
	WMSZ_BOTTOM			= 6;
	WMSZ_BOTTOMLEFT		= 7;
	WMSZ_BOTTOMRIGHT	= 8;
// WM_HOTKEY modifiers
	MOD_ALT			= 1;
	MOD_CONTROL		= 2;
	MOD_SHIFT		= 4;
	MOD_WIN			= 8;
// WM_PRINT flags
	PRF_CHECKVISIBLE	= 0x01;
	PRF_NONCLIENT		= 0x02;
	PRF_CLIENT			= 0x04;
	PRF_ERASEBKGND		= 0x08;
	PRF_CHILDREN		= 0x10;
	PRF_OWNED			= 0x20;
// Virtual key codes
	VK_LBUTTON			= 0x001;
	VK_CANCEL			= 0x003;
	VK_RBUTTON			= 0x002;
	VK_MBUTTON			= 0x004;
	VK_BACK				= 0x008;
	VK_TAB				= 0x009;
	VK_CLEAR			= 0x00C;
	VK_RETURN			= 0x00D;
	VK_SHIFT			= 0x010;
	VK_CONTROL			= 0x011;
	VK_MENU				= 0x012;
	VK_PAUSE			= 0x013;
	VK_CAPITAL			= 0x014;
	VK_ESCAPE			= 0x01B;
	VK_SPACE			= 0x020;
	VK_PRIOR			= 0x021;
	VK_PGUP				= 0x021;
	VK_PGDN				= 0x022;
	VK_NEXT				= 0x022;
	VK_END				= 0x023;
	VK_HOME				= 0x024;
	VK_LEFT				= 0x025;
	VK_UP				= 0x026;
	VK_RIGHT			= 0x027;
	VK_DOWN				= 0x028;
	VK_SELECT			= 0x029;
	VK_PRINT			= 0x02A;
	VK_EXECUTE			= 0x02B;
	VK_SNAPSHOT			= 0x02C;
	VK_INSERT			= 0x02D;
	VK_DELETE			= 0x02E;
	VK_HELP			= 0x02F;
	VK_LWIN			= 0x05B;
	VK_RWIN			= 0x05C;
	VK_APPS			= 0x05D;
	VK_NUMPAD0		= 0x060;
	VK_NUMPAD1		= 0x061;
	VK_NUMPAD2		= 0x062;
	VK_NUMPAD3		= 0x063;
	VK_NUMPAD4		= 0x064;
	VK_NUMPAD5		= 0x065;
	VK_NUMPAD6		= 0x066;
	VK_NUMPAD7		= 0x067;
	VK_NUMPAD8		= 0x068;
	VK_NUMPAD9		= 0x069;
	VK_MULTIPLY		= 0x06A;
	VK_ADD			= 0x06B;
	VK_SEPARATOR	= 0x06C;
	VK_SUBTRACT		= 0x06D;
	VK_DECIMAL		= 0x06E;
	VK_DIVIDE			= 0x06F;
	VK_F1				= 0x070;
	VK_F2				= 0x071;
	VK_F3				= 0x072;
	VK_F4				= 0x073;
	VK_F5				= 0x074;
	VK_F6				= 0x075;
	VK_F7				= 0x076;
	VK_F8				= 0x077;
	VK_F9				= 0x078;
	VK_F10				= 0x079;
	VK_F11				= 0x07A;
	VK_F12				= 0x07B;
	VK_F13				= 0x07C;
	VK_F14				= 0x07D;
	VK_F15				= 0x07E;
	VK_F16				= 0x07F;
	VK_F17				= 0x080;
	VK_F18				= 0x081;
	VK_F19				= 0x082;
	VK_F20				= 0x083;
	VK_F21				= 0x084;
	VK_F22				= 0x085;
	VK_F23				= 0x086;
	VK_F24				= 0x087;
	VK_NUMLOCK			= 0x090;
	VK_SCROLL			= 0x091;
	VK_LSHIFT			= 0x0A0;
	VK_RSHIFT			= 0x0A1;
	VK_LCONTROL			= 0x0A2;
	VK_RCONTROL			= 0x0A3;
	VK_LMENU			= 0x0A4;
	VK_RMENU			= 0x0A5;
	VK_ATTN				= 0x0F6;
	VK_CRSEL			= 0x0F7;
	VK_EXSEL			= 0x0F8;
	VK_EREOF			= 0x0F9;
	VK_PLAY				= 0x0FA;
	VK_ZOOM				= 0x0FB;
	VK_NONAME			= 0x0FC;
	VK_PA1				= 0x0FD;
	VK_OEM_CLEAR		= 0x0FE;
// Accelerator flags
	FVIRTKEY	= 0x01;
	FNOINVERT	= 0x02;
	FSHIFT		= 0x04;
	FCONTROL	= 0x08;
	FALT		= 0x10;
// GetClassLong offsets
	GCL_MENUNAME		= -8;
	GCL_HBRBACKGROUND	= -10;
	GCL_HCURSOR			= -12;
	GCL_HICON			= -14;
	GCL_HMODULE			= -16;
	GCL_CBWNDEXTRA		= -18;
	GCL_CBCLSEXTRA		= -20;
	GCL_WNDPROC			= -24;
	GCL_STYLE			= -26;
	GCW_ATOM			= -32;
	GCL_HICONSM			= -34;
// WNDCLASS parameters
	DLGWINDOWEXTRA		= 30;
// GetWindowLong offsets
	GWL_WNDPROC			= -4;
	GWL_HINSTANCE		= -6;
	GWL_HWNDPARENT		= -8;
	GWL_STYLE			= -16;
	GWL_EXSTYLE			= -20;
	GWL_USERDATA		= -21;
	GWL_ID				= -12;
	DWL_MSGRESULT		= 0;
	DWL_DLGPROC			= 4;
	DWL_USER			= 8;
// GetSystemMetrics codes
	SM_CXSCREEN				= 0;
	SM_CYSCREEN				= 1;
	SM_CXVSCROLL			= 2;
	SM_CYHSCROLL			= 3;
	SM_CYCAPTION			= 4;
	SM_CXBORDER				= 5;
	SM_CYBORDER				= 6;
	SM_CXDLGFRAME			= 7;
	SM_CYDLGFRAME			= 8;
	SM_CYVTHUMB				= 9;
	SM_CXHTHUMB				= 10;
	SM_CXICON				= 11;
	SM_CYICON				= 12;
	SM_CXCURSOR				= 13;
	SM_CYCURSOR				= 14;
	SM_CYMENU				= 15;
	SM_CXFULLSCREEN			= 16;
	SM_CYFULLSCREEN			= 17;
	SM_CYKANJIWINDOW		= 18;
	SM_MOUSEPRESENT			= 19;
	SM_CYVSCROLL			= 20;
	SM_CXHSCROLL			= 21;
	SM_DEBUG				= 22;
	SM_SWAPBUTTON			= 23;
	SM_RESERVED1			= 24;
	SM_RESERVED2			= 25;
	SM_RESERVED3			= 26;
	SM_RESERVED4			= 27;
	SM_CXMIN				= 28;
	SM_CYMIN				= 29;
	SM_CXSIZE				= 30;
	SM_CYSIZE				= 31;
	SM_CXFRAME				= 32;
	SM_CYFRAME				= 33;
	SM_CXMINTRACK			= 34;
	SM_CYMINTRACK			= 35;
	SM_CXDOUBLECLK			= 36;
	SM_CYDOUBLECLK			= 37;
	SM_CXICONSPACING		= 38;
	SM_CYICONSPACING		= 39;
	SM_MENUDROPALIGNMENT	= 40;
	SM_PENWINDOWS			= 41;
	SM_DBCSENABLED			= 42;
	SM_CMOUSEBUTTONS		= 43;
	SM_CXFIXEDFRAME			= SM_CXDLGFRAME;
	SM_CYFIXEDFRAME			= SM_CYDLGFRAME;
	SM_CXSIZEFRAME			= SM_CXFRAME;
	SM_CYSIZEFRAME			= SM_CYFRAME;
	SM_SECURE				= 44;
	SM_CXEDGE				= 45;
	SM_CYEDGE				= 46;
	SM_CXMINSPACING			= 47;
	SM_CYMINSPACING			= 48;
	SM_CXSMICON				= 49;
	SM_CYSMICON				= 50;
	SM_CYSMCAPTION			= 51;
	SM_CXSMSIZE				= 52;
	SM_CYSMSIZE				= 53;
	SM_CXMENUSIZE			= 54;
	SM_CYMENUSIZE			= 55;
	SM_ARRANGE				= 56;
	SM_CXMINIMIZED				= 57;
	SM_CYMINIMIZED				= 58;
	SM_CXMAXTRACK				= 59;
	SM_CYMAXTRACK				= 60;
	SM_CXMAXIMIZED				= 61;
	SM_CYMAXIMIZED				= 62;
	SM_NETWORK					= 63;
	SM_CLEANBOOT				= 67;
	SM_CXDRAG					= 68;
	SM_CYDRAG					= 69;
	SM_SHOWSOUNDS				= 70;
	SM_CXMENUCHECK				= 71;
	SM_CYMENUCHECK				= 72;
	SM_SLOWMACHINE				= 73;
	SM_MIDEASTENABLED			= 74;
	SM_MOUSEWHEELPRESENT		= 75;
	SM_CMETRICS					= 76;
// Predefined cursor identifiers
	IDC_ARROW		= 32512;
	IDC_IBEAM		= 32513;
	IDC_WAIT		= 32514;
	IDC_CROSS		= 32515;
	IDC_UPARROW		= 32516;
	IDC_SIZE		= 32640;
	IDC_ICON		= 32641;
	IDC_SIZENWSE	= 32642;
	IDC_SIZENESW	= 32643;
	IDC_SIZEWE		= 32644;
	IDC_SIZENS		= 32645;
	IDC_NO			= 32648;
	IDC_HAND		= 32649;
	IDC_APPSTARTING	= 32650;
	IDC_HELP		= 32651;
// Predefined icon identifiers
	IDI_APPLICATION	= 32512;
	IDI_HAND		= 32513;
	IDI_QUESTION	= 32514;
	IDI_EXCLAMATION	= 32515;
	IDI_ASTERISK	= 32516;
	IDI_WINLOGO		= 32517;
// System colors
	COLOR_SCROLLBAR					= 0;
	COLOR_BACKGROUND				= 1;
	COLOR_ACTIVECAPTION				= 2;
	COLOR_INACTIVECAPTION			= 3;
	COLOR_MENU						= 4;
	COLOR_WINDOW					= 5;
	COLOR_WINDOWFRAME				= 6;
	COLOR_MENUTEXT					= 7;
	COLOR_WINDOWTEXT				= 8;
	COLOR_CAPTIONTEXT				= 9;
	COLOR_ACTIVEBORDER				= 10;
	COLOR_INACTIVEBORDER			= 11;
	COLOR_APPWORKSPACE				= 12;
	COLOR_HIGHLIGHT					= 13;
	COLOR_HIGHLIGHTTEXT				= 14;
	COLOR_BTNFACE					= 15;
	COLOR_BTNSHADOW					= 16;
	COLOR_GRAYTEXT					= 17;
	COLOR_BTNTEXT					= 18;
	COLOR_INACTIVECAPTIONTEXT		= 19;
	COLOR_BTNHIGHLIGHT				= 20;
	COLOR_3DDKSHADOW				= 21;
	COLOR_3DLIGHT					= 22;
	COLOR_INFOTEXT					= 23;
	COLOR_INFOBK					= 24;
	COLOR_HOTLIGHT					= 26;
	COLOR_GRADIENTACTIVECAPTION		= 27;
	COLOR_GRADIENTINACTIVECAPTION	= 28;
// Button messages
	BM_GETCHECK	= 0x00F0;
	BM_SETCHECK	= 0x00F1;
	BM_GETSTATE	= 0x00F2;
	BM_SETSTATE	= 0x00F3;
	BM_SETSTYLE	= 0x00F4;
	BM_CLICK			= 0x00F5;
	BM_GETIMAGE	= 0x00F6;
	BM_SETIMAGE	= 0x00F7;
// Button notifications
	BN_CLICKED			= 0;
	BN_PAINT			= 1;
	BN_HILITE			= 2;
	BN_UNHILITE			= 3;
	BN_DISABLE			= 4;
	BN_DOUBLECLICKED	= 5;
	BN_SETFOCUS			= 6;
	BN_KILLFOCUS		= 7;
	BN_PUSHED			= BN_HILITE;
	BN_UNPUSHED			= BN_UNHILITE;
	BN_DBLCLK			= BN_DOUBLECLICKED;
// Button styles
	BS_PUSHBUTTON		= 0x0000;
	BS_DEFPUSHBUTTON	= 0x0001;
	BS_CHECKBOX			= 0x0002;
	BS_AUTOCHECKBOX		= 0x0003;
	BS_RADIOBUTTON		= 0x0004;
	BS_3STATE			= 0x0005;
	BS_AUTO3STATE		= 0x0006;
	BS_GROUPBOX			= 0x0007;
	BS_USERBUTTON		= 0x0008;
	BS_AUTORADIOBUTTON	= 0x0009;
	BS_OWNERDRAW		= 0x000B;
	BS_TEXT				= 0x0000;
	BS_LEFTTEXT			= 0x0020;
	BS_RIGHTBUTTON		= BS_LEFTTEXT;
	BS_ICON				= 0x0040;
	BS_BITMAP			= 0x0080;
	BS_LEFT				= 0x0100;
	BS_RIGHT			= 0x0200;
	BS_CENTER			= 0x0300;
	BS_TOP				= 0x0400;
	BS_BOTTOM			= 0x0800;
	BS_VCENTER			= 0x0C00;
	BS_PUSHLIKE			= 0x1000;
	BS_MULTILINE		= 0x2000;
	BS_NOTIFY			= 0x4000;
	BS_FLAT				= 0x8000;
// Button states
	BST_UNCHECKED		= 0;
	BST_CHECKED			= 1;
	BST_INDETERMINATE	= 2;
	BST_PUSHED			= 4;
	BST_FOCUS			= 8;
// List box messages
	LB_ADDSTRING				= 0x0180;
	LB_INSERTSTRING				= 0x0181;
	LB_DELETESTRING				= 0x0182;
	LB_SELITEMRANGEEX			= 0x0183;
	LB_RESETCONTENT				= 0x0184;
	LB_SETSEL					= 0x0185;
	LB_SETCURSEL				= 0x0186;
	LB_GETSEL					= 0x0187;
	LB_GETCURSEL				= 0x0188;
	LB_GETTEXT					= 0x0189;
	LB_GETTEXTLEN				= 0x018A;
	LB_GETCOUNT					= 0x018B;
	LB_SELECTSTRING				= 0x018C;
	LB_DIR						= 0x018D;
	LB_GETTOPINDEX				= 0x018E;
	LB_FINDSTRING				= 0x018F;
	LB_GETSELCOUNT				= 0x0190;
	LB_GETSELITEMS				= 0x0191;
	LB_SETTABSTOPS				= 0x0192;
	LB_GETHORIZONTALEXTENT		= 0x0193;
	LB_SETHORIZONTALEXTENT		= 0x0194;
	LB_SETCOLUMNWIDTH			= 0x0195;
	LB_ADDFILE					= 0x0196;
	LB_SETTOPINDEX				= 0x0197;
	LB_GETITEMRECT				= 0x0198;
	LB_GETITEMDATA				= 0x0199;
	LB_SETITEMDATA				= 0x019A;
	LB_SELITEMRANGE				= 0x019B;
	LB_SETANCHORINDEX			= 0x019C;
	LB_GETANCHORINDEX			= 0x019D;
	LB_SETCARETINDEX			= 0x019E;
	LB_GETCARETINDEX			= 0x019F;
	LB_SETITEMHEIGHT			= 0x01A0;
	LB_GETITEMHEIGHT			= 0x01A1;
	LB_FINDSTRINGEXACT			= 0x01A2;
	LB_SETLOCALE				= 0x01A5;
	LB_GETLOCALE				= 0x01A6;
	LB_SETCOUNT					= 0x01A7;
	LB_INITSTORAGE				= 0x01A8;
	LB_ITEMFROMPOINT			= 0x01A9;
// List box notifications
	LBN_ERRSPACE	= -2;
	LBN_SELCHANGE	= 1;
	LBN_DBLCLK		= 2;
	LBN_SELCANCEL	= 3;
	LBN_SETFOCUS	= 4;
	LBN_KILLFOCUS	= 5;
// List box styles
	LBS_NOTIFY				= 0x0001;
	LBS_SORT				= 0x0002;
	LBS_NOREDRAW			= 0x0004;
	LBS_MULTIPLESEL			= 0x0008;
	LBS_OWNERDRAWFIXED		= 0x0010;
	LBS_OWNERDRAWVARIABLE	= 0x0020;
	LBS_HASSTRINGS			= 0x0040;
	LBS_USETABSTOPS			= 0x0080;
	LBS_NOINTEGRALHEIGHT	= 0x0100;
	LBS_MULTICOLUMN			= 0x0200;
	LBS_WANTKEYBOARDINPUT	= 0x0400;
	LBS_EXTENDEDSEL			= 0x0800;
	LBS_DISABLENOSCROLL		= 0x1000;
	LBS_NODATA				= 0x2000;
	LBS_NOSEL				= 0x4000;
	LBS_STANDARD			= 0x00a00003;
// List box return values
	LB_OKAY					= 0;
	LB_ERR					= -1;
	LB_ERRSPACE				= -2;
// Combo box messages
	CB_GETEDITSEL			= 0x0140;
	CB_LIMITTEXT			= 0x0141;
	CB_SETEDITSEL			= 0x0142;
	CB_ADDSTRING			= 0x0143;
	CB_DELETESTRING			= 0x0144;
	CB_DIR					= 0x0145;
	CB_GETCOUNT				= 0x0146;
	CB_GETCURSEL			= 0x0147;
	CB_GETLBTEXT			= 0x0148;
	CB_GETLBTEXTLEN			= 0x0149;
	CB_INSERTSTRING			= 0x014A;
	CB_RESETCONTENT			= 0x014B;
	CB_FINDSTRING			= 0x014C;
	CB_SELECTSTRING			= 0x014D;
	CB_SETCURSEL			= 0x014E;
	CB_SHOWDROPDOWN			= 0x014F;
	CB_GETITEMDATA			= 0x0150;
	CB_SETITEMDATA			= 0x0151;
	CB_GETDROPPEDCONTROLRECT	= 0x0152;
	CB_SETITEMHEIGHT		= 0x0153;
	CB_GETITEMHEIGHT		= 0x0154;
	CB_SETEXTENDEDUI		= 0x0155;
	CB_GETEXTENDEDUI		= 0x0156;
	CB_GETDROPPEDSTATE		= 0x0157;
	CB_FINDSTRINGEXACT		= 0x0158;
	CB_SETLOCALE			= 0x0159;
	CB_GETLOCALE			= 0x015A;
	CB_GETTOPINDEX			= 0x015B;
	CB_SETTOPINDEX			= 0x015C;
	CB_GETHORIZONTALEXTENT	= 0x015D;
	CB_SETHORIZONTALEXTENT	= 0x015E;
	CB_GETDROPPEDWIDTH		= 0x015F;
	CB_SETDROPPEDWIDTH		= 0x0160;
	CB_INITSTORAGE			= 0x0161;
// Combo box notifications
	CBN_ERRSPACE		= -1;
	CBN_SELCHANGE		= 1;
	CBN_DBLCLK			= 2;
	CBN_SETFOCUS		= 3;
	CBN_KILLFOCUS		= 4;
	CBN_EDITCHANGE		= 5;
	CBN_EDITUPDATE		= 6;
	CBN_DROPDOWN		= 7;
	CBN_CLOSEUP			= 8;
	CBN_SELENDOK		= 9;
	CBN_SELENDCANCEL	= 10;
// Combo box styles
	CBS_SIMPLE					= 0x0001;
	CBS_DROPDOWN				= 0x0002;
	CBS_DROPDOWNLIST			= 0x0003;
	CBS_OWNERDRAWFIXED			= 0x0010;
	CBS_OWNERDRAWVARIABLE		= 0x0020;
	CBS_AUTOHSCROLL				= 0x0040;
	CBS_OEMCONVERT				= 0x0080;
	CBS_SORT					= 0x0100;
	CBS_HASSTRINGS				= 0x0200;
	CBS_NOINTEGRALHEIGHT		= 0x0400;
	CBS_DISABLENOSCROLL			= 0x0800;
	CBS_UPPERCASE				= 0x2000;
	CBS_LOWERCASE				= 0x4000;
// Combo box return values
	CB_OKAY				= 0;
	CB_ERR				= -1;
	CB_ERRSPACE			= -2;
// Edit control messages
	EM_GETSEL					= 0x00B0;
	EM_SETSEL					= 0x00B1;
	EM_GETRECT					= 0x00B2;
	EM_SETRECT					= 0x00B3;
	EM_SETRECTNP				= 0x00B4;
	EM_SCROLL					= 0x00B5;
	EM_LINESCROLL				= 0x00B6;
	EM_SCROLLCARET				= 0x00B7;
	EM_GETMODIFY				= 0x00B8;
	EM_SETMODIFY				= 0x00B9;
	EM_GETLINECOUNT				= 0x00BA;
	EM_LINEINDEX				= 0x00BB;
	EM_SETHANDLE				= 0x00BC;
	EM_GETHANDLE				= 0x00BD;
	EM_GETTHUMB					= 0x00BE;
	EM_LINELENGTH				= 0x00C1;
	EM_REPLACESEL				= 0x00C2;
	EM_GETLINE					= 0x00C4;
	EM_LIMITTEXT				= 0x00C5;
	EM_CANUNDO					= 0x00C6;
	EM_UNDO						= 0x00C7;
	EM_FMTLINES					= 0x00C8;
	EM_LINEFROMCHAR				= 0x00C9;
	EM_SETTABSTOPS				= 0x00CB;
	EM_SETPASSWORDCHAR			= 0x00CC;
	EM_EMPTYUNDOBUFFER			= 0x00CD;
	EM_GETFIRSTVISIBLELINE		= 0x00CE;
	EM_SETREADONLY				= 0x00CF;
	EM_SETWORDBREAKPROC			= 0x00D0;
	EM_GETWORDBREAKPROC			= 0x00D1;
	EM_GETPASSWORDCHAR			= 0x00D2;
	EM_SETMARGINS				= 0x00D3;
	EM_GETMARGINS				= 0x00D4;
	EM_SETLIMITTEXT				= EM_LIMITTEXT;
	EM_GETLIMITTEXT				= 0x00D5;
	EM_POSFROMCHAR				= 0x00D6;
	EM_CHARFROMPOS				= 0x00D7;
// Edit control EM_SETMARGIN parameters
	EC_LEFTMARGIN	= 1;
	EC_RIGHTMARGIN	= 2;
	EC_USEFONTINFO	= 0x0FFFF;
// Edit control notifications
	EN_SETFOCUS			= 0x0100;
	EN_KILLFOCUS		= 0x0200;
	EN_CHANGE			= 0x0300;
	EN_UPDATE			= 0x0400;
	EN_ERRSPACE			= 0x0500;
	EN_MAXTEXT			= 0x0501;
	EN_HSCROLL			= 0x0601;
	EN_VSCROLL			= 0x0602;
// Edit control styles
	ES_LEFT				= 0x0000;
	ES_CENTER			= 0x0001;
	ES_RIGHT			= 0x0002;
	ES_MULTILINE		= 0x0004;
	ES_UPPERCASE		= 0x0008;
	ES_LOWERCASE		= 0x0010;
	ES_PASSWORD			= 0x0020;
	ES_AUTOVSCROLL		= 0x0040;
	ES_AUTOHSCROLL		= 0x0080;
	ES_NOHIDESEL		= 0x0100;
	ES_OEMCONVERT		= 0x0400;
	ES_READONLY			= 0x0800;
	ES_WANTRETURN		= 0x1000;
	ES_NUMBER			= 0x2000;
// Static window messages
	STM_SETICON		= 0x0170;
	STM_GETICON		= 0x0171;
	STM_SETIMAGE	= 0x0172;
	STM_GETIMAGE	= 0x0173;
// Static window notifications
	STN_CLICKED	= 0;
	STN_DBLCLK	= 1;
	STN_ENABLE	= 2;
	STN_DISABLE	= 3;
// Static window styles
	SS_LEFT				= 0x0000;
	SS_CENTER			= 0x0001;
	SS_RIGHT			= 0x0002;
	SS_ICON				= 0x0003;
	SS_BLACKRECT		= 0x0004;
	SS_GRAYRECT			= 0x0005;
	SS_WHITERECT		= 0x0006;
	SS_BLACKFRAME		= 0x0007;
	SS_GRAYFRAME		= 0x0008;
	SS_WHITEFRAME		= 0x0009;
	SS_USERITEM			= 0x000A;
	SS_SIMPLE			= 0x000B;
	SS_LEFTNOWORDWRAP	= 0x000C;
	SS_BITMAP			= 0x000E;
	SS_OWNERDRAW		= 0x000D;
	SS_ENHMETAFILE		= 0x000F;
	SS_ETCHEDHORZ		= 0x0010;
	SS_ETCHEDVERT		= 0x0011;
	SS_ETCHEDFRAME		= 0x0012;
	SS_TYPEMASK			= 0x001F;
	SS_NOPREFIX			= 0x0080;
	SS_NOTIFY			= 0x0100;
	SS_CENTERIMAGE		= 0x0200;
	SS_RIGHTJUST		= 0x0400;
	SS_REALSIZEIMAGE	= 0x0800;
	SS_SUNKEN			= 0x1000;
// Scroll bar constants
	SB_HORZ			= 0;
	SB_VERT			= 1;
	SB_CTL			= 2;
	SB_BOTH			= 3;
// Scroll bar messages
	SBM_SETPOS			= 0x00E0;
	SBM_GETPOS			= 0x00E1;
	SBM_SETRANGE		= 0x00E2;
	SBM_SETRANGEREDRAW	= 0x00E6;
	SBM_GETRANGE		= 0x00E3;
	SBM_ENABLE_ARROWS	= 0x00E4;
	SBM_SETSCROLLINFO	= 0x00E9;
	SBM_GETSCROLLINFO	= 0x00EA;
// Scroll bar commands
	SB_LINEUP		= 0;
	SB_LINELEFT		= 0;
	SB_LINEDOWN		= 1;
	SB_LINERIGHT	= 1;
	SB_PAGEUP		= 2;
	SB_PAGELEFT		= 2;
	SB_PAGEDOWN		= 3;
	SB_PAGERIGHT		= 3;
	SB_THUMBPOSITION	= 4;
	SB_THUMBTRACK		= 5;
	SB_TOP			= 6;
	SB_LEFT			= 6;
	SB_BOTTOM		= 7;
	SB_RIGHT		= 7;
	SB_ENDSCROLL	= 8;
// Scroll bar styles
	SBS_HORZ					= 0x0000;
	SBS_VERT					= 0x0001;
	SBS_TOPALIGN				= 0x0002;
	SBS_LEFTALIGN				= 0x0002;
	SBS_BOTTOMALIGN				= 0x0004;
	SBS_RIGHTALIGN				= 0x0004;
	SBS_SIZEBOXTOPLEFTALIGN		= 0x0002;
	SBS_SIZEBOXBOTTOMRIGHTALIGN	= 0x0004;
	SBS_SIZEBOX					= 0x0008;
	SBS_SIZEGRIP				= 0x0010;
// Scroll bar info flags
	SIF_RANGE				= 0x0001;
	SIF_PAGE				= 0x0002;
	SIF_POS					= 0x0004;
	SIF_DISABLENOSCROLL		= 0x0008;
	SIF_TRACKPOS			= 0x0010;
	SIF_ALL					= 0x0017;
// Dialog styles
	DS_ABSALIGN			= 0x0001;
	DS_SYSMODAL			= 0x0002;
	DS_3DLOOK			= 0x0004;
	DS_FIXEDSYS			= 0x0008;
	DS_NOFAILCREATE		= 0x0010;
	DS_LOCALEDIT		= 0x0020;
	DS_SETFONT			= 0x0040;
	DS_MODALFRAME		= 0x0080;
	DS_NOIDLEMSG		= 0x0100;
	DS_SETFOREGROUND	= 0x0200;
	DS_CONTROL			= 0x0400;
	DS_CENTER			= 0x0800;
	DS_CENTERMOUSE		= 0x1000;
	DS_CONTEXTHELP		= 0x2000;
// Dialog codes
	DLGC_WANTARROWS				= 0x0001;
	DLGC_WANTTAB				= 0x0002;
	DLGC_WANTALLKEYS			= 0x0004;
	DLGC_WANTMESSAGE			= 0x0004;
	DLGC_HASSETSEL				= 0x0008;
	DLGC_DEFPUSHBUTTON			= 0x0010;
	DLGC_UNDEFPUSHBUTTON		= 0x0020;
	DLGC_RADIOBUTTON			= 0x0040;
	DLGC_WANTCHARS				= 0x0080;
	DLGC_STATIC					= 0x0100;
	DLGC_BUTTON					= 0x2000;
// Menu flags
	MF_INSERT			= 0x0000;
	MF_CHANGE			= 0x0080;
	MF_APPEND			= 0x0100;
	MF_DELETE			= 0x0200;
	MF_REMOVE			= 0x1000;
	MF_BYCOMMAND		= 0x0000;
	MF_BYPOSITION		= 0x0400;
	MF_SEPARATOR		= 0x0800;
	MF_UNCHECKED		= 0x0000;
	MF_ENABLED			= 0x0000;
	MF_GRAYED			= 0x0001;
	MF_DISABLED			= 0x0002;
	MF_CHECKED			= 0x0008;
	MF_USECHECKBITMAPS	= 0x0200;
	MF_STRING			= 0x0000;
	MF_BITMAP			= 0x0004;
	MF_OWNERDRAW		= 0x0100;
	MF_POPUP			= 0x0010;
	MF_MENUBARBREAK		= 0x0020;
	MF_MENUBREAK		= 0x0040;
	MF_UNHILITE			= 0x0000;
	MF_HILITE			= 0x0080;
	MF_DEFAULT			= 0x1000;
	MF_SYSMENU			= 0x2000;
	MF_HELP				= 0x4000;
	MF_RIGHTJUSTIFY		= 0x4000;
	MF_MOUSESELECT		= 0x8000;
	MF_END				= 0x0080;
	MFT_STRING			= MF_STRING;
	MFT_BITMAP			= MF_BITMAP;
	MFT_MENUBARBREAK	= MF_MENUBARBREAK;
	MFT_MENUBREAK		= MF_MENUBREAK;
	MFT_OWNERDRAW		= MF_OWNERDRAW;
	MFT_RADIOCHECK		= 0x0200;
	MFT_SEPARATOR		= MF_SEPARATOR;
	MFT_RIGHTORDER		= 0x2000;
	MFT_RIGHTJUSTIFY	= MF_RIGHTJUSTIFY;
	MFS_GRAYED			= 0x0003;
	MFS_DISABLED		= MFS_GRAYED;
	MFS_CHECKED			= MF_CHECKED;
	MFS_HILITE			= MF_HILITE;
	MFS_ENABLED			= MF_ENABLED;
	MFS_UNCHECKED		= MF_UNCHECKED;
	MFS_UNHILITE		= MF_UNHILITE;
	MFS_DEFAULT			= MF_DEFAULT;
	MFR_POPUP			= 0x0001;
	MFR_END				= MF_END;
// System menu command values
	SC_SIZE			= 61440;
	SC_MOVE			= 61456;
	SC_MINIMIZE		= 61472;
	SC_MAXIMIZE		= 61488;
	SC_NEXTWINDOW	= 61504;
	SC_PREVWINDOW	= 61520;
	SC_CLOSE		= 61536;
	SC_VSCROLL		= 61552;
	SC_HSCROLL		= 61568;
	SC_MOUSEMENU	= 61584;
	SC_KEYMENU		= 61696;
	SC_ARRANGE		= 61712;
	SC_RESTORE		= 61728;
	SC_TASKLIST		= 61744;
	SC_SCREENSAVE	= 61760;
	SC_HOTKEY		= 61776;
	SC_DEFAULT		= 61792;
	SC_MONITORPOWER	= 61808;
	SC_CONTEXTHELP	= 61824;
	SC_SEPARATOR	= 61455;
// Border types
	BDR_RAISEDOUTER	= 0x01;
	BDR_SUNKENOUTER	= 0x02;
	BDR_RAISEDINNER	= 0x04;
	BDR_SUNKENINNER	= 0x08;
	BDR_OUTER		= 0x03;
	BDR_INNER		= 0x0C;
	BDR_RAISED		= 0x05;
	BDR_SUNKEN		= 0x0A;
	EDGE_RAISED		= 0x00000005;
	EDGE_SUNKEN		= 0x0000000a;
	EDGE_ETCHED		= 0x00000006;
	EDGE_BUMP		= 0x00000009;
// Border flags
	BF_LEFT					= 0x0001;
	BF_TOP					= 0x0002;
	BF_RIGHT				= 0x0004;
	BF_BOTTOM				= 0x0008;
	BF_TOPLEFT				= BF_TOP + BF_LEFT;
	BF_TOPRIGHT				= BF_TOP + BF_RIGHT;
	BF_BOTTOMLEFT			= BF_BOTTOM + BF_LEFT;
	BF_BOTTOMRIGHT			= BF_BOTTOM + BF_RIGHT;
	BF_RECT					= BF_LEFT + BF_TOP + BF_RIGHT + BF_BOTTOM;
	BF_DIAGONAL				= 0x0010;
	BF_DIAGONAL_ENDTOPRIGHT			= BF_DIAGONAL + BF_TOP + BF_RIGHT;
	BF_DIAGONAL_ENDTOPLEFT			= BF_DIAGONAL + BF_TOP + BF_LEFT;
	BF_DIAGONAL_ENDBOTTOMLEFT		= BF_DIAGONAL + BF_BOTTOM + BF_LEFT;
	BF_DIAGONAL_ENDBOTTOMRIGHT		= BF_DIAGONAL + BF_BOTTOM + BF_RIGHT;
	BF_MIDDLE				= 0x0800;
	BF_SOFT					= 0x1000;
	BF_ADJUST				= 0x2000;
	BF_FLAT					= 0x4000;
	BF_MONO					= 0x8000;
// Frame control types
	DFC_CAPTION			= 1;
	DFC_MENU			= 2;
	DFC_SCROLL			= 3;
	DFC_BUTTON			= 4;
	DFC_POPUPMENU		= 5;
// Frame control states
	DFCS_CAPTIONCLOSE		= 0x0000;
	DFCS_CAPTIONMIN			= 0x0001;
	DFCS_CAPTIONMAX			= 0x0002;
	DFCS_CAPTIONRESTORE		= 0x0003;
	DFCS_CAPTIONHELP		= 0x0004;
	DFCS_MENUARROW			= 0x0000;
	DFCS_MENUCHECK			= 0x0001;
	DFCS_MENUBULLET			= 0x0002;
	DFCS_MENUARROWRIGHT		= 0x0004;
	DFCS_SCROLLUP			= 0x0000;
	DFCS_SCROLLDOWN			= 0x0001;
	DFCS_SCROLLLEFT			= 0x0002;
	DFCS_SCROLLRIGHT		= 0x0003;
	DFCS_SCROLLCOMBOBOX		= 0x0005;
	DFCS_SCROLLSIZEGRIP		= 0x0008;
	DFCS_SCROLLSIZEGRIPRIGHT	= 0x0010;
	DFCS_BUTTONCHECK			= 0x0000;
	DFCS_BUTTONRADIOIMAGE		= 0x0001;
	DFCS_BUTTONRADIOMASK		= 0x0002;
	DFCS_BUTTONRADIO		= 0x0004;
	DFCS_BUTTON3STATE		= 0x0008;
	DFCS_BUTTONPUSH			= 0x0010;
	DFCS_INACTIVE			= 0x0100;
	DFCS_PUSHED				= 0x0200;
	DFCS_CHECKED			= 0x0400;
	DFCS_TRANSPARENT		= 0x0800;
	DFCS_HOT				= 0x1000;
	DFCS_ADJUSTRECT			= 0x2000;
	DFCS_FLAT				= 0x4000;
	DFCS_MONO				= 0x8000;
// DrawCaption flags
	DC_ACTIVE		= 0x01;
	DC_SMALLCAP		= 0x02;
	DC_ICON			= 0x04;
	DC_TEXT			= 0x08;
	DC_INBUTTON		= 0x10;
// DrawIconEx options
	DI_MASK				= 1;
	DI_IMAGE			= 2;
	DI_NORMAL			= 3;
	DI_COMPAT			= 4;
	DI_DEFAULTSIZE		= 8;
// DrawText parameters
	DT_TOP				= 0x00000;
	DT_LEFT				= 0x00000;
	DT_CENTER			= 0x00001;
	DT_RIGHT			= 0x00002;
	DT_VCENTER			= 0x00004;
	DT_BOTTOM			= 0x00008;
	DT_WORDBREAK			= 0x00010;
	DT_SINGLELINE			= 0x00020;
	DT_EXPANDTABS			= 0x00040;
	DT_TABSTOP			= 0x00080;
	DT_NOCLIP			= 0x00100;
	DT_EXTERNALLEADING	= 0x00200;
	DT_CALCRECT			= 0x00400;
	DT_NOPREFIX			= 0x00800;
	DT_INTERNAL			= 0x01000;
	DT_EDITCONTROL			= 0x02000;
	DT_PATH_ELLIPSIS		= 0x04000;
	DT_END_ELLIPSIS			= 0x08000;
	DT_MODIFYSTRING			= 0x10000;
	DT_RTLREADING			= 0x20000;
	DT_WORD_ELLIPSIS		= 0x40000;
// GetDCEx flags
	DCX_WINDOW					= 0x000001;
	DCX_CACHE					= 0x000002;
	DCX_NORESETATTRS			= 0x000004;
	DCX_CLIPCHILDREN			= 0x000008;
	DCX_CLIPSIBLINGS			= 0x000010;
	DCX_PARENTCLIP				= 0x000020;
	DCX_EXCLUDERGN				= 0x000040;
	DCX_INTERSECTRGN			= 0x000080;
	DCX_EXCLUDEUPDATE			= 0x000100;
	DCX_INTERSECTUPDATE			= 0x000200;
	DCX_LOCKWINDOWUPDATE		= 0x000400;
	DCX_VALIDATE				= 0x200000;
// SetWindowsHook codes
	WH_MSGFILTER			= -1;
	WH_JOURNALRECORD		= 0;
	WH_JOURNALPLAYBACK		= 1;
	WH_KEYBOARD				= 2;
	WH_GETMESSAGE			= 3;
	WH_CALLWNDPROC			= 4;
	WH_CBT					= 5;
	WH_SYSMSGFILTER			= 6;
	WH_MOUSE				= 7;
	WH_HARDWARE				= 8;
	WH_DEBUG				= 9;
	WH_SHELL				= 10;
	WH_FOREGROUNDIDLE		= 11;
	WH_CALLWNDPROCRET		= 12;
	WH_KEYBOARD_LL			= 13;
	WH_MOUSE_LL				= 14;
// Hook codes
	HC_ACTION			= 0;
	HC_GETNEXT			= 1;
	HC_SKIP				= 2;
	HC_NOREMOVE			= 3;
	HC_SYSMODALON		= 4;
	HC_SYSMODALOFF		= 5;
// CBT hook codes
	HCBT_MOVESIZE		= 0;
	HCBT_MINMAX			= 1;
	HCBT_QS				= 2;
	HCBT_CREATEWND		= 3;
	HCBT_DESTROYWND		= 4;
	HCBT_ACTIVATE		= 5;
	HCBT_CLICKSKIPPED	= 6;
	HCBT_KEYSKIPPED		= 7;
	HCBT_SYSCOMMAND		= 8;
	HCBT_SETFOCUS		= 9;
// ExitWindowsEx flags
	EWX_LOGOFF		= 0;
	EWX_SHUTDOWN	= 1;
	EWX_REBOOT		= 2;
	EWX_FORCE		= 4;
	EWX_POWEROFF	= 8;
// WinHelp commands
	HELP_CONTEXT		= 0x001;
	HELP_QUIT			= 0x002;
	HELP_INDEX			= 0x003;
	HELP_CONTENTS		= 0x003;
	HELP_HELPONHELP		= 0x004;
	HELP_SETINDEX		= 0x005;
	HELP_SETCONTENTS	= 0x005;
	HELP_CONTEXTPOPUP	= 0x008;
	HELP_FORCEFILE		= 0x009;
	HELP_CONTEXTMENU	= 0x00A;
	HELP_FINDER			= 0x00B;
	HELP_WM_HELP		= 0x00C;
	HELP_SETPOPUP_POS	= 0x00D;
	HELP_KEY			= 0x101;
	HELP_COMMAND		= 0x102;
	HELP_PARTIALKEY		= 0x105;
	HELP_MULTIKEY		= 0x201;
	HELP_SETWINPOS		= 0x203;
// keybd_event flags
	KEYEVENTF_EXTENDEDKEY	= 0x1;
	KEYEVENTF_KEYUP			= 0x2;
// mouse_event flags
	MOUSEEVENTF_MOVE			= 0x0001;
	MOUSEEVENTF_LEFTDOWN		= 0x0002;
	MOUSEEVENTF_LEFTUP			= 0x0004;
	MOUSEEVENTF_RIGHTDOWN		= 0x0008;
	MOUSEEVENTF_RIGHTUP			= 0x0010;
	MOUSEEVENTF_MIDDLEDOWN		= 0x0020;
	MOUSEEVENTF_MIDDLEUP		= 0x0040;
	MOUSEEVENTF_WHEEL			= 0x0800;
	MOUSEEVENTF_ABSOLUTE		= 0x8000;
// TrackPopupMenu flags
	TPM_LEFTBUTTON				= 0x0000;
	TPM_RIGHTBUTTON				= 0x0002;
	TPM_LEFTALIGN				= 0x0000;
	TPM_CENTERALIGN				= 0x0004;
	TPM_RIGHTALIGN				= 0x0008;
	TPM_TOPALIGN				= 0x0000;
	TPM_VCENTERALIGN			= 0x0010;
	TPM_BOTTOMALIGN				= 0x0020;
	TPM_HORIZONTAL				= 0x0000;
	TPM_VERTICAL				= 0x0040;
	TPM_NONOTIFY				= 0x0080;
	TPM_RETURNCMD				= 0x0100;
	TPM_RECURSE					= 0x0001;
	TPM_HORPOSANIMATION			= 0x0400;
	TPM_HORNEGANIMATION			= 0x0800;
	TPM_VERPOSANIMATION			= 0x1000;
	TPM_VERNEGANIMATION			= 0x2000;
	TPM_NOANIMATION				= 0x4000;
	TPM_LAYOUTRTL				= 0x8000;
// Menu item info mask values
	MIIM_STATE		= 0x001;
	MIIM_ID			= 0x002;
	MIIM_SUBMENU	= 0x004;
	MIIM_CHECKMARKS	= 0x008;
	MIIM_TYPE		= 0x010;
	MIIM_DATA		= 0x020;
	MIIM_STRING		= 0x040;
	MIIM_BITMAP		= 0x080;
	MIIM_FTYPE		= 0x100;
// DRAWITEMSTRUCT control types
	ODT_MENU			= 1;
	ODT_LISTBOX		= 2;
	ODT_COMBOBOX	= 3;
	ODT_BUTTON		= 4;
	ODT_STATIC		= 5;
// DRAWITEMSTRUCT actions
	ODA_DRAWENTIRE		= 1;
	ODA_SELECT			= 2;
	ODA_FOCUS			= 4;
// DRAWITEMSTRUCT states
	ODS_SELECTED		= 0x0001;
	ODS_GRAYED			= 0x0002;
	ODS_DISABLED		= 0x0004;
	ODS_CHECKED			= 0x0008;
	ODS_FOCUS			= 0x0010;
	ODS_DEFAULT			= 0x0020;
	ODS_COMBOBOXEDIT	= 0x1000;
	ODS_HOTLIGHT		= 0x0040;
	ODS_INACTIVE		= 0x0080;
// WINDOWPLACEMENT flags
	WPF_SETMINPOSITION			= 1;
	WPF_RESTORETOMAXIMIZED		= 2;
// Layered window attributes
	LWA_COLORKEY		= 1;
	LWA_ALPHA			= 2;
// UpdateLayeredWindow flags
	ULW_COLORKEY		= 1;
	ULW_ALPHA			= 2;
	ULW_OPAQUE			= 4;
// SystemParametersInfo parameters
	SPI_GETACCESSTIMEOUT		= 60;
	SPI_GETANIMATION			= 72;
	SPI_GETBEEP					= 1;
	SPI_GETBORDER				= 5;
	SPI_GETDEFAULTINPUTLANG		= 89;
	SPI_GETDRAGFULLWINDOWS		= 38;
	SPI_GETFASTTASKSWITCH		= 35;
	SPI_GETFILTERKEYS			= 50;
	SPI_GETFONTSMOOTHING		= 74;
	SPI_GETGRIDGRANULARITY		= 18;
	SPI_GETHIGHCONTRAST			= 66;
	SPI_GETICONMETRICS			= 45;
	SPI_GETICONTITLELOGFONT		= 31;
	SPI_GETICONTITLEWRAP		= 25;
	SPI_GETKEYBOARDDELAY		= 22;
	SPI_GETKEYBOARDPREF			= 68;
	SPI_GETKEYBOARDSPEED		= 10;
	SPI_GETLOWPOWERACTIVE		= 83;
	SPI_GETLOWPOWERTIMEOUT		= 79;
	SPI_GETMENUDROPALIGNMENT	= 27;
	SPI_GETMINIMIZEDMETRICS		= 43;
	SPI_GETMOUSE				= 3;
	SPI_GETMOUSEKEYS			= 54;
	SPI_GETMOUSETRAILS			= 94;
	SPI_GETNONCLIENTMETRICS		= 41;
	SPI_GETPOWEROFFACTIVE		= 84;
	SPI_GETPOWEROFFTIMEOUT		= 80;
	SPI_GETSCREENREADER			= 70;
	SPI_GETSCREENSAVEACTIVE		= 16;
	SPI_GETSCREENSAVETIMEOUT	= 14;
	SPI_GETSERIALKEYS			= 62;
	SPI_GETSHOWSOUNDS			= 56;
	SPI_GETSOUNDSENTRY			= 64;
	SPI_GETSTICKYKEYS			= 58;
	SPI_GETTOGGLEKEYS			= 52;
	SPI_GETWINDOWSEXTENSION		= 92;
	SPI_GETWORKAREA				= 48;
	SPI_ICONHORIZONTALSPACING	= 13;
	SPI_ICONVERTICALSPACING		= 24;
	SPI_LANGDRIVER				= 12;
	SPI_SCREENSAVERRUNNING		= 97;
	SPI_SETACCESSTIMEOUT		= 61;
	SPI_SETANIMATION			= 73;
	SPI_SETBEEP					= 2;
	SPI_SETBORDER				= 6;
	SPI_SETDEFAULTINPUTLANG		= 90;
	SPI_SETDESKPATTERN			= 21;
	SPI_SETDESKWALLPAPER		= 20;
	SPI_SETDOUBLECLICKTIME		= 32;
	SPI_SETDOUBLECLKHEIGHT		= 30;
	SPI_SETDOUBLECLKWIDTH		= 29;
	SPI_SETDRAGFULLWINDOWS		= 37;
	SPI_SETDRAGHEIGHT			= 77;
	SPI_SETDRAGWIDTH			= 76;
	SPI_SETFASTTASKSWITCH		= 36;
	SPI_SETFILTERKEYS			= 51;
	SPI_SETFONTSMOOTHING		= 75;
	SPI_SETGRIDGRANULARITY		= 19;
	SPI_SETHANDHELD				= 78;
	SPI_SETHIGHCONTRAST			= 67;
	SPI_SETICONMETRICS			= 46;
	SPI_SETICONTITLELOGFONT		= 34;
	SPI_SETICONTITLEWRAP		= 26;
	SPI_SETKEYBOARDDELAY		= 23;
	SPI_SETKEYBOARDPREF			= 69;
	SPI_SETKEYBOARDSPEED		= 11;
	SPI_SETLANGTOGGLE			= 91;
	SPI_SETLOWPOWERACTIVE		= 85;
	SPI_SETLOWPOWERTIMEOUT		= 81;
	SPI_SETMENUDROPALIGNMENT	= 28;
	SPI_SETMINIMIZEDMETRICS		= 44;
	SPI_SETMOUSE				= 4;
	SPI_SETMOUSEBUTTONSWAP		= 33;
	SPI_SETMOUSEKEYS			= 55;
	SPI_SETMOUSETRAILS			= 93;
	SPI_SETNONCLIENTMETRICS		= 42;
	SPI_SETPENWINDOWS			= 49;
	SPI_SETPOWEROFFACTIVE		= 86;
	SPI_SETPOWEROFFTIMEOUT		= 82;
	SPI_SETSCREENREADER			= 71;
	SPI_SETSCREENSAVEACTIVE		= 17;
	SPI_SETSCREENSAVERRUNNING	= 97;
	SPI_SETSCREENSAVETIMEOUT	= 15;
	SPI_SETSERIALKEYS		= 63;
	SPI_SETSHOWSOUNDS		= 57;
	SPI_SETSOUNDSENTRY		= 65;
	SPI_SETSTICKYKEYS		= 59;
	SPI_SETTOGGLEKEYS		= 53;
	SPI_SETWORKAREA			= 47;
// SystemParametersInfo flags
	SPIF_UPDATEINIFILE			= 1;
	SPIF_SENDWININICHANGE		= 2;
