﻿/* [Ru] Скрипт для преобразования пробелов в начале строки в табуляцию.
// Параметры:
//    /w — переопределить число пробелов в 1 табуляции (формат: /w=число)
//    /s — не подтверждать количество пробелов (по умолчанию перед заменой вылезает диалог)
//    /r — обработка лишних пробелов: /r- — удаление, /r+ — замена на табуляцию (по умолчанию скрипт их не трогает)
*/
/* [En] Convert leading spaces to tabulation.
// Arguments: 
//    /w — set tab width (default is AkelPad's settings; format: /w=number)
//    /s — don't show input box before process
//    /r — residual spaces: /r- — remove, /r+ — make tab (default is ignore)
*/
// Version: F.Phoenix, 2012-08-18a (based on VladSh's SpacesToTabs 2.0)
// http://akelpad.sourceforge.net/forum/viewtopic.php?p=19164#19164

var CAPTION_AP = "AkelPad -> " + WScript.ScriptName;
var hWndEdit = AkelPad.GetEditWnd();
if (hWndEdit)
{
	// Getting selected text 
	var bTextSelected = true;
	var pSelText = AkelPad.GetSelText();
	if (!pSelText)
	{
		pSelText = AkelPad.GetTextRange(0, -1);
		bTextSelected = false;
	}
	if (!pSelText) WScript.Quit();
	
	// Settings
	var nOptWidth = 0, bOptSilent = false, nOptResidual = 0;
	for (var i = 0; i < WScript.Arguments.length; i++)
	{
		var arg = WScript.Arguments(i);
		if (arg == "/s") bOptSilent = true;
		else if (arg.search(/^\/w=\d+$/) != -1) nOptWidth = arg.substr(3);
		else if (arg.search(/^\/r[\+\-]$/) != -1) nOptResidual = arg.substr(2) + 1;
	}
	var nTabStop = (nOptWidth > 0 ? nOptWidth : AkelPad.SendMessage(hWndEdit, 3239 /*AEM_GETTABSTOP*/ , 0, 0));
	if (!bOptSilent)
	{
		var bRu = (AkelPad.GetLangId(1 /*LANGID_PRIMARY*/) == 0x19);
		nTabStop = AkelPad.InputBox(hWndEdit, CAPTION_AP, (bRu ? "Введите количество пробелов в одном символе табуляции"
		                                                       : "Enter the number of spaces in one tab character"), nTabStop);
		if (isNaN(nTabStop)) //not isNumber
		{
			if (nTabStop) AkelPad.MessageBox(hWndEdit, (bRu ? "Введено нечисловое значение, операция отменена..."
			                                                : "Non-numeric value entered, the operation is canceled..."),
			                                 CAPTION_AP, 48 /*MB_ICONEXCLAMATION*/ ); //press Cancel 
			WScript.Quit();
		}
	}
	
	// Changing text (common part)
	pSelText = pSelText.replace(/^\s+/mg, Replacer);
	if(!bTextSelected) AkelPad.SetSel(0, -1);
	AkelPad.ReplaceSel(pSelText);
}

function Replacer(str)
{
	var nMin = (nOptResidual == 0 ? nTabStop : 1);
	for (var nSpaceCount = nTabStop; nSpaceCount >= nMin; nSpaceCount--)
	{
		var rxSpaces = new RegExp(' {' + nSpaceCount + '}', "g");
		str = str.replace(rxSpaces, (nSpaceCount == nTabStop || nOptResidual == "+1" ? "\t" : ""));
	}
	return str;
}