// InsertNum.js - 2012-12-20 by cnnnc
// Insert a sequence of number.
//
// Example:
// Call("Scripts::Main", 1, "InsertNum.js")

try
{
  var hMainWnd=AkelPad.GetMainWnd();
}
catch (oError)
{
  WScript.Quit();
}

if (!(AkelPad.Include("InputBox_function.js")))
{
  WScript.Quit();
}

var sCaption =WScript.ScriptName;
var oSys     =AkelPad.SystemFunction();
var nAkelEdit=AkelPad.IsAkelEdit();
var hWndEdit =AkelPad.GetEditWnd();

var nLng=AkelPad.GetLangId(0 /*LANGID_FULL*/);
if (nLng==2052) //Chinese Simplified
{
  var vLabel     =["ʼ","","","","","ָ","ʮ","ǰ׺","׺"];
  var sTxtWarning="棺̫ܻ࣬ڴ治㡣Ƿ";
  var sTxtError="\n";
  var sTxtError1="ֵ͡";
  var sTxtError2="ܵ";
  var sTxtError3="ܵ 0";
  var sTxtSeconds="ʱ %s 롣";
}
else // English
{
  var vLabel     =["Start","End","Step","Width","Pad","Seperator","Hex","Prefix","Subfix"];
  var sTxtWarning="Warning: Times is so big, may be result to out of memory. Continue?";
  var sTxtError="Error!\n";
  var sTxtError1="allow number type only.";
  var sTxtError2="should not same as";
  var sTxtError3="should not be 0";
  var sTxtSeconds="It's take %s Seconds.";
}

var vEdit    =[];
var nFocus   =0;
var sFunction="CheckNum";
var vFuncArg ="";

SetRedraw(hWndEdit, false);

if (WScript.Arguments.length)
{
  new Function(AkelPad.GetArgLine(0))();
  if (vEdit.length!=9)
  {
    vEdit=["1","9","1","1","0","\\n","0","",""];
  }
}
else
{
  var oSet=AkelPad.ScriptSettings();

  if (oSet.Begin(WScript.ScriptBaseName, 0x1 /*POB_READ*/))
  {
    //Read settings
    vEdit.push(oSet.Read("Start"    , 3 /*PO_STRING*/, "1"));
    vEdit.push(oSet.Read("End"      , 3 /*PO_STRING*/, "9"));
    vEdit.push(oSet.Read("Step"     , 3 /*PO_STRING*/, "1"));
    vEdit.push(oSet.Read("Width"    , 3 /*PO_STRING*/, "1"));
    vEdit.push(oSet.Read("Pad"      , 3 /*PO_STRING*/, "0"));
    vEdit.push(oSet.Read("Seperator", 3 /*PO_STRING*/, "\\n"));
    vEdit.push(oSet.Read("Hex"      , 3 /*PO_STRING*/, "0"));
    vEdit.push(oSet.Read("Prefix"   , 3 /*PO_STRING*/, ""));
    vEdit.push(oSet.Read("Subfix"   , 3 /*PO_STRING*/, ""));

    oSet.End();
  }
  else
  {
    vEdit=["1","9","1","1","0","\\n","0","",""];
  }
  vEdit = InputBox(hMainWnd, sCaption, vLabel, vEdit, nFocus, sFunction, vFuncArg);
  if (vEdit == undefined)
  {
    SetRedraw(hWndEdit, true);
    WScript.Quit();
  }
}

var d=new Date();
var t=d.getTime();

var nStart    =Number(vEdit[0]);
var nEnd      =Number(vEdit[1]);
var nStep     =Number(vEdit[2]);

if (nStart==nEnd || nStep==0)
{
  SetRedraw(hWndEdit, true);
  WScript.Quit();
}

var nCurVal=Math.floor(Math.abs(nEnd-nStart)/nStep);
if (nCurVal>9999999)
{
  if(AkelPad.MessageBox(hMainWnd, sTxtWarning, sCaption, 52)!=6)
  {
    SetRedraw(hWndEdit, true);
    WScript.Quit();
  }
}

if (vEdit[4]=="")
{
  vEdit[3]="1";
}
var sStart    =vEdit[0];
var sEnd      =vEdit[1];
var sStep     =vEdit[2];
var nWidth    =parseInt(vEdit[3]);
var sPad      =vEdit[4];
var sSeperator=vEdit[5];
var bHex      =vEdit[6];
var sPrefix   =vEdit[7];
var sSubfix   =vEdit[8];

var m=0;
var sStr="";
var oneStop=0xFFF;


if (nStart!=parseInt(sStart) || nEnd!=parseInt(sEnd) || nStep!=parseInt(sStep))
{
  var r1,r2,r3;
  try{r1=sStart.split(".")[1].length;}catch(e){r1=0;}
  try{r2=sEnd.split(".")[1].length;}catch(e){r2=0;}
  try{r3=sStep.split(".")[1].length;}catch(e){r3=0;}
  m=Math.max(r1,r2,r3);
}

if (m==0 && bHex=="1")
{
  bHex=true;
}
else
{
  bHex=false;
}

if (sSeperator)
{
  sSeperator=TranslateEscapeString(sSeperator);
}
if (sPrefix)
{
  sPrefix=TranslateEscapeString(sPrefix);
}
if (sSubfix)
{
  sSubfix=TranslateEscapeString(sSubfix);
}

if (nStart<nEnd)
{
  for (;;)
  {
    if (nCurVal>oneStop)
    {
      sStr=sStr+SequenceNum(oneStop,0);
      CollectGarbage();
      nStart=nStart+(oneStop+1)*nStep;
      nCurVal=nCurVal-(oneStop+1);
    }
    else
    {
      sStr=sStr+SequenceNum(nCurVal,0);
      CollectGarbage();
      break;
    }
  }
}
else if (nStart>nEnd)
{
  for (;;)
  {
    if (nCurVal>oneStop)
    {
      sStr=sStr+SequenceNum(oneStop,1);
      CollectGarbage();
      nStart=nStart-(oneStop+1)*nStep;
      nCurVal=nCurVal-(oneStop+1);
    }
    else
    {
      sStr=sStr+SequenceNum(nCurVal,1);
      CollectGarbage();
      break;
    }
  }
}
SetRedraw(hWndEdit, true);

AkelPad.ReplaceSel(sStr);

if (!WScript.Arguments.length)
{
  if (oSet.Begin(WScript.ScriptBaseName, 0x2 /*POB_SAVE*/))
  {
    //Save settings
    oSet.Write("Start"    , 3 /*PO_STRING*/, vEdit[0]);
    oSet.Write("End"      , 3 /*PO_STRING*/, vEdit[1]);
    oSet.Write("Step"     , 3 /*PO_STRING*/, vEdit[2]);
    oSet.Write("Width"    , 3 /*PO_STRING*/, vEdit[3]);
    oSet.Write("Pad"      , 3 /*PO_STRING*/, vEdit[4]);
    oSet.Write("Seperator", 3 /*PO_STRING*/, vEdit[5]);
    oSet.Write("Hex"      , 3 /*PO_STRING*/, vEdit[6]);
    oSet.Write("Prefix"   , 3 /*PO_STRING*/, vEdit[7]);
    oSet.Write("Subfix"   , 3 /*PO_STRING*/, vEdit[8]);

    oSet.End();
  }
}

var d=new Date();
t=(d.getTime()-t)/1000;

if (Math.round(t)>1)
{
  AkelPad.MessageBox(hMainWnd, prepareString(sTxtSeconds, [t]), sCaption, 0 /*MB_OK*/);
}

sStr=null;
CollectGarbage();

//function
function Pad(nCurrentNum)
{
  var pNumText;
  var nLen;
  var cPadding="";

  if (bHex)
  {
    pNumText=nCurrentNum.toString(16);
  }
  else
  {
    pNumText=nCurrentNum.toFixed(m);
  }

  if (nCurrentNum<0)
  {
    pNumText="-"+pNumText.substr(1);
  }

  nLen=Math.abs(nWidth)-pNumText.length+1;

  while ((nLen-=1)>0)
  {
    cPadding+=sPad;
  }

  if (nWidth<0)
  {
    pNumText += cPadding;
  }
  else {pNumText=cPadding+pNumText;}

  return pNumText;
}

function CheckNum(hWnd, vEdit, nIndex)
{
  for (i=0; i<4; i+=1)
  {
    if (isNaN(parseInt(vEdit[i])))
    {
      AkelPad.MessageBox(hWnd, sTxtError + "\""+vLabel[i]+"\" "+sTxtError1, sCaption, 0 /*MB_OK*/);
      return i;
    }
  }
  if (vEdit[0]==vEdit[1])
  {
    AkelPad.MessageBox(hWnd, sTxtError + "\""+vLabel[1]+"\" "+sTxtError2 + "\""+vLabel[0]+"\" ", sCaption, 0 /*MB_OK*/);
    return 1;
  }
  if (vEdit[2]==0)
  {
    AkelPad.MessageBox(hWnd, sTxtError + "\""+vLabel[2]+"\" "+sTxtError3, sCaption, 0 /*MB_OK*/);
    return 2;
  }
  return -1;
}

function SequenceNum(nStop,bMax)
{
  var aStr=null;
  aStr=[];

  if (bMax)
  {
    if (!bHex && (nWidth==1 || nWidth==0 || nWidth ==-1))
    {
      for (i=0; i<=nStop; i+=1)
      {
        aStr[i]=(nStart-i*nStep).toFixed(m);
      }
    }
    else
    {
      for (i=0; i<=nStop; i+=1)
      {
        aStr[i]=Pad(nStart-i*nStep);
      }
    }
  }
  else
  {
    if (!bHex && (nWidth==1 || nWidth==0 || nWidth ==-1))
    {
      for (i=0; i<=nStop; i+=1)
      {
        aStr[i]=(nStart+i*nStep).toFixed(m);
      }
    }
    else
    {
      for (i=0; i<=nStop; i+=1)
      {
        aStr[i]=Pad(nStart+i*nStep);
      }
    }
  }

  if (sPrefix=="" && sSubfix=="")
  {
    return aStr.join(sSeperator)+sSeperator;
  }
  else if (sPrefix=="" && sSubfix!="")
  {
    return aStr.join(sSubfix+sSeperator)+sSubfix+sSeperator;
  }
  else if (sPrefix!="" && sSubfix=="")
  {
    return sPrefix+aStr.join(sSeperator+sPrefix)+sSeperator;
  }
  else
  {
    return sPrefix+aStr.join(sSubfix+sSeperator+sPrefix)+sSubfix+sSeperator;
  }
}

function TranslateEscapeString(pString)
{
  pString=pString.replace(/\\\\/g, "\0");
  pString=pString.replace(/\\n|\\r/g,"\n");
  pString=pString.replace(/\\t/g,"\t");
  return pString.replace(/\0/g,"\\");
}

function prepareString(pString, aVar)
{
  pString=pString.replace(/%%/g,"");
  if (pString.indexOf("%s") >= 0)
  {
    pString = pString.split("%s");
    for (i=0, l=pString.length-1; i<l; i+=1)
    {
      pString[i] = pString[i]+aVar[i].toString();
    }
    pString=pString.join("");
  }
  pString=pString.replace(//g,"%%");
  return pString;
}

function SetRedraw(hWnd, bRedraw)
{
  if (nAkelEdit)
  {
    AkelPad.SendMessage(hWnd, 3185 /*AEM_LOCKSCROLL*/, 3 /*SB_BOTH*/, !bRedraw);
  }

  AkelPad.SendMessage(hWnd, 11 /*WM_SETREDRAW*/, bRedraw, 0);
  if (bRedraw)
  {
    oSys.Call("user32::InvalidateRect", hWnd, 0, true);
  }
}