// http://akelpad.sourceforge.net/forum/viewtopic.php?p=4890#4890
// Description(1033): Insert line numbers to selected lines
// Description(1049):   
// Version: 1.2 (2016.09.18)
// Author: VladSh
// 
// Arguments:
// 	fe     - ([0]/1)  -     
// 	p      - ([0]/1) -   :    
// 	syze   -   ( )    ;    0 -   
// 	sep    -    :
// 	           -  : ". ";
// 	           - <{dialog}> -     AkelPad.InputBox()
// 	keep   - (0/[1])  -        
// 
// Usage:
// 	" " Call("Scripts::Main", 1, "LineNumbersInsert.js")
// 	"  " Call("Scripts::Main", 1, "LineNumbersInsert.js", `-sep="<{dialog}>"`)
// 	"   " Call("Scripts::Main", 1, "LineNumbersInsert.js", `-p=1`)

if (! AkelPad.Include("selCompleteLine.js")) WScript.Quit();
oCh.runWithRedraw();

function process() {
	var sSep = AkelPad.GetArgValue("sep", ". ");
	if (sSep == "<{dialog}>")
		sSep = AkelPad.InputBox(AkelPad.GetMainWnd(), WScript.ScriptName, "Insert your separator:", "");
	var bFillEmptyString = AkelPad.GetArgValue("fe", 0);
	var nPlace = AkelPad.GetArgValue("p", 0);
	var nNumSyze = AkelPad.GetArgValue("syze", 0);
	var bKeepSelection = AkelPad.GetArgValue("keep", 1);
	
	oCh.setCompleteLineText();
	
	if (oCh.Text.length) {
		
		var arrRow = oCh.Text.split(pBreak);
		
		var r = 0, n = 0;
		if (nPlace == 0) {
			if (!bFillEmptyString) {
				for (; r < arrRow.length; r++)
					if (oStr.trim(arrRow[r], " \t")) {
						arrRow[r] = pad((n+1), nNumSyze) + sSep + arrRow[r];
						n++;
					}
			}
			else {
				for (; r < arrRow.length; r++)
					arrRow[r] = pad((r+1), nNumSyze) + sSep + arrRow[r];
			}
		}
		else {
			if (!bFillEmptyString) {
				for (; r < arrRow.length; r++)
					if (oStr.trim(arrRow[r], " \t")) {
						arrRow[r] = arrRow[r] + sSep + pad((n+1), nNumSyze);
						n++;
					}
			}
			else {
				for (; r < arrRow.length; r++)
					arrRow[r] = arrRow[r] + sSep + pad((r+1), nNumSyze);
			}
		}
		
		oCh.Text = arrRow.join(pBreak);
		
		if (bKeepSelection)
			oCh.setSelCaret(oCh.rResult[0], oCh.rResult[0] + oCh.Text.length);
		else
			oCh.setSelCaret(oCh.rResult[0] + oCh.Text.length);
	}
}

function pad(num, len) {
	num = String(num);
	if (num.length >= len)
		return num;
	else {
		return (Array(len - num.length + 1).join('0') + num);
	}
}