﻿//   Сортировка текста по столбцам. Версия 2011-10-20
//   Sort text by columns. Version 2011-10-20

//   http://akelpad.sourceforge.net/forum/viewtopic.php?p=8738#8738
//   ftp://akelscripts:akelscripts@95.172.154.20/NeO.Sort.js


//   2011-10-20
//   * Незначительные изменения.

//   2011-09-21
//   * Теперь правильно реагирует на пустой ввод и на отмену.

//   2010-12-07
//   * Теперь правильно сортирует по произвольному разделителю.



//   Add in format
//      X1[-X2[-X3[...[=s]]]]
//      where
//         Xn   - numbers of cols according to future grading divided by "-" (Minus without quotation marks).
//         s   - any set of symbols that divides cols. Added as last point in entry line separated from cols list by "=" (Equals without quotation marks). Everything placed after "equals" mark is considered to be separator of cols. If this parameter is missed, Tab mark will be used as separator by default.
//   Examples:
//      1. Sorting according second col
//         Type in: 2
//      2. Sorting according third col. If titles coincide, then sort according the first col
//         Type in: 1-3
//      3. Sorting according fourth col. Mark ":" is used as separator
//         Type in: 4=:
//      4. Sorting according fifth col. If titles coincide, than sort according sixth col. If this col also has coincidences, than sort according seventh col. Mark "=" is used as separator.
//         Type in: 7-6-5==



//------------------------------------------------------------------------------
   function AutoRedrawOff(hEditWnd)
   {
     AkelPad.SendMessage(hEditWnd, 11 /*WM_SETREDRAW*/, false, 0);
   }



   function AutoRedrawOn(hEditWnd)
   {
      AkelPad.SendMessage(hEditWnd, 11 /*WM_SETREDRAW*/, true, 0);
      AkelPad.SystemFunction().Call("user32::InvalidateRect", hEditWnd, 0, true);
   }



   function arrSort(tableToSort, colToSort)
   {
      var aTemp = new Array;
      colToSort--;
      for (jjj = 0;   jjj < aRowsLength;   jjj++);
      {
         for (iii = 0;   iii < aRowsLength-1;   iii++)
         {
            if (tableToSort[iii][colToSort] > tableToSort[iii+1][colToSort] || tableToSort[iii+1][colToSort] === undefined)
            {
               aTemp = tableToSort[iii];
               tableToSort[iii] = tableToSort[iii+1];
               tableToSort[iii+1] = aTemp;
            }
         }
      }
      return tableToSort;
   }
//------------------------------------------------------------------------------



   hEditWnd = AkelPad.GetEditWnd()
   hMainWnd = AkelPad.GetMainWnd()
   var aTable = new Array
   var aSortOrder = new Array

   if (AkelPad.SystemFunction().Call("kernel32::GetUserDefaultLangID") == 0x0419)
   {
      var InputBoxTitle = 'Сортировка по столбцам';
      var InputBoxHint  = 'Сначала по 2-му столбцу,  затем по 1-му;   разделитель - ";"';
   }
   else
   {
      var InputBoxTitle = 'Sort by columns';
      var InputBoxHint  = 'First sort by the 2nd column,  then by the 1st;   ";" is delimiter';
   }

   var sInput = AkelPad.InputBox(hMainWnd, InputBoxTitle, InputBoxHint, '2-1=;')
   if (sInput != undefined)
   {
      var iEqPos = sInput.indexOf('=', 0);

      if (iEqPos == -1)
      {
         aSortOrder = sInput.split('-');
         var sSeparator = '\t';
      }
      else
      {
         aSortOrder = sInput.substring(0, iEqPos).split('-');
         var sSeparator = sInput.substring(iEqPos+1, sInput.length);
      }

      AutoRedrawOff(hEditWnd);

      var nSelStart=AkelPad.GetSelStart();
      var nSelEnd=AkelPad.GetSelEnd();
      if (nSelStart == nSelEnd)
         AkelPad.SetSel(0, -1);
      else
      {
         var allText=AkelPad.GetTextRange(0, -1);
         var lineStart=allText.lastIndexOf('\r', nSelStart);
         var lineEnd=allText.indexOf('\r', nSelEnd);
         AkelPad.SetSel(lineStart+1, lineEnd);
      }

      var aRows = AkelPad.GetSelText().split('\r');

      var aRowsLength = aRows.length;
      for (iii = 0;   iii < aRowsLength;   iii++)
         aTable[iii] = aRows[iii].split(sSeparator);

      for (ccc = 0;   ccc < aSortOrder.length;   ccc++)
      {
         aTable = arrSort(aTable, aSortOrder[ccc]);
      }

      for (iii = 0;   iii < aRowsLength;   iii++)
         aRows[iii] = aTable[iii].join(sSeparator);

      var tText = aRows.join('\r');

      AkelPad.ReplaceSel(tText);

      AutoRedrawOn(hEditWnd);
   }
