﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=5598#5598
// Description(1033): Open by Linked, Selected or Clipboard text: file (supported the opening of scripts from AkalPad directory), folder; url, ets...
// Description(1049): Предназначен для открытия автовыбором:
// 	• ссылок в браузере (из контекстного меню ссылок)
// 	• файлов (чаще всего скриптов) в AkelPad'е (работает при выделении текста либо по содержимому буфера; поддерживается открытие скриптов из ..\Scripts\Include\
// 	• папок (в Windoes Explorer'е), в т.ч. сетевых
// Version: 2.3 (2014.10.19)
// Author: VladSh
// 
// Usage:
// 	в меню ссылок: -"Открыть (автовыбор)" Call("Scripts::Main", 1, "OpenByLSC.js", `"%u"`)
// 	в диалоге скриптов для выделенного текста или того, что в буфере обмена, предлагается комбинация клавиш Alt+O

var slash = "\\";

//1. - проверяем в аргументах (L- Link); 2 - берём выделенный текст (S- Selected); 3 - берём содержимое буфера обмена (C - Clipboard)
var tObject = AkelPad.GetArgLine() || AkelPad.GetSelText() || AkelPad.GetClipboardText();

if (!tObject) WScript.Quit();
var WshShell = new ActiveXObject("WScript.Shell");

//Определяем: URL, Файл или Папка

if (tObject.indexOf("//") != -1) {
	WshShell.Exec('explorer.exe "' + tObject + '"');		//URL
	WScript.Quit();
}

var nPos = tObject.indexOf("AkelFiles");
if (nPos != -1 && nPos <= 4)
	tObject = AkelPad.GetAkelDir() + correctSlashes(tObject);		//кусок (не полный путь) сущности из дирректории AkelPad'а

nPos = tObject.lastIndexOf(".");
if (nPos != -1) {
	var nPosSlash = tObject.lastIndexOf(slash);
	if (nPosSlash < nPos) {
		//Файл
		if (nPosSlash <= 1)		//имя скрипта из окна редактирования (и дирректории) AkelPad'а (со слэшами впереди)
			tObject = tObject.replace(/\\/gm, "");
		
		if (tObject.indexOf(slash) == -1)
			tObject = AkelPad.GetAkelDir(6) /*ADTYPE_INCLUDE*/ + slash + tObject;		//имя скрипта, например просто скопированное в буфер обмена (из ContextMenu-плагина или др.)
		
		if (!openFile(tObject, false)) {
			tObject = tObject.substr(tObject.lastIndexOf(slash) + 1);		//выкусываем чисто имя скрипта
			tObject = AkelPad.GetAkelDir(5) /*ADTYPE_SCRIPTS*/ + slash + tObject;		//сначала искали в папке ..\Scripts\Include\, а теперь смотрим в ..\Scripts\
			openFile(tObject, true);
		}
		WScript.Quit();
	}
}

//Папка
openbyDefault(tObject);


function openbyDefault(tObject) {
	WshShell.Exec('rundll32.exe shell32, ShellExec_RunDLL "' + tObject + '"');
}

function openFile(tObject, bErrMsg) {
	tObject = correctSlashes(tObject);
	
	var fso = new ActiveXObject("Scripting.FileSystemObject");
	if (fso.FileExists(tObject) == true) {
		AkelPad.OpenFile(tObject);
		return true;
	}
	else {
		if (bErrMsg) openbyDefault(tObject);
		return false;
	}
}

function correctSlashes(pPath) {
	return pPath.replace(/\\\\/g, slash);
}