﻿' OpenFileNameFromBuffer.vbs
'========================   Описание   =====================================
' Открыть файл, имя/путь которого, находится в выделении или в буфере обмена
' - можно скопировать/выделить кнопку/пункт меню AkelPad, Total Commander ...
' - можно скопировать/выделить пути с абсолютными именами
' - можно скопировать/выделить строку со всяким "лишним мусором" в котором есть имя/путь для открытия
' (если ни в выделении, ни в буфере ничего нет ничего подходящего - поиск имени производится во всей строке...)
'====================  Как работает скрипт  ================================
' из выделенной/отправленной в буфер строки извлекается имя/путь скрипта/файла
' и далее имя проверяется в указанных папках и открывается в AkelPad
' (если такого нет в папках - выдаётся сообщение
'=======================  Дополнение =======================================
' Вы можете удалить/внести свои условия/адреса поиска в скрипте
' используется Functions.vbs, который следует положить ...AkelFiles\Plugs\Scripts\Include\
'=========================    Пример    ====================================
' -"Открыть выделенное имя/путь файла или из буфера" Call("Scripts::Main", 1, "OpenFileNameFromBuffer.vbs")

' используется Functions.vbs, который следует положить в ...AkelFiles\Plugs\Scripts\Include\

' Автор:           Аверин Андрей
' Версия:          1.8 (10.10.2010 - 19.08.2012)
' Mail:            Averin-And@yandex.ru
' Site:            http://tc-image.3dn.ru/forum/9-391-1166-16-1333732766
' Site:            http://akelpad.sourceforge.net/forum/viewtopic.php?p=11255#11255
'===========================================================================
Count = 1 : Call TestingPath

Sub TestingPath
  With AkelPad Text = .GetSelText()
    If Count = 0 Then : Text = ClearNameOrPath(GetLine) : Count = 2 : End If
    If Len(Text) = 0 And Count = 1 Then : Text = .GetClipboardText() : Count = 0 : End If
    If Len(Text) = 0 Then MsBoxErr
    nSelStart = .GetSelStart()
    If InStr(Text, vbNewLine) > 0 Then : sText = Split(Text, vbNewLine) : pText = sText(0) : Else : pText = Text : End If
    Call .Include("Functions.vbs")
  End With
  If CreateObject("Scripting.FileSystemObject").FileExists(pText) Then OpenFF(pText)
  If pText = "TOTALCMD#BAR#DATA" Then pText = sText(1) ' если выделена в буфер кнопка Total Commander
  pText = ClearNameOrPath(pText)
  If Len(pText) = 0 Then Call MsBoxErr
  If InStr(UCase(pText), "AU3") = 0 Then pText = ClearEndLine(pText, "0123456789")
  pText = ReplaceSymPath(pText)

  If Instr(pText, "\") > 0 And Instr(pText, ".") > 0 Then
    If Left(pText, 1) = "%" Then pText = GetPath(pText) ' если путь содержит переменные окружения
    If CreateObject("Scripting.FileSystemObject").FileExists(pText) Then
      OpenFF(pText)
    Else
      If Instr(pText, ".") = InstrRev(pText, ".") Then OpenFF(RunPath(pText)) : Call MsBoxErr
    End If
  Else
    If Instr(pText, ".") = InstrRev(pText, ".") Then OpenFF(RunPath(pText)) : Call MsBoxErr
  End If
End Sub

Sub OpenFF(Name) : Call AkelPad.OpenFile(Name) : Wscript.Quit : End Sub

' функция проверки нахождения имени файла в указанных папках
' удалите ненужные и вставьте свои папки
Function RunPath(FName)
  With AkelPad
    P0 = .GetAkelDir(0) & "\" : P1 = .GetAkelDir(1) & "\" : P2 = .GetAkelDir(2) & "\"
    P4 = .GetAkelDir(4) & "\" : P5 = .GetAkelDir(5) & "\" : P6 = .GetAkelDir(6) & "\"
  End With
  TC =  GetPath("%COMMANDER_PATH%") & "\" : TCF = TC & "Files\" : TU =  TC & "Utilities\"
  TCFL = TCF & "Lists\" : TCC = TC & "Scripts\" : TCB = TC & "Bar\"
  PT = P4 & "Templates\" : TM = TC & "0\" : TS = TM & "Script_Site\"
  WD = GetPath("%WINDIR%") & "\"
  APath = Array(P0, P0 & "Help", P1 & "List", P2, P4, P4 & "AkelMenu", P4 & "AutoComplete",_
          P4 & "AkelMenu", P4 & "Coder", P4 & "Sessions", P4 & "SpellCheck", P4 & "Templates",_
          PT & "AkelPad", PT & "Asp", PT & "Asp.net", PT & "Assemblers", PT & "Batch",_
          PT & "C-Language", PT & "Css", PT & "Html", PT & "Pascal", PT & "Xml", P5,_
          P5 & "Include", P5 & "Include\win32", P5 & "Params", P5 & "Params\ShowMenuEx",_
          P5 & "Params\ShowMenuAlt", P5 & "ShowMenu", P5 & "win32lib", P6, TC, TC & "Language",_
          TC & "Keys", TCB, TCB & "Bars", TCB & "Bars_Plus", TCB & "Filter", TCF & "ExtProgram", _
          TCB & "Font", TCB & "Rename", TCB & "Search", TCB & "Select", TCB & "Start_Menu", _
          TCF, TCF & "Bat", TCF & "Comands", TCF & "Ncl", TCF & "Tab", TCF & "HTML",_
          TCF & "Help\TCInfo",  TCFL & "Collection", TCFL & "CreateMenu", TCFL & "Lst", _
          TCFL & "MarkerList", TCFL & "MusicList", TCFL & "PathList", TCFL & "Play", _
          TCFL & "ProgramList", TCFL & "ReportList", TCFL & "StatisticFile", _
          TCC & "AddIcons", TCC & "Attributes", TCC & "Buffer", TCC & "Copy", TCC & "CreateBar", _
          TCC & "CreateLists", TCC & "CreateRegistration", TCC & "FileEditing", TCC & "Filters", _
          TCC & "Folders", TCC & "ImageWSH", TCC & "Include", TCC & "Keyboard", TCC & "Link", _
          TCC & "Marker", TCC & "Miscellanea", TCC & "Move", TCC & "Panel", TCC & "Plus", _
          TCC & "ReNames", TCC & "Run", TCC & "Searches", TCC & "SysScript", TCC & "NetWork", _
          TCC & "TextWork", TCC & "Un-Packing", WD, WD & "system32", "c:\MyFiles",_
          TS & "N_V", TS & "S", TS & "V", TU & "Inet\WGet", P1 & "Regs")
  p = 0
  For ii = 0 To Ubound(APath)
    PF = Trim(APath(ii) & "\" & FName)
    If CreateObject("Scripting.FileSystemObject").FileExists(PF) Then : RunPath = PF : p = 1 : Exit For : End If
  Next
  If p = 0 Then MsBoxErr
End Function

Sub MsBoxErr
  If Count = 1 Then
    Call AkelPad.SetSel(nSelStart, nSelStart) : Call TestingPath
  Else
    If Count = 0 Then
      Call TestingPath
    Else
      MsgBox "Ни в выделении ни в буфере обмена" & vbNewLine &_
      "Нет корректного ИМЕНИ / ПУТИ файла для открытия" & vbNewLine &_
      "или такого файла нет в папках, указанных в скрипте" & vbNewLine &_
      "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -" & vbNewLine &_
      "Выделите или скопируйте чего-нибудь подходящее" & vbNewLine &_
      "И повторите попытку " , vbApplicationModal & vbExclamation,_
      "Открытие файла, путь/имя которого скопирован или выделен" : Wscript.Quit
    End If
  End If
End Sub