// http://akelpad.sourceforge.net/forum/viewtopic.php?p=9209#9209
// Version: 1.8
// Author: Shengalts Aleksander aka Instructor
//
//
// Description(1033): Shift marker position at specified offset.
// Description(1049):      .
//
// Arguments:
//  First argument      -Current marker position:
//                        +10  increase.
//                        -10  decrease.
//                         80  set to.
//                          0  turn off.
// -Local=true          -Change marker position size locally. Not saved by program (default is false).
// -ShowInput=true      -Show input dialog. Default is false, but true if first argument not specified.
//
// Usage:
// "Set marker manually" Call("Scripts::Main", 1, "ShiftMarker.js")
// "Increase marker" Call("Scripts::Main", 1, "ShiftMarker.js", `+10`)
// "Set marker to 80 locally" Call("Scripts::Main", 1, "ShiftMarker.js", `80 -Local=true`)

//Arguments
var pMarkerShift="";
var bLocal=AkelPad.GetArgValue("Local", false);
var bShowInput=AkelPad.GetArgValue("ShowInput", false);
if (WScript.Arguments.length >= 1)
  pMarkerShift=WScript.Arguments(0);

//Variables
var hMainWnd=AkelPad.GetMainWnd();
var hWndEdit=AkelPad.GetEditWnd();
var pSign;
var nMarkerShift;
var nMarkerPos;

if (bLocal)
  nMarkerPos=AkelPad.SendMessage(hWndEdit, 3257 /*AEM_GETMARKER*/, 0, 0);
else
  nMarkerPos=AkelPad.SendMessage(hMainWnd, 1223 /*AKD_GETFRAMEINFO*/, 64 /*FI_MARKER*/, 0);

nMarkerShift=parseInt(pMarkerShift);
if (isNaN(nMarkerShift))
{
  pMarkerShift="";
  bShowInput=true;
}
if (bShowInput)
{
  if (!pMarkerShift)
    pMarkerShift="" + nMarkerPos;
  pMarkerShift=AkelPad.InputBox(hMainWnd, WScript.ScriptName, GetLangString(0), pMarkerShift);
  nMarkerShift=parseInt(pMarkerShift);
  if (isNaN(nMarkerShift)) pMarkerShift="";
}

if (hWndEdit && pMarkerShift)
{
  pSign=pMarkerShift.substr(0, 1);

  if (pSign == '+' || pSign == '-')
  {
    nMarkerPos=nMarkerPos + nMarkerShift;
    nMarkerPos=Math.max(nMarkerPos, 0);
  }
  else nMarkerPos=nMarkerShift;

  if (bLocal)
    AkelPad.SendMessage(hWndEdit, 3258 /*AEM_SETMARKER*/, 1 /*AEMT_SYMBOL*/, nMarkerPos);
  else
    AkelPad.SetFrameInfo(0, 12 /*FIS_MARKER*/, nMarkerPos);
}

function GetLangString(nStringID)
{
  var nLangID=AkelPad.GetLangId(1 /*LANGID_PRIMARY*/);

  if (nLangID == 0x19) //LANG_RUSSIAN
  {
    if (nStringID == 0)
      return "\u041F\u043E\u0437\u0438\u0446\u0438\u044F\u0020\u043C\u0430\u0440\u043A\u0435\u0440\u0430:";
  }
  else
  {
    if (nStringID == 0)
      return "Marker position:";
  }
  return "";
}
