﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=15158#15158
// Description(1033): Add the current word to the white list
// Description(1049): Добавление текущего слова в белый список проверки орфографии
// Version: 1.4 (2015.01.17)
// Author: VladSh
// 
// Arguments:
// 	ext     - adding the word to <ext>.spck-file
// 	newline - simbol of new line:
// 		"Mac"   = '\r'
// 		["Linux"] or without argument = '\n'
// 		"Win" or other = '\r\n'
// 	enc     - codepage of *.spck-file; examples (down - from the smallest to the largest file weight):
// 		20866   - KOI8 (R);
// 		21866   - KOI8-U;
// 		1251    - ANSI;
// 		[65001] or without argument - UTF8 (without BOM);
// 		1200    - UTF-16LE.
// 
// Usage:
// 	-"В белый список (txt)" Call("Scripts::Main", 1, "SpellCheckAddToWhiteList.js", `-ext="txt" -enc=1251`) - ANSI с '\n'
// 	-"В белый список (txt)" Call("Scripts::Main", 1, "SpellCheckAddToWhiteList.js", `-ext="txt" -newline="Win"`) - UTF8 с '\r\n'

if (! AkelPad.Include("CaretSelect.js")) WScript.Quit();

var sWord = getWordCaret();
if (!sWord) WScript.Quit();

var fso = new ActiveXObject("Scripting.FileSystemObject");

var pFileExt = AkelPad.GetArgValue("ext", "") || fso.GetExtensionName(AkelPad.GetEditFile(0)) || "txt";

var sFileNameFull = AkelPad.GetAkelDir(4) + "\\SpellCheck\\" + pFileExt + ".spck";

var newline = AkelPad.GetArgValue("newline", "Linux");
if (newline == "Linux")
	newline = '\n';
else {
	if (newline == "Mac")
		newline = '\r';
	else
		newline = '\r\n';
}
var enc = AkelPad.GetArgValue("enc", 65001);		//UTF-8 by default

var sAddedText = "|" + sWord;

if (AkelPad.WriteFile(sFileNameFull, sAddedText + newline, -1, enc, false, 0x1|0x2 /*WFF_WRITEREADONLY|WFF_APPENDFILE*/) == 0) {
	
	AkelPad.Call("SpellCheck::Background", 1, newline + "+" + pFileExt + newline + sAddedText + newline);
	
	// обход бага http://akelpad.sourceforge.net/forum/viewtopic.php?p=25397#25397
	AkelPad.Call("Scripts::Main", 1, "SpellCheckUnderlightSwitcher.js");
	AkelPad.Call("Scripts::Main", 1, "SpellCheckUnderlightSwitcher.js");
}