﻿' SwitchSplittedWindow.vbs
'========================   Описание   =====================================
' Переключение между позициями окна в заданной очерёдностью
'========================  Параметры =====================================
'В параметрах вызова скрипта должен быть прописан один параметр:
' 1 - Переключение горизонтальное --> вертикальное --> четыре части
' 2 - Переключение вертикальное --> горизонтальное --> четыре части
' 3 - Переключение горизонтальное --> четыре части -> вертикальное
' 4 - Переключение вертикальное --> четыре части --> горизонтальное
' 5 - Переключение четыре части --> вертикальное --> горизонтальное
' 6 - Переключение четыре части -- > горизонтальное --> вертикальное
'
' Call("Scripts::Main", 1, "SwitchSplittedWindow.vbs", `"2"`)
'
' Автор:           Аверин Андрей & VladSh
' Версия:          1.4 (2011.01.06 - 18.11.2011)
' Mail:            Averin-And@yandex.ru
' Site:            http://tc-image.3dn.ru/forum/9-412-1196-16-1333816090
' Site:            http://akelpad.sourceforge.net/forum/viewtopic.php?p=11012#11012
'========================================================================
Set WSH = CreateObject("WScript.Shell")

If WScript.Arguments.Count < 1 Then
   Param = 1 'если порядок не задан в аргументах, то по умолчанию работает 1-й вариант: гор -> верт -> 4 части
Else
   Param = CInt(WScript.Arguments(0))
End If

Select Case Param
   Case 1 Call Switch(4214, 4213, 4212)
   Case 2 Call Switch(4213, 4214, 4212)
   Case 3 Call Switch(4214, 4212, 4213)
   Case 4 Call Switch(4213, 4212, 4214)
   Case 5 Call Switch(4212, 4213, 4214)
   Case 6 Call Switch(4212, 4214, 4213)
End Select

Sub Switch(n, m, k)
   Tree = "HKCU\Software\Akelsoft\AkelPad\Plugs\Scripts\SwitchSplittedWindow\"
   Name = GetHandleCurrent()
   If Name = 0 Then
      Call SplitWindow(n) : Call RegWrite(Tree, n)
   Else
      On Error Resume Next
      l = CInt(WSH.RegRead(Tree & Name))
      Select Case l
        Case 0 l = n
        Case n l = m
        Case m l = k
        Case k Call SplitWindow(k) : Call WSH.RegDelete(Tree & Name) : Call WsEnd
      End Select
      Call SplitWindow(l) : Call RegWrite(Tree, l) : Call WsEnd
   End If
End Sub

Function GetHandleCurrent() : GetHandleCurrent = AkelPad.SendMessage(AkelPad.GetEditWnd(), 3447, 0, 0) : End Function
Sub SplitWindow(n) : Call AkelPad.SendMessage(AkelPad.GetMainWnd(), 273, n, 0) : End Sub
Sub RegWrite(Tree, n) : Call WSH.RegWrite(Tree & GetHandleCurrent(), Cstr(n)) : End Sub
Sub WsEnd : Set WSH = Nothing : WScript.Quit : End Sub