﻿// version 0.1.0 - 2011-02-06
//
// Usage:
// Call("Scripts::Main", 1, "VersionInfo.js")
//

var WM_COMMAND=273;
var WM_USER=1024;

var ADTYPE_ROOT = 0;   //   корневая папка AkelPad'а.
var ADTYPE_PLUGS = 4;   //   "[AkelPad]\AkelFiles\Plugs".
var IDM_FILE_NEW=4101;   // команда на создание нового файла
var AEM_EMPTYUNDOBUFFER = WM_USER + 2055;   //Erase undo and redo history
var AEM_SETMODIFY = WM_USER + 2063;   //Set the state of an edit control's modification flag.

var sh1 = "--------------------------------";
var sh2 = "  File                   Version";
var sh3 = "  Plugin                 Version";
var sh4 = "\r\n";

var pAkelDir=AkelPad.GetAkelDir(ADTYPE_ROOT);
var pAkelPlugsDir=AkelPad.GetAkelDir(ADTYPE_PLUGS);

var hMainWnd=AkelPad.GetMainWnd();
AkelPad.SendMessage(hMainWnd, WM_COMMAND, IDM_FILE_NEW, 0);

//   Вывод информации в созданную вкладку
AkelPad.ReplaceSel(sh1 + sh4 + sh2 + sh4 + sh1 + sh4);
AkelPad.ReplaceSel(ShowFolderFileVersionList(pAkelDir, "Exe"));
AkelPad.ReplaceSel(sh1 + sh4 + sh3 + sh4 + sh1 + sh4);
AkelPad.ReplaceSel(ShowFolderFileVersionList(pAkelPlugsDir, "Dll"));
//   Установиться на начало текста и дать возможность беспрепятственно закрыть вкладку
AkelPad.SetSel(0, 0);
AkelPad.SendMessage(AkelPad.GetEditWnd(), AEM_SETMODIFY, 0, 0);
AkelPad.SendMessage(AkelPad.GetEditWnd(), AEM_EMPTYUNDOBUFFER, 0, 0);

//
//   Список версий файлов с заданным расширением в указанной директории
//
function ShowFolderFileVersionList(folderspec, extension){
   var fso, f, f1, fc, s, si;
   fso = new ActiveXObject("Scripting.FileSystemObject");
   f = fso.GetFolder(folderspec);
   fc = new Enumerator(f.files);
   s = "";
   si = "";
   for (; !fc.atEnd(); fc.moveNext()){
      si = fc.item().Name;
      if (StringTailUpper(si, 3)==extension.toUpperCase()){
         s += StringFixLength(si, 25) + ShowFileVersion(fc.item()) + "\r\n";
      }
   }
   return(s);
}
//
//   Получить информацию о версии файла
//
function ShowFileVersion(filespec){
   var fso, s = "";
   fso = new ActiveXObject("Scripting.FileSystemObject");
   s += fso.GetFileVersion(filespec);
   return(s);
}
//
//   Получить "хвост" строки заданной длины в верхнем рагистре
//
function StringTailUpper(strvar, numvar){
   s = strvar.substr(strvar.length - numvar, strvar.length)
   return(s.toUpperCase());
}
//
//   Дополнить строку пробелами до заданной длины
//
function StringFixLength(strvar, numvar){
   while (strvar.length < numvar){
      strvar += ' ';
   }
   return(strvar);
}