// (c) Infocatcher 2008
// version 0.1.1
// last edit: 2008.04.23 16:39

var commentsSet = {
	"js": ["/*", "*/", "//"],
	"cpp": ["/*", "*/", "//"],
	"c": ["/*", "*/", "//"],
	"pas": ["{", "}", null],
	"html": ["<!--", "-->", null],
	"htm": ["<!--", "-->", null],
	"css": ["/*", "*/", null]
};

var AkelPad = new ActiveXObject("AkelPad.document");
var hMainWnd = AkelPad.GetMainWnd();
var hEditWnd = AkelPad.GetEditWnd();
var pScriptName = WScript.ScriptName;

/** temp **/
function alert(msg) {
	AkelPad.MessageBox(hMainWnd, msg, pScriptName, 48 /*MB_ICONEXCLAMATION*/);
}
/** temp **/

AkelPad.SendMessage(hEditWnd, 11 /*WM_SETREDRAW*/, false, 0); // disable auto redraw

var Comments = function(cmmStart, cmmEnd, cmmLine) {
	this.cmmStart = cmmStart,
	this.cmmEnd = cmmEnd,
	this.cmmLine = cmmLine || false,
	this.selStart = AkelPad.GetSelStart(),
	this.selEnd = AkelPad.GetSelEnd(),
	this.selText = AkelPad.GetSelText();

	var endEOL = this.selText.match(/([\n\r]+)$/);
	endEOL = endEOL ? endEOL[0].length : 0;

	if(endEOL) {
		this.selEnd -= endEOL;
		this.selText = this.selText.replace(/[\n\r]+$/, "");
	}
	this.isMiltiline = /\n|\r/.test(this.selText);
	this.noSel = this.selStart == this.selEnd;
	AkelPad.SetSel(0, -1); // scroll :-/
	this.allText = AkelPad.GetSelText();

	var br = this.allText.match(/\n\r|\r\n|\n|\r/);
	this.br = br ? br[0] : "\n\r";
};
Comments.prototype = {
	run: function() {
		if(!this.noSel && !this.isMiltiline)
			AkelPad.ReplaceSel(
				this.allText.substring(0, this.selStart) +
				this.cmmStart + this.selText + this.cmmEnd +
				this.allText.substring(this.selEnd, this.allText.length)
			);
		else {
			if(this.delDoubleComments())
				return;
			if(!this.isMiltiline && this.cmmLine && this.delLineComments())
				return;
			this.parseLines();
		}
		AkelPad.SetSel(this.selStart, this.selStart);
	},
	delDoubleComments: function() {
		var txt = this.allText;
		var left = txt.substring(0, this.selStart);
		var indStartL = left.lastIndexOf(this.cmmStart);
		var indEndL = left.lastIndexOf(this.cmmEnd);
		if(indStartL == -1 || indStartL < indEndL)
			return false;

		var right = txt.substring(this.selEnd, txt.length);
		var indStartR = right.indexOf(this.cmmStart);
		var indEndR = right.indexOf(this.cmmEnd);

		if(indEndR == -1 || (indStartR != -1 && indEndR > indStartR))
			return false;

		AkelPad.ReplaceSel(
			left.substring(0, indStartL) +
			txt.substring(indStartL + this.cmmStart.length, this.selEnd + indEndR)
				.replace(/^(\n\r|\r\n|\n|\r)/, "")
				.replace(/(\n\r|\r\n|\n|\r)$/, "") +
			right.substring(indEndR + this.cmmEnd.length, right.length)
		);
		AkelPad.SetSel(this.selStart, this.selStart);
		return true;
	},
	delLineComments: function() {
		var txt = this.allText;
		var left = txt.substring(0, this.selStart);
		var indL = left.lastIndexOf(this.br) + this.br.length;

		var right = txt.substring(this.selEnd, txt.length);
		var indR = right.indexOf(this.br);
		if(indR == -1)
			indR = right.length;

		var line = txt.substring(indL, this.selEnd + indR);
		var indCmm = line.indexOf(this.cmmLine);
		if(indCmm > -1) {
			line = line.substring(0, indCmm) +
				line.substring(indCmm + this.cmmLine.length, line.length)
					.replace(/^(\s*) /, "$1");
 			AkelPad.ReplaceSel(
 				txt.substring(0, indL) +
 				line +
 				txt.substring(this.selEnd + indR, txt.length)
 			);
 			AkelPad.SetSel(this.selStart, this.selStart);
			return true;
		}
		return false;
	},
	parseLines: function() {
		var txt = this.allText;
		var left = txt.substring(0, this.selStart);
		var indL = left.lastIndexOf(this.br) + this.br.length;
		if(indL == 1) // ???
			indL = 0;

		var right = txt.substring(this.selEnd, txt.length);
		var indR = right.indexOf(this.br);
		if(indR == -1)
			indR = right.length;

		var lines = txt.substring(indL, this.selEnd + indR);

		lines = this.isMiltiline || !this.cmmLine
			? this.cmmStart + this.br + lines + this.br + this.cmmEnd
			: lines.replace(/^(\s*)/, "$1" + this.cmmLine + " ");

		AkelPad.ReplaceSel(
			txt.substring(0, indL) +
			lines +
			txt.substring(this.selEnd + indR, txt.length)
		);
	}
};

var cFile = AkelPad.GetEditFile(0);
if(!cFile)
	cFile = AkelPad.InputBox(hMainWnd, pScriptName, "Extension?", ""); // Save it? :-/
if(cFile) {
	cFile = cFile.match(/\.?([a-z0-9]+)$/i);
	cFile = cFile ? cFile[1].toLowerCase() : null;
	if(cFile) {
		var cmms = commentsSet[cFile];
		if(cmms) {
			var comments = new Comments(cmms[0], cmms[1], cmms[2]);
			comments.run();

			// enable auto redraw
			var oSys = AkelPad.SystemFunction();
			AkelPad.SendMessage(hEditWnd, 11 /*WM_SETREDRAW*/, true, 0);
                        oSys.Call("user32::InvalidateRect", hEditWnd, 0, false);
		}
	}
}