﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=1420#1420
// Description(1033): Convert selected lines to predefine structure
// Description(1049): Преобразовывает выделенный текст в блок определённой стрктуры
// Version: 5.4 (2016.01.09)
// Author: VladSh
// 
// Arguments:
//    -shift - lines shift to the right:
//        without this parameter - shift from program settings;
//        "" / "\t" or other value
//    -delEmptyLines:
//        without this parameter or 0 - won't delete empty lines;
//        1 - will delete empty lines;
//        [2] - will delete lines which contains tabs or/and spaces
//    -rootOpen, -rootClose, -lineOpen, -lineClose - see Usage section
// 
// Usage:
//     HTML (ul, ol, dt):
// -"<ul>...</ul>" Call("Scripts::Main", 1, "insertStructure.js", `-rootOpen="<ul>" -lineOpen="<li>" -lineClose="</li>" -rootClose="</ul>"`)
//     fb2 (stanza);
//     BbCode (list):
// -"[list]...[/list]" Call("Scripts::Main", 1, "insertStructure.js", `-rootOpen="[list]" -lineOpen="[*]" -rootClose="[/list]" -shift=""`)

if (AkelPad.IsAkelEdit()) {
	if (WScript.Arguments.length == 0) WScript.Quit();
	
	if (! AkelPad.Include("selCompleteLine.js")) WScript.Quit();
	
	oCh.runWithRedraw();
}

function process() {
	var rootOpen = AkelPad.GetArgValue("rootOpen", "");
	var lineOpen = AkelPad.GetArgValue("lineOpen", "");
	var lineClose = AkelPad.GetArgValue("lineClose", "");
	var rootClose = AkelPad.GetArgValue("rootClose", "");
	
	if (AkelPad.GetArgLine().indexOf("-shift") != -1) {
		sShift = escSequencesProcessing(AkelPad.GetArgValue("shift", ""));
	}
	else
		getShift();
	lineOpen = sShift + lineOpen;
	
	oCh.setCompleteLineText();
	
	var pBreak = (AkelPad.GetEditNewLine(0) != 2) ? "\r" : "\n";
	
	var lines = oCh.Text;
	
	var delEmptyLines = AkelPad.GetArgValue("delEmptyLines", 2);
	
	//убираем хвостовые пробелы и табуляции
	lines = lines.replace(/(\S)([ \t])+$/gm, "$1");
	
	if (delEmptyLines > 0) {
		if (delEmptyLines == 2) {
			//удаляем строки, состоящие только из табуляций и/или пробелов
			lines = lines.replace(/^[ \t]*$/gm, "");
		}
		//убираем пустые строки (2 и более переводов строк)
		lines = lines.replace(/\r{2,}/g, pBreak);
		lines = oStr.trim(lines, pBreak);		//убираем переводы строк по краям
	}
	
	var spaces = lines.match(/^[ \t]*/)[0];
	if (rootOpen) rootOpen = spaces + rootOpen + pBreak;
	if (rootClose) rootClose = pBreak + spaces + rootClose;
	
	if (lineOpen || lineClose) {
		lines = lines.replace(/^([ \t]*)/gm, "$1" + lineOpen);   //открывающий тэг
		lines = lines.replace(/([ \t]*$)/gm, "$1" + lineClose);  //закрывающий тэг
	}
	
	oCh.Text = rootOpen + lines + rootClose;
}