try {
  var hMainWnd=AkelPad.GetMainWnd();
}
catch (oError) {
  WScript.Quit();
}

// Options
var pSep="";
var pPrefix="\\u";
var bSurrogate = true;

// Log.dll Ƿ
var oSys=AkelPad.SystemFunction();
var bLogPluginExists=oSys.Call("kernel32::GetFileAttributes" + _TCHAR, AkelPad.GetAkelDir(4 /*ADTYPE_PLUGS*/) + "\\Log.dll") != -1;

if (bLogPluginExists) {
  var pSelText=AkelPad.GetSelText(2);

  if (pSelText) {
    l=pSelText.length;
    var vChar=[];
    for (i=0; i<l; i+=1) {
      pCode=knownCharCodeAt(pSelText, i);
      if (!isNaN(pCode)) {
        pCode=pCode.toString(16).toUpperCase();
        vChar.push(pPrefix + "0000".substr(0,4-pCode.length)+pCode);
      }
    }

    AkelPad.Call("Log::Output", 4 + _TSTR, vChar.join(pSep), -1, 0 /*APPEND*/);
  }
}

function knownCharCodeAt (str, idx) {
  str += '';
  var code,
    end = str.length;

  if (bSurrogate) {
    var surrogatePairs = /[\uD800-\uDBFF][\uDC00-\uDFFF]/g;
    while ((surrogatePairs.exec(str)) != null) {
      var li = surrogatePairs.lastIndex;
      if (li - 2 < idx) {
        idx++;
      }
      else {
        break;
      }
    }

    if (idx >= end || idx < 0) {
      return NaN;
    }

    code = str.charCodeAt(idx);

    var hi, low;
    if (0xD800 <= code && code <= 0xDBFF) {
      hi = code;
      low = str.charCodeAt(idx+1); // Go one further, since one of the "characters" is part of a surrogate pair
      return ((hi - 0xD800) * 0x400) + (low - 0xDC00) + 0x10000;
    }
  }
  else {
    return str.charCodeAt(idx);
  }
}
