// http://akelpad.sourceforge.net/forum/viewtopic.php?p=13021#13021
// Version: 2.6
// Author: Shengalts Aleksander aka Instructor
//
//
// Description(1033): Export highlighted text to HTML or BBCode.
// Description(1049):     HTML  BBCode.
//
// Arguments:
// -Format="BBCode"                   -Output highlighting in BBCode format (default is "HTML").
// -Enclose="[code]${result}[/code]"  -Enclose result string (default is "<pre>${result}</pre>").
// -BR="<br>"                         -HTML new line string (default is "").
// -Strict=true                       -use "<span style=" instead of "<font" (default is false).
// -Info=false                        -Don't add link to CodePoster.js script (default is true).
// -InfoSize="10"                     -Information font size (default is 1).
//
// Usage:
// Call("Scripts::Main", 1, "CodePoster.js", `-Format="BBCode" -Enclose="[quote]${result}[/quote]" -InfoSize="10"`)
// Call("Scripts::Main", 1, "CodePoster.js", `-Format="BBCode" -Enclose="[code]${result}[/code]"`)
// Call("Scripts::Main", 1, "CodePoster.js", `-Format="HTML" -Strict=true -Info=false`)

//Arguments
var pFormat=AkelPad.GetArgValue("Format", "HTML");
var pEnclose=AkelPad.GetArgValue("Enclose", "<pre>${result}</pre>");
var pBR=AkelPad.GetArgValue("BR", "");
var bStrict=AkelPad.GetArgValue("Strict", false);
var bInfo=AkelPad.GetArgValue("Info", true);
var pInfoSize=AkelPad.GetArgValue("InfoSize", "1");

//Variables
var hMainWnd=AkelPad.GetMainWnd();
var hWndEdit=AkelPad.GetEditWnd();
var oSys=AkelPad.SystemFunction();
var dwSystemTextColor=oSys.Call("user32::GetSysColor", 8 /*COLOR_WINDOWTEXT*/);
var dwSystemBkColor=oSys.Call("user32::GetSysColor", 5 /*COLOR_WINDOW*/);
var lpGH;
var lpCallback;
var pText="";
var lpMemText=0;
var dwMemTextBytes;
var dwPrevColorCloseStart;
var dwPrevColorCloseEnd;
var dwPrevActiveTextColor;
var dwPrevActiveBkColor;
var bBBCode;
var pScriptURL="";

if (hWndEdit)
{
  if (pFormat.toLowerCase() == "html")
    bBBCode=false;
  else
    bBBCode=true;

  if (bInfo)
    pScriptURL="http://akelpad.sourceforge.net/forum/viewtopic.php?p=13021#13021";

  if (lpGH=AkelPad.MemAlloc(_X64?80:40 /*sizeof(AEGETHIGHLIGHT)*/))
  {
    if (lpCallback=oSys.RegisterCallback(GetHighLightCallback))
    {
      AkelPad.MemCopy(_PtrAdd(lpGH, _X64?16:8) /*offsetof(AEGETHIGHLIGHT, lpCallback)*/, lpCallback, 2 /*DT_QWORD*/);
      AkelPad.MemCopy(_PtrAdd(lpGH, _X64?72:36) /*offsetof(AEGETHIGHLIGHT, dwFlags)*/, 0x7 /*AEGHF_NOSELECTION|AEGHF_NOACTIVELINETEXT|AEGHF_NOACTIVELINEBK*/, 3 /*DT_DWORD*/);

      if (!AkelPad.SendMessage(hWndEdit, 3123 /*AEM_EXGETSEL*/, _PtrAdd(lpGH, _X64?24:12) /*offsetof(AEGETHIGHLIGHT, crText.ciMin)*/, _PtrAdd(lpGH, _X64?48:24) /*offsetof(AEGETHIGHLIGHT, crText.ciMax)*/))
      {
        AkelPad.SendMessage(hWndEdit, 3130 /*AEM_GETINDEX*/, 1 /*AEGI_FIRSTCHAR*/, _PtrAdd(lpGH, _X64?24:12) /*offsetof(AEGETHIGHLIGHT, crText.ciMin)*/);
        AkelPad.SendMessage(hWndEdit, 3130 /*AEM_GETINDEX*/, 2 /*AEGI_LASTCHAR*/, _PtrAdd(lpGH, _X64?48:24) /*offsetof(AEGETHIGHLIGHT, crText.ciMax)*/);
      }

      //Calculate dwMemTextBytes
      dwMemTextBytes=0;
      dwPrevColorCloseStart=-1;
      dwPrevColorCloseEnd=-1;
      dwPrevActiveTextColor=-1;
      dwPrevActiveBkColor=-1;
      AkelPad.SendMessage(hWndEdit, 3595 /*AEM_HLGETHIGHLIGHT*/, 0, lpGH);

      if (lpMemText=AkelPad.MemAlloc(dwMemTextBytes + _TSIZE))
      {
        //Fill lpMemText
        dwMemTextBytes=0;
        dwPrevColorCloseStart=-1;
        dwPrevColorCloseEnd=-1;
        dwPrevActiveTextColor=-1;
        dwPrevActiveBkColor=-1;
        AkelPad.SendMessage(hWndEdit, 3595 /*AEM_HLGETHIGHLIGHT*/, 0, lpGH);

        pText=AkelPad.MemRead(lpMemText, _TSTR);
        AkelPad.MemFree(lpMemText);
      }
      oSys.UnregisterCallback(lpCallback);
    }
    AkelPad.MemFree(lpGH);
  }

  if (pText)
  {
    if (pEnclose)
    {
      pText=pText.replace(/\$/g, "$$$$");
      pText=pEnclose.replace(/\$\{result\}/, pText);
    }
    if (bInfo)
    {
      if (bBBCode)
        pText+="[color=Purple][size=" + pInfoSize + "]* " + GetLangString(0) + " [URL=" + pScriptURL + "]CodePoster.js[/URL] " + GetLangString(1) + "[/size]" + "[/color]\r";
      else
      {
        if (bStrict)
          pText+="\r<span style=\"color:Purple; font-size:" + pInfoSize + ";\">* " + GetLangString(0) + " <a href=\"" + pScriptURL + "\">CodePoster.js</a> " + GetLangString(1) + "</span>\r";
        else
          pText+="\r<font color=\"Purple\" size=\"" + pInfoSize + "\">* " + GetLangString(0) + " <a href=\"" + pScriptURL + "\">CodePoster.js</a> " + GetLangString(1) + "</font>\r";
      }
    }
    AkelPad.SetClipboardText(pText);
    AkelPad.MessageBox(hMainWnd, GetLangString(2), WScript.ScriptName, 64 /*MB_ICONINFORMATION*/);
  }
}

function GetHighLightCallback(dwCookie, crAkelRange, crRichRange, hlp)
{
  var nRangeStart=AkelPad.MemRead(_PtrAdd(crRichRange, 0) /*offsetof(CHARRANGE64, crRichRange.cpMin)*/, 2 /*DT_QWORD*/);
  var nRangeEnd=AkelPad.MemRead(_PtrAdd(crRichRange, _X64?8:4) /*offsetof(CHARRANGE64, crRichRange.cpMax)*/, 2 /*DT_QWORD*/);
  var pRangeText;
  var dwFontStyle=AkelPad.MemRead(_PtrAdd(hlp, _X64?20:20) /*offsetof(AEHLPAINT, dwFontStyle)*/, 3 /*DT_DWORD*/);
  var dwActiveTextColor=AkelPad.MemRead(_PtrAdd(hlp, _X64?12:12) /*offsetof(AEHLPAINT, dwActiveText)*/, 3 /*DT_DWORD*/);
  var dwActiveBkColor=AkelPad.MemRead(_PtrAdd(hlp, _X64?16:16) /*offsetof(AEHLPAINT, dwActiveBk)*/, 3 /*DT_DWORD*/);
  var dwPaintType=AkelPad.MemRead(_PtrAdd(hlp, _X64?24:24) /*offsetof(AEHLPAINT, dwPaintType)*/, 3 /*DT_DWORD*/);
  var pColorOpen="";
  var pColorClose="";

  if (pRangeText=AkelPad.GetTextRange(nRangeStart, nRangeEnd))
  {
    if (!bBBCode)
    {
      //pRangeText=pRangeText.replace(/[ ]{2,}/g, "&nbsp;");
      pRangeText=pRangeText.replace(/&/g, "&amp;");
      pRangeText=pRangeText.replace(/</g, "&lt;");
      pRangeText=pRangeText.replace(/>/g, "&gt;");
      pRangeText=pRangeText.replace(/"/g, "&quot;");
    }

    if (dwPaintType & 0x80 /*AEHPT_LINK*/)
    {
      if (bBBCode)
        pRangeText="[url=" + pRangeText + "]" + pRangeText + "[/url]";
      else
        pRangeText="<a href=\"" + pRangeText + "\">" + pRangeText + "</a>";
    }
    if (dwFontStyle == 2 /*AEHLS_FONTBOLD*/)
    {
      if (bBBCode)
        pRangeText="[b]" + pRangeText + "[/b]";
      else
        pRangeText="<b>" + pRangeText + "</b>";
    }
    else if (dwFontStyle == 3 /*AEHLS_FONTITALIC*/)
    {
      if (bBBCode)
        pRangeText="[i]" + pRangeText + "[/i]";
      else
        pRangeText="<i>" + pRangeText + "</i>";
    }
    else if (dwFontStyle == 4 /*AEHLS_FONTBOLDITALIC*/)
    {
      if (bBBCode)
        pRangeText="[b][i]" + pRangeText + "[/i][/b]";
      else
        pRangeText="<b><i>" + pRangeText + "</i></b>";
    }

    if (dwSystemTextColor != dwActiveTextColor || (!bBBCode && bStrict && dwSystemBkColor != dwActiveBkColor))
    {
      if (dwMemTextBytes == dwPrevColorCloseEnd &&
          dwPrevActiveTextColor == dwActiveTextColor && (bBBCode || !bStrict || dwPrevActiveBkColor == dwActiveBkColor))
        dwMemTextBytes=dwPrevColorCloseStart;

      if (bBBCode)
      {
        if (dwMemTextBytes != dwPrevColorCloseStart)
          pColorOpen="[color=#" + rgb2hex(dwActiveTextColor) + "]";
        pColorClose="[/color]";
        dwMemTextBytes+=AkelPad.MemCopy(lpMemText?_PtrAdd(lpMemText, dwMemTextBytes):0, pColorOpen + pRangeText + pColorClose, _TSTR) - _TSIZE;
      }
      else
      {
        if (bStrict)
        {
          if (dwMemTextBytes != dwPrevColorCloseStart)
            pColorOpen="<span style=\"" + (dwSystemTextColor != dwActiveTextColor?"color:#" + rgb2hex(dwActiveTextColor) + ";":"") + (dwSystemBkColor != dwActiveBkColor?"background:#" + rgb2hex(dwActiveBkColor) + ";":"") + "\">";
          pColorClose="</span>";
          dwMemTextBytes+=AkelPad.MemCopy(lpMemText?_PtrAdd(lpMemText, dwMemTextBytes):0, pColorOpen + pRangeText + pColorClose, _TSTR) - _TSIZE;
        }
        else
        {
          if (dwMemTextBytes != dwPrevColorCloseStart)
            pColorOpen="<font color=\"#" + rgb2hex(dwActiveTextColor) + "\">";
          pColorClose="</font>";
          dwMemTextBytes+=AkelPad.MemCopy(lpMemText?_PtrAdd(lpMemText, dwMemTextBytes):0, pColorOpen + pRangeText + pColorClose, _TSTR) - _TSIZE;
        }
      }
    }
    else dwMemTextBytes+=AkelPad.MemCopy(lpMemText?_PtrAdd(lpMemText, dwMemTextBytes):0, pRangeText, _TSTR) - _TSIZE;

    if (pColorClose)
    {
      dwPrevColorCloseStart=dwMemTextBytes - pColorClose.length * _TSIZE;
      dwPrevColorCloseEnd=dwMemTextBytes;
    }
    dwPrevActiveTextColor=dwActiveTextColor;
    dwPrevActiveBkColor=dwActiveBkColor;
  }

  if (IsLastCharInLine(_PtrAdd(crAkelRange, _X64?24:12) /*offsetof(AECHARRANGE, ciMax)*/) && IndexCompare(_PtrAdd(crAkelRange, _X64?24:12) /*offsetof(AECHARRANGE, ciMax)*/, _PtrAdd(lpGH, _X64?48:24) /*offsetof(AEGETHIGHLIGHT, crText.ciMax)*/))
  {
    if (bBBCode)
      dwMemTextBytes+=AkelPad.MemCopy(lpMemText?_PtrAdd(lpMemText, dwMemTextBytes):0, "\r", _TSTR) - _TSIZE;
    else
      dwMemTextBytes+=AkelPad.MemCopy(lpMemText?_PtrAdd(lpMemText, dwMemTextBytes):0, "\r" + pBR, _TSTR) - _TSIZE;
  }
  return 0;
}

function rgb2hex(dwColor)
{
  var pHexColor;

  pHexColor=dwColor.toString(16);
  pHexColor="000000".substr(pHexColor.length) + pHexColor;
  return pHexColor.substr(4, 2) + pHexColor.substr(2, 2) + pHexColor.substr(0, 2);
}

function IsLastCharInLine(lpCharIndex)
{
  var nCharInLine=AkelPad.MemRead(_PtrAdd(lpCharIndex, _X64?16:8) /*offsetof(AECHARINDEX, nCharInLine)*/, 3 /*DT_DWORD*/);
  var lpLine=AkelPad.MemRead(_PtrAdd(lpCharIndex, _X64?8:4) /*offsetof(AECHARINDEX, lpLine)*/, 2 /*DT_QWORD*/);
  var nLineLen=AkelPad.MemRead(_PtrAdd(lpLine, _X64?24:12) /*offsetof(AELINEDATA, nLineLen)*/, 3 /*DT_DWORD*/);
  var nLineBreak=AkelPad.MemRead(_PtrAdd(lpLine, _X64?28:16) /*offsetof(AELINEDATA, nLineBreak)*/, 3 /*DT_DWORD*/);

  if (nCharInLine == nLineLen && nLineBreak != 9 /*AELB_WRAP*/)
    return true;
  return false;
}

function IndexCompare(lpCharIndex1, lpCharIndex2)
{
  var nCharInLine1=AkelPad.MemRead(_PtrAdd(lpCharIndex1, _X64?16:8) /*offsetof(AECHARINDEX, nCharInLine)*/, 3 /*DT_DWORD*/);
  var nLine1=AkelPad.MemRead(_PtrAdd(lpCharIndex1, 0) /*offsetof(AECHARINDEX, nLine)*/, 3 /*DT_DWORD*/);
  var nCharInLine2=AkelPad.MemRead(_PtrAdd(lpCharIndex2, _X64?16:8) /*offsetof(AECHARINDEX, nCharInLine)*/, 3 /*DT_DWORD*/);
  var nLine2=AkelPad.MemRead(_PtrAdd(lpCharIndex2, 0) /*offsetof(AECHARINDEX, nLine)*/, 3 /*DT_DWORD*/);

  if (nLine1 == nLine2 && nCharInLine1 == nCharInLine2)
    return 0;
  if (nLine1 < nLine2 || (nLine1 == nLine2 && nCharInLine1 < nCharInLine2))
    return -1;
  return 1;
}

function GetLangString(nStringID)
{
  var nLangID=AkelPad.GetLangId(1 /*LANGID_PRIMARY*/);

  if (nLangID == 0x19) //LANG_RUSSIAN
  {
    if (nStringID == 0)
      return "\u041F\u043E\u0434\u0441\u0432\u0435\u0447\u0435\u043D\u043E\u0020\u0441\u0020\u043F\u043E\u043C\u043E\u0449\u044C\u044E\u0020\u0441\u043A\u0440\u0438\u043F\u0442\u0430";
    if (nStringID == 1)
      return "\u0434\u043B\u044F AkelPad";
    if (nStringID == 2)
      return "\u041A\u043E\u0434\u0020\u043F\u043E\u043C\u0435\u0449\u0435\u043D\u0020\u0432\u0020\u0431\u0443\u0444\u0435\u0440\u0020\u043E\u0431\u043C\u0435\u043D\u0430\u002E";
  }
  else
  {
    if (nStringID == 0)
      return "Highlighted with script";
    if (nStringID == 1)
      return "for AkelPad";
    if (nStringID == 2)
      return "Code has been placed in clipboard.";
  }
  return "";
}
