// Based on Keyboard.js script

var hMainWnd=AkelPad.GetMainWnd();
var hWndEdit=AkelPad.GetEditWnd();
var oSys=AkelPad.SystemFunction();
var hInstanceDLL=AkelPad.GetInstanceDll();

if (hMainWnd && hWndEdit)
   CodePosterMenu();

function CodePosterMenu()
{
   var hWndHidden;
   var hMenu;
   var nItem;
   var ptPoint=[];

   var ID_BBCODE       = 1;
   var ID_XHTML_STRICT = 2;
   var ID_HTML_STRICT  = 3;
   var ID_XHTML        = 4;
   var ID_HTML         = 5;

   if (hWndHidden=oSys.Call("user32::CreateWindowEx" + _TCHAR, 0, "Static", 0, 0x50000000 /*WS_VISIBLE|WS_CHILD*/, 0, 0, 0, 0, hMainWnd, 0, hInstanceDLL, 0))
   {
      oSys.Call("user32::SetFocus", hWndHidden);
      GetCaretPos(hWndEdit, ptPoint);

      if (hMenu=oSys.Call("user32::CreatePopupMenu"))
      {
         oSys.Call("user32::AppendMenu" + _TCHAR, hMenu, 0x0 /*MF_STRING*/, ID_BBCODE,       "[color=#...]");
         oSys.Call("user32::AppendMenu" + _TCHAR, hMenu, 0x800 /*MF_SEPARATOR*/, -1, "");
         oSys.Call("user32::AppendMenu" + _TCHAR, hMenu, 0x0 /*MF_STRING*/, ID_XHTML_STRICT, "<span style=\"color:#...;\"><br/>");
         oSys.Call("user32::AppendMenu" + _TCHAR, hMenu, 0x0 /*MF_STRING*/, ID_HTML_STRICT,  "<span style=\"color:#...;\"><br>");
         oSys.Call("user32::AppendMenu" + _TCHAR, hMenu, 0x0 /*MF_STRING*/, ID_XHTML,        "<font color=\"#...\"><br/>");
         oSys.Call("user32::AppendMenu" + _TCHAR, hMenu, 0x0 /*MF_STRING*/, ID_HTML,         "<font color=\"#...\"><br>");

         nItem=oSys.Call("user32::TrackPopupMenu", hMenu, 0x182 /*TPM_RETURNCMD|TPM_NONOTIFY|TPM_LEFTBUTTON|TPM_RIGHTBUTTON*/, ptPoint.x, ptPoint.y, 0, hWndHidden, 0);

         if (nItem == ID_BBCODE)
            AkelPad.Call("Scripts::Main", 1, "CodePoster.js", '-Format="BBCode"');
         else if (nItem == ID_XHTML_STRICT)
            AkelPad.Call("Scripts::Main", 1, "CodePoster.js", '-Format="html" -XHTML=true -Strict=true');
         else if (nItem == ID_HTML_STRICT)
            AkelPad.Call("Scripts::Main", 1, "CodePoster.js", '-Format="html" -XHTML=false -Strict=true');
         else if (nItem == ID_XHTML)
            AkelPad.Call("Scripts::Main", 1, "CodePoster.js", '-Format="html" -XHTML=true -Strict=false');
         else if (nItem == ID_HTML)
            AkelPad.Call("Scripts::Main", 1, "CodePoster.js", '-Format="html" -XHTML=false -Strict=false');

         oSys.Call("user32::DestroyMenu", hMenu);
      }
      oSys.Call("user32::DestroyWindow", hWndHidden);
   }
}

function GetCaretPos(hWndEdit, ptPoint)
{
  var lpPoint;

  ptPoint.x=0;
  ptPoint.y=0;

  if (lpPoint=AkelPad.MemAlloc(8 /*sizeof(POINT)*/))
  {
    //Caret position
    AkelPad.SendMessage(hWndEdit, 3190 /*AEM_GETCARETPOS*/, lpPoint, 0);
    ptPoint.x=AkelPad.MemRead(lpPoint, 3 /*DT_DWORD*/);
    ptPoint.y=AkelPad.MemRead(lpPoint + 4, 3 /*DT_DWORD*/);
    AkelPad.MemFree(lpPoint);

    //Caret bottom
    ptPoint.y+=AkelPad.SendMessage(hWndEdit, 3188 /*AEM_GETCHARSIZE*/, 0 /*AECS_HEIGHT*/, 0);

    //In screen coordinates
    ClientToScreen(hWndEdit, ptPoint);
  }
}

function ClientToScreen(hWnd, ptPoint)
{
  var lpPoint;

  if (lpPoint=AkelPad.MemAlloc(8 /*sizeof(POINT)*/))
  {
    AkelPad.MemCopy(lpPoint, ptPoint.x, 3 /*DT_DWORD*/);
    AkelPad.MemCopy(lpPoint + 4, ptPoint.y, 3 /*DT_DWORD*/);
    oSys.Call("user32::ClientToScreen", hWnd, lpPoint);
    ptPoint.x=AkelPad.MemRead(lpPoint, 3 /*DT_DWORD*/);
    ptPoint.y=AkelPad.MemRead(lpPoint + 4, 3 /*DT_DWORD*/);
    AkelPad.MemFree(lpPoint);
  }
}