﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=27218#27218
// Version: 1.0
// Author: Shengalts Aleksander aka Instructor
//
//
// Description(1033): Align text in one line or column selection.
// Description(1049): Выравнивание текста в однострочном или вертикальном выделении.
//
// Arguments:
// C    -Center align.
// L    -Left align.
// R    -Right align.
//
// Usage:
// Call("Scripts::Main", 1, "ColumnAlign.js", "R")

//Arguments
var pAlign="";
if (WScript.Arguments.length >= 1)
  pAlign=WScript.Arguments(0).toUpperCase();

var hMainWnd=AkelPad.GetMainWnd();
var hWndEdit=AkelPad.GetEditWnd();
var oFunction=AkelPad.SystemFunction();
var pSelText;
var pLinesArray;
var nIndex;
var pLineText;
var pLineSpaces;
var nHalfSpaces;

if (hWndEdit)
{
  if (AkelPad.SendMessage(hWndEdit, 3125 /*AEM_GETSEL*/, 0, 0))
  {
    if ((AkelPad.SendMessage(hWndEdit, 3129 /*AEM_GETLINENUMBER*/, 1 /*AEGL_FIRSTSELLINE*/, 0) ==
         AkelPad.SendMessage(hWndEdit, 3129 /*AEM_GETLINENUMBER*/, 2 /*AEGL_LASTSELLINE*/, 0)) ||
         AkelPad.SendMessage(hWndEdit, 3127 /*AEM_GETCOLUMNSEL*/, 0, 0))
    {
      if (!pAlign)
      {
        var aItems=[];

        //Include
        if (!AkelPad.Include("ShowMenu.js")) WScript.Quit();

        //Show menu
        for (nItem=0; nItem <= 2; ++nItem)
          aItems[nItem]=[GetLangString(nItem), MF_NORMAL, nItem];

        if ((nItem=ShowMenu(aItems, POS_CURSOR, POS_CURSOR)) != -1)
        {
          if (nItem == 0)
            pAlign="C";
          else if (nItem == 1)
            pAlign="L";
          else if (nItem == 2)
            pAlign="R";
        }
        if (!pAlign) WScript.Quit();
      }
      pSelText=AkelPad.GetSelText();

      if (pLinesArray=pSelText.split("\r"))
      {
        for (nIndex=0; nIndex < pLinesArray.length; ++nIndex)
        {
          pLinesArray[nIndex].match(/^([ \t]*)(.*?)([ \t]*)$/);
          pLineText=RegExp.$2;
          pLineSpaces=RegExp.$1 + RegExp.$3;

          if (pLineText.length)
          {
            nHalfSpaces=parseInt(pLineSpaces.length / 2);

            if (pAlign == "L")
              pLinesArray[nIndex]=pLineText + pLineSpaces;
            else if (pAlign == "R")
              pLinesArray[nIndex]=pLineSpaces + pLineText;
            else if (pAlign == "C")
              pLinesArray[nIndex]=pLineSpaces.substr(0, nHalfSpaces) + pLineText + pLineSpaces.substr(nHalfSpaces, pLineSpaces.length - nHalfSpaces);
          }
        }
        pSelText=pLinesArray.join("\r");

        AkelPad.ReplaceSel(pSelText, true);
      }
    }
    else AkelPad.MessageBox(hMainWnd, GetLangString(4), WScript.ScriptName, 48 /*MB_ICONEXCLAMATION*/);
  }
  else AkelPad.MessageBox(hMainWnd, GetLangString(3), WScript.ScriptName, 48 /*MB_ICONEXCLAMATION*/);
}


//Functions
function GetLangString(nStringID)
{
  var nLangID=AkelPad.GetLangId(1 /*LANGID_PRIMARY*/);

  if (nLangID == 0x4) //LANG_CHINESE
  {
    if (nStringID == 0)
      return "居中对齐";
    if (nStringID == 1)
      return "左对齐";
    if (nStringID == 2)
      return "右对齐";
    if (nStringID == 3)
      return "无选定文本。";
    if (nStringID == 4)
      return "需要一行或列的选定。";
  }
  else
  {
    if (nStringID == 0)
      return "Center align";
    if (nStringID == 1)
      return "Left align";
    if (nStringID == 2)
      return "Right align";
    if (nStringID == 3)
      return "No text selected.";
    if (nStringID == 4)
      return "Required one line or column selection.";
  }
  return "";
}
