﻿/// Column selection counter (4.2.0 or higher required)

// Modified by Infocatcher
// version: 2011-01-30

// How to use:
// Select column with numbers for processing.
//
// Description:
// First selected line number is a initial number.
// Each next line will be increased at defined step.
//  3    3
//  9    4
//  2 -> 5
//  0    6
//  5    7
//
//
/// Увеличение чисел (счетчик) вертикального выделения (требуется 4.2.0 или выше)
//
// Как использовать:
// Выделите вертикальный блок с числами, которые необходимо преобразовать.
//
// Описание:
// Число в первой выделенной строке является начальным числом.
// Каждая последующая строка будет увеличина на величину назначенного шага.
//  3    3
//  9    4
//  2 -> 5
//  0    6
//  5    7

//Options
var nStep=1;
var nMinDigits=0;

//Variables
var hMainWnd=AkelPad.GetMainWnd();
var hWndEdit=AkelPad.GetEditWnd();
var oSys=AkelPad.SystemFunction();
var pScriptName=WScript.ScriptName;
var pSelText;
var pLinesArray;
var nFirstNumber;
var bMinus;
var nIndex=0;
var dwOptions;

if (hMainWnd)
{
  if (AkelPad.IsAkelEdit())
  {
    if (AkelPad.SendMessage(hWndEdit, 3125 /*AEM_GETSEL*/, 0, 0))
    {
      if (AkelPad.SendMessage(hWndEdit, 3127 /*AEM_GETCOLUMNSEL*/, 0, 0))
      {
        pSelText=AkelPad.GetSelText();

        if (pLinesArray=pSelText.split("\r"))
        {
          nFirstNumber=parseInt(pLinesArray[nIndex]);

          if (!isNaN(nFirstNumber))
          {
            if (nFirstNumber < 0)
              bMinus=true;
            else
              bMinus=false;
            pLinesArray[nIndex]="" + nFirstNumber + pLinesArray[nIndex].replace(/^(0x[\da-f]+|\d+)/i, "");
            while (pLinesArray[nIndex].length < nMinDigits)
              pLinesArray[nIndex]="0" + pLinesArray[nIndex];

            while (++nIndex < pLinesArray.length)
            {
              if (!isNaN(parseInt(pLinesArray[nIndex])))
              {
                if (bMinus)
                  nFirstNumber=nFirstNumber - nStep;
                else
                  nFirstNumber=nFirstNumber + nStep;
                pLinesArray[nIndex]="" + nFirstNumber + pLinesArray[nIndex].replace(/^(0x[\da-f]+|\d+)/i, "");
                while (pLinesArray[nIndex].length < nMinDigits)
                  pLinesArray[nIndex]="0" + pLinesArray[nIndex];
              }
            }
            pSelText=pLinesArray.join("\r");

            dwOptions=AkelPad.SendMessage(hWndEdit, 3227 /*AEM_GETOPTIONS*/, 0, 0);
            if (!(dwOptions & 0x40 /*AECO_PASTESELECTCOLUMN*/))
              AkelPad.SendMessage(hWndEdit, 3228 /*AEM_SETOPTIONS*/, 2 /*AECOOP_OR*/, 0x40 /*AECO_PASTESELECTCOLUMN*/);
            AkelPad.ReplaceSel(pSelText);
            if (!(dwOptions & 0x40 /*AECO_PASTESELECTCOLUMN*/))
              AkelPad.SendMessage(hWndEdit, 3228 /*AEM_SETOPTIONS*/, 4 /*AECOOP_XOR*/, 0x40 /*AECO_PASTESELECTCOLUMN*/);
          }
        }
      }
      else AkelPad.MessageBox(hMainWnd, GetLangString(2), pScriptName, 48 /*MB_ICONEXCLAMATION*/);
    }
    else AkelPad.MessageBox(hMainWnd, GetLangString(1), pScriptName, 48 /*MB_ICONEXCLAMATION*/);
  }
  else AkelPad.MessageBox(hMainWnd, GetLangString(0), pScriptName, 48 /*MB_ICONEXCLAMATION*/);
}


//Functions
function GetLangString(nStringID)
{
  var nLangID;

  nLangID=oSys.Call("kernel32::GetUserDefaultLangID");
  nLangID=nLangID & 0x3ff; //PRIMARYLANGID

  if (nLangID == 0x4) //LANG_CHINESE
  {
    if (nStringID == 0)
      return "需要 AkelPad 4.x.x 或更高版本";
    if (nStringID == 1)
      return "未选定文本。";
    if (nStringID == 2)
      return "需要列选区域。";
  }
  else
  {
    if (nStringID == 0)
      return "Required AkelPad 4.x.x or higher";
    if (nStringID == 1)
      return "No text selected.";
    if (nStringID == 2)
      return "Required column selection.";
  }
  return "";
}
