﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=1653#1653
// Description(1033): Commented text or block of text
// 	variants comments see included CommentsExt.js
// Description(1049): Комментирование строки или текстового блока
// Version: 3.11 (2015.04.22)
// Author: VladSh
// 
// Arguments:
// 	-forceSingle = [true]/false
// 
// Proposed to use a keyboard shortcut in Scripts-plugin box: Ctrl + /

if (! AkelPad.Include("CommentsExt.js")) WScript.Quit();
if (! AkelPad.Include("selCompleteLine.js")) WScript.Quit();
if (! AkelPad.Include("CoderFunctions.js")) WScript.Quit();

setComments(GetSyntaxAliasExtension());
oCh.run();

function process() {
	var nCaretPos = 0;
	
	oCh.Text = oCh.getSelTextEmpty();
	
	if (!oCh.Text.length && !cSimple) {
		//если простые комменты не поддерживаются - пытаемся выделить строку целиком и заключить в блочные
		oCh.setCompleteLineText();
	}
	if (oCh.Text.length) {
		nCaretPos = setMultylineComment();
	}
	if (!nCaretPos) {
		nCaretPos = setSinglelineComment();
	}
	
	oCh.setSelCaret(nCaretPos);		//в этом скрипте восстанавливаем первоначальное положение каретки
}

function setMultylineComment() {
	if (cBlockOpen && !(AkelPad.GetArgValue("forceSingle", true) && cSimple)) {
		var tmpText = oStr.rtrim(oCh.Text, pBreak);
		var nDiff = oCh.Text.length - tmpText.length;
		if (nDiff) {		//если перевод строки в конце выделения захвачен
			oCh.Text = tmpText;
			oCh.rBegin[1] -= nDiff;		//для возможного дальнейшего полного выделения строк (если их выбрано несколько) с помощью setCompleteLineText
		}
		
		var pBreakValue = "";
		if (oCh.Text.indexOf(pBreak) !== -1) {		//если выделенный текст в несколько строк
			oCh.setCompleteLineText();
			if (!nDiff) pBreakValue = pBreak;		//специфика при отключенном NoSelEOL - переводы строк вокруг текста не вставляются
		}
		
		oCh.Text = cBlockOpen + pBreakValue + oCh.Text + pBreakValue + cBlockClose;
		return oCh.rBegin[0] + (pBreakValue + cBlockOpen).length;
	}
}

function setSinglelineComment() {
	if (!cSimple) WScript.Quit();
	
	oCh.setCompleteLineText();
	
	var lines = oCh.Text.split(pBreak);
	for (var i = 0; i < lines.length; i++) {
		lines[i] = cSimple + lines[i];
	}
	oCh.Text = lines.join(pBreak);
	return oCh.rBegin[0] + cSimple.length;
}