﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=1212#1212
// Description(1049): Выполняет команду методом WshShell.Exec; используется для запуска некоторых приложений, аналог команды "Пуск" -> "Выполнить"
// Version: 2.12 (2015.04.10)
// Author: VladSh
// 
// Arguments:
// 	cmd - имя программы, как оно зарегистрировано в Windows; если указано, то меню выводиться не будет, а запустится указанная программа;
// 	остальные аргументы см. скрипт ShowMenuEx.js
// 
// Usage:
// 	-"Калькулятор" Call("Scripts::Main", 1, "ConsoleExec.js", `-cmd="calc"`)
// 	-"Выбор программы для запуска..." Call("Scripts::Main", 1, "ConsoleExec.js", `-pExt="ini" -ignore1menu=1`)	- пример задания игнорирования вывода меню, если в конфигурационном файле одна запись

var pCommand = AkelPad.GetArgValue("cmd", "");
if (!pCommand) {
	if (!AkelPad.Include("ShowMenuEx.js")) WScript.Quit();
	pCommand = getSelectedMenuItem(POS_CURSOR, AkelPad.GetArgValue("sep", "="), 0);
	if (!pCommand) WScript.Quit();
}
try {
	var WshShell = new ActiveXObject("WScript.Shell");
	pCommand = WshShell.ExpandEnvironmentStrings(pCommand);
	WshShell.Exec(pCommand);
}
catch (e) {
	var errInfo = e.name + ": " + e.description + "Command: " + pCommand;
	if (AkelPad.Call("Log::Output", 4, errInfo, -1, 2) == -1)
		AkelPad.MessageBox(AkelPad.GetEditWnd(), errInfo, WScript.ScriptName, 48 /*MB_EXCLAMATION*/);
}