﻿' Descript.vbs
'========================   Описание   =====================================
' Внесение выделенного текста в файл комментариев Descript.ion
' если ничего не выделено, в комментарий вносится часть строки, от курсора вправо
'=======================   Параметры  ======================================
' Один параметр:
'    0 - (или ничего) - открыть файл Descript.ion (если его нет - создать и открыть)
'    1 - внести выделенный текст в комментарии (если коммент. есть для этого файла - заменить)
'    2 - внести выделенный текст в комментарии и открыть файл
'    3 - Удалить комментарии несуществующих файлов\папок
'    4 - Дать полную информацию:
'       - открыть файл
'       - отобразить в новой вкладке каким файлам\папкам присвоены комментарии
'       - отобразить в новой вкладке каким файлам\папкам не присвоены комментарии
'       - отобразить в новой вкладке лишние комментарии (оставшиеся после удаления файла\папки)
' (если документ не имеет имени ничего не происходит)
'========================   Примеры   ======================================
'  "&Комментарии..." Icon("%a\AkelPadImage.dll",557)
'  {
'   -"Открыть файл Descript.ion" Call("Scripts::Main", 1, "Descript.vbs")
'   -"Внести выделенный текст в комментарии Shift+Alt+C" Call("Scripts::Main", 1, "Descript.vbs", `"1"`)
'   -"Внести выделенный текст в комментарии +" Call("Scripts::Main", 1, "Descript.vbs", `"2"`)
'   -"Удалить комментарии несуществующих ф\п" Call("Scripts::Main", 1, "Descript.vbs", `"3"`)
'   -"Дать полную информацию о Descript.ion" Call("Scripts::Main", 1, "Descript.vbs", `"4"`)
'  }

' используется Functions.vbs, который следует положить .в ..AkelFiles\Plugs\Scripts\Include\

' Автор:           Аверин Андрей
' Версия:          1.5 (28.04.2011 - 08.09.2012)
' Mail:            Averin-And@yandex.ru
' Site:            http://tc-image.3dn.ru/forum/9-421-1208-16-1333826782
' Site:            http://akelpad.sourceforge.net/forum/viewtopic.php?p=13346#13346
'===========================================================================
File = AkelPad.GetEditFile(0)
If Len(File) = 0 Then WScript.Quit ' если документ не имеет имени

Set FSO = CreateObject("Scripting.FileSystemObject")
Call AkelPad.Include("Functions.vbs")

dPath = FSO.GetParentFolderName(File)
dFile = dPath & "\descript.ion" : pText = ""

If Not FSO.FileExists(DFile) Then
  Call FSO.CreateTextFile(DFile)
  With FSO.GetFile(DFile) .Attributes = .Attributes Or 38 End With
End If

fName = FSO.GetFileName(File) : nS = 0

If WScript.Arguments.Count = 0 Then
  k = 0
Else
  k = WScript.Arguments(0)
End If

Select Case k
  Case 0 Call AkelPad.OpenFile(dFile)
  Case 1 Call WriteFile(dFile, fName)
  Case 2 Call WriteFile(dFile, fName) : Call AkelPad.OpenFile(dFile)
  Case 3 Call ClearFile(dFile, dPath, 1)
  Case 4 Call ClearFile(dFile, dPath, 2) : Call AkelPad.OpenFile(dFile)
End Select

' функция записи выделенного (или части строки) комментария
Sub WriteFile(fDesc, Name) tText = AkelPad.GetSelText()
  If Len(tText) = 0 Then tText = GetLineRight ' если ничего не выделено, выделяется строка вправо от курсора
  If Len(tText) = 0 Then WScript.Quit ' если ничего не выделено
  If InStr(tText, chr(13)) > 0 Then
    Txt = Split(tText, chr(13))
    iTxt = Name & " ' " & Join(Txt, "\n") & "\nВ"
  Else
    iTxt = Name & " ' " & tText & "\nВ" ' уберите из строки  & "\nВ"   если не нужен перенос в комментарии
  End If
  On Error Resume Next
  pText =  FSO.OpenTextFile(fDesc).ReadAll
  If Len(pText) > 0 Then
    List = Split(pText, vbNewLine)
    For i = 1 To Ubound(List) + 1
      If UCase(Name & Chr(32)) = UCase(Left(List(i - 1), Len(Name) + 1)) Then
        nS = i : Exit For
      End If
    Next
    If nS > 0 Then
      List(nS - 1) = iTxt : Text = Join(List, vbNewLine)
    Else
      Text = Join(List, vbNewLine)  & vbNewLine & iTxt
    End If
    Text = Selecting(Text)
  Else
    Text = iTxt & vbNewLine
  End If
  Text = Replace(Text, vbNewLine & vbNewLine, vbNewLine)
  FSO.OpenTextFile(fDesc, 2).Write Text
End Sub

Sub ClearFile(fD, dP, s)
  cList = Split(FSO.OpenTextFile(fD).ReadAll, vbNewLine)
  On Error Resume Next
  Set Folder = FSO.GetFolder(dP)
  For Each Files In Folder.Files
    nList = nList & Files.Name & " ;"
  Next

  For Each Folder In Folder.SubFolders
    nList = nList & Folder.Name & " ;"
  Next

  sLst = Split(nList, ";") : n = 0
  For i = 0 To Ubound(sLst) ' массив папок и файлов
    For j = 0 To Ubound(cList) ' массив комментариев
      If Len(cList(j)) > 0 And Len(sLst(i)) > 0Then
        if UCase(sLst(i)) = UCase(Left(cList(j), Len(sLst(i)))) Then
          n = 1 : oText = oText & cList(j)  & vbNewLine : cList(j) = "" : Exit For
        End If
      End If
    Next
    If n = 0 Then noText = noText & sLst(i) & vbNewLine : n = 0
  Next

  oText = Selecting(oText)
  If s = 1 Then
    FSO.OpenTextFile(fD, 2).Write oText
  Else
    For i = 0 To Ubound(cList)
      If Len(cList(i)) > 0 Then mText = mText & cList(i) & vbNewLine
    Next
    noText = "Для этих файлов\папок комментарии не установлены" & vbNewLine & String(90, "-") & vbNewLine & Selecting(noText)
    mText = "Комментарии для этих файлов\папок установлены, но файлов\папок нет" & vbNewLine & String(90, "-") & vbNewLine & Selecting(mText)

    Call ReplSel(oText) : Call ReplSel(noText) : Call ReplSel(mText)
  End If
End Sub

Sub ReplSel(xText)
    With AkelPad
      Call .SendMessage(.GetMainWnd(), 273, 4101, 0)
      Call SetRedraw(.GetEditWnd(), False)
      Call .ReplaceSel(Replace(xText, vbNewLine & vbNewLine, vbNewLine))
      Call .SendMessage(.GetEditWnd(), 3087, False, 0)
      Call .SendMessage(.GetEditWnd(), 3079, 0, 0)
      Call .SetSel(0, 0)
      Call SetRedraw(.GetEditWnd(), True)
    End With
End Sub