// http://akelpad.sourceforge.net/forum/viewtopic.php?p=18278#18278
// Version: 1.5
// Author: Shengalts Aleksander aka Instructor
//
//
// Description(1033): Cycle switch between fonts.
// Description(1049):    .
//
// Arguments:
// -FontList="Name1,Style1,Size1|Name2,Style2,Size2|..."   -Font list:
//                                                            Name
//                                                              Font face, for example, "Courier". Unchanged, if empty.
//                                                            Style (one of the following):
//                                                              0  ignored.
//                                                              1  normal.
//                                                              2  bold.
//                                                              3  italic.
//                                                              4  bold italic.
//                                                            Size
//                                                              Font size. Unchanged, if 0.
// Usage:
// Call("Scripts::Main", 1, "FontSwitch.js", `-FontList="Courier New,0,10|MS Sans Serif,0,8|Arial,0,10"`)

//Arguments
var pFontList=AkelPad.GetArgValue("FontList", "");

//Variables
var hMainWnd=AkelPad.GetMainWnd();
var hWndEdit=AkelPad.GetEditWnd();
var lpLogFont;
var aFontStr;
var aFontItem;
var aFontList=[];
var pFontName="";
var nFontStyle=0;
var nFontSize=0;
var nWeight;
var nItalic;
var i;

if (hWndEdit && pFontList)
{
  //Current font
  if (lpLogFont=AkelPad.MemAlloc(92 /*sizeof(LOGFONTW)*/))
  {
    AkelPad.SendMessage(hMainWnd, 1233 /*AKD_GETFONTW*/, hWndEdit, lpLogFont);

    //Name
    pFontName=AkelPad.MemRead(_PtrAdd(lpLogFont, 28) /*offsetof(LOGFONTW, lfFaceName)*/, 1 /*DT_UNICODE*/);

    //Style
    nWeight=AkelPad.MemRead(_PtrAdd(lpLogFont, 16) /*offsetof(LOGFONTW, lfWeight)*/, 3 /*DT_DWORD*/);
    nItalic=AkelPad.MemRead(_PtrAdd(lpLogFont, 20) /*offsetof(LOGFONTW, lfItalic)*/, 5 /*DT_BYTE*/);
    if (nWeight == 700 /*FW_BOLD*/)
    {
      if (nItalic)
        nFontStyle=4 /*FS_FONTBOLDITALIC*/;
      else
        nFontStyle=2 /*FS_FONTBOLD*/;
    }
    else
    {
      if (nItalic)
        nFontStyle=3 /*FS_FONTITALIC*/;
      else
        nFontStyle=1 /*FS_FONTNORMAL*/;
    }

    //Size
    nFontSize=AkelPad.SendMessage(hWndEdit, 3188 /*AEM_GETCHARSIZE*/, 3 /*AECS_POINTSIZE*/, 0);
    AkelPad.MemFree(lpLogFont);
  }

  if (pFontName && nFontSize)
  {
    if (aFontStr=pFontList.split("|"))
    {
      //Parse list
      for (i=0; i < aFontStr.length; ++i)
      {
        if ((aFontItem=aFontStr[i].split(",")) && aFontItem.length == 3)
        {
          aFontList[i]=[];
          aFontList[i].Name=aFontItem[0];
          aFontList[i].Style=parseInt(aFontItem[1]);
          aFontList[i].Size=parseInt(aFontItem[2]);
        }
      }

      //Find current font in list
      for (i=0; i < aFontList.length; ++i)
      {
        if ((!aFontList[i].Name || aFontList[i].Name == pFontName) &&
            (!aFontList[i].Style || aFontList[i].Style == nFontStyle) &&
            (!aFontList[i].Size || aFontList[i].Size == nFontSize))
          break;
      }

      //Set next font
      if (++i >= aFontList.length) i=0;
      AkelPad.Font(aFontList[i].Name, aFontList[i].Style, aFontList[i].Size);
    }
  }
}
