﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=1854#1854
// Description(1033): Remove all HTML tags...
// Description(1049): Удаляет все тэги, превращая HTML-документ в простой текстовый файл
// Version: 3.5 (2011.03.22)
// Author: VladSh

if (! AkelPad.Include("selCompleteLine.js")) WScript.Quit();
oCh.runWithRedraw();

function process() {
   oCh.Text = oCh.getSelTextAll();
   
   oCh.Text = oStr.cleanbyBorders(oCh.Text, '<script', '\\/script>');		//корректно чистим скрипты, чтобы не оставались хвосты
   
   oCh.Text = oCh.Text.replace(/<[^>]*>/g, '');		//чистим другие HTML-тэги
   
   oCh.Text = oCh.Text.replace(/&nbsp;/g, ' ');
   oCh.Text = oCh.Text.replace(/&quot;/g, '"');
   oCh.Text = oCh.Text.replace(/&amp;/g, '&');
   oCh.Text = oCh.Text.replace(/&lt;/g, '<');
   oCh.Text = oCh.Text.replace(/&gt;/g, '>');
   
   oCh.Text = oCh.Text.replace(/&ndash;/g, '-');
   oCh.Text = oCh.Text.replace(/&mdash;/g, '—');
   
   oCh.Text = oCh.Text.replace(/&lsquo;/g, '‘');		//левая одиночная кавычка
   oCh.Text = oCh.Text.replace(/&rsquo;/g, '’');		//правая одиночная кавычка
   oCh.Text = oCh.Text.replace(/&sbquo;/g, '‚');		//нижняя одиночная кавычка
   oCh.Text = oCh.Text.replace(/&ldquo;/g, '“');		//левая двойная кавычка
   oCh.Text = oCh.Text.replace(/&rdquo;/g, '”');		//правая двойная кавычка
   oCh.Text = oCh.Text.replace(/&bdquo;/g, '„');
   
   oStr.flags = "gm";
   oCh.Text = oStr.trim(oCh.Text, " \t");				//чистим строки от кучи пустых пробелов и табуляций
   
   oCh.Text = oCh.Text.replace(/\r{3,}/gm, '\r\r');	//гасим ненужные переводы строк
}