﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=7969#7969
// Description(1033): Select the word or link at the cursor position. Script implemented as the library for using in other scripts.
// Description(1049): Библиотека функций для выделения текущего слова или ссылки.
// Version: 3.0 (2015.01.15)
// Author: VladSh

// Возвращает границы слова, на котором установлена каретка
// используется алгоритм от FeyFre: http://akelpad.sourceforge.net/forum/viewtopic.php?p=7973#7973
function getWordCaretInfo(hWndEdit) {
	if (hWndEdit) {
		var nCaretPos = AkelPad.GetSelStart();
		var crInfo = [];
		crInfo.min = AkelPad.SendMessage(hWndEdit, 1100 /*EM_FINDWORDBREAK */, 0/*WB_LEFT*/, nCaretPos);
		crInfo.max = AkelPad.SendMessage(hWndEdit, 1100 /*EM_FINDWORDBREAK */, 7/*WB_RIGHTBREAK*/, crInfo.min);
		//! For case when caret located on word start position i.e. "prev-word |word-to-copy"
		if (crInfo.max < nCaretPos) {
			crInfo.min = AkelPad.SendMessage(hWndEdit, 1100/*EM_FINDWORDBREAK*/, 0/*WB_LEFT*/, nCaretPos + 1);
			crInfo.max = AkelPad.SendMessage(hWndEdit, 1100/*EM_FINDWORDBREAK*/, 7/*WB_RIGHTBREAK*/, crInfo.min);
		}
		if (crInfo.max >= nCaretPos)
			return crInfo;
	}
}

// Возвращает текст слова, на котором установлена каретка
function getWordCaret() {
	var sResult = "";
	var hWndEdit = AkelPad.GetEditWnd();
	var crInfo = getWordCaretInfo(hWndEdit);
	if (crInfo) sResult = AkelPad.GetTextRange(crInfo.min, crInfo.max);
	return sResult;
}

// Выделяет слово, на котором установлена каретка
function WordCaretSelect() {
	var bSelected = false;
	var hWndEdit = AkelPad.GetEditWnd();
	var crInfo = getWordCaretInfo(hWndEdit);
	if (crInfo) {
		if (crInfo) AkelPad.SetSel(crInfo.min, crInfo.max);
		bSelected = true;
	}
	return bSelected;
}


// Возвращает границы ссылки, на которой установлена каретка
// код KDJ, VladSh, Instructor; начиная отсюда: http://akelpad.sourceforge.net/forum/viewtopic.php?p=19312#19312
function getLinkCaretInfo(hWndEdit) {
	if (hWndEdit) {
		var bResult = false;
		var lpCaret;
		var lpInfo;
		var crInfo = [];
		if (lpCaret = AkelPad.MemAlloc(_X64 ? 24 : 12 /*sizeof(AECHARINDEX)*/)) {
			AkelPad.SendMessage(hWndEdit, 3130 /*AEM_GETINDEX*/, 5 /*AEGI_CARETCHAR*/, lpCaret);
			if (lpInfo = AkelPad.MemAlloc(_X64 ? 48 : 24 /*sizeof(AECHARInfo)*/)) {
				if (AkelPad.SendMessage(hWndEdit, 3149 /*AEM_INDEXINURL*/, lpCaret, lpInfo)) {
					crInfo.min = AkelPad.SendMessage(hWndEdit, 3136 /*AEM_INDEXTORICHOFFSET*/, 0, lpInfo);
					crInfo.max = AkelPad.SendMessage(hWndEdit, 3136 /*AEM_INDEXTORICHOFFSET*/, 0, lpInfo + (_X64 ? 24 : 12) /*offsetof(AECHARInfo, ciMax)*/);
					bResult = true;
				}
				AkelPad.MemFree(lpInfo);
			}
			AkelPad.MemFree(lpCaret);
		}
		if (bResult)
			return crInfo;
	}
}

// Возвращает текст ссылки, на которой установлена каретка
function getLinkCaret() {
	var sResult = "";
	var hWndEdit = AkelPad.GetEditWnd();
	var crInfo = getLinkCaretInfo(hWndEdit);
	if (crInfo) sResult = AkelPad.GetTextRange(crInfo.min, crInfo.max);
	return sResult;
}

// Выделяет ссылку, на которой установлена каретка
function LinkCaretSelect() {
	var bSelected = false;
	var hWndEdit = AkelPad.GetEditWnd();
	var crInfo = getLinkCaretInfo(hWndEdit);
	if (crInfo) {
		if (crInfo) AkelPad.SetSel(crInfo.min, crInfo.max);
		bSelected = true;
	}
	return bSelected;
}


// Открывает файл по заданному пути ищет в нём определённое вхождение ВЫДЕЛЕННОГО ТЕКСТА.
function openHelpString(pFileInAkelDirPath, pSearchText, nCycles) {
	if (!pSearchText) {
		pSearchText = getWordCaret();
	}
	
	var pFile = AkelPad.GetAkelDir() + pFileInAkelDirPath;
	
	var fso = new ActiveXObject("Scripting.FileSystemObject");
	if (fso.FileExists(pFile) == false)
		WScript.Quit();
	
	AkelPad.OpenFile(pFile);
	if (pSearchText) {
		AkelPad.SetSel(0, 0);
		for (var n = nCycles; n > 0; n--) {
			AkelPad.TextFind(AkelPad.GetEditWnd(), pSearchText, 0x00000002 /*FR_WHOLEWORD*/ + 0x00000001 /*FR_DOWN*/);
		}
	}
}