﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=1387#1387
// Description(1033): Working with time and date; return it in specified format. Script implemented as the library for using in other scripts.
// Description(1049): Библиотека функций для работы с датами; возвращает дату/время в определённом формате.
// Version: 2.1 (2011.07.20)
// Author: VladSh
// Initial code: © Instructor
// 
//// 以指定格式插入日期和时间。
//
// 时间:
// h   单个数字时无前导零的小时；12小时制。
// hh  单个数字时有前导零的小时；12小时制。
// H   单个数字时无前导零的小时；24小时制。
// HH  单个数字时有前导零的小时；24小时制。
// m   单个数字时无前导零的分。
// mm  单个数字时有前导零的分。
// s   单个数字时无前导零的秒。
// ss  单个数字时有前导零的秒。
// t   一个字符时间标记字符串，如 A 或 P。
// tt  多个字符时间标记字符串，如 AM 或 PM。
//
// 日期:
// d     单个数字时无前导零的月份中的天。
// dd    单个数字时有前导零的月份中的天。
// ddd   三个字母缩写的星期。
// dddd  完整名称的星期。
// M     单个数字时无前导零的月。
// MM    单个数字时有前导零的月。
// MMM   三个字母缩写的月。
// MMMM  完整名称的月。
// y     最后两位数的年，但若年小于 10 时无前导零。
// yy    最后两位数的年，但若年小于 10 时有前导零。
// yyyy  完整四位数字的年。
//
// 例:
// "H:mm:ss dd MMMM yyyy" -> "12:50:24 07 January 2008"

function DateFormat(pFormat)
{
  if (AkelPad.GetMainWnd())
  {
    if (!pFormat)
      pFormat = AkelPad.GetArgLine() || "H:mm dd.MM.yyyy";    //default value

    return TimeFormat(pFormat);
  }
}


function TimeFormat(pFormat)
{
  var oSys=AkelPad.SystemFunction();
  var lpFormatBuffer;
  var lpTimeBuffer;
  var pTime="";

  if (lpFormatBuffer=AkelPad.MemAlloc(256 * _TSIZE))
  {
    AkelPad.MemCopy(lpFormatBuffer, pFormat.substr(0, 255), _TSTR);

    if (lpTimeBuffer=AkelPad.MemAlloc(256 * _TSIZE))
    {
      oSys.Call("kernel32::GetTimeFormat" + _TCHAR, 1024 /*LOCALE_USER_DEFAULT*/, 0, 0, lpFormatBuffer, lpTimeBuffer);
      oSys.Call("kernel32::GetDateFormat" + _TCHAR, 1024 /*LOCALE_USER_DEFAULT*/, 0, 0, lpTimeBuffer, lpFormatBuffer, 256);
      pTime=AkelPad.MemRead(lpFormatBuffer, _TSTR);

      AkelPad.MemFree(lpTimeBuffer);
    }
    AkelPad.MemFree(lpFormatBuffer);
  }
  return pTime;
}
