;
// KERNEL32.DLL constants
	DELETE_RIGHT					= 0x00010000;
	READ_CONTROL					= 0x00020000;
	WRITE_DAC						= 0x00040000;
	WRITE_OWNER						= 0x00080000;
	SYNCHRONIZE						= 0x00100000;
	STANDARD_RIGHTS_READ			= READ_CONTROL;
	STANDARD_RIGHTS_WRITE			= READ_CONTROL;
	STANDARD_RIGHTS_EXECUTE			= READ_CONTROL;
	STANDARD_RIGHTS_REQUIRED		= 0x000F0000;
	STANDARD_RIGHTS_ALL				= 0x001F0000;
	SPECIFIC_RIGHTS_ALL				= 0x0000FFFF;
	ACCESS_SYSTEM_SECURITY			= 0x01000000;
	MAXIMUM_ALLOWED					= 0x02000000;
	GENERIC_READ					= 0x80000000;
	GENERIC_WRITE					= 0x40000000;
	GENERIC_EXECUTE					= 0x20000000;
	GENERIC_ALL						= 0x10000000;
	PROCESS_TERMINATE				= 0x00000001;
	PROCESS_CREATE_THREAD			= 0x00000002;
	PROCESS_VM_OPERATION			= 0x00000008;
	PROCESS_VM_READ					= 0x00000010;
	PROCESS_VM_WRITE				= 0x00000020;
	PROCESS_DUP_HANDLE				= 0x00000040;
	PROCESS_CREATE_PROCESS			= 0x00000080;
	PROCESS_SET_QUOTA				= 0x00000100;
	PROCESS_SET_INFORMATION			= 0x00000200;
	PROCESS_QUERY_INFORMATION		= 0x00000400;
	PROCESS_ALL_ACCESS				= 0x001fffff;
	FILE_SHARE_READ					= 0x00000001;
	FILE_SHARE_WRITE				= 0x00000002;
	FILE_SHARE_DELETE				= 0x00000004;
// CreateFile actions
	CREATE_NEW					= 1;
	CREATE_ALWAYS				= 2;
	OPEN_EXISTING				= 3;
	OPEN_ALWAYS					= 4;
	TRUNCATE_EXISTING			= 5;
// OpenFile modes
	OF_READ							= 0x0000;
	OF_WRITE						= 0x0001;
	OF_READWRITE					= 0x0002;
	OF_SHARE_COMPAT					= 0x0000;
	OF_SHARE_EXCLUSIVE				= 0x0010;
	OF_SHARE_DENY_WRITE				= 0x0020;
	OF_SHARE_DENY_READ				= 0x0030;
	OF_SHARE_DENY_NONE				= 0x0040;
	OF_PARSE						= 0x0100;
	OF_DELETE						= 0x0200;
	OF_VERIFY						= 0x0400;
	OF_CANCEL						= 0x0800;
	OF_CREATE						= 0x1000;
	OF_PROMPT						= 0x2000;
	OF_EXIST						= 0x4000;
	OF_REOPEN						= 0x8000;
// SetFilePointer methods
	FILE_BEGIN						= 0;
	FILE_CURRENT					= 1;
	FILE_END						= 2;
// File attributes
	FILE_ATTRIBUTE_READONLY				= 0x001;
	FILE_ATTRIBUTE_HIDDEN				= 0x002;
	FILE_ATTRIBUTE_SYSTEM				= 0x004;
	FILE_ATTRIBUTE_DIRECTORY			= 0x010;
	FILE_ATTRIBUTE_ARCHIVE				= 0x020;
	FILE_ATTRIBUTE_NORMAL				= 0x080;
	FILE_ATTRIBUTE_TEMPORARY			= 0x100;
	FILE_ATTRIBUTE_COMPRESSED			= 0x800;
// File flags
	FILE_FLAG_WRITE_THROUGH					= 0x80000000;
	FILE_FLAG_OVERLAPPED					= 0x40000000;
	FILE_FLAG_NO_BUFFERING					= 0x20000000;
	FILE_FLAG_RANDOM_ACCESS					= 0x10000000;
	FILE_FLAG_SEQUENTIAL_SCAN				= 0x08000000;
	FILE_FLAG_DELETE_ON_CLOSE				= 0x04000000;
	FILE_FLAG_BACKUP_SEMANTICS				= 0x02000000;
	FILE_FLAG_POSIX_SEMANTICS				= 0x01000000;
// Notify filters
	FILE_NOTIFY_CHANGE_FILE_NAME			= 0x001;
	FILE_NOTIFY_CHANGE_DIR_NAME				= 0x002;
	FILE_NOTIFY_CHANGE_ATTRIBUTES			= 0x004;
	FILE_NOTIFY_CHANGE_SIZE					= 0x008;
	FILE_NOTIFY_CHANGE_LAST_WRITE			= 0x010;
	FILE_NOTIFY_CHANGE_SECURITY				= 0x100;
// File types
	FILE_TYPE_UNKNOWN				= 0;
	FILE_TYPE_DISK					= 1;
	FILE_TYPE_CHAR					= 2;
	FILE_TYPE_PIPE					= 3;
	FILE_TYPE_REMOTE				= 0x8000;
// LockFileEx flags
	LOCKFILE_FAIL_IMMEDIATELY		= 1;
	LOCKFILE_EXCLUSIVE_LOCK			= 2;
// MoveFileEx flags
	MOVEFILE_REPLACE_EXISTING			= 1;
	MOVEFILE_COPY_ALLOWED				= 2;
	MOVEFILE_DELAY_UNTIL_REBOOT			= 4;
	MOVEFILE_WRITE_THROUGH				= 8;
// FindFirstFileEx flags
	FIND_FIRST_EX_CASE_SENSITIVE		= 1;
// Device handles
	INVALID_HANDLE_VALUE				= -1;
	STD_INPUT_HANDLE					= -10;
	STD_OUTPUT_HANDLE					= -11;
	STD_ERROR_HANDLE					= -12;
// DuplicateHandle options
	DUPLICATE_CLOSE_SOURCE				= 1;
	DUPLICATE_SAME_ACCESS				= 2;
// File mapping acccess rights
	SECTION_QUERY						= 0x01;
	SECTION_MAP_WRITE					= 0x02;
	SECTION_MAP_READ					= 0x04;
	SECTION_MAP_EXECUTE					= 0x08;
	SECTION_EXTEND_SIZE					= 0x10;
	SECTION_ALL_ACCESS					= 0x000f001f;
	FILE_MAP_COPY						= SECTION_QUERY;
	FILE_MAP_WRITE						= SECTION_MAP_WRITE;
	FILE_MAP_READ						= SECTION_MAP_READ;
	FILE_MAP_ALL_ACCESS					= SECTION_ALL_ACCESS;
// File system flags
	FILE_CASE_SENSITIVE_SEARCH			= 0x0001;
	FILE_CASE_PRESERVED_NAMES			= 0x0002;
	FILE_UNICODE_ON_DISK				= 0x0004;
	FILE_PERSISTENT_ACLS				= 0x0008;
	FILE_FILE_COMPRESSION				= 0x0010;
	FILE_VOLUME_IS_COMPRESSED			= 0x8000;
	FS_CASE_IS_PRESERVED				= FILE_CASE_PRESERVED_NAMES;
	FS_CASE_SENSITIVE					= FILE_CASE_SENSITIVE_SEARCH;
	FS_UNICODE_STORED_ON_DISK			= FILE_UNICODE_ON_DISK;
	FS_PERSISTENT_ACLS					= FILE_PERSISTENT_ACLS;
// Drive types
	DRIVE_UNKNOWN				= 0;
	DRIVE_NO_ROOT_DIR			= 1;
	DRIVE_REMOVABLE				= 2;
	DRIVE_FIXED					= 3;
	DRIVE_REMOTE				= 4;
	DRIVE_CDROM					= 5;
	DRIVE_RAMDISK				= 6;
// Pipe modes
	PIPE_ACCESS_INBOUND			= 1;
	PIPE_ACCESS_OUTBOUND		= 2;
	PIPE_ACCESS_DUPLEX			= 3;
	PIPE_CLIENT_END				= 0;
	PIPE_SERVER_END				= 1;
	PIPE_WAIT					= 0;
	PIPE_NOWAIT					= 1;
	PIPE_READMODE_BYTE			= 0;
	PIPE_READMODE_MESSAGE		= 2;
	PIPE_TYPE_BYTE				= 0;
	PIPE_TYPE_MESSAGE			= 4;
	PIPE_UNLIMITED_INSTANCES	= 255;
// Global memory flags
	GMEM_FIXED									= 0x0000;
	GMEM_MOVEABLE								= 0x0002;
	GMEM_NOCOMPACT								= 0x0010;
	GMEM_NODISCARD								= 0x0020;
	GMEM_ZEROINIT								= 0x0040;
	GMEM_MODIFY									= 0x0080;
	GMEM_DISCARDABLE							= 0x0100;
	GMEM_NOT_BANKED								= 0x1000;
	GMEM_SHARE									= 0x2000;
	GMEM_DDESHARE								= 0x2000;
	GMEM_NOTIFY									= 0x4000;
	GMEM_LOWER									= GMEM_NOT_BANKED;
	GMEM_VALID_FLAGS							= 0x7F72;
	GMEM_INVALID_HANDLE							= 0x8000;
	GMEM_DISCARDED								= 0x4000;
	GMEM_LOCKCOUNT								= 0x0FF;
	GHND										= 0x00000042;
	GPTR										= 0x00000040;
// Local memory flags
	LMEM_FIXED									= 0x0000;
	LMEM_MOVEABLE								= 0x0002;
	LMEM_NOCOMPACT								= 0x0010;
	LMEM_NODISCARD								= 0x0020;
	LMEM_ZEROINIT								= 0x0040;
	LMEM_MODIFY									= 0x0080;
	LMEM_DISCARDABLE							= 0x0F00;
	LMEM_VALID_FLAGS							= 0x0F72;
	LMEM_INVALID_HANDLE							= 0x8000;
	LHND										= 0x00000042;
	LPTR										= 0x00000040;
	LMEM_DISCARDED								= 0x4000;
	LMEM_LOCKCOUNT								= 0x00FF;
// Page access flags
	PAGE_NOACCESS								= 0x001;
	PAGE_READONLY								= 0x002;
	PAGE_READWRITE								= 0x004;
	PAGE_WRITECOPY								= 0x008;
	PAGE_EXECUTE								= 0x010;
	PAGE_EXECUTE_READ							= 0x020;
	PAGE_EXECUTE_READWRITE						= 0x040;
	PAGE_EXECUTE_WRITECOPY						= 0x080;
	PAGE_GUARD									= 0x100;
	PAGE_NOCACHE								= 0x200;
// Memory allocation flags
	MEM_COMMIT									= 0x001000;
	MEM_RESERVE									= 0x002000;
	MEM_DECOMMIT								= 0x004000;
	MEM_RELEASE									= 0x008000;
	MEM_FREE									= 0x010000;
	MEM_PRIVATE									= 0x020000;
	MEM_MAPPED									= 0x040000;
	MEM_RESET									= 0x080000;
	MEM_TOP_DOWN								= 0x100000;
// Heap allocation flags
	HEAP_NO_SERIALIZE					= 1;
	HEAP_GENERATE_EXCEPTIONS			= 4;
	HEAP_ZERO_MEMORY					= 8;
// Platform identifiers
	VER_PLATFORM_WIN32s						= 0;
	VER_PLATFORM_WIN32_WINDOWS				= 1;
	VER_PLATFORM_WIN32_NT					= 2;
// GetBinaryType return values
	SCS_32BIT_BINARY		= 0;
	SCS_DOS_BINARY			= 1;
	SCS_WOW_BINARY			= 2;
	SCS_PIF_BINARY			= 3;
	SCS_POSIX_BINARY		= 4;
	SCS_OS216_BINARY		= 5;
// CreateProcess flags
	DEBUG_PROCESS					= 0x001;
	DEBUG_ONLY_THIS_PROCESS			= 0x002;
	CREATE_SUSPENDED				= 0x004;
	DETACHED_PROCESS				= 0x008;
	CREATE_NEW_CONSOLE				= 0x010;
	NORMAL_PRIORITY_CLASS			= 0x020;
	IDLE_PRIORITY_CLASS				= 0x040;
	HIGH_PRIORITY_CLASS				= 0x080;
	REALTIME_PRIORITY_CLASS			= 0x100;
	CREATE_NEW_PROCESS_GROUP		= 0x200;
	CREATE_SEPARATE_WOW_VDM			= 0x800;
// Thread priority values
	THREAD_BASE_PRIORITY_MIN					= -2;
	THREAD_BASE_PRIORITY_MAX					= 2;
	THREAD_BASE_PRIORITY_LOWRT					= 15;
	THREAD_BASE_PRIORITY_IDLE					= -15;
	THREAD_PRIORITY_LOWEST						= THREAD_BASE_PRIORITY_MIN;
	THREAD_PRIORITY_BELOW_NORMAL				= THREAD_PRIORITY_LOWEST + 1;
	THREAD_PRIORITY_NORMAL						= 0;
	THREAD_PRIORITY_HIGHEST						= THREAD_BASE_PRIORITY_MAX;
	THREAD_PRIORITY_ABOVE_NORMAL				= THREAD_PRIORITY_HIGHEST - 1;
	THREAD_PRIORITY_ERROR_RETURN				= 0x7FFFFFFF;
	THREAD_PRIORITY_TIME_CRITICAL				= THREAD_BASE_PRIORITY_LOWRT;
	THREAD_PRIORITY_IDLE						= THREAD_BASE_PRIORITY_IDLE;
// Startup flags
	STARTF_USESHOWWINDOW		= 0x001;
	STARTF_USESIZE				= 0x002;
	STARTF_USEPOSITION			= 0x004;
	STARTF_USECOUNTCHARS		= 0x008;
	STARTF_USEFILLATTRIBUTE		= 0x010;
	STARTF_RUNFULLSCREEN		= 0x020;
	STARTF_FORCEONFEEDBACK		= 0x040;
	STARTF_FORCEOFFFEEDBACK		= 0x080;
	STARTF_USESTDHANDLES		= 0x100;
// Shutdown flags
	SHUTDOWN_NORETRY			= 0x1;
// LoadLibraryEx flags
	DONT_RESOLVE_DLL_REFERENCES			= 1;
	LOAD_LIBRARY_AS_DATAFILE			= 2;
	LOAD_WITH_ALTERED_SEARCH_PATH		= 8;
// DLL entry-point calls
	DLL_PROCESS_DETACH			= 0;
	DLL_PROCESS_ATTACH			= 1;
	DLL_THREAD_ATTACH			= 2;
	DLL_THREAD_DETACH			= 3;
// Status codes
	STATUS_WAIT_0						= 0x000000000;
	STATUS_ABANDONED_WAIT_0				= 0x000000080;
	STATUS_USER_APC						= 0x0000000C0;
	STATUS_TIMEOUT						= 0x000000102;
	STATUS_PENDING						= 0x000000103;
	STATUS_DATATYPE_MISALIGNMENT		= 0x080000002;
	STATUS_BREAKPOINT					= 0x080000003;
	STATUS_SINGLE_STEP					= 0x080000004;
	STATUS_ACCESS_VIOLATION				= 0x0C0000005;
	STATUS_IN_PAGE_ERROR				= 0x0C0000006;
	STATUS_NO_MEMORY					= 0x0C0000017;
	STATUS_ILLEGAL_INSTRUCTION			= 0x0C000001D;
	STATUS_NONCONTINUABLE_EXCEPTION		= 0x0C0000025;
	STATUS_INVALID_DISPOSITION			= 0x0C0000026;
	STATUS_ARRAY_BOUNDS_EXCEEDED		= 0x0C000008C;
	STATUS_FLOAT_DENORMAL_OPERAND		= 0x0C000008D;
	STATUS_FLOAT_DIVIDE_BY_ZERO			= 0x0C000008E;
	STATUS_FLOAT_INEXACT_RESULT			= 0x0C000008F;
	STATUS_FLOAT_INVALID_OPERATION		= 0x0C0000090;
	STATUS_FLOAT_OVERFLOW				= 0x0C0000091;
	STATUS_FLOAT_STACK_CHECK			= 0x0C0000092;
	STATUS_FLOAT_UNDERFLOW				= 0x0C0000093;
	STATUS_INTEGER_DIVIDE_BY_ZERO		= 0x0C0000094;
	STATUS_INTEGER_OVERFLOW				= 0x0C0000095;
	STATUS_PRIVILEGED_INSTRUCTION		= 0x0C0000096;
	STATUS_STACK_OVERFLOW				= 0x0C00000FD;
	STATUS_CONTROL_C_EXIT				= 0x0C000013A;
	WAIT_FAILED							= -1;
	WAIT_OBJECT_0						= STATUS_WAIT_0;
	WAIT_ABANDONED						= STATUS_ABANDONED_WAIT_0;
	WAIT_ABANDONED_0					= STATUS_ABANDONED_WAIT_0;
	WAIT_TIMEOUT						= STATUS_TIMEOUT;
	WAIT_IO_COMPLETION					= STATUS_USER_APC;
	STILL_ACTIVE						= STATUS_PENDING;
// Exception codes
	EXCEPTION_CONTINUABLE					= 0;
	EXCEPTION_NONCONTINUABLE				= 1;
	EXCEPTION_ACCESS_VIOLATION				= STATUS_ACCESS_VIOLATION;
	EXCEPTION_DATATYPE_MISALIGNMENT			= STATUS_DATATYPE_MISALIGNMENT;
	EXCEPTION_BREAKPOINT					= STATUS_BREAKPOINT;
	EXCEPTION_SINGLE_STEP					= STATUS_SINGLE_STEP;
	EXCEPTION_ARRAY_BOUNDS_EXCEEDED			= STATUS_ARRAY_BOUNDS_EXCEEDED;
	EXCEPTION_FLT_DENORMAL_OPERAND			= STATUS_FLOAT_DENORMAL_OPERAND;
	EXCEPTION_FLT_DIVIDE_BY_ZERO			= STATUS_FLOAT_DIVIDE_BY_ZERO;
	EXCEPTION_FLT_INEXACT_RESULT			= STATUS_FLOAT_INEXACT_RESULT;
	EXCEPTION_FLT_INVALID_OPERATION			= STATUS_FLOAT_INVALID_OPERATION;
	EXCEPTION_FLT_OVERFLOW					= STATUS_FLOAT_OVERFLOW;
	EXCEPTION_FLT_STACK_CHECK				= STATUS_FLOAT_STACK_CHECK;
	EXCEPTION_FLT_UNDERFLOW					= STATUS_FLOAT_UNDERFLOW;
	EXCEPTION_INT_DIVIDE_BY_ZERO			= STATUS_INTEGER_DIVIDE_BY_ZERO;
	EXCEPTION_INT_OVERFLOW					= STATUS_INTEGER_OVERFLOW;
	EXCEPTION_ILLEGAL_INSTRUCTION			= STATUS_ILLEGAL_INSTRUCTION;
	EXCEPTION_PRIV_INSTRUCTION				= STATUS_PRIVILEGED_INSTRUCTION;
	EXCEPTION_IN_PAGE_ERROR					= STATUS_IN_PAGE_ERROR;
// Registry options
	REG_OPTION_RESERVED							= 0;
	REG_OPTION_NON_VOLATILE						= 0;
	REG_OPTION_VOLATILE							= 1;
	REG_OPTION_CREATE_LINK						= 2;
	REG_OPTION_BACKUP_RESTORE					= 4;
	REG_CREATED_NEW_KEY							= 1;
	REG_OPENED_EXISTING_KEY						= 2;
	REG_WHOLE_HIVE_VOLATILE						= 1;
	REG_REFRESH_HIVE							= 2;
	REG_NOTIFY_CHANGE_NAME						= 1;
	REG_NOTIFY_CHANGE_ATTRIBUTES				= 2;
	REG_NOTIFY_CHANGE_LAST_SET					= 4;
	REG_NOTIFY_CHANGE_SECURITY					= 8;
	REG_LEGAL_CHANGE_FILTER						= 0x0000000F;
	REG_LEGAL_OPTION							= 0x0000000F;
	REG_NONE									= 0;
	REG_SZ										= 1;
	REG_EXPAND_SZ								= 2;
	REG_BINARY									= 3;
	REG_DWORD									= 4;
	REG_DWORD_LITTLE_ENDIAN						= 4;
	REG_DWORD_BIG_ENDIAN						= 5;
	REG_LINK									= 6;
	REG_MULTI_SZ								= 7;
	REG_RESOURCE_LIST							= 8;
	REG_FULL_RESOURCE_DESCRIPTOR				= 9;
	REG_RESOURCE_REQUIREMENTS_LIST				= 10;
// Registry access modes
	KEY_QUERY_VALUE									= 1;
	KEY_SET_VALUE									= 2;
	KEY_CREATE_SUB_KEY								= 4;
	KEY_ENUMERATE_SUB_KEYS							= 8;
	KEY_NOTIFY										= 0x10;
	KEY_CREATE_LINK									= 0x20;
	KEY_READ										= 0x00020019;
	KEY_WRITE										= 0x00020006;
	KEY_EXECUTE										= KEY_READ;
	KEY_ALL_ACCESS									= 0x000f003f;
// Predefined registry keys
	HKEY_CLASSES_ROOT						= 0x80000000;
	HKEY_CURRENT_USER						= 0x80000001;
	HKEY_LOCAL_MACHINE						= 0x80000002;
	HKEY_USERS								= 0x80000003;
	HKEY_PERFORMANCE_DATA					= 0x80000004;
	HKEY_CURRENT_CONFIG						= 0x80000005;
	HKEY_DYN_DATA							= 0x80000006;
// FormatMessage flags
	FORMAT_MESSAGE_ALLOCATE_BUFFER			= 0x0100;
	FORMAT_MESSAGE_IGNORE_INSERTS			= 0x0200;
	FORMAT_MESSAGE_FROM_STRING				= 0x0400;
	FORMAT_MESSAGE_FROM_HMODULE				= 0x0800;
	FORMAT_MESSAGE_FROM_SYSTEM				= 0x1000;
	FORMAT_MESSAGE_ARGUMENT_ARRAY			= 0x2000;
	FORMAT_MESSAGE_MAX_WIDTH_MASK			= 0x00FF;
// Language identifiers
	LANG_NEUTRAL								= 0x00;
	LANG_BULGARIAN								= 0x02;
	LANG_CHINESE								= 0x04;
	LANG_CROATIAN								= 0x1A;
	LANG_CZECH									= 0x05;
	LANG_DANISH									= 0x06;
	LANG_DUTCH									= 0x13;
	LANG_ENGLISH								= 0x09;
	LANG_FINNISH								= 0x0B;
	LANG_FRENCH									= 0x0C;
	LANG_GERMAN									= 0x07;
	LANG_GREEK									= 0x08;
	LANG_HUNGARIAN								= 0x0E;
	LANG_ICELANDIC								= 0x0F;
	LANG_ITALIAN								= 0x10;
	LANG_JAPANESE								= 0x11;
	LANG_KOREAN									= 0x12;
	LANG_NORWEGIAN								= 0x14;
	LANG_POLISH									= 0x15;
	LANG_PORTUGUESE								= 0x16;
	LANG_ROMANIAN								= 0x18;
	LANG_RUSSIAN								= 0x19;
	LANG_SLOVAK									= 0x1B;
	LANG_SLOVENIAN								= 0x24;
	LANG_SPANISH								= 0x0A;
	LANG_SWEDISH								= 0x1D;
	LANG_THAI									= 0x1E;
	LANG_TURKISH								= 0x1F;
// Sublanguage identifiers
	SUBLANG_NEUTRAL								= 0x00 * 0x0400;
	SUBLANG_DEFAULT								= 0x01 * 0x0400;
	SUBLANG_SYS_DEFAULT							= 0x02 * 0x0400;
	SUBLANG_CHINESE_TRADITIONAL					= 0x01 * 0x0400;
	SUBLANG_CHINESE_SIMPLIFIED					= 0x02 * 0x0400;
	SUBLANG_CHINESE_HONGKONG					= 0x03 * 0x0400;
	SUBLANG_CHINESE_SINGAPORE					= 0x04 * 0x0400;
	SUBLANG_DUTCH								= 0x01 * 0x0400;
	SUBLANG_DUTCH_BELGIAN						= 0x02 * 0x0400;
	SUBLANG_ENGLISH_US							= 0x01 * 0x0400;
	SUBLANG_ENGLISH_UK							= 0x02 * 0x0400;
	SUBLANG_ENGLISH_AUS							= 0x03 * 0x0400;
	SUBLANG_ENGLISH_CAN							= 0x04 * 0x0400;
	SUBLANG_ENGLISH_NZ							= 0x05 * 0x0400;
	SUBLANG_ENGLISH_EIRE						= 0x06 * 0x0400;
	SUBLANG_FRENCH								= 0x01 * 0x0400;
	SUBLANG_FRENCH_BELGIAN						= 0x02 * 0x0400;
	SUBLANG_FRENCH_CANADIAN						= 0x03 * 0x0400;
	SUBLANG_FRENCH_SWISS						= 0x04 * 0x0400;
	SUBLANG_GERMAN								= 0x01 * 0x0400;
	SUBLANG_GERMAN_SWISS						= 0x02 * 0x0400;
	SUBLANG_GERMAN_AUSTRIAN						= 0x03 * 0x0400;
	SUBLANG_ITALIAN								= 0x01 * 0x0400;
	SUBLANG_ITALIAN_SWISS						= 0x02 * 0x0400;
	SUBLANG_NORWEGIAN_BOKMAL					= 0x01 * 0x0400;
	SUBLANG_NORWEGIAN_NYNORSK					= 0x02 * 0x0400;
	SUBLANG_PORTUGUESE							= 0x02 * 0x0400;
	SUBLANG_PORTUGUESE_BRAZILIAN				= 0x01 * 0x0400;
	SUBLANG_SPANISH								= 0x01 * 0x0400;
	SUBLANG_SPANISH_MEXICAN						= 0x02 * 0x0400;
	SUBLANG_SPANISH_MODERN						= 0x03 * 0x0400;
// Sorting identifiers
	SORT_DEFAULT								= 0 * 0x010000;
	SORT_JAPANESE_XJIS							= 0 * 0x010000;
	SORT_JAPANESE_UNICODE						= 1 * 0x010000;
	SORT_CHINESE_BIG5							= 0 * 0x010000;
	SORT_CHINESE_PRCP							= 0 * 0x010000;
	SORT_CHINESE_UNICODE						= 1 * 0x010000;
	SORT_CHINESE_PRC							= 2 * 0x010000;
	SORT_CHINESE_BOPOMOFO						= 3 * 0x010000;
	SORT_KOREAN_KSC								= 0 * 0x010000;
	SORT_KOREAN_UNICODE							= 1 * 0x010000;
	SORT_GERMAN_PHONE_BOOK						= 1 * 0x010000;
	SORT_HUNGARIAN_DEFAULT						= 0 * 0x010000;
	SORT_HUNGARIAN_TECHNICAL					= 1 * 0x010000;
// Code pages
	CP_ACP								= 0					// default to ANSI code page;
	CP_OEMCP							= 1					// default to OEM code page;
	CP_MACCP							= 2					// default to MAC code page;
	CP_THREAD_ACP						= 3					// current thread's ANSI code page;
	CP_SYMBOL							= 42				// SYMBOL translations;
	CP_UTF7								= 65000				// UTF-7 translation;
	CP_UTF8								= 65001				// UTF-8 translation;
// Resource types
	RT_CURSOR			= 1;
	RT_BITMAP			= 2;
	RT_ICON				= 3;
	RT_MENU				= 4;
	RT_DIALOG			= 5;
	RT_STRING			= 6;
	RT_FONTDIR			= 7;
	RT_FONT				= 8;
	RT_ACCELERATOR		= 9;
	RT_RCDATA			= 10;
	RT_MESSAGETABLE		= 11;
	RT_GROUP_CURSOR		= 12;
	RT_GROUP_ICON		= 14;
	RT_VERSION			= 16;
	RT_DLGINCLUDE		= 17;
	RT_PLUGPLAY			= 19;
	RT_VXD				= 20;
	RT_ANICURSOR		= 21;
	RT_ANIICON			= 22;
	RT_HTML				= 23;
	RT_MANIFEST			= 24;
// Clipboard formats
	CF_TEXT						= 0x001;
	CF_BITMAP					= 0x002;
	CF_METAFILEPICT				= 0x003;
	CF_SYLK						= 0x004;
	CF_DIF						= 0x005;
	CF_TIFF						= 0x006;
	CF_OEMTEXT					= 0x007;
	CF_DIB						= 0x008;
	CF_PALETTE					= 0x009;
	CF_PENDATA					= 0x00A;
	CF_RIFF						= 0x00B;
	CF_WAVE						= 0x00C;
	CF_UNICODETEXT				= 0x00D;
	CF_ENHMETAFILE				= 0x00E;
	CF_HDROP					= 0x00F;
	CF_LOCALE					= 0x010;
	CF_OWNERDISPLAY				= 0x080;
	CF_DSPTEXT					= 0x081;
	CF_DSPBITMAP				= 0x082;
	CF_DSPMETAFILEPICT			= 0x083;
	CF_DSPENHMETAFILE			= 0x08E;
	CF_PRIVATEFIRST				= 0x200;
	CF_PRIVATELAST				= 0x2FF;
	CF_GDIOBJFIRST				= 0x300;
	CF_GDIOBJLAST				= 0x3FF;
// OS types for version info
	VOS_UNKNOWN				= 0x00000000;
	VOS_DOS					= 0x00010000;
	VOS_OS216				= 0x00020000;
	VOS_OS232				= 0x00030000;
	VOS_NT					= 0x00040000;
	VOS__BASE				= 0x00000000;
	VOS__WINDOWS16			= 0x00000001;
	VOS__PM16				= 0x00000002;
	VOS__PM32				= 0x00000003;
	VOS__WINDOWS32			= 0x00000004;
	VOS_DOS_WINDOWS16		= 0x00010001;
	VOS_DOS_WINDOWS32		= 0x00010004;
	VOS_OS216_PM16			= 0x00020002;
	VOS_OS232_PM32			= 0x00030003;
	VOS_NT_WINDOWS32		= 0x00040004;
// File types for version info
	VFT_UNKNOWN								= 0x00000000;
	VFT_APP									= 0x00000001;
	VFT_DLL									= 0x00000002;
	VFT_DRV									= 0x00000003;
	VFT_FONT								= 0x00000004;
	VFT_VXD									= 0x00000005;
	VFT_STATIC_LIB							= 0x00000007;
// File subtypes for version info
	VFT2_UNKNOWN						= 0x00000000;
	VFT2_DRV_PRINTER					= 0x00000001;
	VFT2_DRV_KEYBOARD					= 0x00000002;
	VFT2_DRV_LANGUAGE					= 0x00000003;
	VFT2_DRV_DISPLAY					= 0x00000004;
	VFT2_DRV_MOUSE						= 0x00000005;
	VFT2_DRV_NETWORK					= 0x00000006;
	VFT2_DRV_SYSTEM						= 0x00000007;
	VFT2_DRV_INSTALLABLE				= 0x00000008;
	VFT2_DRV_SOUND						= 0x00000009;
	VFT2_DRV_COMM						= 0x0000000A;
	VFT2_DRV_INPUTMETHOD				= 0x0000000B;
	VFT2_DRV_VERSIONED_PRINTER			= 0x0000000C;
	VFT2_FONT_RASTER					= 0x00000001;
	VFT2_FONT_VECTOR					= 0x00000002;
	VFT2_FONT_TRUETYPE					= 0x00000003;
// Console control signals
	CTRL_C_EVENT						= 0;
	CTRL_BREAK_EVENT					= 1;
	CTRL_CLOSE_EVENT					= 2;
	CTRL_LOGOFF_EVENT					= 5;
	CTRL_SHUTDOWN_EVENT					= 6;
// Standard file handles
	STD_INPUT_HANDLE					= 0x0FFFFFFF6;
	STD_OUTPUT_HANDLE					= 0x0FFFFFFF5;
	STD_ERROR_HANDLE					= 0x0FFFFFFF4;
