// http://akelpad.sourceforge.net/forum/viewtopic.php?p=23559#23559
// Version: 2015-03-19
// Author: KDJ
// 
// *** Right click on LineBoard panel, calls any script or ContextMenu::Show instead of LineBoard menu ***
// 
// Usage:
//   Call("Scripts::Main", 1, "LineBoardRClickPanel.js", '"ScriptOrMenu" "Parameters"')
// 
// Arguments (are optional):
//   "ScriptOrMenu"
//     script name or submenu defined in ContextMenu::Show, default is "LineBoardBookmarks.js"
//   "Parameters"
//     parameters passed to the script; if script is "LineBoardBookmarks.js", default parameter is "MM"
// 
// Notes:
//   After first call, the script resides in the memory.
//   Second script call, closes the script.
// 
// For autostart, in AkelPad.ini or registry CmdLineBegin/CmdLineEnd key, need to add eg:
//   /Call("Scripts::Main", 1, "LineBoardRClickPanel.js")
//     show menu from script LineBoardBookmarks.js at mouse cursor position
//   /Call("Scripts::Main", 1, "LineBoardRClickPanel.js", '"Bookmarks"')
//     show user submenu "Bookmarks" from ContextMenu plugin at cursor position
//       #menu example
//       "Bookmarks"
//       {
//         "Set bookmarks"
//         {
//           -"In selection" Call("Scripts::Main", 1, "LineBoardBookmarks.js", "BS")
//           -"All" Call("Scripts::Main", 1, "LineBoardBookmarks.js", "B")
//         }
//         "Delete bookmarks"
//         {
//           -"In selection" Call("Scripts::Main", 1, "LineBoardBookmarks.js", "US")
//           -"All" Call("Scripts::Main", 1, "LineBoardBookmarks.js", "U"')
//         }
//         "Inverse bookmarks"
//         {
//           -"In selection" Call("Scripts::Main", 1, "LineBoardBookmarks.js", "IS")
//           -"All" Call("Scripts::Main", 1, "LineBoardBookmarks.js", "I"')
//         }
//         SEPARATOR
//         "Settings" Call("LineBoard::Settings")
//       }

var hScript = AkelPad.ScriptHandle(WScript.ScriptName, 3 /*SH_FINDSCRIPT*/);

if (hScript && AkelPad.ScriptHandle(hScript, 13 /*SH_GETMESSAGELOOP*/))
{
  //script already is running, close it
  AkelPad.ScriptHandle(hScript, 33 /*SH_CLOSESCRIPT*/);
}
else
{
  var hSubClassEdit = AkelPad.WindowSubClass(2 /*WSC_EDITPROC*/, EditCallback, 123 /*WM_CONTEXTMENU*/);
  var sArg0, sArg1;
  var bMenu;

  if (hSubClassEdit)
  {
    if (WScript.Arguments.length)
    {
      sArg0 = WScript.Arguments(0).toUpperCase();

      if ((sArg0.slice(-3) == ".JS") || (sArg0.slice(-4) == ".VBS"))
      {
        if (WScript.Arguments.length > 1)
          sArg1 = WScript.Arguments(1);
        else if (sArg0 == "LINEBOARDBOOKMARKS.JS")
          sArg1 = "MM";
      }
      else
        bMenu = true;
    }
    else
    {
      sArg0 = "LineBoardBookmarks.js";
      sArg1 = "MM";
    }

    //Allow other scripts running
    AkelPad.ScriptNoMutex();

    //Message loop
    AkelPad.WindowGetMessage();

    AkelPad.WindowUnsubClass(2 /*WSC_EDITPROC*/);
  }
}

function EditCallback(hWnd, uMsg, wParam, lParam)
{
  if ((uMsg == 123 /*WM_CONTEXTMENU*/) && AkelPad.IsPluginRunning("LineBoard::Main") && IsRClickPanel(hWnd, lParam & 0xFFFF, (lParam >> 16) & 0xFFFF))
  {
    AkelPad.WindowNoNextProc(hSubClassEdit);

    if (bMenu)
      AkelPad.Call("ContextMenu::Show", 1, "-6", "-6", -1, sArg0);
    else
      AkelPad.Call("Scripts::Main", 1, sArg0, sArg1);

    AkelPad.WindowNoNextProc(hSubClassEdit);
  }

  return 0;
}

function IsRClickPanel(hWnd, nCursorX, nCursorY)
{
  var lpRect = AkelPad.MemAlloc(16 /*sizeof(RECT)*/);

  //get rectangle outside panels
  AkelPad.CallW("LineBoard::Main", 11, hWnd, 0, lpRect);

  AkelPad.SystemFunction().Call("User32::ClientToScreen", hWnd, lpRect);
  AkelPad.SystemFunction().Call("User32::ClientToScreen", hWnd, lpRect + 8);

  var nX = AkelPad.MemRead(_PtrAdd(lpRect,  0), 3 /*DT_DWORD*/);
  var nY = AkelPad.MemRead(_PtrAdd(lpRect,  4), 3 /*DT_DWORD*/);
  var nH = AkelPad.MemRead(_PtrAdd(lpRect, 12), 3 /*DT_DWORD*/);
  AkelPad.MemFree(lpRect);

  if ((nCursorX <= nX) && (nCursorY >= nY) && (nCursorY <= nH))
    return true;

  return false;
}
