// http://akelpad.sourceforge.net/forum/viewtopic.php?p=28437#28437
// Version: 1.1
// Author: Shengalts Aleksander aka Instructor
//
//
// Description(1033): Multiple clipboard.
// Description(1049):   .
//
// Arguments:
// -SaveID=1             -Save current clipboard in specified ID.
// -PasteID=1            -Paste text from saved ID.
// -SendKeys="^v"        -SendKeys to paste text. Most common combinations:
//                         "^v"     - Ctrl+V.
//                         "+{INS}" - Shift+Insert.
//                        Special values:
//                         "1"      - Ctrl+V via keybd_event (default).
//                         "2"      - Shift+Insert via keybd_event.
// -RestoreTimeout=100   -Sleep before restore clipboard after paste. Default is 100. If zero, don't restore clipboard.
// -DeleteID=0           -Delete saved IDs. If zero, delete all IDs.
//
// Usage (save clipboard):
// Call("Scripts::Main", 1, "MultiClipboard.js", `-SaveID=1`)
//
// Usage (paste clipboard):
// Call("Scripts::Main", 1, "MultiClipboard.js", `-PasteID=1`)

//Arguments
var nSaveID=AkelPad.GetArgValue("SaveID", -1);
var nPasteID=AkelPad.GetArgValue("PasteID", -1);
var pSendKeys=AkelPad.GetArgValue("SendKeys", "1");
var nRestoreTimeout=AkelPad.GetArgValue("RestoreTimeout", 100);
var nDeleteID=AkelPad.GetArgValue("DeleteID", -1);

//Variables
var oSys=AkelPad.SystemFunction();
var oSet=AkelPad.ScriptSettings();
var pPasteText;
var pClipboardText=AkelPad.GetClipboardText();

if (nSaveID != -1)
{
  if (oSet.Begin("", 0x2 /*POB_SAVE*/))
  {
    oSet.Write("ID" + nSaveID, 2 /*PO_BINARY*/, pClipboardText);
    oSet.End();
  }
}
if (nPasteID != -1)
{
  if (oSet.Begin("", 0x1 /*POB_READ*/))
  {
    pPasteText=oSet.Read("ID" + nPasteID, 20 /*PO_BINARYSTRING*/);
    AkelPad.SetClipboardText(pPasteText);

    if (pSendKeys == "1") //Ctrl+V
    {
      oSys.Call("user32::keybd_event", 0x11 /*VK_CONTROL*/, 0, 0x1 /*KEYEVENTF_EXTENDEDKEY*/, 0);
      oSys.Call("user32::keybd_event", 0x56 /*V*/, 0, 0x0, 0);
      oSys.Call("user32::keybd_event", 0x56 /*V*/, 0, 0x2 /*KEYEVENTF_KEYUP*/, 0);
      oSys.Call("user32::keybd_event", 0x11 /*VK_CONTROL*/, 0, 0x3 /*KEYEVENTF_EXTENDEDKEY|KEYEVENTF_KEYUP*/, 0);
    }
    else if (pSendKeys == "2") //Shift+Insert
    {
      oSys.Call("user32::keybd_event", 0x10 /*VK_SHIFT*/, 0, 0x1 /*KEYEVENTF_EXTENDEDKEY*/, 0);
      oSys.Call("user32::keybd_event", 0x2D /*VK_INSERT*/, 0, 0x1 /*KEYEVENTF_EXTENDEDKEY*/, 0);
      oSys.Call("user32::keybd_event", 0x2D /*VK_INSERT*/, 0, 0x3 /*KEYEVENTF_EXTENDEDKEY|KEYEVENTF_KEYUP*/, 0);
      oSys.Call("user32::keybd_event", 0x10 /*VK_SHIFT*/, 0, 0x3 /*KEYEVENTF_EXTENDEDKEY|KEYEVENTF_KEYUP*/, 0);
    }
    else
    {
      var WshShell=new ActiveXObject("WScript.shell");

      WshShell.SendKeys(pSendKeys);
    }

    if (nRestoreTimeout)
    {
      WScript.Sleep(nRestoreTimeout);
      AkelPad.SetClipboardText(pClipboardText);
    }
    oSet.End();
  }
}
if (nDeleteID != -1)
{
  if (nDeleteID)
  {
    if (oSet.Begin("", 0x2 /*POB_SAVE*/))
    {
      oSet.Delete("ID" + nDeleteID);
      oSet.End();
    }
  }
  else
  {
    if (oSet.Begin("", 0x6 /*POB_SAVE|POB_CLEAR*/))
    {
      oSet.End();
    }
  }
}
