// http://akelpad.sourceforge.net/forum/viewtopic.php?p=7137#7137
// Version: 2014-12-15
// Author: cnnnc
//
// *** Insert text or/and a sequence of Num/RandomNum to Begin or/and End of every line. ***

try
{
  var hMainWnd=AkelPad.GetMainWnd();
}
catch (oError)
{
  WScript.Quit();
}

var hWndEdit=AkelPad.GetEditWnd();

try{

var oSys        =AkelPad.SystemFunction();
var pScriptName =WScript.ScriptName;

var sStr  =AkelPad.GetArgValue("Str"  , "$1");
var bNum  =AkelPad.GetArgValue("Num"  ,    0);
var bRand =AkelPad.GetArgValue("Rand" ,    0);
var bLazy =AkelPad.GetArgValue("Lazy" ,    0);
var nFirst=AkelPad.GetArgValue("First",    1);
var nStep =AkelPad.GetArgValue("Step" ,    1);
var nWidth=AkelPad.GetArgValue("Width",    1);
var sPad  =AkelPad.GetArgValue("Pad"  ,  "0");

var bHex=false;

// Without GUI
if (AkelPad.GetArgLine(0))
{
  if (isNaN(nFirst))
  {
    nFirst=1;
  }
  if (isNaN(nStep))
  {
    nStep=1;
  }
  if (isNaN(nWidth))
  {
    nWidth=1;
  }

  if (bRand)
  {
    bNum=true;
  }

  NumberCount();
  WScript.Quit();
}

// With GUI
var hInstanceDLL=AkelPad.GetInstanceDll();
var pClassName  ="AkelPad::Scripts::"+pScriptName+"::"+oSys.Call("kernel32::GetCurrentProcessId");

var hWndDialog;
var lpBuffer;
var nStrings=10;
var lpStrings=[];
var oSet=AkelPad.ScriptSettings();

var nBegSelIn = 0;
var nEndSelIn = 0;
var nMaxLen   = 1024;

if (oSet.Begin(WScript.ScriptBaseName, 0x1 /*POB_READ*/))
{
  //Read settings
  bNum  =oSet.Read("Num"  , 1 /*PO_DWORD*/ );
  bRand =oSet.Read("Rand" , 1 /*PO_DWORD*/ );
  bLazy =oSet.Read("Lazy" , 1 /*PO_DWORD*/ );
  nFirst=oSet.Read("First", 3 /*PO_STRING*/, 1);
  nStep =oSet.Read("Step" , 3 /*PO_STRING*/, 1);
  nWidth=oSet.Read("Width", 1 /*PO_DWORD*/ , 1);
  sPad  =oSet.Read("Pad"  , 3 /*PO_STRING*/);

  //String
  for (i=0; i<nStrings; i+=1)
  {
    lpStrings[i]=oSet.Read("String"+i, 3 /*PO_STRING*/);
    if (typeof lpStrings[i]=="undefined")
    {
      break;
    }
  }

  if (typeof lpStrings[0]!="undefined")
  {
    sStr=lpStrings[0];
  }

  oSet.End();
}

if (typeof lpStrings[0]=="undefined")
{
  lpStrings[0]=sStr;
}

var sTxtStr           ="String";
var sTxtNum           ="Number";
var sTxtRand          ="Random";
var sTxtLazy          ="Lazy mode";
var sTxtFirst         ="First";
var sTxtStep          ="Step";
var sTxtEnd           ="End";
var sTxtWidth         ="Width";
var sTxtPad           ="Padding char";
var sTxtSeconds       ="Seconds";
var sTxtOK            ="OK";
var sTxtCancel        ="Cancel";
var sTxtBackSlace     ="backslash";
var sTxtReturn        ="return";
var sTxtLineFeed      ="line feed";
var sTxtTabulation    ="tabulation";
var sTxtNumberSequence="number sequence";
var sTxtHexNumSequence="Hex number sequence";
var sTxtOriginalLine  ="original line";
var sTxtEmpty         ="Empty";

var fso      =new ActiveXObject("Scripting.FileSystemObject");
var pLangFile=AkelPad.GetAkelDir(5)+ "\\Langs\\" + pScriptName.substring(0, pScriptName.lastIndexOf("."))+"_"+AkelPad.GetLangId().toString()+".lng";
var nError;

if (fso.FileExists(pLangFile))
{
  try
  {
    AkelPad.Include("..\\Langs\\"+pScriptName.substring(0, pScriptName.lastIndexOf("."))+"_"+AkelPad.GetLangId().toString()+".lng");
  }
  catch (nError)
  {
  }
}

var aWnd            =[];
var IDC_CBB_STR     =1000;
var IDC_STATIC_STR  =1001;
var IDC_SYNTEX      =1002;
var IDC_NUM         =1003;
var IDC_RAND        =1004;
var IDC_LAZY        =1005;
var IDC_STATIC_FIRST=1006;
var IDC_EDT_FIRST   =1007;
var IDC_STATIC_STEP =1008;
var IDC_EDT_STEP    =1009;
var IDC_STATIC_WIDTH=1010;
var IDC_EDT_WIDTH   =1011;
var IDC_STATIC_PAD  =1012;
var IDC_EDT_PAD     =1013;
var IDC_OK          =1014;
var IDC_CANCEL      =1015;

var WNDTYPE =0;
var WND     =1;
var WNDEXSTY=2;
var WNDSTY  =3;
var WNDX    =4;
var WNDY    =5;
var WNDW    =6;
var WNDH    =7;
var WNDTXT  =8;
//0x50000000 - WS_VISIBLE|WS_CHILD
//0x50010000 - WS_VISIBLE|WS_CHILD|WS_TABSTOP
//0x50010003 - WS_VISIBLE|WS_CHILD|WS_TABSTOP|BS_AUTOCHECKBOX
//0x50210042 - WS_VISIBLE|WS_CHILD|WS_TABSTOP|WS_VSCROLL|CBS_DROPDOWN|CBS_AUTOHSCROLL
//0x58010000 - WS_VISIBLE|WS_CHILD|WS_DISABLED|WS_TABSTOP|BS_PUSHBUTTON
//0x58010003 - WS_VISIBLE|WS_CHILD|WS_DISABLED|WS_TABSTOP|BS_AUTOCHECKBOX
//0x58010080 - WS_VISIBLE|WS_CHILD|WS_DISABLED|WS_TABSTOP|ES_AUTOHSCROLL
//Windows                WNDTYPE, WND, WNDEXSTY,     WNDSTY,WNDX,WNDY,WNDW,WNDH,           WNDTXT
aWnd[IDC_CBB_STR     ]=["COMBOBOX", 0,        0, 0x50210042,  95,   5, 228, 160,             sStr];
aWnd[IDC_STATIC_STR  ]=["STATIC",   0,        0, 0x50000000,   5,   8,  85,  20,          sTxtStr];
aWnd[IDC_SYNTEX      ]=["BUTTON",   0,        0, 0x50010000, 303,  30,  20,  20,            " > "];
aWnd[IDC_NUM         ]=["BUTTON",   0,        0, 0x50010003,   5,  33,  85,  20,          sTxtNum];
aWnd[IDC_RAND        ]=["BUTTON",   0,        0, 0x58010003, 100,  33,  85,  20,         sTxtRand];
aWnd[IDC_LAZY        ]=["BUTTON",   0,        0, 0x58010003, 190,  33,  85,  20,         sTxtLazy];
aWnd[IDC_STATIC_FIRST]=["STATIC",   0,        0, 0x50000000,   5,  58,  85,  20,        sTxtFirst];
aWnd[IDC_EDT_FIRST   ]=[  "EDIT",   0,    0x200, 0x58010080, 100,  55, 100,  20,           nFirst];
aWnd[IDC_STATIC_STEP ]=["STATIC",   0,        0, 0x50000000,   5,  83,  85,  20,         sTxtStep];
aWnd[IDC_EDT_STEP    ]=[  "EDIT",   0,    0x200, 0x58010080, 100,  80, 100,  20,            nStep];
aWnd[IDC_STATIC_WIDTH]=["STATIC",   0,        0, 0x50000000,   5, 108,  85,  20,        sTxtWidth];
aWnd[IDC_EDT_WIDTH   ]=[  "EDIT",   0,    0x200, 0x58010080, 100, 105, 100,  20,nWidth.toString()];
aWnd[IDC_STATIC_PAD  ]=["STATIC",   0,        0, 0x50000000,   5, 133, 145,  20,          sTxtPad];
aWnd[IDC_EDT_PAD     ]=[  "EDIT",   0,    0x200, 0x58010080, 150, 130,  50,  20,             sPad];
aWnd[IDC_OK          ]=["BUTTON",   0,        0, 0x58010000, 263, 105,  60,  20,           sTxtOK];
aWnd[IDC_CANCEL      ]=["BUTTON",   0,        0, 0x50010000, 263, 130,  60,  20,       sTxtCancel];

if (AkelPad.WindowRegisterClass(pClassName))
{
  lpBuffer=AkelPad.MemAlloc(nMaxLen * _TSIZE);
  if (lpBuffer)
  {
    //Create dialog
    hWndDialog=oSys.Call("user32::CreateWindowEx"+_TCHAR,
      0,               //dwExStyle
      pClassName,      //lpClassName
      0,               //lpWindowName
      0x90CA0000,      //WS_VISIBLE|WS_POPUP|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX
      0,               //x
      0,               //y
      333,             //nWidth
      180,             //nHeight
      hMainWnd,        //hWndParent
      0,               //ID
      hInstanceDLL,    //hInstance
      DialogCallback); //Script function callback. To use it class must be registered by WindowRegisterClass.

    if (hWndDialog)
    {
      //Allow other scripts running
      AkelPad.ScriptNoMutex();
      //Message loop
      AkelPad.WindowGetMessage();
    }
    AkelPad.MemFree(lpBuffer);
  }

  AkelPad.WindowUnregisterClass(pClassName);
}
else
{
  hWndDialog=oSys.Call("user32::FindWindowEx"+_TCHAR, 0, 0, pClassName, 0);
  if (hWndDialog)
  {
    if (oSys.Call("user32::IsIconic", hWndDialog))
    {
      oSys.Call("user32::ShowWindow", hWndDialog, 9 /*SW_RESTORE*/);
    }
    AkelPad.SendMessage(hWndDialog, 7 /*WM_SETFOCUS*/, 0, 0);
  }
}
}catch (oError)
{
  if (AkelPad.IsAkelEdit())
  {
    AkelPad.SendMessage(hWndEdit, 3185 /*AEM_LOCKSCROLL*/, 3 /*SB_BOTH*/, false);
  }
  SetRedraw(hWndEdit, true);
}


function DialogCallback(hWnd, uMsg, wParam)
{
  if (uMsg==1)  //WM_CREATE
  {
    var hGuiFont=oSys.Call("gdi32::GetStockObject", 17 /*DEFAULT_GUI_FONT*/);

    //Dialog caption
    oSys.Call("user32::SetWindowText"+_TCHAR, hWnd, pScriptName);

    //Create window
    for (i=1000, l=aWnd.length; i<l; i+=1)
    {
      aWnd[i][WND]=oSys.Call("user32::CreateWindowEx"+_TCHAR,
        aWnd[i][WNDEXSTY], //dwExStyle
        aWnd[i][WNDTYPE],  //lpClassName
        0,                 //lpWindowName
        aWnd[i][WNDSTY],   //dwStyle
        aWnd[i][WNDX],     //x
        aWnd[i][WNDY],     //y
        aWnd[i][WNDW],     //nWidth
        aWnd[i][WNDH],     //nHeight
        hWnd,              //hWndParent
        i,                 //ID
        hInstanceDLL,      //hInstance
        0);                //lpParam
      //Set font and text
      SetWindowFontAndText(aWnd[i][WND], hGuiFont, aWnd[i][WNDTXT]);
    }

    //Fill combobox
    for (i=0; i<nStrings && typeof lpStrings[i]!="undefined"; i+=1)
    {
      AkelPad.MemCopy(lpBuffer, lpStrings[i], _TSTR);
      AkelPad.SendMessage(aWnd[IDC_CBB_STR][WND], 0x143 /*CB_ADDSTRING*/, 0, lpBuffer);
    }
    AkelPad.SendMessage(aWnd[IDC_CBB_STR][WND], 0x14E /*CB_SETCURSEL*/, 0, 0);

    //Checks
    if (bNum)
    {
      AkelPad.SendMessage(aWnd[IDC_NUM][WND], 241 /*BM_SETCHECK*/, 1 /*BST_CHECKED*/, 0);
      EnableNumWin(bNum);
    }

    if (bRand)
    {
      AkelPad.SendMessage(aWnd[IDC_RAND][WND], 241 /*BM_SETCHECK*/, 1 /*BST_CHECKED*/, 0);
      oSys.Call("user32::SetWindowText"+_TCHAR, aWnd[IDC_STATIC_STEP][WND], sTxtEnd);
    }

    if (bLazy)
    {
      AkelPad.SendMessage(aWnd[IDC_LAZY][WND], 241 /*BM_SETCHECK*/, 1 /*BST_CHECKED*/, 0);
    }

    //Center dialog
    CenterWindow(hMainWnd, hWnd);
  }
  else if (uMsg==7)  //WM_SETFOCUS
  {
    oSys.Call("user32::SetFocus", aWnd[IDC_CBB_STR][WND]);
  }
  else if (uMsg==256)  //WM_KEYDOWN
  {
    if (wParam==27)    //VK_ESCAPE
    {
      //Escape key pushes Cancel button
      oSys.Call("user32::PostMessage"+_TCHAR, hWnd, 273 /*WM_COMMAND*/, IDC_CANCEL, 0);
    }
    else if (wParam==13)  //VK_RETURN
    {
      if (oSys.Call("user32::IsWindowEnabled", aWnd[IDC_OK][WND]))
      {
        //Return key pushes OK button
        oSys.Call("user32::PostMessage"+_TCHAR, hWnd, 273 /*WM_COMMAND*/, IDC_OK, 0);
      }
    }
  }
  else if (uMsg==273)  //WM_COMMAND
  {
    nLowParam = LoWord(wParam);
    nHiwParam = HiWord(wParam);
    bCloseCB1 = 1;

    if (nLowParam==IDC_NUM       ||
             nLowParam==IDC_CBB_STR   ||
             nLowParam==IDC_EDT_FIRST ||
             nLowParam==IDC_EDT_STEP  ||
             nLowParam==IDC_EDT_WIDTH)
    {
      if (nLowParam==IDC_NUM)
      {
        bNum=AkelPad.SendMessage(aWnd[IDC_NUM][WND], 240 /*BM_GETCHECK*/, 0, 0);
        EnableNumWin(bNum);
      }
      else if (nLowParam == IDC_CBB_STR)
      {
        if (nHiwParam == 3 /*CBN_SETFOCUS*/)
        {
          SetWindowFontAndText(aWnd[IDC_CBB_STR][WND], hGuiFont, sStr);
          AkelPad.SendMessage(aWnd[IDC_CBB_STR][WND], 0x0142 /*CB_SETEDITSEL*/, 0, MkLong(nBegSelIn, nEndSelIn));
        }
        else if (nHiwParam == 10 /*CBN_SELENDCANCEL*/)
        {
          nBegSelIn = LoWord(AkelPad.SendMessage(aWnd[IDC_CBB_STR][WND], 0x140 /*CB_GETEDITSEL*/, 0, 0));
          nEndSelIn = HiWord(AkelPad.SendMessage(aWnd[IDC_CBB_STR][WND], 0x140 /*CB_GETEDITSEL*/, 0, 0));
        }
        else if (nHiwParam == 5 /*CBN_EDITCHANGE*/)
        {
          nBegSelIn = LoWord(AkelPad.SendMessage(aWnd[IDC_CBB_STR][WND], 0x140 /*CB_GETEDITSEL*/, 0, 0));
          nEndSelIn = HiWord(AkelPad.SendMessage(aWnd[IDC_CBB_STR][WND], 0x140 /*CB_GETEDITSEL*/, 0, 0));
          oSys.Call("user32::GetWindowText" + _TCHAR, aWnd[IDC_CBB_STR][WND], lpBuffer, nMaxLen);
          sStr = AkelPad.MemRead(lpBuffer, _TSTR);
        }
        else if (nHiwParam == 1 /*CBN_SELCHANGE*/)
        {
          nNumStrIn = AkelPad.SendMessage(aWnd[IDC_CBB_STR][WND], 0x147 /*CB_GETCURSEL*/, 0, 0);
          AkelPad.SendMessage(aWnd[IDC_CBB_STR][WND], 0x148 /*CB_GETLBTEXT*/, nNumStrIn, lpBuffer);
          pStrIn = AkelPad.MemRead(lpBuffer, _TSTR);
        }
        else if (nHiwParam == 7 /*CBN_DROPDOWN*/)
        {
          bCloseCB2 = 0;
        }
        else if (nHiwParam == 8 /*CBN_CLOSEUP*/)
        {
          bCloseCB2 = 1;
        }
      }

      if (bNum)
      {
        if (DisableBtnOK(aWnd[IDC_EDT_FIRST][WND]))
        {
          return;
        }
        if (DisableBtnOK(aWnd[IDC_EDT_STEP][WND]))
        {
          return;
        }
        if (DisableBtnOK(aWnd[IDC_EDT_WIDTH][WND]))
        {
          return;
        }
        sStr=GetWindowText(aWnd[IDC_CBB_STR][WND]);
        if (sStr.search(/\\N/g) == -1 && sStr.search(/\\H/g) == -1)
        {
          return;
        }
      }
      oSys.Call("user32::EnableWindow", aWnd[IDC_OK][WND], (oSys.Call("user32::GetWindowTextLength"+_TCHAR, aWnd[IDC_CBB_STR][WND])) ? true : false);
    }
    else if (nLowParam==IDC_RAND)
    {
      bRand=AkelPad.SendMessage(aWnd[IDC_RAND][WND], 240 /*BM_GETCHECK*/, 0, 0);
      oSys.Call("user32::SetWindowText"+_TCHAR, aWnd[IDC_STATIC_STEP][WND], (bRand) ? sTxtEnd : sTxtStep);
    }
    else if (nLowParam==IDC_LAZY)
    {
      bLazy=AkelPad.SendMessage(aWnd[IDC_LAZY][WND], 240 /*BM_GETCHECK*/, 0, 0);
    }
    else if (nLowParam==IDC_SYNTEX)
    {
      if (!AkelPad.Include("ShowMenu.js"))
      {
       AkelPad.MessageBox(hWnd, sTxtIncShowMenuJs, pScriptName, 0 /*MB_OK*/);
      }
      else
      {
        //Variables
        var lpItems;
        var nItem;

        lpItems=[["$1\t"+sTxtOriginalLine, MF_NORMAL, 101],
                 ["\\N\t"+sTxtNumberSequence, MF_NORMAL, 102],
                 ["\\H\t"+sTxtHexNumSequence, MF_NORMAL, 103],
                 ["", MF_SEPARATOR],
                 ["\\\\\t"+sTxtBackSlace, MF_NORMAL, 104],
                 ["\\r\t"+sTxtReturn, MF_NORMAL, 105],
                 ["\\n\t"+sTxtLineFeed, MF_NORMAL, 106],
                 ["\\t\t"+sTxtTabulation, MF_NORMAL, 107],
                 ["", MF_SEPARATOR],
                 [sTxtEmpty, (oSys.Call("user32::GetWindowTextLength"+_TCHAR, aWnd[IDC_CBB_STR][WND])) ? MF_NORMAL|MF_LAST : MF_NORMAL|MF_GRAYED|MF_LAST, 108]];

        nItem=ShowMenu(lpItems, POS_CURSOR, POS_CURSOR);
        if (nItem == -1)
        {
        }
        else
        {
          nItem=lpItems[nItem][2];
          switch (nItem)
          {
            case 101 : FunToIn("$1");
              break;
            case 102 : FunToIn("\\N");
              break;
            case 103 : FunToIn("\\H");
              break;
            case 104 : FunToIn("\\\\");
              break;
            case 105 : FunToIn("\\r");
              break;
            case 106 : FunToIn("\\n");
              break;
            case 107 : FunToIn("\\t");
              break;
            case 108 :
              sStr = "";
              oSys.Call("user32::SetFocus", aWnd[IDC_CBB_STR][WND]);
              break;
          }
        }
      }
    }
    else if (nLowParam==IDC_OK)
    {
      //String
      sStr=GetWindowText(aWnd[IDC_CBB_STR][WND]);

      if (nStrings)
      {
        for (i=0; i<nStrings && typeof lpStrings[i]!="undefined"; i+=1)
        {
          if (lpStrings[i]==sStr)
          {
            AkelPad.SendMessage(aWnd[IDC_CBB_STR][WND], 0x144 /*CB_DELETESTRING*/, i, 0);
            DeleteFromArray(lpStrings, i, 1);
          }
        }

        InsertInArray(lpStrings, sStr, 0);

        if (lpStrings.length>nStrings)
        {
          DeleteFromArray(lpStrings, -1, 1);
        }

        AkelPad.MemCopy(lpBuffer, sStr, _TSTR);
        AkelPad.SendMessage(aWnd[IDC_CBB_STR][WND], 0x14A /*CB_INSERTSTRING*/, 0, lpBuffer);
        AkelPad.SendMessage(aWnd[IDC_CBB_STR][WND], 0x14E /*CB_SETCURSEL*/, 0, 0);
      }

      if (bNum)
      {
        sPad  =GetWindowText(aWnd[IDC_EDT_PAD][WND]);
        nFirst=GetWindowText(aWnd[IDC_EDT_FIRST][WND]);
        nStep =GetWindowText(aWnd[IDC_EDT_STEP][WND]);

        nFirstCur=GetWindowText(aWnd[IDC_EDT_FIRST][WND],"n");
        nStepCur =GetWindowText(aWnd[IDC_EDT_STEP][WND] ,"n");

        nWidth=parseInt(GetWindowText(aWnd[IDC_EDT_WIDTH][WND],"n"),10);
      }

      var d=new Date();
      var t=d.getTime();

      NumberCount();

      var d=new Date();
      t=(d.getTime()-t)/1000;

      if (Math.round(t)>1)
      {
        AkelPad.MessageBox(hWndDialog, "    "+t.toFixed(3)+" "+sTxtSeconds, pScriptName, 0 /*MB_OK*/);
      }
    }
    else if (nLowParam==IDC_CANCEL)
    {
      oSys.Call("user32::PostMessage"+_TCHAR, hWnd, 16 /*WM_CLOSE*/, 0, 0);
    }
  }
  else if (uMsg==16)  //WM_CLOSE
  {
    if (oSet.Begin(WScript.ScriptBaseName, 0x2 /*POB_SAVE*/))
    {
      //Save settings
      oSet.Write("Num"  , 1 /*PO_DWORD*/ ,             bNum);
      oSet.Write("Rand" , 1 /*PO_DWORD*/ ,            bRand);
      oSet.Write("Lazy" , 1 /*PO_DWORD*/ ,            bLazy);
      oSet.Write("First", 3 /*PO_STRING*/,           nFirst);
      oSet.Write("Step" , 3 /*PO_STRING*/,            nStep);
      oSet.Write("Width", 1 /*PO_DWORD*/ ,           nWidth);
      oSet.Write("Pad"  , 3 /*PO_STRING*/,             sPad);

      //Save string history
      for (i=0; i<nStrings && typeof lpStrings[i]!="undefined"; i+=1)
      {
        oSet.Write("String"+i, 3 /*PO_STRING*/, lpStrings[i]);
      }

      oSet.End();
    }

    //Destroy dialog
    oSys.Call("user32::DestroyWindow", hWnd);
  }
  else if (uMsg==2)  //WM_DESTROY
  {
    //Exit message loop
    oSys.Call("user32::PostQuitMessage", 0);
  }
}

function GetWindowText(hWnd,cType)
{
  oSys.Call("user32::GetWindowText"+_TCHAR, hWnd, lpBuffer, nMaxLen);
  var pStrExp=AkelPad.MemRead(lpBuffer, _TSTR);

  if (cType=="n")
  {
    if (pStrExp=="")
    {
      pStrExp="1";
    }
    return Number(pStrExp);
  }
  else
  {
    return pStrExp;
  }
}

function Pad(nCurrentNum,m)
{
  var pNumText;
  var nLen;
  var cPadding="";

  if (bHex)
  {
    pNumText=nCurrentNum.toString(16);
  }
  else
  {
    pNumText=nCurrentNum.toFixed(m);
  }

  if (nCurrentNum<0)
  {
    pNumText="-"+pNumText.substr(1);
  }

  nLen=Math.abs(nWidth)-pNumText.length+1;

  while ((nLen-=1)>0)
  {
    cPadding+=sPad;
  }

  if (nWidth<0)
  {
    pNumText += cPadding;
  }
  else
  {
    pNumText=cPadding+pNumText;
  }

  return pNumText;
}

function EnableNumWin(bNum)
{
  oSys.Call("user32::EnableWindow", aWnd[IDC_RAND][WND]     , bNum);
  oSys.Call("user32::EnableWindow", aWnd[IDC_LAZY][WND]     , bNum);
  oSys.Call("user32::EnableWindow", aWnd[IDC_EDT_FIRST][WND], bNum);
  oSys.Call("user32::EnableWindow", aWnd[IDC_EDT_STEP][WND] , bNum);
  oSys.Call("user32::EnableWindow", aWnd[IDC_EDT_WIDTH][WND], bNum);
  oSys.Call("user32::EnableWindow", aWnd[IDC_EDT_PAD][WND]  , bNum);
}

function NumberCount()
{
  //Variables
  var nSelState=0;
  var SELECTALL=0;
  var NORMALSEL=1;
  var COLUMNSEL=2;
  var pSelText;

  //Esc-sequences
  var sEscStr=sStr.replace(/\\\\/g, "");
  sEscStr=sEscStr.replace(/\\r\\n|\\r|\\n/g, "");
  sEscStr=sEscStr.replace(/\\t/g, "\t");
  sEscStr=sEscStr.replace(//g, "\\");

  if (bNum && sEscStr.indexOf("\\H") != -1)
  {
    sEscStr=sEscStr.replace(/\\H/g, "");
    bHex=true;
  }

  if (bNum)
  {
    sEscStr=sEscStr.replace(/\\N/g, "");
  }

  if (AkelPad.IsAkelEdit())
  {
    AkelPad.SendMessage(hWndEdit, 3185 /*AEM_LOCKSCROLL*/, 3 /*SB_BOTH*/, true);
  }

  SetRedraw(hWndEdit, false);

  if (AkelPad.SendMessage(hWndEdit, 3125 /*AEM_GETSEL*/, 0, 0))
  {
    if (AkelPad.SendMessage(hWndEdit, 3127 /*AEM_GETCOLUMNSEL*/, 0, 0))
    {
      nSelState=COLUMNSEL;
      pSelText =AkelPad.GetSelText(2);
    }
    else
    {
      nSelState    =NORMALSEL;
      var nSelStart=AkelPad.GetSelStart();
      var nSelEnd  =AkelPad.GetSelEnd();

      SelCompleteLine(hWndEdit, nSelStart, nSelEnd);

      nSelStart=AkelPad.GetSelStart();
      pSelText =AkelPad.GetSelText(2);

      var pLastStr =pSelText.charAt(pSelText.length-1);

      if (pLastStr=="\n")
      {
        pSelText=pSelText.substr(0, pSelText.length-1);
        CollectGarbage();
      }
    }
  }
  else
  {
    pSelText =AkelPad.GetTextRange(0, -1, 2);
  }

  var oPattern=new RegExp("(^.*$)", "mg");
  pSelText=pSelText.replace(oPattern, sEscStr);
  CollectGarbage();

  if (bNum && sEscStr.indexOf("")!=-1)
  {
    pSelText=pSelText.split("");
    CollectGarbage();
    var m=0;

    if (nFirstCur==undefined)
    {
      var nFirstCur=Number(nFirst);
    }
    if (nStepCur==undefined)
    {
      var nStepCur=Number(nStep);
    }
    if (nFirstCur!=parseInt(nFirstCur,10) || nStepCur!=parseInt(nStepCur,10))
    {
      var r1,r2;
      try{r1=nFirstCur.toString().split(".")[1].length;}catch(e){r1=0;}
      try{r2=nStepCur.toString().split(".")[1].length;}catch(e){r2=0;}
      m=Math.max(r1,r2);
    }

    var nCurrentNum=(bRand) ? nFirstCur+(nStepCur-nFirstCur)*Math.random() : nFirstCur;

    var pNumText;

    if (!bHex && (nWidth==1 || nWidth==0 || nWidth ==-1))
    {
      for (i=0, l=pSelText.length-1; i<l; i+=1)
      {
        pNumText=nCurrentNum.toFixed(m);

        pSelText[i]=pSelText[i]+pNumText;
        if (!bLazy || (bLazy && (pSelText[i+1].indexOf("\n")!=-1)))
        {
          nCurrentNum=(bRand) ? nFirstCur+(nStepCur-nFirstCur)*Math.random() : nCurrentNum+nStepCur;
        }
      }
    }
    else
    {
      for (i=0, l=pSelText.length-1; i<l; i+=1)
      {
        pNumText=Pad(nCurrentNum,m);

        pSelText[i]=pSelText[i]+pNumText;
        if (!bLazy || (bLazy && (pSelText[i+1].indexOf("\n")!=-1)))
        {
          nCurrentNum=(bRand) ? nFirstCur+(nStepCur-nFirstCur)*Math.random() : nCurrentNum+nStepCur;
        }
      }
    }
    pSelText=pSelText.join("");
    CollectGarbage();
  }
  pSelText=pSelText.replace(//g, "\n");
  CollectGarbage();

  if (nSelState==COLUMNSEL)
  {
    dwOptions=AkelPad.SendMessage(hWndEdit, 3227 /*AEM_GETOPTIONS*/, 0, 0);
    if (!(dwOptions & 0x40 /*AECO_PASTESELECTCOLUMN*/))
    {
      AkelPad.SendMessage(hWndEdit, 3228 /*AEM_SETOPTIONS*/, 2 /*AECOOP_OR*/, 0x40 /*AECO_PASTESELECTCOLUMN*/);
    }
    AkelPad.ReplaceSel(pSelText);
    if (!(dwOptions & 0x40 /*AECO_PASTESELECTCOLUMN*/))
    {
      AkelPad.SendMessage(hWndEdit, 3228 /*AEM_SETOPTIONS*/, 4 /*AECOOP_XOR*/, 0x40 /*AECO_PASTESELECTCOLUMN*/);
    }
  }
  else if (nSelState==NORMALSEL)
  {
    if (pLastStr=="\n")
    {
      pSelText=pSelText+"\n";
      CollectGarbage();
    }
    AkelPad.ReplaceSel(pSelText);
    nSelEnd=AkelPad.GetSelEnd();
    AkelPad.SetSel(nSelStart,nSelEnd);
  }
  else if (nSelState==SELECTALL)
  {
    AkelPad.SetSel(0, -1);
    AkelPad.ReplaceSel(pSelText);
  }

  if (AkelPad.IsAkelEdit())
  {
    AkelPad.SendMessage(hWndEdit, 3185 /*AEM_LOCKSCROLL*/, 3 /*SB_BOTH*/, false);
  }

  SetRedraw(hWndEdit, true);

  pSelText=null;
  CollectGarbage();
}

function DisableBtnOK(hWnd)
{
  oSys.Call("user32::GetWindowText"+_TCHAR, hWnd, lpBuffer, nMaxLen);
  var pStrExp=AkelPad.MemRead(lpBuffer, _TSTR);

  if (pStrExp=="")
  {
    pStrExp="1";
  }

  if (isNaN(Number(pStrExp)))
  {
    oSys.Call("user32::EnableWindow", aWnd[IDC_OK][WND], false);
    oSys.Call("user32::SetFocus", hWnd);
    return true;
  }
}

function InsertInArray(lpArray, lpItem, nPos)
{
  //For MS JScript backward compatibility
  var i;

  if (nPos<0)
  {
    nPos=lpArray.length+nPos+1;
  }
  if (nPos<0)
  {
    nPos=0;
  }
  if (nPos>lpArray.length)
  {
    nPos=lpArray.length;
  }

  for (i=lpArray.length; i >= 0; i-=1)
  {
    if (i==nPos)
    {
      lpArray[i]=lpItem;
      break;
    }
    lpArray[i]=lpArray[i-1];
  }
}

function DeleteFromArray(lpArray, nPos, nCount)
{
  //For MS JScript backward compatibility
  var i;

  if (nPos<0)
  {
    nPos=lpArray.length+nPos;
  }
  if (nPos<0 || nPos >= lpArray.length)
  {
    return;
  }
  if (nPos+nCount >= lpArray.length)
  {
    nCount=lpArray.length-nPos;
  }

  for (i=nPos, l=lpArray.length; i+nCount<l; i+=1)
  {
    lpArray[i]=lpArray[i+nCount];
  }
  lpArray.length-=nCount;
}

function SetWindowFontAndText(hWnd, hFont, pText)
{
  if (hFont)
  {
    AkelPad.SendMessage(hWnd, 48 /*WM_SETFONT*/, hFont, 1);
  }

  AkelPad.MemCopy(lpBuffer, pText.toString().substr(0, 255).replace(/\r$/, ""), _TSTR);
  oSys.Call("user32::SetWindowText"+_TCHAR, hWnd, lpBuffer);
}

function SetRedraw(hWnd, bRedraw)
{
  AkelPad.SendMessage(hWnd, 11 /*WM_SETREDRAW*/, bRedraw, 0);
  if (bRedraw)
  {
    oSys.Call("user32::InvalidateRect", hWnd, 0, true);
  }
}

function RectToArray(lpRect, rcRect)
{
  rcRect.left  =AkelPad.MemRead(lpRect   , 3 /*DT_DWORD*/);
  rcRect.top   =AkelPad.MemRead(lpRect+4 , 3 /*DT_DWORD*/);
  rcRect.right =AkelPad.MemRead(lpRect+8 , 3 /*DT_DWORD*/);
  rcRect.bottom=AkelPad.MemRead(lpRect+12, 3 /*DT_DWORD*/);
  return rcRect;
}

function CenterWindow(hWndParent, hWnd)
{
  var lpRect;
  var rcWndParent=[];
  var rcWnd=[];
  var X;
  var Y;

  lpRect=AkelPad.MemAlloc(16);
  if (lpRect)  //sizeof(RECT)
  {
    if (!hWndParent)
    {
      hWndParent=oSys.Call("user32::GetDesktopWindow");
    }

    oSys.Call("user32::GetWindowRect", hWndParent, lpRect);
    RectToArray(lpRect, rcWndParent);

    oSys.Call("user32::GetWindowRect", hWnd, lpRect);
    RectToArray(lpRect, rcWnd);

    //Center window
    X=rcWndParent.left+((rcWndParent.right-rcWndParent.left)/2-(rcWnd.right-rcWnd.left)/2);
    Y=rcWndParent.top +((rcWndParent.bottom-rcWndParent.top)/2-(rcWnd.bottom-rcWnd.top)/2);

    oSys.Call("user32::SetWindowPos", hWnd, 0, X, Y, 0, 0, 0x15 /*SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE*/);

    AkelPad.MemFree(lpRect);
  }
}

function SelCompleteLine(hWnd, nMinSel, nMaxSel)
{
  if (nMinSel<nMaxSel)
  {
    var nMinLine      =AkelPad.SendMessage(hWnd, 1078 /*EM_EXLINEFROMCHAR*/,        0, nMinSel);
    var nMaxLine      =AkelPad.SendMessage(hWnd, 1078 /*EM_EXLINEFROMCHAR*/,        0, nMaxSel);
    var nMinLineIndex =AkelPad.SendMessage(hWnd, 187       /*EM_LINEINDEX*/, nMinLine,       0);
    var nMaxLineIndex =AkelPad.SendMessage(hWnd, 187       /*EM_LINEINDEX*/, nMaxLine,       0);
    var nMaxLineLength=AkelPad.SendMessage(hWnd, 193      /*EM_LINELENGTH*/,  nMaxSel,       0);
    if (nMaxLineIndex==nMaxSel)
    {
      nMaxLine-=1;
    }
    else if (nMaxLineLength)
    {
      nMaxSel=nMaxLineIndex+nMaxLineLength+1;
    }
    nMinSel=nMinLineIndex;
    AkelPad.SetSel(nMinSel, nMaxSel);
    return nMaxLine-nMinLine+1;
  }
  return 0;
}

function FunToIn(pTxt)
{
  if (pTxt.indexOf("(...)") > -1)
  {
    pTxt   = pTxt.replace("...", sStr.substring(nBegSelIn, nEndSelIn));
    sStr = sStr.substr(0, nBegSelIn) + pTxt + sStr.substr(nEndSelIn);
    if (nBegSelIn == nEndSelIn)
    {
      nBegSelIn = nBegSelIn + pTxt.length - 1;
      nEndSelIn = nBegSelIn;
    }
    else
    {
      nBegSelIn = nBegSelIn + pTxt.indexOf("(") + 1;
      nEndSelIn = nEndSelIn + pTxt.indexOf("(") + 1;
    }
  }
  else if (pTxt.indexOf("(") > -1)
  {
    sStr = sStr.substr(0, nBegSelIn) + pTxt + sStr.substr(nEndSelIn);
    nBegSelIn = nBegSelIn + pTxt.indexOf("(") + 1;
    nEndSelIn = nBegSelIn;
  }
  else
  {
    sStr = sStr.substr(0, nBegSelIn) + pTxt + sStr.substr(nEndSelIn);
    nBegSelIn = nBegSelIn + pTxt.length;
    nEndSelIn = nBegSelIn;
  }

  oSys.Call("user32::SetFocus", aWnd[IDC_CBB_STR][WND]);
}

function LoWord(nParam)
{
  return (nParam & 0xffff);
}

function HiWord(nParam)
{
  return ((nParam >> 16) & 0xffff);
}

function MkLong(nLoWord, nHiWord)
{
  return (nHiWord << 16) | (nLoWord & 0xffff);
}
