﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=1585#1585
// Description(1033): Opening a file with a choice of extensions from the list
// Description(1049): Открытие файла с возможностью выбора расширения из списка файла параметров
// Version: 4.0 (2015.04.29)
// Author: VladSh
// 
// Usage:
// 	-"Открыть..." Call("Scripts::Main", 1, "OpenEx.js")                                - открывает файл из последнего места открытия без установки фильтра по расширению  (обычный диалог открытия)
// 	-"Открыть из папки..." Call("Scripts::Main", 1, "OpenEx.js", `-dir="%d\"`)         - открывает из папки файла без установки фильтра по расширению
// 	-"Открыть по файлу..." Call("Scripts::Main", 1, "OpenEx.js", `-file="%f"`)         - открывает из папки файла; расширение для фильтра определяется по файлу
// 	-"Открыть [ini]..." Call("Scripts::Main", 1, "OpenEx.js", `-file="%f" -ext="ini"`) - открывает из папки файла с фильтром по указанному расширению

if (!AkelPad.Include("CommonFunctions.js")) WScript.Quit();

var pInitialFile = AkelPad.GetArgValue("file", "");
var pInitialDir = AkelPad.GetArgValue("dir", "") || getParentClosed(pInitialFile);
var pInitialExt = AkelPad.GetArgValue("ext", "") || getFileExt(pInitialFile);
pInitialFile = "";

pInitialFile = fileDialogDefault(true, pInitialDir, pInitialFile, pInitialExt);
if (pInitialFile) {
	//Проверка на существование файла с введенным в диалоге именем
	var fso = new ActiveXObject("Scripting.FileSystemObject");
	if (fso.FileExists(pInitialFile) == true)
		AkelPad.OpenFile(pInitialFile);
	else
		AkelPad.MessageBox(AkelPad.GetMainWnd(), "File '" + pInitialFile + "' not found.", "AkelPad", 64);
}