// http://akelpad.sourceforge.net/forum/viewtopic.php?p=5163#5163
// Version: 1.6
// Author: Shengalts Aleksander aka Instructor
//
//
// Description(1033): Print all MDI/PMDI documents.
// Description(1049):   MDI/PMDI .
//
// Arguments:
// -FromPage=1     -Print from first page (default is 0).
// -ToPage=4       -Print to fourth page (default is 0).
// -Copies=2       -Print two copies (default is 1).
// -Collate=false  -Collate copies (default is true).
// -AddFlags=0x0   -Additional print flags (default is 0x0). See PRINTDLG.Flags in MSDN.
// -Close=true     -Close printed document. "Print directly to the printer" must be turned on in advanced printer settings. Default is false.
//
// Usage:
// "Print all" Call("Scripts::Main", 1, "PrintAll.js")
// "Print all (only first page)" Call("Scripts::Main", 1, "PrintAll.js", `-FromPage=1 -ToPage=1`)

//Arguments
var nFromPage=AkelPad.GetArgValue("FromPage", 0);
var nToPage=AkelPad.GetArgValue("ToPage", 0);
var nCopies=AkelPad.GetArgValue("Copies", 1);
var bCollate=AkelPad.GetArgValue("Collate", true);
var dwAddFlags=AkelPad.GetArgValue("AddFlags", 0x0);
var bClose=AkelPad.GetArgValue("Close", false);

//Variables
var hMainWnd=AkelPad.GetMainWnd();
var hWndEdit=AkelPad.GetEditWnd();
var lpFrameInit;
var lpFrameCur;

if (hWndEdit)
{
  //Initial MDI frame
  lpFrameInit=AkelPad.SendMessage(hMainWnd, 1288 /*AKD_FRAMEFIND*/, 1 /*FWF_CURRENT*/, 0);
  lpFrameCur=lpFrameInit;

  for (;;)
  {
    if ((nFromPage != 0 && nToPage != 0) || nCopies > 1 || dwAddFlags)
      SetPrintSettings(nFromPage, nToPage, nCopies, bCollate, dwAddFlags);

    if (lpFrameCur == lpFrameInit)
    {
      if (!AkelPad.Command(4108 /*IDM_FILE_PRINT*/))
        break;
    }
    else
    {
      if (!AkelPad.Command(4113 /*IDM_FILE_SILENTPRINT*/))
        break;
    }

    if (bClose)
    {
      if (!AkelPad.Command(4318 /*IDM_WINDOW_FRAMECLOSE*/))
        break;
      if (AkelPad.SendMessage(hMainWnd, 1292 /*AKD_FRAMENOWINDOWS*/, 0, 0))
        break;
      lpFrameCur=0;
    }
    else
    {
      //Next MDI frame
      lpFrameCur=AkelPad.Command(4316 /*IDM_WINDOW_FRAMENEXT*/);
      if (!lpFrameCur || lpFrameCur == lpFrameInit)
        break;
    }
  }
}

function SetPrintSettings(nFromPage, nToPage, nCopies, bCollate, dwAddFlags)
{
  var lpPrintInfo;
  var dwPrintFlags;

  if (lpPrintInfo=AkelPad.MemAlloc(_X64?56:44 /*sizeof(PRINTINFO)*/))
  {
    AkelPad.SendMessage(hMainWnd, 1215 /*AKD_GETPRINTINFO*/, lpPrintInfo, 0);
    dwPrintFlags=AkelPad.MemRead(_PtrAdd(lpPrintInfo, _X64?24:12) /*offsetof(PRINTINFO, dwPrintFlags)*/, 3 /*DT_DWORD*/);
    if (nFromPage != 0 && nToPage != 0)
    {
      dwPrintFlags|=0x2 /*PD_PAGENUMS*/;
      AkelPad.MemCopy(_PtrAdd(lpPrintInfo, _X64?28:16) /*offsetof(PRINTINFO, nFromPage)*/, nFromPage, 4 /*DT_WORD*/);
      AkelPad.MemCopy(_PtrAdd(lpPrintInfo, _X64?30:18) /*offsetof(PRINTINFO, nToPage)*/, nToPage, 4 /*DT_WORD*/);
    }
    if (nCopies > 1)
    {
      AkelPad.MemCopy(_PtrAdd(lpPrintInfo, _X64?32:20) /*offsetof(PRINTINFO, nCopies)*/, nCopies, 4 /*DT_WORD*/);
      if (bCollate)
        dwPrintFlags|=0x10 /*PD_COLLATE*/;
      else
        dwPrintFlags&=~0x10 /*PD_COLLATE*/;
    }
    if (dwAddFlags)
    {
      dwPrintFlags|=dwAddFlags;
    }
    AkelPad.MemCopy(_PtrAdd(lpPrintInfo, _X64?24:12) /*offsetof(PRINTINFO, dwPrintFlags)*/, dwPrintFlags, 3 /*DT_DWORD*/);
    AkelPad.SendMessage(hMainWnd, 1216 /*AKD_SETPRINTINFO*/, lpPrintInfo, 0);
    AkelPad.MemFree(lpPrintInfo);
  }
}
