﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=5837#5837
// Description(1033): Extended "Save as ..."
// Description(1049): Расширенное "Сохранить как..."
// Version: 2.24 (2015.10.08)
// Author: VladSh
// 
// Arguments:
//    dir - папка для сохранения, с которой будем открывать диалог сохранения
//    ext - расширение, если мы хотим его задать жёстко для сохраняемых файлов
//    selUse:
//       0 - использовать выделение для определения из него имени файла, по аналогии с тем, как это делает MS Word;
//      [1] - для сохранения выделения в отдельный файл; имя файла в этом случае будет выдаваться текущее
//    srcClose - закрывать исходный файл или нет; [true] - будет закрываться только если файл не был изменён в окне AkelPad'а
// 
// Usage:
//    -"Сохранить как..." Call("Scripts::Main", 1, "SaveAs.js")
//    -"Сохранить в js..." Call("Scripts::Main", 1, "SaveAs.js", `-ext="js"`)

var pAllText = AkelPad.GetTextRange(0, -1);		//берём весь текст

if (! AkelPad.Include("CommonFunctions.js")) WScript.Quit();

var pSelText = AkelPad.GetSelText();		//если есть выделенный текст, то значит из него, а не из первой строки, будем брать наименование будущего файла

var hWndEdit = AkelPad.GetEditWnd();
var pCurrentFile = AkelPad.GetEditFile(hWndEdit);

//если нет выделения, то инициировать сохранение выделения в отдельный файл не имеет смысла
var selUse = (pSelText ? AkelPad.GetArgValue("selUse", 1) : 0);

//начальный текст для возможного имени файла
var pInitialFile = (selUse == 0 ? pSelText : (pCurrentFile || pAllText)) || pCurrentFile /* если выделения не было (т.е. из него определить имя файла не удалось), значит для подстановки в диалог используем текущее имя файла */;

//Определяем расширение будущего файла; значение в аргументах приоритетнее
var fileExt = AkelPad.GetArgValue("ext", "") || getFileExt(pCurrentFile) || getFileExt(pInitialFile);
if (!fileExt) {
	if (AkelPad.Include("CoderFunctions.js"))
		fileExt = GetSyntaxAliasExtension(hWndEdit);
}
if (fileExt == "bbc") fileExt = "";		//bbc важно только для подсветки, а для сохранения то, что указано в настроках проги; если нужно bbc, то его можно выбрать в диалоге

if (pInitialFile && (pInitialFile != pCurrentFile))
	pInitialFile = getFileNameByFirstRow(pInitialFile);		//получение возможного имени файла по его первой строке

var pInitialDir = AkelPad.GetArgValue("dir", "") || getParentClosed(pInitialFile);

pInitialFile = fileDialogDefault(false, pInitialDir, pInitialFile, fileExt);		//выдаём в диалоге - можно поменять
if (pInitialFile) {
	pInitialFile = correctFileNameFull(pInitialFile);
	if (pInitialFile) {
		//Проверка, возможно новое расширение было добавлено к уже существующему
		var dFile = separateFile(pInitialFile);
		var tmpFileName = getFileNameOnly(pInitialFile);
		
		if (dFile.name.length != tmpFileName.length)
			pInitialFile = dFile.path + tmpFileName + "." + dFile.ext;		//то, что было введено в диалоге, приоритетнее!
		
		//если выбрали для сохранения не текущий файл
		if (pInitialFile != pCurrentFile ) {
			//Проверка на существование файла с таким именем
			var newFileFormat;
			fso = new ActiveXObject("Scripting.FileSystemObject");
			if (fso.FileExists(pInitialFile) == true) {
				if (AkelPad.MessageBox(AkelPad.GetMainWnd(), "File '" + pInitialFile + "' already exist! Replace it?!", "AkelPad message...", 48+4) != 6)
					WScript.Quit();
			}
			else {
				//если у текущего файла нет имени и установлено "не сохранять выделение", - сохраняем текущий
				if (!pCurrentFile && !selUse) {
					saveFile(pInitialFile);
					WScript.Quit();
				}
				newFileFormat = getFileFormat(0);
			}
			
			if (AkelPad.GetArgValue("srcClose", true)) {
				if (!AkelPad.GetEditModified(0) && pCurrentFile) {
					//Закрытие текущего файла и его вкладки, т.к. будем сохранять точно не текущий файл
					closeFile();
				}
			}
			
			if (newFileFormat) {
				//файл не существует - создаём
				createFile(newFileFormat, dFile.ext);
			}
			else {
				//файл существует - открываем
				AkelPad.OpenFile(pInitialFile);
				AkelPad.SetSel(0, -1);
			}
			AkelPad.ReplaceSel(selUse == 1 ? pSelText : pAllText);
			AkelPad.SetSel(0, 0);
		}
		
		//сохранение файла
		saveFile(pInitialFile);
	}
}

//Сохранение с обновлением панели Explorer-плагина
function saveFile(pFile) {
	AkelPad.SaveFile(0, pFile);
	var pExplorer = "Explorer::Main";
	if (AkelPad.IsPluginRunning(pExplorer)) {
		AkelPad.Call(pExplorer, 2);
	}
}

//Берём первую строку, как это делает MS Word
function getFileNameByFirstRow(pInitialFile) {
	var pTmpFile = pInitialFile.replace(new RegExp("^[" + " \t\r" + "]+", "gm"), "");
	pTmpFile = pTmpFile.split(/\r/)[0];
	return correctFileName(pTmpFile);
}