// http://akelpad.sourceforge.net/forum/viewtopic.php?p=4678#4678
// Version: 1.1
// Author: Shengalts Aleksander aka Instructor
//
//
// Description(1033): Save new file to a default folder.
// Description(1049):       .
//
// Arguments:
// -Dir="C:\MyFolder\"  -Save folder. If not specified, Windows temp folder will be used.
// -Name="file"         -Base file name (default is "new").
// -Ext=".txt"          -File name extension (default is ".txt").
// -CodePage=65001      -Save codepage. If -1, current codepage will be used (default).
// -BOM=1               -File byte order mark (one of the following):
//                         1 - exist (default).
//                         0 - doesn't exist.
//                        -1 - current BOM will be used.
//
// Usage:
// Call("Scripts::Main", 1, "SaveDefault.js", `-Dir="C:\MyFolder\" -CodePage=65001`)

//Arguments
var pDir=AkelPad.GetArgValue("Dir", "");
var pName=AkelPad.GetArgValue("Name", "new");
var pExt=AkelPad.GetArgValue("Ext", ".txt");
var nCodePage=AkelPad.GetArgValue("CodePage", -1);
var nBOM=AkelPad.GetArgValue("BOM", 1);

//Variables
var hMainWnd=AkelPad.GetMainWnd();
var hEditWnd=AkelPad.GetEditWnd();
var oSys=AkelPad.SystemFunction();
var pFile=AkelPad.GetEditFile(0);
var nFileCount;
var nSaveResult;

if (hEditWnd)
{
  if (pFile == "")
  {
    if (!pDir)
      pDir=GetTempPath();
    if (pDir)
    {
      if (pDir.substr(pDir.length - 1, 1) != "\\")
        pDir+="\\";
    }

    if (IsFileExist(pDir))
    {
      for (nFileCount=1; ; ++nFileCount)
      {
        pFile=pDir + pName + nFileCount + pExt;

        if (!IsFileExist(pFile))
        {
          if (nSaveResult=AkelPad.SaveFile(hEditWnd, pFile, nCodePage, nBOM))
          {
            AkelPad.MessageBox(hMainWnd, GetLangString(0).replace(/%d/, "" + nSaveResult), WScript.ScriptName, 16 /*MB_ICONERROR*/);
          }
          break;
        }
      }
    }
    else AkelPad.MessageBox(hMainWnd, GetLangString(1).replace(/%s/, pDir), WScript.ScriptName, 48 /*MB_ICONEXCLAMATION*/);
  }
  else AkelPad.Command(4105 /*IDM_FILE_SAVE*/);
}

function IsFileExist(pFile)
{
  if (oSys.Call("kernel32::GetFileAttributes" + _TCHAR, pFile) == -1)
    return false;
  return true;
}

function GetTempPath()
{
  var lpBuffer;
  var pTempDir="";

  if (lpBuffer=AkelPad.MemAlloc(256 * _TSIZE))
  {
    oSys.Call("kernel32::GetTempPath" + _TCHAR, 256, lpBuffer);
    pTempDir=AkelPad.MemRead(lpBuffer, _TSTR);
    AkelPad.MemFree(lpBuffer);
  }
  return pTempDir;
}

function GetLangString(nStringID)
{
  var nLangID=AkelPad.GetLangId(1 /*LANGID_PRIMARY*/);

  if (nLangID == 0x19) //LANG_RUSSIAN
  {
    if (nStringID == 0)
      return "\u041E\u0448\u0438\u0431\u043A\u0430\u003A %d";
    if (nStringID == 1)
      return "\u0414\u0438\u0440\u0435\u043A\u0442\u043E\u0440\u0438\u0438 \"%s\" \u043D\u0435\u0020\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442";
  }
  else
  {
    if (nStringID == 0)
      return "Error: %d";
    if (nStringID == 1)
      return "Folder \"%s\" doesn't exist";
  }
  return "";
}
