﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=13573#13573
// Description(1033): Copies the name of the script in BBCode, substituting in URL is first found the link in edit window
// Description(1049): Копирует название скрипта в BBCode, подставляя в URL первую найденную в окне редактирования ссылку
// Version: 1.6 (2014.12.17)
// Author: VladSh
// 
// Usage:
// 	-"Имя как BBCode" Call("Scripts::Main", 1, "ScriptNameCopyAsBBCode.js", `"%f"`)		- для контекстных меню вкладок и последних файлов, но для текущего файла можно вызывать и из окна скриптов

var pFileName = AkelPad.GetArgLine() || AkelPad.GetEditFile(0);

if (pFileName) {
	if (! AkelPad.Include("CommonFunctions.js")) WScript.Quit();
	var pURL = getFileContent(pFileName, true, 500, "");
	if (pURL)
		pURL = getFirstLink(pURL);
	pFileName = getFileName(pFileName);
	var result = "[url=" + pURL + "]" + pFileName + "[/url]";
	AkelPad.SetClipboardText(result);
}
else
	AkelPad.MessageBox(AkelPad.GetEditWnd(), "Имя файла не задано. Сохраните файл и попробуйте снова...", WScript.ScriptName, 0 /*MB_OK*/ + 48);

function getFirstLink(pText) {
	var pResult = "";
	var nIndex = pText.search(/http:|https:/);
	if (nIndex != -1) {
		pResult = pText.slice(nIndex);
		nIndex = pResult.search(/\s|'|"/i);
		pResult = pResult.slice(0, nIndex);
	}
	return pResult;
}