// http://akelpad.sourceforge.net/forum/viewtopic.php?p=9209#9209
// Version: 1.2
// Author: Shengalts Aleksander aka Instructor
//
//
// Description(1033): Change alternating lines size.
// Description(1049):      .
//
// Arguments:
//  First argument      -Current alternating lines size:
//                           +1  increase.
//                           -1  decrease.
//                            3  set to.
//                        +1;+1  increase.
//                        -1;-1  decrease.
//                          2;3  set to.
//                            0  turn off.
// -Local=true          -Change alternating lines size locally. Not saved by program (default is false).
// -ShowInput=true      -Show input dialog. Default is false, but true if first argument not specified.
//
// Usage:
// "Set alt lines manually" Call("Scripts::Main", 1, "ShiftAltLines.js")
// "Increase alt lines" Call("Scripts::Main", 1, "ShiftAltLines.js", `+1`)
// "Set alt lines to 3 locally" Call("Scripts::Main", 1, "ShiftAltLines.js", `3 -Local=true`)

//Arguments
var pAltLineShift="";
var bLocal=AkelPad.GetArgValue("Local", false);
var bShowInput=AkelPad.GetArgValue("ShowInput", false);
if (WScript.Arguments.length >= 1)
  pAltLineShift=WScript.Arguments(0);

//Variables
var hMainWnd=AkelPad.GetMainWnd();
var hWndEdit=AkelPad.GetEditWnd();
var pSkipSign;
var nSkipShift;
var nSkipSize;
var pFillSign;
var nFillShift;
var nFillSize;
var aAltLineShift;
var dwAltLineSize;

if (bLocal)
  dwAltLineSize=AkelPad.SendMessage(hWndEdit, 3264 /*AEM_GETALTLINE*/, 0, 0);
else
  dwAltLineSize=MAKELONG(AkelPad.SendMessage(hMainWnd, 1223 /*AKD_GETFRAMEINFO*/, 74 /*FI_ALTLINESKIP*/, 0), AkelPad.SendMessage(hMainWnd, 1223 /*AKD_GETFRAMEINFO*/, 73 /*FI_ALTLINEFILL*/, 0));

nSkipShift=parseInt(pAltLineShift);
if (isNaN(nSkipShift))
{
  pAltLineShift="";
  bShowInput=true;
}
if (bShowInput)
{
  if (!pAltLineShift)
    pAltLineShift="" + LOWORD(dwAltLineSize) + ";" + HIWORD(dwAltLineSize);
  pAltLineShift=AkelPad.InputBox(hMainWnd, WScript.ScriptName, GetLangString(0), pAltLineShift);
}

if (hWndEdit && pAltLineShift)
{
  aAltLineShift=pAltLineShift.split(";");

  if (aAltLineShift.length > 1)
  {
    pSkipSign=aAltLineShift[0].substr(0, 1);
    nSkipShift=parseInt(aAltLineShift[0]);
    pFillSign=aAltLineShift[1].substr(0, 1);
    nFillShift=parseInt(aAltLineShift[1]);
  }
  else
  {
    pSkipSign=pAltLineShift.substr(0, 1);
    nSkipShift=parseInt(pAltLineShift);
    pFillSign="";
    nFillShift=0;
  }

  if (pSkipSign == '+' || pSkipSign == '-')
  {
    nSkipSize=LOWORD(dwAltLineSize) + nSkipShift;
    nSkipSize=Math.max(nSkipSize, 0);
  }
  else nSkipSize=nSkipShift;

  if (aAltLineShift.length > 1)
  {
    if (pFillSign == '+' || pFillSign == '-')
    {
      nFillSize=HIWORD(dwAltLineSize) + nFillShift;
      nFillSize=Math.max(nFillSize, 0);
    }
    else nFillSize=nFillShift;
  }
  else nFillSize=nSkipSize;

  if (bLocal)
    AkelPad.SendMessage(hWndEdit, 3265 /*AEM_SETALTLINE*/, MAKELONG(nSkipSize, nFillSize), 0);
  else
    AkelPad.SetFrameInfo(0, 21 /*FIS_ALTLINES*/, MAKELONG(nSkipSize, nFillSize));
}

function LOWORD(dwNumber)
{
  return (dwNumber & 0xffff);
}

function HIWORD(dwNumber)
{
  return (dwNumber >> 16);
}

function MAKELONG(a, b)
{
  return (a & 0xffff) | ((b & 0xffff) << 16);
}

function GetLangString(nStringID)
{
  var nLangID=AkelPad.GetLangId(1 /*LANGID_PRIMARY*/);

  if (nLangID == 0x19) //LANG_RUSSIAN
  {
    if (nStringID == 0)
      return "\u0420\u0430\u0437\u043C\u0435\u0440\u0020\u0437\u0435\u0431\u0440\u044B:";
  }
  else
  {
    if (nStringID == 0)
      return "Alternating lines size:";
  }
  return "";
}
