// http://akelpad.sourceforge.net/forum/viewtopic.php?p=9209#9209
// Version: 1.9
// Author: Shengalts Aleksander aka Instructor
//
//
// Description(1033): Shift tabulation size at specified offset.
// Description(1049):      .
//
// Arguments:
//  First argument      -Current tabulation size:
//                        +2  increase.
//                        -2  decrease.
//                         8  set to.
// -Local=true          -Change tabulation size locally. Not saved by program (default is false).
// -ShowInput=true      -Show input dialog. Default is false, but true if first argument not specified.
//
// Usage:
// "Set tab manually" Call("Scripts::Main", 1, "ShiftTabSize.js")
// "Increase tab" Call("Scripts::Main", 1, "ShiftTabSize.js", `+2`)
// "Set tab to 8 locally" Call("Scripts::Main", 1, "ShiftTabSize.js", `8 -Local=true`)

//Arguments
var pTabShift="";
var bLocal=AkelPad.GetArgValue("Local", false);
var bShowInput=AkelPad.GetArgValue("ShowInput", false);
if (WScript.Arguments.length >= 1)
  pTabShift=WScript.Arguments(0);

//Variables
var hMainWnd=AkelPad.GetMainWnd();
var hWndEdit=AkelPad.GetEditWnd();
var pSign;
var nTabShift;
var nTabSize;

if (bLocal)
  nTabSize=AkelPad.SendMessage(hWndEdit, 3239 /*AEM_GETTABSTOP*/, 0, 0);
else
  nTabSize=AkelPad.SendMessage(hMainWnd, 1223 /*AKD_GETFRAMEINFO*/, 52 /*FI_TABSTOPSIZE*/, 0);

nTabShift=parseInt(pTabShift);
if (isNaN(nTabShift))
{
  pTabShift="";
  bShowInput=true;
}
if (bShowInput)
{
  if (!pTabShift)
    pTabShift="" + nTabSize;
  pTabShift=AkelPad.InputBox(hMainWnd, WScript.ScriptName, GetLangString(0), pTabShift);
  nTabShift=parseInt(pTabShift);
  if (isNaN(nTabShift)) pTabShift="";
}

if (hWndEdit && pTabShift)
{
  pSign=pTabShift.substr(0, 1);

  if (pSign == '+' || pSign == '-')
  {
    nTabSize=nTabSize + nTabShift;
    nTabSize=Math.max(nTabSize, 0);
  }
  else nTabSize=nTabShift;

  if (bLocal)
    AkelPad.SendMessage(hWndEdit, 3240 /*AEM_SETTABSTOP*/, nTabSize, 0);
  else
    AkelPad.SetFrameInfo(0, 1 /*FIS_TABSTOPSIZE*/, nTabSize);
}

function GetLangString(nStringID)
{
  var nLangID=AkelPad.GetLangId(1 /*LANGID_PRIMARY*/);

  if (nLangID == 0x19) //LANG_RUSSIAN
  {
    if (nStringID == 0)
      return "\u0420\u0430\u0437\u043C\u0435\u0440\u0020\u0442\u0430\u0431\u0443\u043B\u044F\u0446\u0438\u0438:";
  }
  else
  {
    if (nStringID == 0)
      return "Tabulation size:";
  }
  return "";
}
