// http://akelpad.sourceforge.net/forum/viewtopic.php?p=30423#30423
// Version: 2016-01-25
// Author: KDJ
//
// *** Sort lines containing integers ***
//
// Usage:
//   Call("Scripts::Main", 1, "SortLinesWithIntegers.js", "-ascending=true -matchCase=false -matchLocale=false -msgBefore=true -msgAfter=true")
//
// Arguments (are optional):
//   -ascending   - sort ascending (default: true)
//   -matchCase   - match case (default: false)
//   -matchLocale - match locale, alphabetically (default: false)
//   -msgBefore   - show message box before sorting (default: true)
//   -msgAfter    - show message box after sorting (default: true)

var hMainWnd     = AkelPad.GetMainWnd();
var hEditWnd     = AkelPad.GetEditWnd();
var bAscending   = AkelPad.GetArgValue("ascending", true);
var bMatchCase   = AkelPad.GetArgValue("matchCase", false);
var bMatchLocale = AkelPad.GetArgValue("matchLocale", false);
var bMsgBefore   = AkelPad.GetArgValue("msgBefore", true);
var bMsgAfter    = AkelPad.GetArgValue("msgAfter", true);
var aLine;

if (hEditWnd && (! AkelPad.GetEditReadOnly(0)))
{
  GetLines();

  if (aLine.length)
  {
    if (bMsgBefore)
    {
      if (AkelPad.MessageBox(hMainWnd, "Do you want to sort selected lines?" + "\n\n   - ascending:\t" + bAscending + "\n   - match case:\t" + bMatchCase + "\n   - match locale:\t" + bMatchLocale, WScript.ScriptName, 0x21 /*MB_ICONQUESTION|MB_OKCANCEL*/) != 1 /*IDOK*/)
        WScript.Quit();
    }

    aLine.sort(SortFunc);
    AkelPad.ReplaceSel(aLine.join("\r"), -1 /*RST_SELECT*/);

    if (bMsgAfter)
      AkelPad.MessageBox(hMainWnd, "Lines have been sorted.", WScript.ScriptName, 0x40 /*MB_ICONINFORMATION*/);
  }
}

function SortFunc(s1, s2)
{
  //without this assignment, in replace method error occurs
  var sL1 = s1;
  var sL2 = s2;
  var aMatch;
  var nLen;
  var i;

  if (aMatch = (sL1 + " " + sL2).match(/\d+/g))
  {
    nLen = 1;

    for (i = 0; i < aMatch.length; ++i)
      nLen = Math.max(nLen, aMatch[i].length);

    sL1 = sL1.replace(/\d+/g, ReplaceFunc);
    sL2 = sL2.replace(/\d+/g, ReplaceFunc);
  }

  if (bMatchLocale)
    return oSys.Call("Kernel32::lstrcmp" + (bMatchCase ? "W" : "iW"), sL1, sL2);

  if (! bMatchCase)
  {
    sL1 = sL1.toLowerCase();
    sL2 = sL2.toLowerCase();
  }

  if (bAscending)
  {
    if (sL1 < sL2)
      return -1;
    if (sL1 > sL2)
      return 1;
  }
  else
  {
    if (sL1 > sL2)
      return -1;
    if (sL1 < sL2)
      return 1;
  }

  return 0;

  function ReplaceFunc(sNum)
  {
    while (sNum.length < nLen)
      sNum = "0" + sNum;

    return sNum;
  }
}

function GetLines()
{
  var nSel1 = AkelPad.GetSelStart();
  var nSel2 = AkelPad.GetSelEnd();

  if (nSel1 == nSel2)
  {
    nSel1 = 0;
    nSel2 = -1;
  }
  else
  {
    nSel1 = AkelPad.SendMessage(hEditWnd, 3138 /*AEM_GETRICHOFFSET*/, 18 /*AEGI_WRAPLINEBEGIN*/, nSel1);
    nSel2 = AkelPad.SendMessage(hEditWnd, 3138 /*AEM_GETRICHOFFSET*/, 19 /*AEGI_WRAPLINEEND*/, nSel2);
  }

  AkelPad.SetSel(nSel1, nSel2);
  aLine = AkelPad.GetSelText().split("\r");

  if (aLine.length == 1)
    aLine.shift();
}
